/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.sqlTemplate;

import com.testDataBuilder.sqlTemplate.IDBTemplate;
import com.testDataBuilder.sqlTemplate.XmlConfigTemplate;
import com.testDataBuilder.util.RadixConverter;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateFactory {
    static Logger logger = Logger.getLogger(TemplateFactory.class);
    public static final String TEMPLATE_DIR = "res/sqlTemplate";
    private static TemplateFactory instance = null;
    private Map map = new HashMap();

    private TemplateFactory() {
    }

    public static TemplateFactory getInstance() {
        if (instance == null) {
            instance = new TemplateFactory();
            instance.init();
        }
        return instance;
    }

    public TemplateFactory init() {
        File dir = new File(TEMPLATE_DIR);
        if (!dir.exists()) {
            logger.info((Object)("dir [" + dir.getAbsolutePath() + "] not exist"));
            return this;
        }
        logger.info((Object)("load sql template from dir[" + dir.getAbsolutePath() + "]"));
        if (dir.isDirectory()) {
            String[] tempcnfigFiles;
            SuffixFileFilter filter = new SuffixFileFilter(".xml");
            String[] stringArray = tempcnfigFiles = dir.list((FilenameFilter)filter);
            int n = tempcnfigFiles.length;
            int n2 = 0;
            while (n2 < n) {
                String tempConfigFile = stringArray[n2];
                try {
                    XmlConfigTemplate xmlConfigTemplate = new XmlConfigTemplate().loadFromXmlFile(new File(dir, tempConfigFile));
                    this.map.put(xmlConfigTemplate.getName(), xmlConfigTemplate);
                }
                catch (Exception e) {
                    logger.error((Object)("TemplateFactory, \u52a0\u8f7d[" + tempConfigFile + "]\u4e2d\u7684SQLTemplate\u65f6\u51fa\u9519\uff0c"), (Throwable)e);
                }
                ++n2;
            }
        }
        return this;
    }

    public Map getTemplates() {
        return this.map;
    }

    public List<String> getAllTypes() {
        Set keySet = this.getTemplates().keySet();
        return RadixConverter.toList(keySet);
    }

    public void addTemplate(IDBTemplate dbTemplate) {
        this.map.put(dbTemplate.getName(), dbTemplate);
    }

    public IDBTemplate removeTemplate(String templateName) {
        return (IDBTemplate)this.map.remove(templateName);
    }

    public IDBTemplate getTemplate(String templateName) {
        return (IDBTemplate)this.map.get(templateName);
    }
}

