/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.ui.core;

import com.testDataBuilder.core.IProcess;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;

public class ProgressPanel
extends JPanel
implements IProcess {
    private int gap = 15;
    private static final long serialVersionUID = 1L;
    private JProgressBar processBar;
    private JTextField txtInfo;

    public ProgressPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(300, 200);
        this.setLayout(null);
        this.setPreferredSize(new Dimension(456, 197));
        this.add(this.getProcessBar());
        this.add(this.getTxtInfo());
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                ProgressPanel.this.PanelResized(e);
            }
        });
    }

    protected void PanelResized(ComponentEvent e) {
        int width = this.getWidth();
        int controlWidth = width - this.gap * 2;
        this.getProcessBar().setSize(controlWidth, this.getProcessBar().getHeight());
        this.getTxtInfo().setSize(controlWidth, this.getTxtInfo().getHeight());
    }

    public JProgressBar getProcessBar() {
        if (this.processBar == null) {
            this.processBar = new JProgressBar();
            this.processBar.setBounds(15, 10, 429, 22);
            this.processBar.setForeground(new Color(95, 191, 95));
        }
        return this.processBar;
    }

    public JTextField getTxtInfo() {
        if (this.txtInfo == null) {
            this.txtInfo = new JTextField();
            this.txtInfo.setEditable(false);
            this.txtInfo.setBounds(15, 44, 429, 22);
        }
        return this.txtInfo;
    }

    public int getGap() {
        return this.gap;
    }

    public void setGap(int gap) {
        this.gap = gap;
    }

    public void setInfo(String info) {
        this.getTxtInfo().setText(info);
    }

    public void setProcessBarPos(int pos) {
        this.getProcessBar().setValue(pos);
    }
}

