/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.ui.database;

import com.testDataBuilder.config.DatabaseConfig;
import com.testDataBuilder.core.DatabaseUtil;
import com.testDataBuilder.exception.ValidataException;
import com.testDataBuilder.resources.RM;
import com.testDataBuilder.sqlTemplate.IDBTemplate;
import com.testDataBuilder.sqlTemplate.TemplateFactory;
import com.testDataBuilder.sqlTemplate.XmlConfigTemplate;
import com.testDataBuilder.ui.core.CenterDialog;
import com.testDataBuilder.ui.core.JTDButton;
import com.testDataBuilder.ui.core.JTextFieldEx;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class ConfigDBDialog
extends CenterDialog {
    static Logger logger = Logger.getLogger(ConfigDBDialog.class);
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JLabel jLabel = null;
    private JComboBox cbxName = null;
    private JLabel jLabel1 = null;
    private JTextField txtDriverClass = null;
    private JLabel jLabel2 = null;
    private JTextField txtURL = null;
    private JLabel jLabel3 = null;
    private JTextField txtUserName = null;
    private JLabel jLabel4 = null;
    private JPasswordField txtPwd = null;
    private JTDButton btnTestConn = null;
    private JTDButton btnCancel = null;
    private DatabaseConfig databaseConfig = null;
    private boolean ok = false;
    private JTDButton btnOK = null;
    private JPanel jInnerPanel = null;
    private JTextField txtSchema;
    private JLabel jLabel7;
    private JComboBox cbxConnectAs;
    private JLabel jLabel6;
    private JTDButton btnSaveAsTemplate = null;

    public ConfigDBDialog(Frame owner) {
        super(owner);
        this.initialize();
        this.center();
    }

    public ConfigDBDialog(Frame owner, DatabaseConfig databaseConfig) {
        super(owner);
        this.initialize();
        this.center();
        this.databaseConfig = databaseConfig;
        try {
            this.dataExchange(databaseConfig, true);
        }
        catch (Exception ex) {
            logger.error((Object)"OpenDBDialog", (Throwable)ex);
            JOptionPane.showMessageDialog(this, String.valueOf(RM.R("label.ConfigDBDialog.parseConfigFileError")) + ex.getMessage());
        }
    }

    public void center() {
        Dimension screenSize = this.getToolkit().getScreenSize();
        int x = (screenSize.width - this.getWidth()) / 2;
        int y = (screenSize.height - this.getHeight()) / 2;
        this.setLocation(x, y);
    }

    private void initialize() {
        this.setSize(467, 310);
        this.setResizable(false);
        this.setTitle(RM.R("label.ConfigDBDialog.title"));
        this.setDefaultCloseOperation(2);
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jLabel4 = new JLabel();
            this.jLabel4.setText(RM.R("label.ConfigDBDialog.password"));
            this.jLabel4.setBounds(208, 109, 55, 20);
            this.jLabel3 = new JLabel();
            this.jLabel3.setText(RM.R("label.ConfigDBDialog.userName"));
            this.jLabel3.setBounds(18, 109, 62, 20);
            this.jLabel2 = new JLabel();
            this.jLabel2.setText(RM.R("label.ConfigDBDialog.URL"));
            this.jLabel2.setBounds(18, 77, 62, 20);
            this.jLabel1 = new JLabel();
            this.jLabel1.setText(RM.R("label.ConfigDBDialog.jdbcDriver"));
            this.jLabel1.setBounds(18, 45, 61, 20);
            this.jLabel = new JLabel();
            this.jLabel.setText(RM.R("label.ConfigDBDialog.type"));
            this.jLabel.setBounds(19, 13, 61, 20);
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(null);
            this.jContentPane.setPreferredSize(new Dimension(459, 273));
            this.jContentPane.add((Component)this.getBtnTestConn(), null);
            this.jContentPane.add((Component)this.getBtnCancel(), null);
            this.jContentPane.add((Component)this.getBtnOK(), null);
            this.jContentPane.add((Component)this.getJInnerPanel(), null);
            this.jContentPane.add((Component)this.getBtnSaveAsTemplate(), null);
        }
        return this.jContentPane;
    }

    public JComboBox getCbxName() {
        if (this.cbxName == null) {
            this.cbxName = new JComboBox();
            this.cbxName.setBounds(92, 13, 305, 20);
            this.cbxName.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    ConfigDBDialog.this.cbxTemplateNameClicked();
                }
            });
            List<String> types = TemplateFactory.getInstance().getAllTypes();
            for (String type : types) {
                this.cbxName.addItem(type);
            }
        }
        return this.cbxName;
    }

    private void cbxTemplateNameClicked() {
        IDBTemplate template;
        if (this.cbxName.getSelectedItem() != null && (template = TemplateFactory.getInstance().getTemplate(this.cbxName.getSelectedItem().toString())) != null) {
            this.dataExchange(template, true);
        }
    }

    private void dataExchange(IDBTemplate template, boolean isToControl) {
        if (isToControl) {
            if (template != null) {
                String templateName = (String)this.getCbxName().getSelectedItem();
                if (StringUtils.isNotEmpty((String)template.getName()) && !templateName.equalsIgnoreCase(template.getName())) {
                    this.getCbxName().setSelectedItem(template.getName());
                }
                this.getTxtDriverClass().setText(template.getDriverClass());
                this.getTxtURL().setText(template.getUrl());
                this.getTxtUserName().setText(template.getUserName());
                this.getTxtPwd().setText(template.getPwd());
                this.getCbxConnectAs().setSelectedItem(template.getRole());
                this.getTxtSchema().setText(template.getSchemas());
            }
        } else if (template instanceof DatabaseConfig) {
            DatabaseConfig databaseConfig = (DatabaseConfig)template;
            databaseConfig.setName((String)this.getCbxName().getSelectedItem());
            databaseConfig.setDriverClass(this.getTxtDriverClass().getText().trim());
            databaseConfig.setUrl(this.getTxtURL().getText().trim());
            databaseConfig.setUserName(this.getTxtUserName().getText().trim());
            databaseConfig.setPassword(this.getTxtPwd().getText());
            if (this.getCbxConnectAs().getSelectedItem() != null) {
                databaseConfig.setRole(this.getCbxConnectAs().getSelectedItem().toString());
            }
            if (this.getTxtSchema().getText() != null) {
                databaseConfig.setSchemas(this.getTxtSchema().getText().toUpperCase());
            }
        }
    }

    private JTextField getTxtDriverClass() {
        if (this.txtDriverClass == null) {
            this.txtDriverClass = new JTextFieldEx();
            this.txtDriverClass.setBounds(91, 45, 305, 20);
        }
        return this.txtDriverClass;
    }

    private JTextField getTxtURL() {
        if (this.txtURL == null) {
            this.txtURL = new JTextFieldEx();
            this.txtURL.setBounds(92, 77, 305, 20);
        }
        return this.txtURL;
    }

    private JTextField getTxtUserName() {
        if (this.txtUserName == null) {
            this.txtUserName = new JTextFieldEx();
            this.txtUserName.setBounds(92, 109, 104, 20);
            this.txtUserName.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent evt) {
                    if (StringUtils.isEmpty((String)ConfigDBDialog.this.txtSchema.getText())) {
                        ConfigDBDialog.this.txtSchema.setText(ConfigDBDialog.this.txtUserName.getText());
                    }
                }
            });
        }
        return this.txtUserName;
    }

    private JPasswordField getTxtPwd() {
        if (this.txtPwd == null) {
            this.txtPwd = new JPasswordField();
            this.txtPwd.setBounds(275, 109, 122, 20);
        }
        return this.txtPwd;
    }

    private JTDButton getBtnTestConn() {
        if (this.btnTestConn == null) {
            this.btnTestConn = new JTDButton();
            this.btnTestConn.setBounds(269, 236, 74, 25);
            this.btnTestConn.setText(RM.R("label.ConfigDBDialog.Test"));
            this.btnTestConn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    try {
                        if (ConfigDBDialog.this.testConnection()) {
                            JOptionPane.showMessageDialog(ConfigDBDialog.this, RM.R("label.ConfigDBDialog.connect.success"));
                        }
                    }
                    catch (SQLException e) {
                        System.out.println(e.getMessage());
                        JOptionPane.showMessageDialog(ConfigDBDialog.this, "\u8fde\u63a5\u6570\u636e\u5e93\u51fa\u9519![" + e.getMessage() + "]");
                    }
                }
            });
        }
        return this.btnTestConn;
    }

    protected boolean testConnection() throws SQLException {
        try {
            this.checkInvalid();
        }
        catch (ValidataException e1) {
            JOptionPane.showMessageDialog(this, e1.getMessage());
            if (e1.getControl() instanceof JTextField) {
                JTextField txt = (JTextField)e1.getControl();
                txt.grabFocus();
            }
            return false;
        }
        DatabaseConfig databaseConfig = new DatabaseConfig();
        this.dataExchange(databaseConfig, false);
        return DatabaseUtil.testConnect(databaseConfig);
    }

    protected void saveConfig() throws SAXException, IOException {
        if (this.databaseConfig == null) {
            this.databaseConfig = new DatabaseConfig();
        }
        this.dataExchange(this.databaseConfig, false);
    }

    private JTDButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JTDButton();
            this.btnCancel.setBounds(173, 236, 75, 25);
            this.btnCancel.setText(RM.R("label.ConfigDBDialog.cancel"));
            this.btnCancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ConfigDBDialog.this.destroy();
                }
            });
        }
        return this.btnCancel;
    }

    private void destroy() {
        this.dispose();
    }

    public boolean isOk() {
        return this.ok;
    }

    public void setOk(boolean ok) {
        this.ok = ok;
    }

    private JTDButton getBtnOK() {
        if (this.btnOK == null) {
            this.btnOK = new JTDButton();
            this.btnOK.setBounds(360, 236, 74, 25);
            this.btnOK.setText(RM.R("label.ConfigDBDialog.ok"));
            this.btnOK.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ConfigDBDialog.this.onOK(e);
                }
            });
        }
        return this.btnOK;
    }

    protected void onOK(ActionEvent e) {
        try {
            try {
                this.checkInvalid();
            }
            catch (ValidataException e1) {
                JOptionPane.showMessageDialog(this, e1.getMessage());
                if (e1.getControl() instanceof JTextField) {
                    JTextField txt = (JTextField)e1.getControl();
                    txt.grabFocus();
                }
                return;
            }
            this.saveConfig();
        }
        catch (SAXException e1) {
            logger.error((Object)"OpenDBDialog", (Throwable)e1);
            JOptionPane.showMessageDialog(this, String.valueOf(RM.R("label.ConfigDBDialog.XmlFileOperateError")) + e1.getMessage());
        }
        catch (IOException e1) {
            logger.error((Object)"OpenDBDialog", (Throwable)e1);
            JOptionPane.showMessageDialog(this, String.valueOf(RM.R("label.ConfigDBDialog.saveConfigFileError")) + e1.getMessage());
        }
        this.ok = true;
        this.destroy();
    }

    protected void checkInvalid() throws ValidataException {
        if (StringUtils.isEmpty((String)this.getTxtDriverClass().getText())) {
            throw new ValidataException(this.getTxtDriverClass(), RM.R("label.ConfigDBDialog.invalid.driverIsNull"));
        }
        if (StringUtils.isEmpty((String)this.getTxtURL().getText())) {
            throw new ValidataException(this.getTxtURL(), RM.R("label.ConfigDBDialog.invalid.URLIsNull"));
        }
        if (StringUtils.isEmpty((String)this.getTxtUserName().getText())) {
            throw new ValidataException(this.getTxtUserName(), RM.R("label.ConfigDBDialog.invalid.userNameIsNull"));
        }
    }

    private JPanel getJInnerPanel() {
        if (this.jInnerPanel == null) {
            this.jInnerPanel = new JPanel();
            this.jInnerPanel.setLayout(null);
            this.jInnerPanel.setBounds(12, 3, 422, 213);
            this.jInnerPanel.setBorder(BorderFactory.createEtchedBorder(0));
            this.jInnerPanel.add((Component)this.jLabel, null);
            this.jInnerPanel.add((Component)this.getCbxName(), null);
            this.jInnerPanel.add((Component)this.jLabel1, null);
            this.jInnerPanel.add((Component)this.getTxtDriverClass(), null);
            this.jInnerPanel.add((Component)this.jLabel2, null);
            this.jInnerPanel.add((Component)this.getTxtURL(), null);
            this.jInnerPanel.add((Component)this.jLabel3, null);
            this.jInnerPanel.add((Component)this.getTxtUserName(), null);
            this.jInnerPanel.add((Component)this.jLabel4, null);
            this.jInnerPanel.add((Component)this.getTxtPwd(), null);
            this.jInnerPanel.add(this.getJLabel6());
            this.jInnerPanel.add(this.getCbxConnectAs());
            this.jInnerPanel.add(this.getJLabel7());
            this.jInnerPanel.add(this.getTxtSchema());
        }
        return this.jInnerPanel;
    }

    public DatabaseConfig getDatabaseConfig() {
        return this.databaseConfig;
    }

    public void setDatabaseConfig(DatabaseConfig databaseConfig) {
        this.databaseConfig = databaseConfig;
    }

    private JTDButton getBtnSaveAsTemplate() {
        if (this.btnSaveAsTemplate == null) {
            this.btnSaveAsTemplate = new JTDButton();
            this.btnSaveAsTemplate.setBounds(12, 236, 114, 25);
            this.btnSaveAsTemplate.setText(RM.R("label.ConfigDBDialog.saveAsTemplate"));
            this.btnSaveAsTemplate.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ConfigDBDialog.this.saveAsTemplate();
                }
            });
        }
        return this.btnSaveAsTemplate;
    }

    protected void saveAsTemplate() {
        try {
            this.checkInvalid();
        }
        catch (ValidataException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage());
            if (ex.getControl() instanceof JTextField) {
                JTextField txt = (JTextField)ex.getControl();
                txt.grabFocus();
            }
            return;
        }
        String templateFileName = JOptionPane.showInputDialog(this, (Object)RM.R("label.ConfigDBDialog.pleaseInputTemplateFileName"));
        if (StringUtils.isNotEmpty((String)templateFileName)) {
            File configFile = new File("res/sqlTemplate", String.valueOf(templateFileName) + ".xml");
            XmlConfigTemplate xmlConfigTemplate = new XmlConfigTemplate();
            this.dataExchange(xmlConfigTemplate, false);
            xmlConfigTemplate.setName(templateFileName);
            try {
                xmlConfigTemplate.storeToXmlFile(configFile);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, String.format(RM.R("label.ConfigDBDialog.ErrorOnSaveAsTemplate"), e.getMessage()));
            }
        } else {
            JOptionPane.showMessageDialog(this, RM.R("label.ConfigDBDialog.nullTemplateName"));
        }
    }

    private JLabel getJLabel6() {
        if (this.jLabel6 == null) {
            this.jLabel6 = new JLabel();
            this.jLabel6.setText(RM.R("label.ConfigDBDialog.ConnectAs"));
            this.jLabel6.setBounds(18, 141, 62, 19);
        }
        return this.jLabel6;
    }

    public JComboBox getCbxConnectAs() {
        if (this.cbxConnectAs == null) {
            DefaultComboBoxModel<String> cbxConnectAsModel = new DefaultComboBoxModel<String>(new String[]{"normal", "sysdba", "sysoper"});
            this.cbxConnectAs = new JComboBox();
            this.cbxConnectAs.setModel(cbxConnectAsModel);
            this.cbxConnectAs.setBounds(92, 139, 104, 23);
            this.cbxConnectAs.setSelectedIndex(0);
        }
        return this.cbxConnectAs;
    }

    private JLabel getJLabel7() {
        if (this.jLabel7 == null) {
            this.jLabel7 = new JLabel();
            this.jLabel7.setText(RM.R("label.ConfigDBDialog.Schema"));
            this.jLabel7.setBounds(18, 172, 62, 20);
        }
        return this.jLabel7;
    }

    private JTextField getTxtSchema() {
        if (this.txtSchema == null) {
            this.txtSchema = new JTextField();
            this.txtSchema.setBounds(92, 171, 304, 23);
            this.txtSchema.setToolTipText("eg:sys,system,user1");
        }
        return this.txtSchema;
    }
}

