/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.ui.help;

import com.testDataBuilder.resources.ResourceManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class Helper {
    static Logger logger = Logger.getLogger(Helper.class);
    public static final String DEF_HELP_PKG = "/res/helpdoc";
    public static final String DEF_HELP_HS = "/res/helpdoc/def/help.hs";
    HelpSet helpset = null;
    ActionListener helpListener = null;
    HelpBroker helpBroker = null;
    private static Helper instance = null;

    public static Helper getInstance() {
        if (instance == null) {
            instance = new Helper();
        }
        return instance;
    }

    private Helper() {
        try {
            this.helpset = new HelpSet(this.getClass().getClassLoader(), this.getURL());
        }
        catch (HelpSetException e) {
            logger.error((Object)"Error loading helpSystem", (Throwable)e);
        }
        catch (MalformedURLException e) {
            logger.error((Object)"Error loading helpSystem", (Throwable)e);
        }
        this.helpBroker = this.helpset.createHelpBroker();
        this.helpBroker.setLocation(new Point(100, 100));
        this.helpBroker.setSize(new Dimension(800, 600));
        this.helpListener = new CSH.DisplayHelpFromSource(this.helpBroker);
    }

    private URL getURL() throws MalformedURLException {
        String helpName = "/res/helpdoc/" + ResourceManager.getLocale().toString() + "/help.hs";
        File file = new File("res/helpdoc/def/help.hs");
        if (!file.exists()) {
            String errorInfo = "\u52a0\u8f7d\u5e2e\u52a9\u6587\u6863\u65f6\u51fa\u9519\uff01\u5982\u679c\u662f\u5728eclipse\u91cc\u9762\u8fd0\u884c\uff0c\n\r\u8bf7\u5c06Working Directory\u8bbe\u7f6e\u4e3aTestDataBuilder\bin. \n\r\u65b9\u6cd5: Menu Run->Run...->TestDataBuilder->arguments->WorkingDirectory->Other.";
            JOptionPane.showMessageDialog(null, errorInfo);
        }
        URL url = file.toURL();
        return url;
    }

    protected HelpBroker getHelpBroker() {
        return this.helpBroker;
    }

    public void setHelpBroker(HelpBroker helpBroker) {
        this.helpBroker = helpBroker;
    }

    public ActionListener getHelpListener() {
        return this.helpListener;
    }

    public void setHelpListener(ActionListener helpListener) {
        this.helpListener = helpListener;
    }

    public HelpSet getHelpset() {
        return this.helpset;
    }

    public void setHelpset(HelpSet helpset) {
        this.helpset = helpset;
    }

    public void enableHelpKey(Component comp, String helpKey) {
        this.getHelpBroker().enableHelpKey(comp, helpKey, this.getHelpset());
    }
}

