/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.ui.log;

import com.testDataBuilder.ui.log.LoopedStreams;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.Document;

public class ConsoleTextArea
extends JTextArea {
    public ConsoleTextArea() throws IOException {
        LoopedStreams ls = new LoopedStreams();
        PrintStream ps = new PrintStream(ls.getOutputStream());
        System.setOut(ps);
        System.setErr(ps);
        this.startConsoleReaderThread(ls.getInputStream());
    }

    private void startConsoleReaderThread(InputStream inStream) {
        final BufferedReader br = new BufferedReader(new InputStreamReader(inStream));
        new Thread(new Runnable(){

            public void run() {
                StringBuffer sb = new StringBuffer();
                try {
                    String s;
                    Document doc = ConsoleTextArea.this.getDocument();
                    while ((s = br.readLine()) != null) {
                        boolean caretAtEnd = false;
                        caretAtEnd = ConsoleTextArea.this.getCaretPosition() == doc.getLength();
                        sb.setLength(0);
                        ConsoleTextArea.this.append(sb.append(s).append('\n').toString());
                        System.out.println(".................");
                        if (!caretAtEnd) continue;
                        ConsoleTextArea.this.setCaretPosition(doc.getLength());
                    }
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(null, "\u4eceBufferedReader\u8bfb\u53d6\u9519\u8bef\uff1a" + e);
                    System.exit(1);
                }
            }
        }).start();
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("ConsoleTextArea\u6d4b\u8bd5");
        ConsoleTextArea consoleTextArea = null;
        try {
            consoleTextArea = new ConsoleTextArea();
        }
        catch (IOException e) {
            System.err.println("\u4e0d\u80fd\u521b\u5efaLoopedStreams\uff1a" + e);
            System.exit(1);
        }
        consoleTextArea.setFont(Font.decode("monospaced"));
        f.getContentPane().add((Component)new JScrollPane(consoleTextArea), "Center");
        f.setBounds(50, 50, 300, 300);
        f.setVisible(true);
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                System.exit(0);
            }
        });
    }

    private static void startWriterTestThread(final String name, final PrintStream ps, final int delay, final int count) {
        new Thread(new Runnable(){

            public void run() {
                int i = 1;
                while (i <= count) {
                    ps.println("***" + name + ", hello !, i=" + i);
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        }).start();
    }
}

