/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.ui.main;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

public class ButtonCellEditor
extends DefaultCellEditor
implements TableCellRenderer {
    private JButton button = new JButton();
    private JButton rendererButton;
    private String label;
    private boolean isPushed;
    protected int row = -1;
    protected int col = -1;

    public ButtonCellEditor(JCheckBox checkBox) {
        super(checkBox);
        this.button.setOpaque(true);
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ButtonCellEditor.this.fireEditingStopped();
            }
        });
        this.rendererButton = new JButton();
        this.rendererButton.setOpaque(true);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.rendererButton.setForeground(table.getSelectionForeground());
            this.rendererButton.setBackground(table.getSelectionBackground());
        } else {
            this.rendererButton.setForeground(table.getForeground());
            this.rendererButton.setBackground(UIManager.getColor("Button.background"));
        }
        this.label = value == null ? "" : value.toString();
        this.rendererButton.setText(this.label);
        return this.rendererButton;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (isSelected) {
            this.button.setForeground(table.getSelectionForeground());
            this.button.setBackground(table.getSelectionBackground());
        } else {
            this.button.setForeground(table.getForeground());
            this.button.setBackground(table.getBackground());
        }
        this.label = value == null ? "" : value.toString();
        this.button.setText(this.label);
        this.isPushed = true;
        this.row = row;
        this.col = column;
        return this.button;
    }

    public Object getCellEditorValue() {
        if (this.isPushed) {
            this.doEditing();
        }
        this.isPushed = false;
        return new String(this.label);
    }

    protected void doEditing() {
    }

    public boolean stopCellEditing() {
        this.isPushed = false;
        return super.stopCellEditing();
    }

    protected void fireEditingStopped() {
        super.fireEditingStopped();
    }
}

