/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.ui.main;

import com.testDataBuilder.config.ColumnConfig;
import com.testDataBuilder.resources.RM;
import com.testDataBuilder.ui.core.JComboBoxEx;
import com.testDataBuilder.ui.main.ButtonCellEditor;
import com.testDataBuilder.ui.main.ColumnTableModel;
import com.testDataBuilder.ui.main.ComboxCellEditor;
import com.testDataBuilder.ui.util.ColumnInfo;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnTable
extends JTable {
    static final int EDIT_COLUMN = 2;
    private List<ColumnInfo> columnNames = null;
    private JComboBoxEx fieldComboBox = null;
    private JComboBoxEx refComboBox = null;

    public ColumnTable() {
        this.init();
    }

    protected void init() {
        this.setModel(new ColumnTableModel(this.getColumnNames()));
        this.setSelectionMode(1);
        int i = 0;
        while (i < this.getColumnModel().getColumnCount()) {
            TableColumn fieldColumn = this.getColumnModel().getColumn(i);
            switch (i) {
                case 0: {
                    fieldColumn.setCellEditor(new ComboxCellEditor((JComboBox)this.getFieldsComboBox()));
                    break;
                }
                case 1: {
                    fieldColumn.setCellEditor(new ComboxCellEditor((JComboBox)this.getRefComboBox()));
                    break;
                }
                case 2: {
                    fieldColumn.setCellEditor(new ButtonCellEditor(new JCheckBox(RM.R("label.ColumnTable.edit"))));
                    fieldColumn.setCellRenderer(new DefaultTableCellRenderer.UIResource(){

                        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                            this.setHorizontalAlignment(0);
                            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                        }
                    });
                }
            }
            fieldColumn.setPreferredWidth(this.getColumnNames().get(i).getWidth());
            ++i;
        }
    }

    private List<ColumnInfo> getColumnNames() {
        if (this.columnNames == null) {
            this.columnNames = new ArrayList<ColumnInfo>();
            this.columnNames.add(new ColumnInfo(RM.R("label.ColumnTable.columnName.columnName"), 100));
            this.columnNames.add(new ColumnInfo(RM.R("label.ColumnTable.columnName.refRole"), 150));
            this.columnNames.add(new ColumnInfo(RM.R("label.ColumnTable.columnName.editRole"), 50));
            this.columnNames.add(new ColumnInfo(RM.R("label.ColumnTable.columnName.isPK"), 5));
        }
        return this.columnNames;
    }

    public JComboBoxEx getFieldsComboBox() {
        if (this.fieldComboBox == null) {
            this.fieldComboBox = new JComboBoxEx();
        }
        return this.fieldComboBox;
    }

    public void setFields(List fields) {
        this.getFieldsComboBox().setData(fields);
    }

    public JComboBoxEx getRefComboBox() {
        if (this.refComboBox == null) {
            this.refComboBox = new JComboBoxEx();
            this.refComboBox.setToolTipText(RM.R("label.ColumnTable.toolTip"));
        }
        return this.refComboBox;
    }

    public void setRefs(List ref) {
        if (ref != null) {
            ref.add(0, "");
        }
        this.getRefComboBox().setData(ref);
    }

    public ColumnTableModel getDataModel() {
        return (ColumnTableModel)this.dataModel;
    }

    public List<ColumnConfig> getData() {
        return this.getDataModel().getData();
    }

    public void setData(List<ColumnConfig> columnData) {
        this.getDataModel().setData(columnData);
        this.clearSelection();
        this.updateUI();
    }

    public void addRow() {
        int size = this.getData().size();
        this.getData().add(new ColumnConfig("column" + size));
        this.updateUI();
    }

    @Override
    public Class<?> getColumnClass(int column) {
        Object value = this.getValueAt(0, column);
        if (value == null) {
            return Object.class;
        }
        return value.getClass();
    }

    public void deleteCurrentItem() {
        this.getDataModel().deleteItem(this.getSelectedRow());
        this.updateUI();
    }
}

