/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.ui.main;

import com.testDataBuilder.config.ColumnConfig;
import com.testDataBuilder.resources.RM;
import com.testDataBuilder.ui.util.ColumnInfo;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ColumnTableModel
extends AbstractTableModel {
    List<ColumnConfig> data = new ArrayList<ColumnConfig>();
    List<ColumnInfo> columnInfos = null;

    public ColumnTableModel(List<ColumnInfo> columnInfos) {
        this.columnInfos = columnInfos;
    }

    public ColumnTableModel(List<ColumnConfig> data, List<ColumnInfo> columnInfos) {
        this.data = data;
        this.columnInfos = columnInfos;
    }

    @Override
    public int getColumnCount() {
        return this.columnInfos.size();
    }

    @Override
    public int getRowCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ColumnConfig columnConfig = this.data.get(rowIndex);
        Object value = null;
        switch (columnIndex) {
            case 0: {
                value = columnConfig.getName();
                break;
            }
            case 1: {
                value = columnConfig.getRef();
                break;
            }
            case 2: {
                value = RM.R("label.ColumnTable.edit");
                break;
            }
            case 3: {
                value = columnConfig.isPK();
                break;
            }
            default: {
                value = "";
            }
        }
        return value;
    }

    @Override
    public int findColumn(String columnName) {
        return this.columnInfos.indexOf(columnName);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        Object value = this.getValueAt(0, columnIndex);
        if (value == null) {
            return Object.class;
        }
        return value.getClass();
    }

    @Override
    public String getColumnName(int column) {
        ColumnInfo columnInfo = this.columnInfos.get(column);
        return columnInfo.getName();
    }

    public int getColumnWidth(int column) {
        ColumnInfo columnInfo = this.columnInfos.get(column);
        return columnInfo.getWidth();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        ColumnConfig columnConfig = this.getData().get(rowIndex);
        switch (columnIndex) {
            case 0: {
                columnConfig.setName((String)aValue);
                break;
            }
            case 1: {
                columnConfig.setRef((String)aValue);
                break;
            }
            case 3: {
                columnConfig.setPK((Boolean)aValue);
            }
        }
    }

    public List<ColumnConfig> getData() {
        return this.data;
    }

    public void setData(List<ColumnConfig> data) {
        if (data == null) {
            data = new LinkedList<ColumnConfig>();
        }
        this.data = data;
    }

    public List<ColumnInfo> getColumnInfos() {
        return this.columnInfos;
    }

    public void setColumnInfos(List<ColumnInfo> columnInfos) {
        this.columnInfos = columnInfos;
    }

    public void deleteItem(int index) {
        this.getData().remove(index);
    }
}

