/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.ui.main;

import com.testDataBuilder.config.DatabaseConfig;
import com.testDataBuilder.dbMetaInfo.Column;
import com.testDataBuilder.dbMetaInfo.Constraints;
import com.testDataBuilder.dbMetaInfo.Database;
import com.testDataBuilder.dbMetaInfo.ForeignKey;
import com.testDataBuilder.dbMetaInfo.PrimaryKey;
import com.testDataBuilder.dbMetaInfo.Table;
import com.testDataBuilder.ui.main.JDBTreeRootObj;
import java.util.List;
import java.util.Map;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DBTreeModel
implements TreeModel {
    JDBTreeRootObj rootObj = null;

    public DBTreeModel() {
        this.rootObj = new JDBTreeRootObj();
    }

    public DBTreeModel(Database data, Map<String, DatabaseConfig> databaseConfigs) {
        this.rootObj = new JDBTreeRootObj(data, databaseConfigs);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
    }

    @Override
    public Object getChild(Object parent, int index) {
        Object obj = null;
        if (parent instanceof JDBTreeRootObj) {
            JDBTreeRootObj rootObj = (JDBTreeRootObj)parent;
            obj = index == 0 ? rootObj.getData() : rootObj.getDatabaseConfigs();
        } else if (parent instanceof List) {
            List list = (List)parent;
            obj = list.get(index);
        } else if (parent instanceof Map) {
            obj = this.rootObj.getDatabaseConfigs().values().toArray()[index];
        } else if (parent instanceof Database) {
            Database database = (Database)parent;
            obj = database.getTables().get(index);
        } else if (parent instanceof Table) {
            Table table = (Table)parent;
            switch (index) {
                case 0: {
                    obj = table.getColumns();
                    break;
                }
                case 1: {
                    obj = new Constraints(table.getPrimaryKey(), table.getForeignKeys());
                    break;
                }
                default: {
                    System.out.println("error in getChild.......");
                    break;
                }
            }
        } else if (parent instanceof Constraints) {
            Constraints constraints = (Constraints)parent;
            obj = constraints.getPrimaryKey() == null ? constraints.getForeignKeys().get(index) : (index == 0 ? constraints.getPrimaryKey() : constraints.getForeignKeys().get(index - 1));
        } else if (parent instanceof PrimaryKey) {
            PrimaryKey primaryKey = (PrimaryKey)parent;
            obj = primaryKey.getFields().get(index);
        } else if (parent instanceof ForeignKey) {
            ForeignKey foreignKey = (ForeignKey)parent;
            String field = foreignKey.getFKFileds().get(index);
            String refField = foreignKey.getRefFields().get(field);
            obj = String.valueOf(field) + " => " + refField;
        }
        return obj;
    }

    @Override
    public int getChildCount(Object parent) {
        int count = 0;
        if (parent instanceof JDBTreeRootObj) {
            if (this.rootObj.getData() != null) {
                ++count;
                if (this.rootObj.getDatabaseConfigs() != null) {
                    ++count;
                }
            }
        } else if (parent instanceof List) {
            List list = (List)parent;
            count = list.size();
        } else if (parent instanceof Map) {
            Map map = (Map)parent;
            count = map.size();
        } else if (parent instanceof Database) {
            Database database = (Database)parent;
            count = database.getTables() == null ? 0 : database.getTables().size();
        } else if (parent instanceof Table) {
            count = 2;
        } else if (parent instanceof Column) {
            count = 0;
        } else if (parent instanceof Constraints) {
            Constraints constraints = (Constraints)parent;
            if (constraints.getPrimaryKey() != null) {
                ++count;
            }
            count += constraints.getForeignKeys().size();
        } else if (parent instanceof PrimaryKey) {
            PrimaryKey primaryKey = (PrimaryKey)parent;
            count = primaryKey.getFields().size();
        } else if (parent instanceof ForeignKey) {
            ForeignKey foreignKey = (ForeignKey)parent;
            count = foreignKey.getFKFileds().size();
        }
        return count;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return 0;
    }

    @Override
    public Object getRoot() {
        return this.rootObj;
    }

    @Override
    public boolean isLeaf(Object node) {
        return node instanceof Column || node instanceof String || node instanceof DatabaseConfig;
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public Database getData() {
        return this.rootObj.getData();
    }

    public void setData(Database data) {
        this.rootObj.setData(data);
    }

    public Map<String, DatabaseConfig> getDatabaseConfigs() {
        return this.rootObj.getDatabaseConfigs();
    }

    public void setDatabaseConfigs(Map<String, DatabaseConfig> databaseConfigs) {
        this.rootObj.setDatabaseConfigs(databaseConfigs);
    }
}

