/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.ui.main;

import com.testDataBuilder.config.AutoConfigEngine;
import com.testDataBuilder.config.DatabaseConfig;
import com.testDataBuilder.config.TableConfig;
import com.testDataBuilder.config.WorkspaceDataCache;
import com.testDataBuilder.dbMetaInfo.Database;
import com.testDataBuilder.dbMetaInfo.Table;
import com.testDataBuilder.ui.main.DBTreeModel;
import com.testDataBuilder.ui.main.MainFrame;
import com.testDataBuilder.ui.main.TDBTreeRenderer;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBTree
extends JTree {
    public static int LEVEL_DB = 1;
    public static int LEVEL_TABLE = 2;
    public static int LEVEL_COLUMNS = 3;
    public static int LEVEL_COLUMN = 4;
    public static int LEVEL_CONN_POOL = 1;
    public static int LEVEL_CONNECT = 2;
    static Logger logger = Logger.getLogger(JDBTree.class);
    private static final long serialVersionUID = 1L;
    MainFrame parent = null;
    private Database database = null;
    private DatabaseConfig curSelDatabaseConfig = null;

    public JDBTree() {
        this.setModel(new DBTreeModel());
        this.setCellRenderer(new TDBTreeRenderer(this));
        this.setSelectionRow(0);
        this.getSelectionModel().setSelectionMode(1);
    }

    public JDBTree(MainFrame parent) {
        this.parent = parent;
        this.setModel(new DBTreeModel());
        this.setCellRenderer(new TDBTreeRenderer(this));
        this.setSelectionRow(0);
        this.getSelectionModel().setSelectionMode(1);
    }

    public boolean isSelTableOrTableField(Object[] paths) {
        return paths != null && paths.length >= LEVEL_TABLE + 1 && paths[LEVEL_TABLE] instanceof Table;
    }

    public boolean isSelTable(Object[] paths) {
        boolean isSelTable = paths != null && paths[paths.length - 1] instanceof Table;
        return isSelTable;
    }

    public boolean isSelDatabase(Object[] paths) {
        return paths != null && paths[paths.length - 1] instanceof Database;
    }

    public boolean isSelConnectionPool(Object[] paths) {
        return paths != null && paths[paths.length - 1] instanceof Map;
    }

    public boolean isSelConnectConfig(Object[] paths) {
        return paths != null && paths[paths.length - 1] instanceof DatabaseConfig;
    }

    public void autoConfigAll() throws IOException {
        List<Table> tables = this.database.getTables();
        try {
            for (Table table : tables) {
                if (this.tableIsConfiged(table)) continue;
                AutoConfigEngine autoConfigEngine = new AutoConfigEngine();
                TableConfig tableConfig = autoConfigEngine.reverseTable(table);
                tableConfig.saveConfig();
                tableConfig.deleteBankupFile();
                this.parent.getWorkspaceDataCache().addOrRefershTableConfig(tableConfig);
            }
        }
        finally {
            this.updateUI();
        }
    }

    public Database getData() {
        return this.getModel().getData();
    }

    public void setData(Database database) {
        this.getModel().setData(database);
    }

    public Map<String, DatabaseConfig> getDatabaseConfigs() {
        return this.getModel().getDatabaseConfigs();
    }

    public void setDatabaseConfigs(Map<String, DatabaseConfig> databaseConfigs) {
        this.getModel().setDatabaseConfigs(databaseConfigs);
    }

    public boolean connIsOpend(String configName) {
        return this.parent.getWorkspaceDataCache().getTestDataConfig().getConnFromCache(configName) != null;
    }

    @Override
    public DBTreeModel getModel() {
        return (DBTreeModel)super.getModel();
    }

    public boolean tableIsConfiged(Table table) {
        File configFile = WorkspaceDataCache.getInstance().getTableConfigFile(table.getTableName());
        return configFile.exists();
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(Database curSelDB) {
        this.database = curSelDB;
    }

    public DatabaseConfig getCurSelDatabaseConfig() {
        return this.curSelDatabaseConfig;
    }

    public void setCurSelDatabaseConfig(DatabaseConfig curSelDatabaseConfig) {
        this.curSelDatabaseConfig = curSelDatabaseConfig;
    }
}

