/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.ui.main;

import com.testDataBuilder.config.AutoConfigEngine;
import com.testDataBuilder.config.ColumnConfig;
import com.testDataBuilder.config.DatabaseConfig;
import com.testDataBuilder.config.TableConfig;
import com.testDataBuilder.config.TestDataConfig;
import com.testDataBuilder.config.WorkspaceDataCache;
import com.testDataBuilder.core.DatabaseUtil;
import com.testDataBuilder.dbMetaInfo.Database;
import com.testDataBuilder.dbMetaInfo.Table;
import com.testDataBuilder.exception.BaseException;
import com.testDataBuilder.resources.RM;
import com.testDataBuilder.ui.core.CenterFrame;
import com.testDataBuilder.ui.core.JTDButton;
import com.testDataBuilder.ui.core.JTextFieldEx;
import com.testDataBuilder.ui.database.ConfigDBDialog;
import com.testDataBuilder.ui.help.AboutDialog;
import com.testDataBuilder.ui.help.Helper;
import com.testDataBuilder.ui.help.UpgradeDialog;
import com.testDataBuilder.ui.main.ColumnTable;
import com.testDataBuilder.ui.main.JDBTree;
import com.testDataBuilder.ui.main.OpenWorkspaceUtil;
import com.testDataBuilder.ui.main.dataModel.DataModelPanel;
import com.testDataBuilder.ui.main.others.AppPropertyDialog;
import com.testDataBuilder.ui.main.others.JTDBMenuBar;
import com.testDataBuilder.ui.main.others.JTDBToolBar;
import com.testDataBuilder.ui.main.queryConsole.QueryPanel;
import com.testDataBuilder.ui.preference.PreferenceDialog;
import com.testDataBuilder.ui.project.JProjectDirChooser;
import com.testDataBuilder.ui.project.ProjectDialog;
import com.testDataBuilder.ui.project.RecentProjects;
import com.testDataBuilder.ui.role.GenerateDataDialog;
import com.testDataBuilder.ui.role.RoleDialog;
import com.testDataBuilder.util.Global;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.DocumentException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainFrame
extends CenterFrame {
    static Logger logger = Logger.getLogger(MainFrame.class);
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JTDBToolBar tdbToolBar = null;
    private JSplitPane jSplitPane = null;
    private JLabel msgLine = null;
    private WorkspaceDataCache workspaceDataCache = WorkspaceDataCache.getInstance();
    public Global G = Global.getInstance();
    private JScrollPane leftPane = null;
    private JDBTree jLeftTree = null;
    private JPanel configPanel = null;
    private JCheckBox cbxGenerate = null;
    private JLabel jLabel = null;
    private JTextField txtCount = null;
    private JLabel jLabel1 = null;
    private JComboBox cbxOnError = null;
    private JLabel jLabel2 = null;
    private JScrollPane initPanel = null;
    private JTextArea txtInit = null;
    private JLabel jLabel3 = null;
    private JScrollPane destroyPane = null;
    private JTextArea txtDestroy = null;
    private JScrollPane columnPane = null;
    private ColumnTable columnTable = null;
    private JLabel jLabel4 = null;
    private JCheckBox cbxCloseIDAutoInsert = null;
    private JTDButton btnAutoConfig = null;
    private JTDButton btnAdd = null;
    private JTDButton btnDel = null;
    private QueryPanel queryPanel = null;
    private String newConfigName = null;
    public static final int rightSpace = 20;
    private static MainFrame instance = null;
    private String initTitle = "TestDataBuilder";
    private JTDButton btnSave = null;
    private JTDButton btnClose = null;
    private JTabbedPane jTabbedPane = null;
    GenerateDataDialog genDialog = null;
    private JTDButton btnClearColumnConfig = null;
    private DataModelPanel dataModelPanel = null;

    public String getProjectConfigFile() {
        return String.valueOf(this.getWorkspace()) + Global.SEP + "project.xml";
    }

    public Database getDatabase() {
        return this.getJLeftTree().getDatabase();
    }

    public void enableControl(boolean enable) {
        this.getCbxCloseIDAutoInsert().setEnabled(enable);
        this.getTxtCount().setEnabled(enable);
        this.getCbxOnError().setEnabled(enable);
        this.getTxtInit().setEnabled(enable);
        this.getTxtDestroy().setEnabled(enable);
        this.getColumnTable().setEnabled(enable);
        this.getBtnAutoConfig().setEnabled(enable);
        this.getBtnAdd().setEnabled(enable);
        this.getBtnDel().setEnabled(enable);
        this.getBtnSave().setEnabled(enable);
        this.getBtnClearColumnConfig().setEnabled(enable);
    }

    private void resetRefValues() {
        List<String> allTypes = this.getAllRefRoles4List();
        this.getColumnTable().setRefs(allTypes);
    }

    public List<String> getAllRefRoles4List() {
        List<String> tempList = null;
        TableConfig curTableConfig = this.getCurTableConfig();
        tempList = curTableConfig != null ? curTableConfig.getRoleFactory().getAllRefRoles4List() : new ArrayList<String>();
        return tempList;
    }

    @Override
    public JTDBMenuBar getJMenuBar() {
        return (JTDBMenuBar)super.getJMenuBar();
    }

    public void configDBAndInitWorkspace(String configName, boolean changeWorkspace) throws IOException, BaseException {
        boolean result = false;
        try {
            result = this.configAndReconnect(configName);
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this, String.valueOf(RM.R("label.MainFrame.error.connectDatabase")) + ex.getMessage());
        }
        if (result && configName.equals("MySQL")) {
            if (changeWorkspace) {
                this.initWorkspaceFromDB();
            } else {
                this.refreshDataFromDB();
            }
        }
    }

    public boolean configDB(String configName) throws BaseException {
        DatabaseConfig databaseConfig = null;
        if (configName != null) {
            databaseConfig = this.getDatabaseConfig(configName);
        }
        ConfigDBDialog dbDialog = new ConfigDBDialog((Frame)this, databaseConfig);
        dbDialog.setModal(true);
        dbDialog.setVisible(true);
        if (dbDialog.isOk()) {
            this.getTestDataConfig().saveOrUpdateDatabaseConfig(dbDialog.getDatabaseConfig());
            this.newConfigName = configName == null ? dbDialog.getCbxName().getSelectedItem().toString() : null;
        }
        return dbDialog.isOk();
    }

    public DatabaseConfig getDatabaseConfig(String configName) {
        DatabaseConfig databaseConfig = null;
        TestDataConfig testDataConfig = this.getTestDataConfig();
        databaseConfig = configName.equals("MySQL") ? testDataConfig.getDefDatabaseConfig() : testDataConfig.getDatabaseConfigs().get(configName);
        return databaseConfig;
    }

    private void bindToTree(Database database) {
        if (database != null) {
            this.getJLeftTree().setDatabase(database);
        }
        if (this.workspaceDataCache != null) {
            this.workspaceDataCache.setDatabase(database);
        } else {
            logger.error((Object)"%%%%%%%%%%%  workspaceDatCache is null %%%%%%%%%");
        }
        this.getJLeftTree().setData(database);
        TestDataConfig tdc = this.getTestDataConfig();
        if (tdc != null && tdc.getDatabaseConfigs() != null) {
            this.getJLeftTree().setDatabaseConfigs(tdc.getDatabaseConfigs());
        }
        this.getJLeftTree().updateUI();
    }

    private JSplitPane getJSplitPane() {
        if (this.jSplitPane == null) {
            this.jSplitPane = new JSplitPane();
            this.jSplitPane.setDividerSize(3);
            this.jSplitPane.setLeftComponent(this.getLeftPane());
            this.jSplitPane.setRightComponent(this.getJTabbedPane());
            this.jSplitPane.setDividerLocation(200);
            this.jSplitPane.setResizeWeight(0.4);
            this.jSplitPane.setPreferredSize(new Dimension(759, 501));
        }
        return this.jSplitPane;
    }

    private JScrollPane getLeftPane() {
        if (this.leftPane == null) {
            this.leftPane = new JScrollPane();
            this.leftPane.setViewportView(this.getJLeftTree());
        }
        return this.leftPane;
    }

    private JDBTree getJLeftTree() {
        if (this.jLeftTree == null) {
            this.jLeftTree = new JDBTree(this);
            this.jLeftTree.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    MainFrame.this.treeMouseClicked(e);
                }
            });
            TreeSelectionListener tsl = new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent e) {
                    MainFrame.this.treeSelectionChanged(e);
                }
            };
            this.jLeftTree.addTreeSelectionListener(tsl);
        }
        return this.jLeftTree;
    }

    protected void treeSelectionChanged(TreeSelectionEvent e) {
        TreePath treePath = e.getPath();
        if (treePath != null) {
            this.treeSelectChanged(treePath.getPath());
        }
    }

    protected void treeMouseClicked(MouseEvent e) {
        JDBTree DBTree = (JDBTree)e.getComponent();
        TreePath treePath = null;
        if (e.getButton() == 3) {
            treePath = DBTree.getPathForLocation(e.getX(), e.getY());
            if (treePath == null) {
                return;
            }
            DBTree.setSelectionPath(treePath);
        }
        if ((treePath = DBTree.getSelectionPath()) == null) {
            return;
        }
        Object[] paths = treePath.getPath();
        if (e.getButton() == 3 && !DBTree.isSelTable(paths)) {
            if (DBTree.isSelDatabase(paths)) {
                this.showDBPopupMenu(DBTree, e.getX(), e.getY());
            } else if (DBTree.isSelConnectionPool(paths)) {
                this.showConnectionPoolMenu(DBTree, e.getX(), e.getY());
            } else if (DBTree.isSelConnectConfig(paths)) {
                this.showConnectMenu(DBTree, e.getX(), e.getY());
            }
        }
    }

    protected void treeSelectChanged(Object[] paths) {
        if (this.getJLeftTree().isSelTableOrTableField(paths)) {
            String tableName = paths[JDBTree.LEVEL_TABLE].toString();
            Table selTable = (Table)paths[JDBTree.LEVEL_TABLE];
            Table curSelTable = this.getJLeftTree().getDatabase().getSelTable();
            if (curSelTable != selTable) {
                this.setCurSelTable(selTable);
                File configFile = this.workspaceDataCache.getTableConfigFile(selTable.getTableName());
                this.getCbxGenerate().setSelected(configFile.exists());
                this.showConfig(tableName);
            }
        } else {
            this.setCurSelTable(null);
            this.getCbxGenerate().setSelected(false);
            this.showConfig(null);
        }
        if (this.getJLeftTree().isSelConnectConfig(paths)) {
            DatabaseConfig curSelDatabaseConfig = (DatabaseConfig)paths[JDBTree.LEVEL_CONNECT];
            this.setCurSelDatabaseConfig(curSelDatabaseConfig);
        } else {
            this.setCurSelDatabaseConfig(null);
        }
        if (this.getCurSelTable() != null) {
            this.getColumnTable().setFields(this.getCurSelTable().getAllFields());
        }
        this.cbxGenerate.setEnabled(this.getCurSelTable() != null);
    }

    protected void showDBPopupMenu(Component invoker, int x, int y) {
        JPopupMenu pupupMenu = this.getJMenuBar().getDBPopupMenu();
        pupupMenu.show(invoker, x, y);
    }

    protected void showConnectionPoolMenu(Component invoker, int x, int y) {
        JPopupMenu pupupMenu = this.getJMenuBar().getConnectionPoolPopupMenu();
        pupupMenu.show(invoker, x, y);
    }

    public void addConnectConfig() {
        try {
            this.addNewConnectionConfig();
            this.tabbedPaneSelChanged();
            this.getJLeftTree().updateUI();
        }
        catch (Exception e) {
            logger.error((Object)"addConnectConfig", (Throwable)e);
            JOptionPane.showMessageDialog(this, String.valueOf(RM.R("label.MainFrame.error.addNewConfig")) + e.getMessage());
        }
    }

    public void disconnectAll() {
        this.getTestDataConfig().disconnectAll();
        this.tabbedPaneSelChanged();
        this.getJLeftTree().updateUI();
    }

    public void disconnect() {
        if (this.getCurSelDatabaseConfig() != null) {
            String configName = this.getCurSelDatabaseConfig().getName();
            this.getTestDataConfig().disconnectDatabase(configName);
            this.tabbedPaneSelChanged();
            this.getJLeftTree().updateUI();
        }
    }

    public void showConnectMenu(Component invoker, int x, int y) {
        if (invoker instanceof JDBTree) {
            JPopupMenu pupupMenu = this.getJMenuBar().getConnectionPopupMenu();
            pupupMenu.show(invoker, x, y);
        }
    }

    public void delelteConfig() {
        if (this.getTestDataConfig() != null && this.getCurSelDatabaseConfig() != null) {
            try {
                if (JOptionPane.showConfirmDialog(this, RM.R("label.MainFrame.deleteConnectConfirm")) == 0) {
                    int[] rows = this.getJLeftTree().getSelectionRows();
                    int selRow = rows[0];
                    TreePath parentPath = this.getJLeftTree().getSelectionPath().getParentPath();
                    if (this.getTestDataConfig().deleteDatabaseConfig(this.getCurSelDatabaseConfig().getName())) {
                        this.getJLeftTree().updateUI();
                        this.getJLeftTree().expandPath(parentPath);
                        int rowCount = this.getJLeftTree().getRowCount();
                        if (selRow == rowCount) {
                            selRow = rowCount - 1;
                        }
                        this.getJLeftTree().setSelectionRow(selRow);
                        this.getJLeftTree().updateUI();
                    }
                }
            }
            catch (BaseException e) {
                JOptionPane.showMessageDialog(this, String.valueOf(RM.R("label.MainFrame.error.deleteConfig")) + e.getMessage());
            }
        }
    }

    public boolean configAndReconnect() throws BaseException, SQLException {
        if (this.getCurSelDatabaseConfig() != null) {
            String configName = this.getCurSelDatabaseConfig().getName();
            return this.configAndReconnect(configName);
        }
        return false;
    }

    protected boolean configAndReconnect(String configName) throws BaseException, SQLException {
        boolean result = this.configDB(configName);
        if (result) {
            this.getTestDataConfig().disconnectDatabase(configName);
            if (configName == null) {
                configName = this.newConfigName;
            }
            this.getTestDataConfig().connectDatabase(configName);
        }
        return result;
    }

    public boolean addNewConnectionConfig() throws SQLException, BaseException {
        return this.configAndReconnect(null);
    }

    public TestDataConfig getTestDataConfig() {
        if (this.getWorkspaceDataCache() != null) {
            return this.getWorkspaceDataCache().getTestDataConfig();
        }
        return null;
    }

    public void connectAll() {
        try {
            this.getTestDataConfig().connectAll();
            this.tabbedPaneSelChanged();
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this, String.valueOf(RM.R("label.MainFrame.error.connectDatabase")) + ex.getMessage());
        }
        this.getJLeftTree().updateUI();
    }

    public void connect() {
        try {
            if (this.getCurSelDatabaseConfig() != null) {
                this.getTestDataConfig().connectDatabase(this.getCurSelDatabaseConfig().getName());
                this.tabbedPaneSelChanged();
            }
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this, String.valueOf(RM.R("label.MainFrame.error.connectDatabase")) + ex.getMessage());
        }
        this.getJLeftTree().updateUI();
    }

    public void autoConfigAll() {
        try {
            this.getJLeftTree().autoConfigAll();
        }
        catch (IOException ex) {
            logger.error((Object)"autoConfigAll", (Throwable)ex);
            JOptionPane.showMessageDialog(this, String.valueOf(RM.R("label.MainFrame.error.saveAutoConfig")) + ex.getMessage());
        }
    }

    public void deleteAllConfig() {
        int result = JOptionPane.showConfirmDialog(this, RM.R("label.MainFrame.deleteAllConfig.confirm"), RM.R("label.MainFrame.deleteAllConfig.confirm.title"), 0);
        if (result == 0) {
            this.getWorkspaceDataCache().removeAndBankupAllTableConfig();
            this.getJLeftTree().updateUI();
        }
    }

    private void showConfig(String tableName) {
        if (tableName == null) {
            this.dataExchange(null, true);
            this.getColumnTable().setRefs(new ArrayList(0));
        } else {
            File configFile = this.workspaceDataCache.getTableConfigFile(tableName);
            if (configFile.exists()) {
                try {
                    TableConfig tableConfig = this.getWorkspaceDataCache().getTableConfig(tableName);
                    this.dataExchange(tableConfig, true);
                }
                catch (BaseException e) {
                    logger.error((Object)"showConfig", (Throwable)e);
                    JOptionPane.showMessageDialog(this, String.valueOf(RM.R("label.MainFrame.error.parseConfigFile")) + e.getMessage());
                }
            } else {
                this.dataExchange(null, true);
            }
            this.resetRefValues();
        }
    }

    private void dataExchange(TableConfig tableConfig, boolean isToControl) {
        if (isToControl) {
            boolean configExist;
            boolean bl = configExist = tableConfig != null;
            if (!configExist) {
                this.cbxCloseIDAutoInsert.setSelected(false);
                this.txtCount.setText(null);
                this.cbxOnError.setSelectedItem(0);
                this.txtInit.setText(null);
                this.txtDestroy.setText(null);
                this.columnTable.setData(null);
            } else {
                this.cbxCloseIDAutoInsert.setSelected(tableConfig.isCloseIdAutoInsert());
                this.txtCount.setText(String.valueOf(tableConfig.getCount()));
                this.cbxOnError.setSelectedItem(tableConfig.getOnError());
                this.txtInit.setText(tableConfig.getInit());
                this.txtDestroy.setText(tableConfig.getDestroy());
                List<ColumnConfig> tempColumnConfig = TableConfig.cloneColumnConfigs(tableConfig.getColumnConfigs());
                this.columnTable.setData(tempColumnConfig);
            }
        } else if (this.getCurSelTable() != null) {
            tableConfig.setTableName(this.getCurSelTable().getTableName());
            tableConfig.setOnError((String)this.cbxOnError.getSelectedItem());
            tableConfig.setCloseIdAutoInsert(this.cbxCloseIDAutoInsert.isSelected());
            tableConfig.setCount(Integer.valueOf(this.txtCount.getText()).intValue());
            tableConfig.setInit(this.txtInit.getText().trim());
            tableConfig.setDestroy(this.txtDestroy.getText().trim());
            List<ColumnConfig> tempColumnConfigs = TableConfig.cloneColumnConfigs(this.columnTable.getData());
            tableConfig.setColumnConfigs(tempColumnConfigs);
        }
    }

    public static void printPath(Object[] paths) {
        System.out.println("==============================");
        Object[] objectArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            Object path = objectArray[n2];
            System.out.println(path);
            ++n2;
        }
    }

    private JPanel getConfigPanel() {
        if (this.configPanel == null) {
            this.jLabel4 = new JLabel();
            this.jLabel4.setBounds(new Rectangle(19, 203, 49, 18));
            this.jLabel4.setText(RM.R("label.MainFrame.ColumnConfig"));
            this.jLabel3 = new JLabel();
            this.jLabel3.setBounds(new Rectangle(20, 137, 45, 20));
            this.jLabel3.setText(RM.R("label.MainFrame.Clear"));
            this.jLabel2 = new JLabel();
            this.jLabel2.setBounds(new Rectangle(20, 73, 51, 20));
            this.jLabel2.setText(RM.R("label.MainFrame.Init"));
            this.jLabel1 = new JLabel();
            this.jLabel1.setBounds(263, 44, 49, 21);
            this.jLabel1.setText(RM.R("label.MainFrame.OnError"));
            this.jLabel = new JLabel();
            this.jLabel.setBounds(new Rectangle(20, 44, 49, 20));
            this.jLabel.setText(RM.R("label.MainFrame.Rows"));
            this.configPanel = new JPanel();
            this.configPanel.setLayout(null);
            this.configPanel.add((Component)this.getCbxGenerate(), null);
            this.configPanel.add((Component)this.jLabel, null);
            this.configPanel.add((Component)this.getTxtCount(), null);
            this.configPanel.add((Component)this.jLabel1, null);
            this.configPanel.add((Component)this.getCbxOnError(), null);
            this.configPanel.add((Component)this.jLabel2, null);
            this.configPanel.add((Component)this.getInitPanel(), null);
            this.configPanel.add((Component)this.jLabel3, null);
            this.configPanel.add((Component)this.getDestroyPane(), null);
            this.configPanel.add((Component)this.getColumnPane(), null);
            this.configPanel.add((Component)this.jLabel4, null);
            this.configPanel.add((Component)this.getCbxCloseIDAutoInsert(), null);
            this.configPanel.add((Component)this.getBtnAutoConfig(), null);
            this.configPanel.add((Component)this.getBtnAdd(), null);
            this.configPanel.add((Component)this.getBtnDel(), null);
            this.configPanel.add((Component)this.getBtnSave(), null);
            this.configPanel.add((Component)this.getBtnClose(), null);
            this.configPanel.add((Component)this.getBtnClearColumnConfig(), null);
            this.configPanel.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent e) {
                    MainFrame.this.frameResized(e);
                }
            });
        }
        return this.configPanel;
    }

    protected void frameResized(ComponentEvent e) {
        int rightPaneHeight;
        int rightPaneWidth = this.getConfigPanel().getWidth();
        if (rightPaneWidth < 500) {
            rightPaneWidth = 500;
        }
        if ((rightPaneHeight = this.getConfigPanel().getHeight()) < 350) {
            rightPaneHeight = 350;
        }
        int btnCloseX = rightPaneWidth - this.getBtnSave().getWidth() - 20;
        int btnSaveX = btnCloseX - 20 - this.getBtnClose().getWidth();
        this.getInitPanel().setSize(rightPaneWidth - this.getInitPanel().getX() - 20, this.getInitPanel().getHeight());
        this.getDestroyPane().setSize(rightPaneWidth - this.getDestroyPane().getX() - 20, this.getDestroyPane().getHeight());
        this.getColumnPane().setSize(rightPaneWidth - this.getColumnPane().getX() - 20, rightPaneHeight - 250);
        this.getBtnSave().setLocation(btnSaveX, rightPaneHeight - 35);
        this.getBtnClose().setLocation(btnCloseX, rightPaneHeight - 35);
        this.paintComponents(this.getGraphics());
    }

    private JCheckBox getCbxGenerate() {
        if (this.cbxGenerate == null) {
            this.cbxGenerate = new JCheckBox();
            this.cbxGenerate.setBounds(18, 17, 219, 20);
            this.cbxGenerate.setEnabled(false);
            this.cbxGenerate.setText(RM.R("label.MainFrame.generateTestData"));
            this.cbxGenerate.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.roleActionPerformed(e);
                }
            });
            this.cbxGenerate.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    MainFrame.this.roleStateChanged(e);
                }
            });
        }
        return this.cbxGenerate;
    }

    protected void roleStateChanged(ChangeEvent e) {
        boolean isSelected = this.getCbxGenerate().isSelected();
        this.enableControl(isSelected);
    }

    protected void roleActionPerformed(ActionEvent e) {
        boolean isSelected = this.getCbxGenerate().isSelected();
        String tableName = this.getCurSelTable().getTableName();
        File configFile = this.workspaceDataCache.getTableConfigFile(this.getCurSelTable().getTableName());
        String configFileName = configFile.getAbsolutePath();
        String bankupConfigFileName = String.valueOf(configFileName) + ".bank";
        if (!isSelected) {
            this.getWorkspaceDataCache().removeAndBankupTableConfig(tableName);
        } else {
            File bankupConfigFile = new File(bankupConfigFileName);
            if (bankupConfigFile.exists()) {
                if (!bankupConfigFile.renameTo(configFile)) {
                    logger.error((Object)("error on rename file [" + bankupConfigFileName + "] to [" + configFileName + "]"));
                }
            } else if (!configFile.exists()) {
                try {
                    String tableConfigContent = TableConfig.CONIFG_DEF_VALUE.replaceAll("tableName", this.getCurSelTable().getTableName());
                    FileUtils.writeStringToFile((File)configFile, (String)tableConfigContent);
                }
                catch (IOException e1) {
                    logger.error((Object)"MainFrame", (Throwable)e1);
                    JOptionPane.showMessageDialog(this, String.valueOf(RM.R("label.MainFrame.error.saveConfigFile")) + e1.getMessage());
                }
            }
        }
        this.showConfig(tableName);
        if (this.txtCount.getText().trim().equals("")) {
            this.txtCount.setText("" + Global.getInstance().P.getDefaultRowToGenerate());
        }
    }

    private JTextField getTxtCount() {
        if (this.txtCount == null) {
            this.txtCount = new JTextFieldEx();
            this.txtCount.setBounds(100, 43, 137, 21);
            this.txtCount.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    MainFrame.this.txtCountLostFocus(e);
                }
            });
        }
        return this.txtCount;
    }

    protected void txtCountLostFocus(FocusEvent e) {
        try {
            Integer.valueOf(this.txtCount.getText().trim());
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, RM.R("label.MainFrame.InvalidNumberInfo"));
            this.txtCount.setText("100");
            this.txtCount.grabFocus();
        }
    }

    private JComboBox getCbxOnError() {
        if (this.cbxOnError == null) {
            this.cbxOnError = new JComboBox();
            this.cbxOnError.setBounds(335, 43, 173, 22);
            this.cbxOnError.addItem("ignore");
            this.cbxOnError.addItem("exit");
            this.cbxOnError.addItem("query");
        }
        return this.cbxOnError;
    }

    private JScrollPane getInitPanel() {
        if (this.initPanel == null) {
            this.initPanel = new JScrollPane();
            this.initPanel.setBounds(101, 73, 404, 53);
            this.initPanel.setViewportView(this.getTxtInit());
        }
        return this.initPanel;
    }

    private JTextArea getTxtInit() {
        if (this.txtInit == null) {
            this.txtInit = new JTextArea();
            this.txtInit.setBounds(98, 74, 406, 50);
        }
        return this.txtInit;
    }

    private JScrollPane getDestroyPane() {
        if (this.destroyPane == null) {
            this.destroyPane = new JScrollPane();
            this.destroyPane.setBounds(101, 140, 404, 53);
            this.destroyPane.setViewportView(this.getTxtDestroy());
        }
        return this.destroyPane;
    }

    private JTextArea getTxtDestroy() {
        if (this.txtDestroy == null) {
            this.txtDestroy = new JTextArea();
            this.txtDestroy.setBounds(98, 136, 406, 50);
        }
        return this.txtDestroy;
    }

    private JScrollPane getColumnPane() {
        if (this.columnPane == null) {
            this.columnPane = new JScrollPane();
            this.columnPane.setBounds(101, 205, 409, 200);
            this.columnPane.setViewportView(this.getColumnTable());
        }
        return this.columnPane;
    }

    private ColumnTable getColumnTable() {
        if (this.columnTable == null) {
            this.columnTable = new ColumnTable();
            this.columnTable.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (MainFrame.this.columnTable.getSelectedColumn() == 2 && e.getButton() == 1) {
                        MainFrame.this.editRole();
                    }
                }
            });
            this.columnTable.setCellEditor(this.getTableCellEditor());
        }
        return this.columnTable;
    }

    protected void editRole() {
        int selRow = this.getColumnTable().getSelectedRow();
        String selRoleName = null;
        if (selRow != -1) {
            ColumnConfig columnConfig = this.getColumnTable().getData().get(selRow);
            selRoleName = columnConfig.getRefRoleName();
        }
        this.showRoleDialogAndSelPath(this.getCurSelTable().getTableName(), selRoleName);
    }

    public DefaultCellEditor getTableCellEditor() {
        JComboBox<String> cbxTT = new JComboBox<String>();
        cbxTT.addItem("String");
        cbxTT.addItem("def");
        DefaultCellEditor cellEditor = new DefaultCellEditor(cbxTT);
        return cellEditor;
    }

    private JCheckBox getCbxCloseIDAutoInsert() {
        if (this.cbxCloseIDAutoInsert == null) {
            this.cbxCloseIDAutoInsert = new JCheckBox();
            this.cbxCloseIDAutoInsert.setBounds(263, 19, 232, 13);
            this.cbxCloseIDAutoInsert.setText(RM.R("label.MainFrame.idEntityCanInsert"));
        }
        return this.cbxCloseIDAutoInsert;
    }

    private JTDButton getBtnAutoConfig() {
        if (this.btnAutoConfig == null) {
            this.btnAutoConfig = new JTDButton();
            this.btnAutoConfig.setBounds(15, 301, 75, 23);
            this.btnAutoConfig.setText(RM.R("label.MainFrame.Auto"));
            this.btnAutoConfig.setToolTipText(RM.R("label.MainFrame.auto.toolTip"));
            this.btnAutoConfig.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        MainFrame.this.autoConfig();
                    }
                    catch (Exception e1) {
                        logger.error((Object)"getBtnAutoConfig", (Throwable)e1);
                        JOptionPane.showMessageDialog(MainFrame.this, String.valueOf(RM.R("label.MainFrame.error.saveResult")) + e1.getMessage());
                    }
                }
            });
        }
        return this.btnAutoConfig;
    }

    public void autoConfig() throws SAXException, IOException, DocumentException {
        Table table = this.getCurSelTable();
        if (table != null) {
            AutoConfigEngine autoConfigEngine = new AutoConfigEngine();
            TableConfig tableConfig = autoConfigEngine.reverseTable(table);
            this.dataExchange(tableConfig, true);
            this.getWorkspaceDataCache().addOrRefershTableConfig(tableConfig);
            this.resetRefValues();
        }
    }

    private JTDButton getBtnAdd() {
        if (this.btnAdd == null) {
            this.btnAdd = new JTDButton();
            this.btnAdd.setBounds(15, 234, 75, 23);
            this.btnAdd.setText(RM.R("label.MainFrame.add"));
            this.btnAdd.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.addRow();
                }
            });
        }
        return this.btnAdd;
    }

    protected void addRow() {
        this.getColumnTable().addRow();
    }

    private JTDButton getBtnDel() {
        if (this.btnDel == null) {
            this.btnDel = new JTDButton();
            this.btnDel.setBounds(15, 268, 75, 23);
            this.btnDel.setText(RM.R("label.MainFrame.delete"));
            this.btnDel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.deleteCurrentItem();
                }
            });
        }
        return this.btnDel;
    }

    protected void deleteCurrentItem() {
        int result;
        if (this.getColumnTable().getSelectedRow() != -1 && (result = JOptionPane.showConfirmDialog(this, RM.R("label.MainFrame.delete.confirm"))) == 0) {
            this.getColumnTable().deleteCurrentItem();
        }
    }

    private JTDButton getBtnSave() {
        if (this.btnSave == null) {
            this.btnSave = new JTDButton();
            this.btnSave.setBounds(296, 423, 97, 23);
            this.btnSave.setText(RM.R("label.MainFrame.SaveConfig"));
            this.btnSave.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        MainFrame.this.saveConfig(e);
                    }
                    catch (IOException e1) {
                        logger.error((Object)"getBtnSave", (Throwable)e1);
                        JOptionPane.showMessageDialog(MainFrame.this, "\u4fdd\u5b58\u914d\u7f6e\u6587\u4ef6\u65f6\u51fa\ufffd? [" + e1.getMessage());
                    }
                }
            });
        }
        return this.btnSave;
    }

    protected void saveConfig(ActionEvent e) throws IOException {
        if (this.getCurSelTable() != null) {
            TableConfig tableConfig = this.getCurTableConfig();
            if (tableConfig == null) {
                tableConfig = new TableConfig();
            }
            this.dataExchange(tableConfig, false);
            tableConfig.saveConfig();
        }
    }

    private JTDButton getBtnClose() {
        if (this.btnClose == null) {
            this.btnClose = new JTDButton();
            this.btnClose.setBounds(416, 423, 94, 23);
            this.btnClose.setText(RM.R("label.info.btnClose"));
            this.btnClose.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.dispose();
                    System.exit(0);
                }
            });
        }
        return this.btnClose;
    }

    private JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTabbedPane();
            this.jTabbedPane.setPreferredSize(new Dimension(566, 485));
            this.jTabbedPane.addTab(RM.R("label.MainFrame.TestDataConfig.title"), this.getConfigPanel());
            this.jTabbedPane.addTab(RM.R("label.MainFrame.queryPane.title"), this.getQueryPane());
            this.jTabbedPane.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    MainFrame.this.tabbedPaneSelChanged();
                }
            });
        }
        return this.jTabbedPane;
    }

    public void tabbedPaneSelChanged() {
        int selIndex = this.getJTabbedPane().getSelectedIndex();
        switch (selIndex) {
            case 0: {
                break;
            }
            case 1: {
                if (!StringUtils.isNotEmpty((String)this.getWorkspace())) break;
                this.getQueryPane().initConnectionCombox(this.getTestDataConfig().getAllConnNames());
            }
        }
    }

    public QueryPanel getQueryPane() {
        if (this.queryPanel == null) {
            this.queryPanel = new QueryPanel();
        }
        return this.queryPanel;
    }

    private MainFrame() {
        this.initialize();
        this.center();
        this.enableControl(false);
    }

    public static synchronized MainFrame getInstance() {
        if (instance == null) {
            instance = new MainFrame();
        }
        return instance;
    }

    private void initialize() {
        this.G.initlize();
        this.setSize(759, 544);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/resources/icon/TDB.png")));
        this.setContentPane(this.getJContentPane());
        this.setJMenuBar(new JTDBMenuBar(this));
        this.setTitle(this.initTitle);
        Helper.getInstance().enableHelpKey(this.getRootPane(), "quickStart.readme");
    }

    public boolean exists(String filePath) {
        return new File(filePath).exists();
    }

    public void initWorkspace() {
        this.getJMenuBar().setHasWorkspace(this.getWorkspace() != null);
        this.getJTDBToolBar().setHasWorkspace(this.getWorkspace() != null);
        if (this.getWorkspace() != null && !Global.isValidWorkspace(this.getWorkspace())) {
            JOptionPane.showMessageDialog(this, String.format(RM.R("label.MainFrame.project.invalid"), this.getWorkspace()));
            this.G.saveLastWorkspace(null);
            RecentProjects.getInstance().removeProjectByPathAndSave(this.getWorkspace());
            this.G.setWorkspace(null);
        }
        if (StringUtils.isEmpty((String)this.getWorkspace())) {
            try {
                WorkspaceDataCache.getInstance().init(null);
            }
            catch (BaseException e) {
                logger.error((Object)"initWorkspace", (Throwable)e);
            }
            this.setTitle(this.initTitle);
            this.bindToTree(null);
            this.treeSelectChanged(null);
        } else {
            try {
                if (this.G.P.getAutoConnWhenProgramStartup().booleanValue()) {
                    this.initWorkspaceFromDB();
                } else {
                    this.initWorkspaceFromLocalFile();
                }
            }
            catch (Exception e) {
                logger.error((Object)"initWorkspaceFromDB or local file", (Throwable)e);
                JOptionPane.showMessageDialog(this, String.valueOf(RM.R("label.MainFrame.error.initApp")) + e.getMessage());
                this.getJLeftTree().setModel(null);
                this.treeSelectChanged(null);
                this.getJMenuBar().setHasWorkspace(false);
            }
        }
    }

    public void initWorkspaceFromDB() throws BaseException {
        this.initWorkspaceDataCache();
        this.refreshDataFromDB();
        this.setTitle(String.valueOf(this.getWorkspace()) + "[" + this.workspaceDataCache.getTestDataConfig().getName() + "]");
    }

    public void initWorkspaceFromLocalFile() throws BaseException {
        this.initWorkspaceDataCache();
        try {
            DatabaseUtil dbUtil = new DatabaseUtil();
            dbUtil.setBasePath(this.getWorkspace());
            Database database = dbUtil.readDBInfoFromBasePath();
            this.bindToTree(database);
            dbUtil.disconnect();
        }
        catch (Exception e) {
            logger.error((Object)"initWorkspaceFromLocalFile", (Throwable)e);
            JOptionPane.showMessageDialog(this, String.valueOf(RM.R("label.MainFrame.error.readLocalConfigFile")) + e.getMessage());
            this.bindToTree(null);
        }
        this.setTitle(String.valueOf(this.getWorkspace()) + "[" + this.workspaceDataCache.getTestDataConfig().getName() + "]");
    }

    protected void initWorkspaceDataCache() throws BaseException {
        this.workspaceDataCache.init(this.getWorkspace());
    }

    public void refreshDataFromDB() {
        Database database;
        DatabaseUtil dbUtil;
        block7: {
            dbUtil = new DatabaseUtil();
            dbUtil.setBasePath(this.getWorkspace());
            this.resetRefValues();
            dbUtil.setConfig(this.getTestDataConfig().getDefDatabaseConfig());
            database = null;
            try {
                dbUtil.connect();
                database = dbUtil.getDefArchitecture(3);
                if (this.G.P.getSaveDbMetaInfo().booleanValue() && database != null) {
                    dbUtil.writeDBInfo(database);
                }
            }
            catch (Exception ex) {
                logger.error((Object)"MianFrame", (Throwable)ex);
                JOptionPane.showMessageDialog(this, String.valueOf(RM.R("label.MainFrame.error.connectDatabase")) + ex.getMessage());
                if (!this.G.P.getReadDBInfoFromFileWhenConnError().booleanValue()) break block7;
                try {
                    database = dbUtil.readDBInfoFromBasePath();
                }
                catch (IOException e) {
                    logger.error((Object)"MianFrame", (Throwable)e);
                    JOptionPane.showMessageDialog(this, String.valueOf(RM.R("label.MainFrame.error.connectDatabase")) + e.getMessage());
                }
            }
        }
        this.bindToTree(database);
        try {
            dbUtil.disconnect();
        }
        catch (SQLException e) {
            logger.error((Object)"MianFrame", (Throwable)e);
        }
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJTDBToolBar(), "North");
            this.jContentPane.add((Component)this.getJSplitPane(), "Center");
            this.jContentPane.add((Component)this.getMsgLine(), "South");
        }
        return this.jContentPane;
    }

    private JTDBToolBar getJTDBToolBar() {
        if (this.tdbToolBar == null) {
            this.tdbToolBar = new JTDBToolBar(this);
        }
        return this.tdbToolBar;
    }

    public JLabel getMsgLine() {
        if (this.msgLine == null) {
            this.msgLine = new JLabel(" ");
        }
        return this.msgLine;
    }

    public String getWorkspace() {
        return this.G.getWorkspace();
    }

    public Table getCurSelTable() {
        if (this.getDatabase() != null) {
            return this.getDatabase().getSelTable();
        }
        return null;
    }

    public TableConfig getCurTableConfig() {
        TableConfig curTableConfig = null;
        Table curSelTable = this.getCurSelTable();
        if (curSelTable != null) {
            curTableConfig = this.getWorkspaceDataCache().getTableConfigFromList(curSelTable.getTableName());
        }
        return curTableConfig;
    }

    public void setCurSelTable(Table selTable) {
        if (this.getDatabase() != null) {
            this.getDatabase().setSelTable(selTable);
        }
    }

    public void setCurSelDatabaseConfig(DatabaseConfig curSelDatabaseConfig) {
        this.getJLeftTree().setCurSelDatabaseConfig(curSelDatabaseConfig);
    }

    public DatabaseConfig getCurSelDatabaseConfig() {
        return this.getJLeftTree().getCurSelDatabaseConfig();
    }

    public void openProject() {
        JProjectDirChooser directoryChooser = new JProjectDirChooser(Global.getInstance().P.getWorkspace());
        directoryChooser.setFileSelectionMode(1);
        if (directoryChooser.showOpenDialog(this) == 0) {
            String dirPath = directoryChooser.getSelectedFile().getAbsolutePath();
            this.openProject(dirPath);
        }
    }

    public void openProjectInExplorer() {
        if (StringUtils.isNotEmpty((String)this.getWorkspace())) {
            OpenWorkspaceUtil.openWorkspaceInExplorer(this.getWorkspace(), this);
        }
    }

    public void openProject(String projectPath) {
        this.setWorkspaceAndUpdateConfig(projectPath);
        this.initWorkspace();
    }

    public void setWorkspaceAndUpdateConfig(String workspace) {
        this.G.setWorkspaceLastWorkspace(workspace);
        int sep_index = workspace.lastIndexOf(Global.SEP);
        String projectName = workspace.substring(sep_index + 1);
        RecentProjects.getInstance().addProject2RecentList(projectName, workspace);
    }

    public void closeProject() {
        int result = JOptionPane.showConfirmDialog(this, RM.R("label.MainFrame.closeProjectConfirm"));
        if (result == 0) {
            this.G.setWorkspace(null);
            this.initWorkspace();
        }
    }

    public void createProject() {
        ProjectDialog projectDialog = new ProjectDialog(this);
        projectDialog.setModal(true);
        projectDialog.setVisible(true);
        if (projectDialog.isOK()) {
            this.setWorkspaceAndUpdateConfig(projectDialog.getProjectPath());
            try {
                this.initWorkspaceDataCache();
                this.configDBAndInitWorkspace("MySQL", true);
                this.getJMenuBar().setHasWorkspace(this.getWorkspace() != null);
                this.getJTDBToolBar().setHasWorkspace(this.getWorkspace() != null);
            }
            catch (Exception ex) {
                logger.error((Object)"MainFrame", (Throwable)ex);
                JOptionPane.showMessageDialog(this, String.valueOf(RM.R("label.MainFrame.error.connectDatabase")) + ex.getMessage());
            }
        }
    }

    GenerateDataDialog getGenerateDataDialog() throws BaseException {
        if (this.genDialog != null && this.genDialog.isRunInBackground()) {
            this.genDialog.setIsRunInBackground(false);
            return this.genDialog;
        }
        if (this.genDialog != null) {
            this.genDialog.dispose();
        }
        this.getWorkspaceDataCache().setSortedTableNames(this.getDatabase().getSortedTableNames());
        this.genDialog = new GenerateDataDialog(this, this.getWorkspaceDataCache());
        this.genDialog.setModal(true);
        return this.genDialog;
    }

    public void showGeneateDateDialog() {
        try {
            this.getGenerateDataDialog().setVisible(true);
        }
        catch (BaseException ex) {
            JOptionPane.showMessageDialog(this, String.valueOf(RM.R("label.MainFrame.error.e")) + ex.getMessage());
        }
    }

    public void showAboutDialog() {
        AboutDialog aboutDialog = new AboutDialog(this);
        aboutDialog.setModal(true);
        aboutDialog.setVisible(true);
    }

    public void showQueryConsole() {
        this.getJTabbedPane().setSelectedIndex(1);
    }

    public void showDataExchangerWindow() {
        JOptionPane.showMessageDialog(this, RM.R("label.MainFrame.unImplementFunction"));
    }

    public void showDataModelView() {
        JOptionPane.showMessageDialog(this, RM.R("label.MainFrame.unImplementFunction"));
    }

    public void showPreferenceDialog() {
        PreferenceDialog preferenceDialog = new PreferenceDialog(this, this.G.P);
        preferenceDialog.setModal(true);
        preferenceDialog.setWorkspace(this.getWorkspace());
        preferenceDialog.setVisible(true);
    }

    public void showSysPropertyDialog() {
        AppPropertyDialog appPropertyDialog = new AppPropertyDialog(this, this.G.getAppProperties());
        appPropertyDialog.setModal(true);
        appPropertyDialog.setVisible(true);
    }

    public void showHelp() {
    }

    public void showUpgradeDialog() {
        UpgradeDialog upgradeDialog = new UpgradeDialog(this);
        upgradeDialog.setVisible(true);
    }

    public void showRoleWindow() {
        if (this.getCurSelTable() != null) {
            this.showRoleDialogAndSelPath(this.getCurSelTable().getTableName());
        } else {
            this.showRoleDialogAndSelPath(new Object[0]);
        }
    }

    public void showRoleDialogAndSelPath(Object ... selPath) {
        RoleDialog roleDialog = new RoleDialog(this, this.getWorkspaceDataCache());
        if (selPath != null) {
            roleDialog.setSelectPath(selPath);
        }
        roleDialog.setModal(true);
        roleDialog.setVisible(true);
        this.resetRefValues();
    }

    public WorkspaceDataCache getWorkspaceDataCache() {
        return this.workspaceDataCache;
    }

    public void setWorkspaceDataCache(WorkspaceDataCache workspaceDataCache) {
        this.workspaceDataCache = workspaceDataCache;
    }

    private JTDButton getBtnClearColumnConfig() {
        if (this.btnClearColumnConfig == null) {
            this.btnClearColumnConfig = new JTDButton();
            this.btnClearColumnConfig.setBounds(15, 337, 75, 23);
            this.btnClearColumnConfig.setText(RM.R("label.MainFrame.clearAll"));
            this.btnClearColumnConfig.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.delAllColumnConfig();
                }
            });
        }
        return this.btnClearColumnConfig;
    }

    protected void delAllColumnConfig() {
        if (this.getColumnTable().getData() != null && this.getColumnTable().getData().size() > 0 && JOptionPane.showConfirmDialog(this, RM.R("label.MainFrame.clearAll.confirm")) == 0) {
            this.getColumnTable().setData(null);
        }
    }

    private DataModelPanel getDataModelPanel() {
        if (this.dataModelPanel == null) {
            this.dataModelPanel = new DataModelPanel();
        }
        return this.dataModelPanel;
    }
}

