/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.ui.main;

import com.testDataBuilder.resources.RM;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JOptionPane;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class OpenWorkspaceUtil {
    static Logger logger = Logger.getLogger(OpenWorkspaceUtil.class);
    public static String COMMAND_FILE = "res/osExplorerCmd.xml";
    public static String WORKSPACE_MASK = "${workspace}";

    public static void openWorkspaceInExplorer(String workspace, Component parent) {
        Properties p = new Properties();
        FileInputStream is = null;
        File file = new File(COMMAND_FILE);
        try {
            is = FileUtils.openInputStream((File)file);
            p.loadFromXML(is);
        }
        catch (IOException ex) {
            String info = String.format(RM.R("label.OpenWorkspaceUtil.error.openCommandFile"), file.getAbsolutePath());
            JOptionPane.showMessageDialog(parent, info);
            logger.info((Object)info, (Throwable)ex);
            return;
        }
        String OSName = System.getProperty("os.name").toLowerCase();
        String command = (String)p.get(OSName);
        if (command != null) {
            command = command.replace(WORKSPACE_MASK, workspace);
            try {
                Runtime.getRuntime().exec(command);
            }
            catch (IOException ex) {
                String info = String.format(RM.R("label.OpenWorkspaceUtil.error.openProject"), workspace, ex.getMessage());
                JOptionPane.showMessageDialog(parent, info);
                logger.info((Object)info, (Throwable)ex);
            }
        } else {
            String info = String.format(RM.R("label.OpenWorkspaceUtil.error.openProject.noCmd"), OSName, file.getAbsolutePath());
            logger.info((Object)info);
            JOptionPane.showMessageDialog(parent, info);
        }
    }
}

