/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.ui.main;

import com.testDataBuilder.config.DatabaseConfig;
import com.testDataBuilder.dbMetaInfo.Column;
import com.testDataBuilder.dbMetaInfo.Constraints;
import com.testDataBuilder.dbMetaInfo.Database;
import com.testDataBuilder.dbMetaInfo.ForeignKey;
import com.testDataBuilder.dbMetaInfo.PrimaryKey;
import com.testDataBuilder.dbMetaInfo.Table;
import com.testDataBuilder.ui.main.JDBTree;
import com.testDataBuilder.ui.main.JDBTreeRootObj;
import java.awt.Component;
import java.net.URL;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

class TDBTreeRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 1L;
    JDBTree parent = null;

    public TDBTreeRenderer(JDBTree parent) {
        this.parent = parent;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String strIcon = "Host.gif";
        if (value instanceof JDBTreeRootObj) {
            strIcon = "project.gif";
        } else if (value instanceof List) {
            List list = (List)value;
            if (list.size() > 0 && list.get(0) instanceof Column) {
                strIcon = "Columns.gif";
            }
        } else if (value instanceof Database) {
            strIcon = "Database.gif";
        } else if (value instanceof Table) {
            strIcon = this.parent.tableIsConfiged((Table)value) ? "TableSel.gif" : "Table.gif";
        } else if (value instanceof Column) {
            strIcon = "Field.gif";
        } else if (value instanceof Constraints) {
            strIcon = "Constraints.gif";
        } else if (value instanceof PrimaryKey) {
            strIcon = "pk.gif";
        } else if (value instanceof ForeignKey) {
            strIcon = "pk.gif";
        } else if (value instanceof String) {
            strIcon = "cField.gif";
        } else if (value instanceof DatabaseConfig) {
            DatabaseConfig databaseConfig = (DatabaseConfig)value;
            strIcon = this.parent.connIsOpend(databaseConfig.getName()) ? "DatabaseConnected.gif" : "Database.gif";
        }
        URL url = this.getClass().getResource("/resources/icon/tree/" + strIcon);
        ImageIcon icon = new ImageIcon(url);
        this.setLeafIcon(icon);
        this.setOpenIcon(icon);
        this.setClosedIcon(icon);
        return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }
}

