/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.ui.main.others;

import com.testDataBuilder.resources.RM;
import com.testDataBuilder.resources.ResourceManager;
import com.testDataBuilder.ui.core.CenterDialog;
import com.testDataBuilder.ui.core.JTDButton;
import com.testDataBuilder.ui.main.others.LookAndFeelItem;
import com.testDataBuilder.util.AppProperty;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppPropertyDialog
extends CenterDialog {
    AppProperty appProperty = null;
    private JPanel jContentPane = null;
    private JPanel jInnerPanel = null;
    private JCheckBox cbxShowConfigDialogOnStart = null;
    private JTDButton btnOK = null;
    private JTDButton btnCancel = null;
    private JLabel labelLocale = null;
    private JLabel jLabel = null;
    private JComboBox comboxLocale = null;
    private JComboBox comboxLookAndFeel = null;
    List<LookAndFeelItem> lookAndFeels = null;
    private boolean isOK = false;

    public List<LookAndFeelItem> getLookAndFeels() {
        if (this.lookAndFeels == null) {
            this.lookAndFeels = new ArrayList<LookAndFeelItem>(4);
            this.lookAndFeels.add(new LookAndFeelItem("label.AppPropertyDialog.lookAndFeel.javaDef", "javax.swing.plaf.metal.MetalLookAndFeel"));
            this.lookAndFeels.add(new LookAndFeelItem("label.AppPropertyDialog.lookAndFeel.sysDef", AppProperty.LOOK_AND_FEEL_SYS_DEF));
        }
        return this.lookAndFeels;
    }

    public LookAndFeelItem getLookAndFeelByClassName(String className) {
        for (LookAndFeelItem lookAndFeelItem : this.getLookAndFeels()) {
            if (!lookAndFeelItem.getClassName().equals(className)) continue;
            return lookAndFeelItem;
        }
        return null;
    }

    public AppPropertyDialog() {
        this.initialize();
    }

    public AppPropertyDialog(AppProperty appProperty) {
        this.appProperty = appProperty;
        this.initialize();
    }

    public AppPropertyDialog(JFrame parent, AppProperty appProperty) {
        super(parent);
        this.appProperty = appProperty;
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(390, 233));
        this.setTitle(RM.R("label.AppPropertyDialog.title"));
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.setContentPane(this.getJContentPane());
        this.getRootPane().setDefaultButton(this.getBtnOK());
        this.center();
        this.dataExchange(this.appProperty, true);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(null);
            this.jContentPane.add((Component)this.getJInnerPanel(), null);
            this.jContentPane.add((Component)this.getCbxShowConfigDialogOnStart(), null);
            this.jContentPane.add((Component)this.getBtnOK(), null);
            this.jContentPane.add((Component)this.getBtnCancel(), null);
        }
        return this.jContentPane;
    }

    private JPanel getJInnerPanel() {
        if (this.jInnerPanel == null) {
            this.jLabel = new JLabel();
            this.jLabel.setBounds(new Rectangle(28, 82, 64, 22));
            this.jLabel.setText(RM.R("label.AppPropertyDialog.label.lookAndFeel"));
            this.labelLocale = new JLabel();
            this.labelLocale.setBounds(new Rectangle(28, 44, 64, 22));
            this.labelLocale.setHorizontalTextPosition(4);
            this.labelLocale.setText(RM.R("label.AppPropertyDialog.label.locale"));
            this.jInnerPanel = new JPanel();
            this.jInnerPanel.setLayout(null);
            this.jInnerPanel.setBounds(new Rectangle(19, 15, 349, 139));
            this.jInnerPanel.setBorder(BorderFactory.createTitledBorder(null, "\u7cfb\u7edf\u53c2\u6570", 1, 2, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.jInnerPanel.add((Component)this.labelLocale, null);
            this.jInnerPanel.add((Component)this.jLabel, null);
            this.jInnerPanel.add((Component)this.getComboxLocale(), null);
            this.jInnerPanel.add((Component)this.getComboxLookAndFeel(), null);
        }
        return this.jInnerPanel;
    }

    void dataExchange(AppProperty appProperty, boolean isToControl) {
        if (isToControl) {
            this.getComboxLocale().setSelectedItem(appProperty.getLocale());
            LookAndFeelItem lookAndFeelItem = this.getLookAndFeelByClassName(appProperty.getLookAndFeel());
            if (lookAndFeelItem != null) {
                this.getComboxLookAndFeel().setSelectedItem(lookAndFeelItem);
            }
            this.getCbxShowConfigDialogOnStart().setSelected(appProperty.getShowConfigDialog());
        } else {
            appProperty.setLocale((String)this.getComboxLocale().getSelectedItem());
            LookAndFeelItem lookAndFeelItem = (LookAndFeelItem)this.getComboxLookAndFeel().getSelectedItem();
            appProperty.setLookAndFeel(lookAndFeelItem.getClassName());
            appProperty.setShowConfigDialog(this.getCbxShowConfigDialogOnStart().isSelected());
        }
    }

    private JCheckBox getCbxShowConfigDialogOnStart() {
        if (this.cbxShowConfigDialogOnStart == null) {
            this.cbxShowConfigDialogOnStart = new JCheckBox();
            this.cbxShowConfigDialogOnStart.setBounds(new Rectangle(19, 169, 178, 18));
            this.cbxShowConfigDialogOnStart.setText(RM.R("label.AppPropertyDialog.label.showConfigDialogWhenStart"));
        }
        return this.cbxShowConfigDialogOnStart;
    }

    private JTDButton getBtnOK() {
        if (this.btnOK == null) {
            this.btnOK = new JTDButton();
            this.btnOK.setBounds(new Rectangle(200, 168, 80, 22));
            this.btnOK.setText(RM.R("label.info.btnOK"));
            this.btnOK.requestFocusInWindow();
            this.btnOK.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AppPropertyDialog.this.onOK();
                }
            });
        }
        return this.btnOK;
    }

    protected void onOK() {
        try {
            this.dataExchange(this.appProperty, false);
            this.appProperty.storeToDefXmlFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, String.valueOf(RM.R("label.AppPropertyDialog.error.saveConfig")) + e.getMessage());
        }
        this.isOK = true;
        this.dispose();
    }

    private JTDButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JTDButton();
            this.btnCancel.setBounds(new Rectangle(288, 168, 80, 22));
            this.btnCancel.setText(RM.R("label.info.btnCancel"));
            this.btnCancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AppPropertyDialog.this.onCancel();
                }
            });
        }
        return this.btnCancel;
    }

    protected void onCancel() {
        this.dispose();
    }

    private JComboBox getComboxLocale() {
        if (this.comboxLocale == null) {
            this.comboxLocale = new JComboBox();
            this.comboxLocale.setBounds(new Rectangle(98, 44, 176, 21));
            List<String> allLocale = ResourceManager.getAllLocale();
            for (String locale : allLocale) {
                this.comboxLocale.addItem(locale);
            }
            this.comboxLocale.setSelectedItem(Locale.getDefault().toString());
        }
        return this.comboxLocale;
    }

    private JComboBox getComboxLookAndFeel() {
        if (this.comboxLookAndFeel == null) {
            this.comboxLookAndFeel = new JComboBox();
            this.comboxLookAndFeel.setBounds(new Rectangle(98, 83, 176, 21));
            List<LookAndFeelItem> lookAndFeels = this.getLookAndFeels();
            for (LookAndFeelItem lookAndFeel : lookAndFeels) {
                this.comboxLookAndFeel.addItem(lookAndFeel);
            }
        }
        return this.comboxLookAndFeel;
    }

    public boolean isOK() {
        return this.isOK;
    }

    public void setOK(boolean isOK) {
        this.isOK = isOK;
    }
}

