/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.ui.main.others;

import com.testDataBuilder.resources.RM;
import com.testDataBuilder.ui.help.Helper;
import com.testDataBuilder.ui.main.MainFrame;
import com.testDataBuilder.ui.project.ProjectInfo;
import com.testDataBuilder.ui.project.RecentProjects;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTDBMenuBar
extends JMenuBar {
    static Logger logger = Logger.getLogger(JTDBMenuBar.class);
    private MainFrame parent;
    private JMenu projectMenu;
    private JMenu databaseMenu;
    private JMenu roleMenu;
    private JMenu windowMenu;
    private JMenu helpMenu;
    public boolean hasWorkspace = false;
    int recentProjectBeginPos = 0;
    JMenuItem generateItem = null;
    JMenuItem newProjectItem = null;
    JMenuItem openProjectItem = null;
    JMenuItem closeProjectItem = null;
    JMenuItem openProjectInExplorerItem = null;
    JMenuItem exitItem = null;
    JMenuItem configureDefaultConnectionItem = null;
    JMenuItem addConnectionMenuItem = null;
    JMenuItem connectAllMenuItem = null;
    JMenuItem disconnectAllMenuItem = null;
    JMenuItem configMenuItem = null;
    JMenuItem deleteConfigMenuItem = null;
    JMenuItem connectMenuItem = null;
    JMenuItem disconnectMenuItem = null;
    JMenuItem autoConfigAllMenuItem = null;
    JMenuItem refreshDbStructureMenuItem = null;
    JMenuItem deleteAllConfigMenuItem = null;
    JMenuItem roleItem = null;
    JMenuItem queryConsoleWindowItem = null;
    JMenuItem dataModelItem = null;
    JMenuItem dataExchangerItem = null;
    JMenuItem preferenceItem = null;
    JMenuItem sysPropertyItem = null;

    public void setHasWorkspace(boolean hasWorkspace) {
        if (this.hasWorkspace != hasWorkspace) {
            this.hasWorkspace = hasWorkspace;
            this.setMenuState();
        }
    }

    private void setMenuState() {
        this.getCloseProjectItem().setEnabled(this.hasWorkspace);
        this.getOpenProjectInExplorerItem().setEnabled(this.hasWorkspace);
        this.getDefaultConnectionItem().setEnabled(this.hasWorkspace);
        this.getAddConnectionMenuItem().setEnabled(this.hasWorkspace);
        this.getConfigMenuItem().setEnabled(this.hasWorkspace);
        this.getConnectMenuItem().setEnabled(this.hasWorkspace);
        this.getDisConnectItem().setEnabled(this.hasWorkspace);
        this.getConnectAllMenuItem().setEnabled(this.hasWorkspace);
        this.getDisconnectAllMenuItem().setEnabled(this.hasWorkspace);
        this.getRoleWindowItem().setEnabled(this.hasWorkspace);
        this.getGenerateItem().setEnabled(this.hasWorkspace);
    }

    public JTDBMenuBar(MainFrame parent) {
        this.parent = parent;
        this.add(this.getProjectMenu());
        this.add(this.getDatabaseMenu());
        this.add(this.getRoleMenu());
        this.add(this.getWindowMenu());
        this.add(this.getHelpMenu());
        this.setMenuState();
    }

    @Override
    public JMenu getHelpMenu() {
        if (this.helpMenu == null) {
            this.helpMenu = new JMenu(this.R("label.JTDBMenuBar.menu.help"));
            JMenuItem subjectItem = new JMenuItem(this.R("label.JTDBMenuBar.menu.help.content"));
            subjectItem.addActionListener(Helper.getInstance().getHelpListener());
            this.helpMenu.add(subjectItem);
            this.helpMenu.addSeparator();
            JMenuItem autoUpgradeItem = new JMenuItem(this.R("label.JTDBMenuBar.menu.help.autoUpgrade"));
            autoUpgradeItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTDBMenuBar.this.parent.showUpgradeDialog();
                }
            });
            this.helpMenu.add(autoUpgradeItem);
            this.helpMenu.addSeparator();
            JMenuItem aboutItem = new JMenuItem(this.R("label.JTDBMenuBar.menu.help.about"));
            aboutItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTDBMenuBar.this.parent.showAboutDialog();
                }
            });
            this.helpMenu.add(aboutItem);
        }
        return this.helpMenu;
    }

    private JMenu getWindowMenu() {
        if (this.windowMenu == null) {
            this.windowMenu = new JMenu(this.R("label.JTDBMenuBar.menu.window"));
            this.windowMenu.add(this.getQueryConsoleWindowItem());
            this.windowMenu.add(this.getDataModelItem());
            this.windowMenu.add(this.getDataExchangerItem());
            this.windowMenu.addSeparator();
            this.windowMenu.add(this.getPreferenceItem());
            this.windowMenu.addSeparator();
            this.windowMenu.add(this.getSysPropertyItem());
        }
        return this.windowMenu;
    }

    public JMenu getRoleMenu() {
        if (this.roleMenu == null) {
            this.roleMenu = new JMenu(this.R("label.JTDBMenuBar.menu.role"));
            this.roleMenu.add(this.getRoleWindowItem());
            this.roleMenu.addSeparator();
            this.roleMenu.add(this.getGenerateItem());
        }
        return this.roleMenu;
    }

    private JMenu getDatabaseMenu() {
        if (this.databaseMenu == null) {
            this.databaseMenu = new JMenu(this.R("label.JTDBMenuBar.menu.database"));
            this.databaseMenu.add(this.getDefaultConnectionItem());
            this.databaseMenu.addSeparator();
            this.databaseMenu.add(this.getAddConnectionMenuItem());
            this.databaseMenu.add(this.getConfigMenuItem());
            this.databaseMenu.add(this.getConnectMenuItem());
            this.databaseMenu.add(this.getDisConnectItem());
            this.databaseMenu.addSeparator();
            this.databaseMenu.add(this.getConnectAllMenuItem());
            this.databaseMenu.add(this.getDisconnectAllMenuItem());
        }
        return this.databaseMenu;
    }

    private JMenu getProjectMenu() {
        if (this.projectMenu == null) {
            this.projectMenu = new JMenu(this.R("label.JTDBMenuBar.menu.project"));
            this.projectMenu.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    JTDBMenuBar.this.projectMenuMouseClicked(e);
                }
            });
            this.projectMenu.add(this.getNewProjectItem());
            this.projectMenu.add(this.getOpenProjectItem());
            this.projectMenu.add(this.getCloseProjectItem());
            this.projectMenu.add(this.getOpenProjectInExplorerItem());
            this.recentProjectBeginPos = this.projectMenu.getItemCount();
            this.addRecentProjectMenuItem(this.projectMenu);
            this.projectMenu.addSeparator();
            this.projectMenu.add(this.getExitItem());
        }
        return this.projectMenu;
    }

    protected void projectMenuMouseClicked(MouseEvent e) {
        if (RecentProjects.getInstance().isChanged()) {
            RecentProjects.getInstance().setChanged(false);
            int i = this.recentProjectBeginPos;
            while (i < this.projectMenu.getItemCount() - 2) {
                this.projectMenu.remove(i);
            }
            this.addRecentProjectMenuItem(this.projectMenu);
            this.projectMenu.updateUI();
        }
    }

    protected void addRecentProjectMenuItem(JMenu menu) {
        List<JMenuItem> recentProjectsMenuItems = this.getRecentProjectsMenuItems();
        if (recentProjectsMenuItems != null) {
            menu.add((Component)new JPopupMenu.Separator(), this.recentProjectBeginPos);
            int i = 0;
            while (i < recentProjectsMenuItems.size()) {
                menu.insert(recentProjectsMenuItems.get(i), i + this.recentProjectBeginPos + 1);
                ++i;
            }
        }
    }

    public List<JMenuItem> getRecentProjectsMenuItems() {
        ArrayList<JMenuItem> recentProjectMenuList = null;
        RecentProjects recentProjects = RecentProjects.getInstance();
        if (recentProjects != null && recentProjects.getRecentProjectList().size() > 0) {
            recentProjectMenuList = new ArrayList<JMenuItem>();
            for (ProjectInfo projectInfo : recentProjects.getRecentProjectList()) {
                StringBuffer menuText = new StringBuffer(projectInfo.getProjectName());
                menuText.append("  [");
                if (projectInfo.getProjectPath().length() < 30) {
                    menuText.append(projectInfo.getProjectPath());
                } else {
                    menuText.append(String.valueOf(StringUtils.left((String)projectInfo.getProjectPath(), (int)27)) + "...");
                }
                menuText.append("]");
                JMenuItem recProjectMenuItem = new JMenuItem(menuText.toString());
                recProjectMenuItem.setToolTipText(projectInfo.getProjectPath());
                recProjectMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        JMenuItem menuItem = (JMenuItem)e.getSource();
                        JTDBMenuBar.this.parent.openProject(menuItem.getToolTipText());
                    }
                });
                recentProjectMenuList.add(recProjectMenuItem);
            }
        }
        return recentProjectMenuList;
    }

    public JPopupMenu getDBPopupMenu() {
        JPopupMenu root = new JPopupMenu("database");
        root.add(this.getAutoConfigAllMenuItem());
        root.add(this.getDeleteAllConfigMenuItem());
        root.add(this.getRefreshDbStructureMenuItem());
        return root;
    }

    public JPopupMenu getConnectionPoolPopupMenu() {
        JPopupMenu root = new JPopupMenu("connPool");
        root.add(this.getAddConnectionMenuItem());
        root.add(this.getConnectAllMenuItem());
        root.add(this.getDisconnectAllMenuItem());
        return root;
    }

    public JPopupMenu getConnectionPopupMenu() {
        JPopupMenu root = new JPopupMenu("connPool");
        root.add(this.getConfigMenuItem());
        root.add(this.getDeleteConfigMenuItem());
        root.add(this.getConnectMenuItem());
        root.add(this.getDisConnectItem());
        return root;
    }

    public JMenuItem getGenerateItem() {
        if (this.generateItem == null) {
            this.generateItem = new JMenuItem(this.R("label.JTDBMenuBar.menu.role.generateData"));
            this.generateItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTDBMenuBar.this.parent.showGeneateDateDialog();
                }
            });
        }
        return this.generateItem;
    }

    public JMenuItem getNewProjectItem() {
        if (this.newProjectItem == null) {
            this.newProjectItem = new JMenuItem(this.R("label.JTDBMenuBar.menu.project.new"));
            this.newProjectItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTDBMenuBar.this.parent.createProject();
                }
            });
        }
        return this.newProjectItem;
    }

    public JMenuItem getOpenProjectItem() {
        if (this.openProjectItem == null) {
            this.openProjectItem = new JMenuItem(this.R("label.JTDBMenuBar.menu.project.open"));
            this.openProjectItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTDBMenuBar.this.parent.openProject();
                }
            });
        }
        return this.openProjectItem;
    }

    public JMenuItem getCloseProjectItem() {
        if (this.closeProjectItem == null) {
            this.closeProjectItem = new JMenuItem(this.R("label.JTDBMenuBar.menu.project.close"));
            this.closeProjectItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTDBMenuBar.this.parent.closeProject();
                }
            });
        }
        return this.closeProjectItem;
    }

    public JMenuItem getOpenProjectInExplorerItem() {
        if (this.openProjectInExplorerItem == null) {
            this.openProjectInExplorerItem = new JMenuItem(this.R("label.JTDBMenuBar.menu.project.viewInExplorer"));
            this.openProjectInExplorerItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTDBMenuBar.this.parent.openProjectInExplorer();
                }
            });
        }
        return this.openProjectInExplorerItem;
    }

    public JMenuItem getExitItem() {
        if (this.exitItem == null) {
            this.exitItem = new JMenuItem(this.R("label.JTDBMenuBar.menu.project.exit"));
            this.exitItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    JTDBMenuBar.this.parent.dispose();
                    System.exit(0);
                }
            });
        }
        return this.exitItem;
    }

    public JMenuItem getDefaultConnectionItem() {
        if (this.configureDefaultConnectionItem == null) {
            this.configureDefaultConnectionItem = new JMenuItem(this.R("label.JTDBMenuBar.menu.database.defaultConn"));
            this.configureDefaultConnectionItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        JTDBMenuBar.this.parent.configDBAndInitWorkspace("MySQL", false);
                    }
                    catch (Exception ex) {
                        logger.error((Object)"MainFrame", (Throwable)ex);
                        JOptionPane.showMessageDialog(JTDBMenuBar.this.parent, "\u8fde\u63a5\u6570\u636e\u5e93\u65f6\u51fa\u9519!" + ex.getMessage());
                    }
                }
            });
        }
        return this.configureDefaultConnectionItem;
    }

    public JMenuItem getAddConnectionMenuItem() {
        if (this.addConnectionMenuItem == null) {
            this.addConnectionMenuItem = new JMenuItem(this.R("label.JTDBMenuBar.menu.database.newConn"));
            this.addConnectionMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTDBMenuBar.this.parent.addConnectConfig();
                }
            });
        }
        return this.addConnectionMenuItem;
    }

    public JMenuItem getConnectAllMenuItem() {
        if (this.connectAllMenuItem == null) {
            this.connectAllMenuItem = new JMenuItem(this.R("label.JTDBMenuBar.menu.database.connAll"));
            this.connectAllMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTDBMenuBar.this.parent.connectAll();
                }
            });
        }
        return this.connectAllMenuItem;
    }

    public JMenuItem getDisconnectAllMenuItem() {
        if (this.disconnectAllMenuItem == null) {
            this.disconnectAllMenuItem = new JMenuItem(this.R("label.JTDBMenuBar.menu.database.disConnAll"));
            this.disconnectAllMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTDBMenuBar.this.parent.disconnectAll();
                }
            });
        }
        return this.disconnectAllMenuItem;
    }

    public JMenuItem getConfigMenuItem() {
        if (this.configMenuItem == null) {
            this.configMenuItem = new JMenuItem(this.R("label.JTDBMenuBar.menu.database.config"));
            this.configMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        JTDBMenuBar.this.parent.configAndReconnect();
                    }
                    catch (Exception ex) {
                        logger.error((Object)"MainFrame", (Throwable)ex);
                        JOptionPane.showMessageDialog(JTDBMenuBar.this.parent, "\u4fdd\u5b58\u914d\u7f6e\u65f6\u51fa\u9519\uff0c" + ex.getMessage());
                    }
                }
            });
        }
        return this.configMenuItem;
    }

    public JMenuItem getDeleteConfigMenuItem() {
        if (this.deleteConfigMenuItem == null) {
            this.deleteConfigMenuItem = new JMenuItem(this.R("label.JTDBMenuBar.menu.database.delConn"));
            this.deleteConfigMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTDBMenuBar.this.parent.delelteConfig();
                }
            });
        }
        return this.deleteConfigMenuItem;
    }

    public JMenuItem getConnectMenuItem() {
        if (this.connectMenuItem == null) {
            this.connectMenuItem = new JMenuItem(this.R("label.JTDBMenuBar.menu.database.connect"));
            this.connectMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTDBMenuBar.this.parent.connect();
                }
            });
        }
        return this.connectMenuItem;
    }

    public JMenuItem getDisConnectItem() {
        if (this.disconnectMenuItem == null) {
            this.disconnectMenuItem = new JMenuItem(this.R("label.JTDBMenuBar.menu.database.disConnect"));
            this.disconnectMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTDBMenuBar.this.parent.disconnect();
                }
            });
        }
        return this.disconnectMenuItem;
    }

    public JMenuItem getAutoConfigAllMenuItem() {
        if (this.autoConfigAllMenuItem == null) {
            this.autoConfigAllMenuItem = new JMenuItem(this.R("label.JTDBMenuBar.menu.database.autoConfigAll"));
            this.autoConfigAllMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTDBMenuBar.this.parent.autoConfigAll();
                }
            });
        }
        return this.autoConfigAllMenuItem;
    }

    public JMenuItem getRefreshDbStructureMenuItem() {
        if (this.refreshDbStructureMenuItem == null) {
            this.refreshDbStructureMenuItem = new JMenuItem(this.R("label.JTDBMenuBar.menu.database.refreshDbStructure"));
            this.refreshDbStructureMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTDBMenuBar.this.parent.refreshDataFromDB();
                }
            });
        }
        return this.refreshDbStructureMenuItem;
    }

    public JMenuItem getDeleteAllConfigMenuItem() {
        if (this.deleteAllConfigMenuItem == null) {
            this.deleteAllConfigMenuItem = new JMenuItem(this.R("label.JTDBMenuBar.menu.database.delAllConfig"));
            this.deleteAllConfigMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTDBMenuBar.this.parent.deleteAllConfig();
                }
            });
        }
        return this.deleteAllConfigMenuItem;
    }

    public JMenuItem getRoleWindowItem() {
        if (this.roleItem == null) {
            this.roleItem = new JMenuItem(this.R("label.JTDBMenuBar.menu.window.role"));
            this.roleItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTDBMenuBar.this.parent.showRoleWindow();
                }
            });
        }
        return this.roleItem;
    }

    public JMenuItem getQueryConsoleWindowItem() {
        if (this.queryConsoleWindowItem == null) {
            this.queryConsoleWindowItem = new JMenuItem(this.R("label.JTDBMenuBar.menu.window.queryConsole"));
            this.queryConsoleWindowItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTDBMenuBar.this.parent.showQueryConsole();
                }
            });
        }
        return this.queryConsoleWindowItem;
    }

    public JMenuItem getDataModelItem() {
        if (this.dataModelItem == null) {
            this.dataModelItem = new JMenuItem(this.R("label.JTDBMenuBar.menu.window.dataModel"));
            this.dataModelItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTDBMenuBar.this.parent.showDataModelView();
                }
            });
        }
        return this.dataModelItem;
    }

    public JMenuItem getDataExchangerItem() {
        if (this.dataExchangerItem == null) {
            this.dataExchangerItem = new JMenuItem(this.R("label.JTDBMenuBar.menu.window.dataExchange"));
            this.dataExchangerItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTDBMenuBar.this.parent.showDataExchangerWindow();
                }
            });
        }
        return this.dataExchangerItem;
    }

    public JMenuItem getPreferenceItem() {
        if (this.preferenceItem == null) {
            this.preferenceItem = new JMenuItem(this.R("label.JTDBMenuBar.menu.window.preferences"));
            this.preferenceItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTDBMenuBar.this.parent.showPreferenceDialog();
                }
            });
        }
        return this.preferenceItem;
    }

    public JMenuItem getSysPropertyItem() {
        if (this.sysPropertyItem == null) {
            this.sysPropertyItem = new JMenuItem(this.R("label.JTDBMenuBar.menu.window.sysProperty"));
            this.sysPropertyItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTDBMenuBar.this.parent.showSysPropertyDialog();
                }
            });
        }
        return this.sysPropertyItem;
    }

    String R(String key) {
        return RM.R(key);
    }
}

