/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.ui.main.others;

import com.testDataBuilder.resources.RM;
import com.testDataBuilder.ui.core.JTDButton;
import com.testDataBuilder.ui.help.Helper;
import com.testDataBuilder.ui.main.MainFrame;
import com.testDataBuilder.ui.main.others.IconButton;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import org.apache.log4j.Logger;

public class JTDBToolBar
extends JToolBar {
    static Logger logger = Logger.getLogger(JTDBToolBar.class);
    public static final String ICON_DIR = "/resources/icon/";
    private MainFrame parent;
    private JTDButton btnConfigDefDB = null;
    private JTDButton btnNewConnection = null;
    private JTDButton btnOpenProject = null;
    private JTDButton btnNewProject = null;
    private JTDButton btnRole = null;
    private JTDButton btnGenerate = null;
    private JTDButton btnPreferences = null;
    private JTDButton btnHelp = null;
    public boolean hasWorkspace = false;

    public JTDBToolBar() {
        this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.initialize();
        this.setToolbarState();
    }

    public JTDBToolBar(MainFrame parent) {
        this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.parent = parent;
        this.initialize();
        this.setToolbarState();
    }

    public void setHasWorkspace(boolean hasWorkspace) {
        if (this.hasWorkspace != hasWorkspace) {
            this.hasWorkspace = hasWorkspace;
            this.setToolbarState();
        }
    }

    private void setToolbarState() {
        this.getBtnConfigDefDB().setEnabled(this.hasWorkspace);
        this.getBtnNewConnection().setEnabled(this.hasWorkspace);
        this.getBtnRole().setEnabled(this.hasWorkspace);
        this.getBtnGenerate().setEnabled(this.hasWorkspace);
    }

    private void initialize() {
        this.setSize(new Dimension(329, 23));
        this.add(this.getBtnNewProject());
        this.add(this.getBtnOpenProject());
        this.addSeparator();
        this.add(this.getBtnConfigDefDB());
        this.add(this.getBtnNewConnection());
        this.addSeparator();
        this.add(this.getBtnRole());
        this.add(this.getBtnGenerate());
        this.addSeparator();
        this.add(this.getBtnPreferences());
        this.addSeparator();
        this.add(this.getBtnHelp());
    }

    private JTDButton getBtnConfigDefDB() {
        if (this.btnConfigDefDB == null) {
            this.btnConfigDefDB = new IconButton("/resources/icon/database_edit.png");
            this.btnConfigDefDB.setToolTipText(JTDBToolBar.R("label.JTDBMenuBar.menu.database.defaultConn"));
            this.btnConfigDefDB.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        JTDBToolBar.this.parent.configDBAndInitWorkspace("MySQL", false);
                    }
                    catch (Exception e1) {
                        logger.error((Object)"Main", (Throwable)e1);
                        JOptionPane.showMessageDialog(JTDBToolBar.this.parent, String.valueOf(RM.R("label.JTDBToolBar.error.parseConfigFile")) + e1.getMessage());
                    }
                }
            });
        }
        return this.btnConfigDefDB;
    }

    private JTDButton getBtnNewConnection() {
        if (this.btnNewConnection == null) {
            this.btnNewConnection = new IconButton("/resources/icon/database_add.png");
            this.btnNewConnection.setToolTipText(JTDBToolBar.R("label.JTDBMenuBar.menu.database.newConn"));
            this.btnNewConnection.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTDBToolBar.this.parent.addConnectConfig();
                }
            });
        }
        return this.btnNewConnection;
    }

    private JTDButton getBtnRole() {
        if (this.btnRole == null) {
            this.btnRole = new IconButton("/resources/icon/database_role.png");
            this.btnRole.setToolTipText(JTDBToolBar.R("label.JTDBMenuBar.menu.window.role"));
            this.btnRole.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTDBToolBar.this.parent.showRoleWindow();
                }
            });
        }
        return this.btnRole;
    }

    private JTDButton getBtnGenerate() {
        if (this.btnGenerate == null) {
            this.btnGenerate = new IconButton("/resources/icon/database_go.png");
            this.btnGenerate.setToolTipText(JTDBToolBar.R("label.JTDBMenuBar.menu.role.generateData"));
            this.btnGenerate.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTDBToolBar.this.parent.showGeneateDateDialog();
                }
            });
        }
        return this.btnGenerate;
    }

    private JTDButton getBtnOpenProject() {
        if (this.btnOpenProject == null) {
            this.btnOpenProject = new IconButton("/resources/icon/open_project.png");
            this.btnOpenProject.setToolTipText(RM.R("label.JTDBToolBar.openProject.tooltip"));
            this.btnOpenProject.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTDBToolBar.this.parent.openProject();
                }
            });
        }
        return this.btnOpenProject;
    }

    private JTDButton getBtnNewProject() {
        if (this.btnNewProject == null) {
            this.btnNewProject = new IconButton("/resources/icon/newProject.png");
            this.btnNewProject.setToolTipText(RM.R("label.JTDBToolBar.newProject.tooltip"));
            this.btnNewProject.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTDBToolBar.this.parent.createProject();
                }
            });
        }
        return this.btnNewProject;
    }

    public static String R(String key) {
        return RM.R(key);
    }

    private JTDButton getBtnPreferences() {
        if (this.btnPreferences == null) {
            this.btnPreferences = new IconButton("/resources/icon/preferences.png");
            this.btnPreferences.setToolTipText(RM.R("label.JTDBToolBar.preferences.tooltip"));
            this.btnPreferences.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTDBToolBar.this.parent.showPreferenceDialog();
                }
            });
        }
        return this.btnPreferences;
    }

    private JTDButton getBtnHelp() {
        if (this.btnHelp == null) {
            this.btnHelp = new IconButton("/resources/icon/help.png");
            this.btnHelp.setToolTipText(RM.R("label.JTDBToolBar.help.tooltip"));
            this.btnHelp.addActionListener(Helper.getInstance().getHelpListener());
        }
        return this.btnHelp;
    }
}

