/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.ui.main.queryConsole;

import com.testDataBuilder.ui.database.JSQLFileChooser;
import com.testDataBuilder.ui.main.MainFrame;
import com.testDataBuilder.ui.main.queryConsole.JEditTextArea;
import com.testDataBuilder.ui.main.queryConsole.ResultSetTableModel;
import com.testDataBuilder.ui.main.queryConsole.SQLQueryToolBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.io.FileUtils;
import org.syntax.jedit.tokenmarker.TSQLTokenMarker;
import org.syntax.jedit.tokenmarker.TokenMarker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryPanel
extends JPanel {
    private SQLQueryToolBar sqlQueryToolBar = null;
    private JSplitPane jQueryPane = null;
    private JScrollPane jQueryConsoleTopPane1 = null;
    private JEditTextArea SQLQueryTextArea = null;
    private JScrollPane jQueryConsoleBottomPane = null;
    private JTable jResultTable = null;
    List<String> allConnNames = null;
    private JLabel msgLine = null;
    private String queryType = "sqlquery";

    public QueryPanel() {
        this.initialize();
    }

    private void initialize() {
        BorderLayout borderLayout = new BorderLayout();
        this.setLayout(borderLayout);
        this.setSize(new Dimension(380, 266));
        this.add((Component)this.getSQLQueryToolBar(), "North");
        this.add((Component)this.getJQueryPane(), "Center");
        this.add((Component)this.getMsgLine(), "South");
    }

    public SQLQueryToolBar getSQLQueryToolBar() {
        if (this.sqlQueryToolBar == null) {
            this.sqlQueryToolBar = new SQLQueryToolBar(this);
        }
        return this.sqlQueryToolBar;
    }

    private JSplitPane getJQueryPane() {
        if (this.jQueryPane == null) {
            this.jQueryPane = new JSplitPane();
            this.jQueryPane.setOrientation(0);
            this.jQueryPane.setDividerLocation(150);
            this.jQueryPane.setDividerSize(3);
            this.jQueryPane.setResizeWeight(0.5);
            this.jQueryPane.setBottomComponent(this.getJQueryConsoleBottomPane());
            this.jQueryPane.setTopComponent(this.getJQueryConsoleTopPane1());
        }
        return this.jQueryPane;
    }

    private JScrollPane getJQueryConsoleTopPane1() {
        if (this.jQueryConsoleTopPane1 == null) {
            this.jQueryConsoleTopPane1 = new JScrollPane();
            this.jQueryConsoleTopPane1.setViewportView((Component)((Object)this.getSQLQueryTextArea()));
        }
        return this.jQueryConsoleTopPane1;
    }

    private JLabel getMsgLine() {
        if (this.msgLine == null) {
            this.msgLine = new JLabel();
        }
        return this.msgLine;
    }

    private JEditTextArea getSQLQueryTextArea() {
        if (this.SQLQueryTextArea == null) {
            this.SQLQueryTextArea = new JEditTextArea();
            this.SQLQueryTextArea.setTokenMarker((TokenMarker)new TSQLTokenMarker());
        }
        return this.SQLQueryTextArea;
    }

    public String getExecuteSQLString() {
        String selStr = this.getSQLQueryTextArea().getSelectedText();
        if (selStr == null || selStr.equals("")) {
            selStr = this.getSQLString();
        }
        return selStr;
    }

    public String getBatchSeparator() {
        return this.getSQLQueryToolBar().getBatchSeparator();
    }

    public String getSQLString() {
        return this.getSQLQueryTextArea().getText().trim();
    }

    public void setSQLString(String sqlString) {
        this.getSQLQueryTextArea().setText(sqlString);
    }

    public String getCurConnName() {
        return (String)this.getSQLQueryToolBar().getComboxConnection().getSelectedItem();
    }

    private JScrollPane getJQueryConsoleBottomPane() {
        if (this.jQueryConsoleBottomPane == null) {
            this.jQueryConsoleBottomPane = new JScrollPane();
            this.jQueryConsoleBottomPane.setViewportView(this.getJResultTable());
        }
        return this.jQueryConsoleBottomPane;
    }

    public JTable getJResultTable() {
        if (this.jResultTable == null) {
            this.jResultTable = new JTable();
            this.jResultTable.setAutoResizeMode(0);
        }
        return this.jResultTable;
    }

    public void initConnectionCombox(List<String> allConnNames) {
        this.allConnNames = allConnNames;
        this.getSQLQueryToolBar().getComboxConnection().initConnectionCombox(allConnNames);
    }

    public void initConnectionCombox(List<String> allConnNames, Object selObject) {
        this.allConnNames = allConnNames;
        this.getSQLQueryToolBar().getComboxConnection().initConnectionCombox(allConnNames, selObject);
    }

    public void displayQueryResults(final String sqls, final JLabel msgLine, String sep) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    msgLine.setText("\u6b63\u5728\u67e5\u8be2.......");
                    String connName = QueryPanel.this.getCurConnName();
                    if (connName != null) {
                        Connection connection = MainFrame.getInstance().getTestDataConfig().getConn(connName);
                        ResultSetTableModel dataModel = ResultSetTableModel.getResultSetTableModel(sqls, connection);
                        QueryPanel.this.jResultTable.setAutoResizeMode(0);
                        QueryPanel.this.jResultTable.setModel(dataModel);
                    } else {
                        QueryPanel.this.jResultTable.setAutoResizeMode(4);
                        Object[][] data = new String[][]{{"\u6ca1\u6709\u53ef\u7528\u7684\u8fde\u63a5"}};
                        Object[] columnNames = new String[]{"\u7ed3\u679c"};
                        QueryPanel.this.jResultTable.setModel(new DefaultTableModel(data, columnNames));
                    }
                }
                catch (SQLException ex) {
                    QueryPanel.this.jResultTable.setAutoResizeMode(4);
                    Object[][] data = new String[][]{{ex.getMessage()}};
                    Object[] columnNames = new String[]{"\u67e5\u8be2\u51fa\u9519"};
                    QueryPanel.this.jResultTable.setModel(new DefaultTableModel(data, columnNames));
                }
                msgLine.setText(" ");
            }
        }).start();
    }

    public void execSQL() {
        String sql = this.getExecuteSQLString();
        String sep = this.getBatchSeparator();
        if (sql != null && sql.trim().length() > 0) {
            sql = sql.trim().toLowerCase();
            if (this.getQueryType().equalsIgnoreCase("sqlfunc") && !sql.startsWith("select")) {
                sql = "select (" + sql + ")";
            }
            this.displayQueryResults(sql, this.msgLine, sep);
        }
    }

    public void openScript() {
        JSQLFileChooser sqlFileChooser = new JSQLFileChooser();
        if (sqlFileChooser.showOpenDialog(this) == 0) {
            String scriptFile = sqlFileChooser.getSelectedFile().getAbsolutePath();
            try {
                String script = FileUtils.readFileToString((File)new File(scriptFile));
                this.getSQLQueryTextArea().setText(script);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "\u6253\u5f00\u811a\u672c\u51fa\u9519\uff0c" + e.getMessage());
            }
        }
    }

    public List<String> getAllConnNames() {
        return this.allConnNames;
    }

    public void setAllConnNames(List<String> allConnNames) {
        this.allConnNames = allConnNames;
    }

    public String getQueryType() {
        return this.queryType;
    }

    public void setQueryType(String queryType) {
        this.queryType = queryType;
    }
}

