/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.ui.main.queryConsole;

import com.testDataBuilder.config.preference.Preferences;
import com.testDataBuilder.ui.main.others.JTDBToolBar;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

public class ResultSetTableModel
extends AbstractTableModel {
    static Logger logger = Logger.getLogger(JTDBToolBar.class);
    ResultSet results;
    ResultSetMetaData metadata;
    int numcols;
    int numrows;
    Map<Integer, Integer> widths = new HashMap<Integer, Integer>();

    ResultSetTableModel(ResultSet results) throws SQLException {
        this.results = results;
        this.metadata = results.getMetaData();
        this.numcols = this.metadata.getColumnCount() + 1;
        results.last();
        this.numrows = results.getRow();
    }

    public void close() {
        try {
            this.results.getStatement().close();
        }
        catch (SQLException e) {
            logger.error((Object)"ResultSetTableModel", (Throwable)e);
        }
    }

    protected void finalize() {
        this.close();
    }

    public int getColumnCount() {
        return this.numcols;
    }

    public int getRowCount() {
        return this.numrows;
    }

    public String getColumnName(int column) {
        block3: {
            try {
                if (column != 0) break block3;
                return "No.";
            }
            catch (SQLException e) {
                return e.toString();
            }
        }
        return this.metadata.getColumnLabel(column);
    }

    public Class getColumnClass(int column) {
        return String.class;
    }

    public Object getValueAt(int row, int column) {
        String retValue = "";
        if (column == 0) {
            retValue = Integer.valueOf(row + 1).toString();
        } else {
            try {
                Object o;
                if (this.results.getRow() != row + 1) {
                    this.results.absolute(row + 1);
                }
                if ((o = this.results.getObject(column)) != null) {
                    retValue = o.toString();
                }
            }
            catch (SQLException e) {
                retValue = e.toString();
            }
        }
        Integer width = this.widths.get(column);
        if (width == null) {
            width = retValue.length();
            this.widths.put(column, width);
        } else {
            width = width + retValue.length();
        }
        return retValue.toString();
    }

    public Integer getColumnWidth(int column) {
        Integer width = this.widths.get(column);
        if (width != null) {
            return width / this.numrows;
        }
        return 0;
    }

    public boolean isCellEditable(int row, int column) {
        return true;
    }

    public void setValueAt(Object value, int row, int column) {
    }

    public void addTableModelListener(TableModelListener l) {
    }

    public void removeTableModelListener(TableModelListener l) {
    }

    public static ResultSetTableModel getResultSetTableModel(String query, Connection conn) throws SQLException {
        if (conn == null) {
            throw new IllegalStateException("Connection already closed.");
        }
        Statement statement = conn.createStatement(1004, 1007);
        int maxResult = 0;
        if (Preferences.getPreference() != null) {
            maxResult = Preferences.getPreference().getQueryConsoleMaxSize();
        }
        if (maxResult == 0) {
            maxResult = 1000;
        }
        statement.setMaxRows(maxResult);
        ResultSet r = statement.executeQuery(query);
        return new ResultSetTableModel(r);
    }
}

