/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.ui.preference;

import com.testDataBuilder.config.preference.DefPreference;
import com.testDataBuilder.config.preference.IPreference;
import com.testDataBuilder.config.preference.XmlPreference;
import com.testDataBuilder.exception.ValidataException;
import com.testDataBuilder.resources.RM;
import com.testDataBuilder.ui.core.CenterDialog;
import com.testDataBuilder.ui.core.JTDButton;
import com.testDataBuilder.ui.core.JTextFieldEx;
import com.testDataBuilder.ui.help.Helper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PreferenceDialog
extends CenterDialog {
    static Logger logger = Logger.getLogger(PreferenceDialog.class);
    private JPanel jContentPane = null;
    private JPanel jInnerPanel = null;
    private JCheckBox cbxAutoConnWhenProgramStartup = null;
    private JCheckBox cbxSaveDbMetaInfo = null;
    private JCheckBox cbxReadDBInfoFromFileWhenConnError = null;
    private JLabel jLabel = null;
    private JCheckBox cbxNotIncludeIDEntityClumn = null;
    private JTextField txtDefaultRowToGenerate = null;
    private JCheckBox cbxCloseIDAutoInsert = null;
    private JCheckBox cbxClearBefInsert = null;
    private JLabel jLabel1 = null;
    private JTextField txtMinDate = null;
    private JLabel jLabel2 = null;
    private JTextField txtMaxDate = null;
    private JLabel jLabel3 = null;
    private JTextField txtTextFieldMin = null;
    private JLabel jLabel4 = null;
    private JTextField txtTextFieldMax = null;
    private JCheckBox cbxGenerateSQLFile = null;
    private JLabel jLabel6 = null;
    private JTextField txtDataTypePluginDir = null;
    private JLabel jLabel7 = null;
    private JTextField txtDateFormat = null;
    private JTDButton btnOK = null;
    private JTDButton btnCancel = null;
    private JTDButton btnApply = null;
    private JTDButton btnDefault = null;
    private JTDButton btnSelDatatypeDir = null;
    private JTDButton btnSelWorkspaceDir = null;
    private IPreference preference = null;
    private String workspace = null;
    private JLabel jLabel5 = null;
    private JComboBox comBoxScope = null;
    private JTDButton btnDeleteCurrentProjectPreferenceConfig = null;
    private JLabel jLabel8 = null;
    private JTextField txtDateExample = null;
    private SimpleDateFormat dateFormat = null;
    private JLabel jLabel9 = null;
    private JTextField txtWorkspace = null;

    public PreferenceDialog(JFrame parent, IPreference preference) {
        super(parent);
        this.preference = preference;
        this.initialize();
        this.dateFormat = new SimpleDateFormat(preference.getDateFormat());
        this.dataExchange(preference, true);
    }

    public void dataExchange(IPreference preference, boolean isToConsole) {
        if (isToConsole) {
            if (preference == null) {
                this.enableAll(false);
            }
            if (preference instanceof XmlPreference) {
                XmlPreference xmlPreference = (XmlPreference)preference;
                if (xmlPreference.isGlobal().booleanValue()) {
                    this.getComBoxScope().setSelectedIndex(0);
                } else {
                    this.getComBoxScope().setSelectedIndex(1);
                }
                this.enableAll(true);
            } else {
                this.getComBoxScope().setSelectedIndex(0);
                this.enableAll(false);
            }
            this.getCbxSaveDbMetaInfo().setSelected(preference.getSaveDbMetaInfo());
            this.getCbxAutoConnWhenProgramStartup().setSelected(preference.getAutoConnWhenProgramStartup());
            this.getCbxReadDBInfoFromFileWhenConnError().setSelected(preference.getReadDBInfoFromFileWhenConnError());
            this.getCbxNotIncludeIDEntityClumn().setSelected(preference.getNotIncludeIDEntityClumn());
            this.getCbxCloseIDAutoInsert().setSelected(preference.getCloseIDAutoInsert());
            this.getCbxClearBefInsert().setSelected(preference.getClearBefInsert());
            this.getCbxGenerateSQLFile().setSelected(preference.getGenerateSQLFile());
            this.getTxtDefaultRowToGenerate().setText("" + preference.getDefaultRowToGenerate());
            this.getTxtDateFormat().setText(preference.getDateFormat());
            this.getTxtDateExample().setText(this.getCurTime(preference.getDateFormat()));
            this.getTxtMinDate().setText(this.dateToString(preference.getMinDate()));
            this.getTxtMaxDate().setText(this.dateToString(preference.getMaxDate()));
            this.getTxtTextFieldMin().setText("" + preference.getTextFieldMin());
            this.getTxtTextFieldMax().setText("" + preference.getTextFieldMax());
            this.getTxtWorkspace().setText(preference.getWorkspace());
            this.getTxtDataTypePluginDir().setText(preference.getDataTypePluginDir());
        } else if (preference instanceof XmlPreference) {
            XmlPreference xmlPreference = (XmlPreference)preference;
            if (this.getComBoxScope().getSelectedIndex() == 0) {
                xmlPreference.setGlobal(true);
            } else {
                xmlPreference.setGlobal(false);
            }
            xmlPreference.setSaveDbMetaInfo(this.getCbxSaveDbMetaInfo().isSelected());
            xmlPreference.setAutoConnWhenProgramStartup(this.getCbxAutoConnWhenProgramStartup().isSelected());
            xmlPreference.setReadDBInfoFromFileWhenConnError(this.getCbxReadDBInfoFromFileWhenConnError().isSelected());
            xmlPreference.setNotIncludeIDEntityClumn(this.getCbxNotIncludeIDEntityClumn().isSelected());
            xmlPreference.setCloseIDAutoInsert(this.getCbxCloseIDAutoInsert().isSelected());
            xmlPreference.setClearBefInsert(this.getCbxClearBefInsert().isSelected());
            xmlPreference.setGenerateSQLFile(this.getCbxGenerateSQLFile().isSelected());
            String strRows = this.getTxtDefaultRowToGenerate().getText().trim();
            xmlPreference.setDefaultRowToGenerate(Long.valueOf(strRows));
            xmlPreference.setDateFormat(this.getTxtDateFormat().getText().trim());
            try {
                java.util.Date minDate = this.strToDate(this.getTxtMinDate().getText().trim());
                xmlPreference.setMinDate(minDate);
            }
            catch (ParseException e) {
                logger.error((Object)"PreferenceDialog", (Throwable)e);
            }
            try {
                java.util.Date maxDate = this.strToDate(this.getTxtMaxDate().getText().trim());
                xmlPreference.setMaxDate(maxDate);
            }
            catch (ParseException e) {
                logger.error((Object)"PreferenceDialog", (Throwable)e);
            }
            xmlPreference.setWorkspace(this.getTxtWorkspace().getText().trim());
            xmlPreference.setDataTypePluginDir(this.getTxtDataTypePluginDir().getText().trim());
        } else {
            JOptionPane.showMessageDialog(this, RM.R("label.PreferenceDialog.unProcessed"));
        }
    }

    public String getCurTime(String strDateFormat) {
        this.dateFormat.applyPattern(strDateFormat);
        return this.dateFormat.format(new java.util.Date());
    }

    private void initialize() {
        this.setSize(new Dimension(605, 419));
        this.setTitle(RM.R("label.PreferenceDialog.title"));
        this.setResizable(false);
        this.setContentPane(this.getJContentPane());
        this.center();
        Helper.getInstance().enableHelpKey(this.getRootPane(), "detail.window.preferences");
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(null);
            this.jContentPane.add((Component)this.getJInnerPanel(), null);
            this.jContentPane.add((Component)this.getBtnOK(), null);
            this.jContentPane.add((Component)this.getBtnCancel(), null);
            this.jContentPane.add((Component)this.jLabel5, null);
            this.jContentPane.add((Component)this.getComBoxScope(), null);
            this.jContentPane.add((Component)this.getBtnDeleteCurrentProjectPreferenceConfig(), null);
        }
        return this.jContentPane;
    }

    private JPanel getJInnerPanel() {
        if (this.jInnerPanel == null) {
            this.jLabel9 = new JLabel();
            this.jLabel9.setBounds(new Rectangle(22, 235, 117, 22));
            this.jLabel9.setText(RM.R("label.PreferenceDialog.workspaceDir"));
            this.jLabel8 = new JLabel();
            this.jLabel8.setBounds(new Rectangle(289, 146, 102, 22));
            this.jLabel8.setText(RM.R("label.PreferenceDialog.TimeExample"));
            this.jLabel5 = new JLabel();
            this.jLabel5.setText(RM.R("label.PreferenceDialog.ConfigApplyTo"));
            this.jLabel5.setBounds(new Rectangle(30, 4, 113, 21));
            this.jLabel7 = new JLabel();
            this.jLabel7.setBounds(new Rectangle(22, 146, 99, 22));
            this.jLabel7.setText(RM.R("label.PreferenceDialog.TimeFormat"));
            this.jLabel6 = new JLabel();
            this.jLabel6.setBounds(new Rectangle(22, 266, 118, 21));
            this.jLabel6.setText(RM.R("label.PreferenceDialog.dataTypeDir"));
            this.jLabel4 = new JLabel();
            this.jLabel4.setBounds(new Rectangle(290, 207, 121, 22));
            this.jLabel4.setText(RM.R("label.PreferenceDialog.TextFieldMaxLength"));
            this.jLabel3 = new JLabel();
            this.jLabel3.setBounds(new Rectangle(22, 207, 127, 22));
            this.jLabel3.setText(RM.R("label.PreferenceDialog.TextFieldMinLength"));
            this.jLabel2 = new JLabel();
            this.jLabel2.setBounds(new Rectangle(290, 177, 101, 22));
            this.jLabel2.setText(RM.R("label.PreferenceDialog.DataMax"));
            this.jLabel1 = new JLabel();
            this.jLabel1.setBounds(new Rectangle(22, 177, 99, 22));
            this.jLabel1.setText(RM.R("label.PreferenceDialog.DataMin"));
            this.jLabel = new JLabel();
            this.jLabel.setBounds(new Rectangle(22, 116, 99, 21));
            this.jLabel.setText(RM.R("label.PreferenceDialog.RowOfPerTable"));
            this.jInnerPanel = new JPanel();
            this.jInnerPanel.setLayout(null);
            this.jInnerPanel.setBounds(new Rectangle(9, 31, 578, 329));
            this.jInnerPanel.setBorder(BorderFactory.createEtchedBorder(0));
            this.jInnerPanel.add((Component)this.getCbxAutoConnWhenProgramStartup(), null);
            this.jInnerPanel.add((Component)this.getCbxSaveDbMetaInfo(), null);
            this.jInnerPanel.add((Component)this.getCbxReadDBInfoFromFileWhenConnError(), null);
            this.jInnerPanel.add((Component)this.jLabel, null);
            this.jInnerPanel.add((Component)this.getCbxNotIncludeIDEntityClumn(), null);
            this.jInnerPanel.add((Component)this.getTxtDefaultRowToGenerate(), null);
            this.jInnerPanel.add((Component)this.getCbxCloseIDAutoInsert(), null);
            this.jInnerPanel.add((Component)this.getCbxClearBefInsert(), null);
            this.jInnerPanel.add((Component)this.jLabel1, null);
            this.jInnerPanel.add((Component)this.getTxtMinDate(), null);
            this.jInnerPanel.add((Component)this.jLabel2, null);
            this.jInnerPanel.add((Component)this.getTxtMaxDate(), null);
            this.jInnerPanel.add((Component)this.jLabel3, null);
            this.jInnerPanel.add((Component)this.getTxtTextFieldMin(), null);
            this.jInnerPanel.add((Component)this.jLabel4, null);
            this.jInnerPanel.add((Component)this.getTxtTextFieldMax(), null);
            this.jInnerPanel.add((Component)this.getCbxGenerateSQLFile(), null);
            this.jInnerPanel.add((Component)this.jLabel6, null);
            this.jInnerPanel.add((Component)this.getTxtDataTypePluginDir(), null);
            this.jInnerPanel.add((Component)this.jLabel7, null);
            this.jInnerPanel.add((Component)this.getTxtDateFormat(), null);
            this.jInnerPanel.add((Component)this.getBtnApply(), null);
            this.jInnerPanel.add((Component)this.getBtnDefault(), null);
            this.jInnerPanel.add((Component)this.getBtnSelDatatypeDir(), null);
            this.jInnerPanel.add((Component)this.jLabel8, null);
            this.jInnerPanel.add((Component)this.getTxtDateExample(), null);
            this.jInnerPanel.add((Component)this.jLabel9, null);
            this.jInnerPanel.add((Component)this.getTxtWorkspace(), null);
            this.jInnerPanel.add((Component)this.getBtnSelWorkspaceDir(), null);
        }
        return this.jInnerPanel;
    }

    private JCheckBox getCbxAutoConnWhenProgramStartup() {
        if (this.cbxAutoConnWhenProgramStartup == null) {
            this.cbxAutoConnWhenProgramStartup = new JCheckBox();
            this.cbxAutoConnWhenProgramStartup.setBounds(new Rectangle(15, 32, 270, 24));
            this.cbxAutoConnWhenProgramStartup.setText(RM.R("label.PreferenceDialog.autoConnDBWhenProgramStartup"));
        }
        return this.cbxAutoConnWhenProgramStartup;
    }

    private JCheckBox getCbxSaveDbMetaInfo() {
        if (this.cbxSaveDbMetaInfo == null) {
            this.cbxSaveDbMetaInfo = new JCheckBox();
            this.cbxSaveDbMetaInfo.setBounds(new Rectangle(15, 10, 514, 24));
            this.cbxSaveDbMetaInfo.setText(RM.R("label.PreferenceDialog.saveDBMetaInfo"));
        }
        return this.cbxSaveDbMetaInfo;
    }

    private JCheckBox getCbxReadDBInfoFromFileWhenConnError() {
        if (this.cbxReadDBInfoFromFileWhenConnError == null) {
            this.cbxReadDBInfoFromFileWhenConnError = new JCheckBox();
            this.cbxReadDBInfoFromFileWhenConnError.setBounds(new Rectangle(292, 32, 279, 24));
            this.cbxReadDBInfoFromFileWhenConnError.setText(RM.R("label.PreferenceDialog.readLocalFileWhenConnDBFailure"));
        }
        return this.cbxReadDBInfoFromFileWhenConnError;
    }

    private JCheckBox getCbxNotIncludeIDEntityClumn() {
        if (this.cbxNotIncludeIDEntityClumn == null) {
            this.cbxNotIncludeIDEntityClumn = new JCheckBox();
            this.cbxNotIncludeIDEntityClumn.setBounds(new Rectangle(15, 60, 269, 19));
            this.cbxNotIncludeIDEntityClumn.setText(RM.R("label.PreferenceDialog.whenAutoGenConfigNotIncludeIDEntityClumn"));
        }
        return this.cbxNotIncludeIDEntityClumn;
    }

    private JTextField getTxtDefaultRowToGenerate() {
        if (this.txtDefaultRowToGenerate == null) {
            this.txtDefaultRowToGenerate = new JTextFieldEx();
            this.txtDefaultRowToGenerate.setBounds(new Rectangle(131, 116, 149, 21));
        }
        return this.txtDefaultRowToGenerate;
    }

    private JCheckBox getCbxCloseIDAutoInsert() {
        if (this.cbxCloseIDAutoInsert == null) {
            this.cbxCloseIDAutoInsert = new JCheckBox();
            this.cbxCloseIDAutoInsert.setBounds(new Rectangle(292, 60, 279, 19));
            this.cbxCloseIDAutoInsert.setText(RM.R("label.PreferenceDialog.closeIDAutoInsert"));
        }
        return this.cbxCloseIDAutoInsert;
    }

    private JCheckBox getCbxClearBefInsert() {
        if (this.cbxClearBefInsert == null) {
            this.cbxClearBefInsert = new JCheckBox();
            this.cbxClearBefInsert.setBounds(new Rectangle(15, 83, 271, 24));
            this.cbxClearBefInsert.setText(RM.R("label.PreferenceDialog.clearTableBefInsert"));
        }
        return this.cbxClearBefInsert;
    }

    private JTextField getTxtMinDate() {
        if (this.txtMinDate == null) {
            this.txtMinDate = new JTextFieldEx();
            this.txtMinDate.setBounds(new Rectangle(131, 177, 149, 22));
        }
        return this.txtMinDate;
    }

    private JTextField getTxtMaxDate() {
        if (this.txtMaxDate == null) {
            this.txtMaxDate = new JTextFieldEx();
            this.txtMaxDate.setBounds(new Rectangle(406, 177, 149, 22));
        }
        return this.txtMaxDate;
    }

    private JTextField getTxtTextFieldMin() {
        if (this.txtTextFieldMin == null) {
            this.txtTextFieldMin = new JTextFieldEx();
            this.txtTextFieldMin.setBounds(new Rectangle(159, 207, 121, 22));
        }
        return this.txtTextFieldMin;
    }

    private JTextField getTxtTextFieldMax() {
        if (this.txtTextFieldMax == null) {
            this.txtTextFieldMax = new JTextFieldEx();
            this.txtTextFieldMax.setBounds(new Rectangle(417, 207, 139, 22));
        }
        return this.txtTextFieldMax;
    }

    private JCheckBox getCbxGenerateSQLFile() {
        if (this.cbxGenerateSQLFile == null) {
            this.cbxGenerateSQLFile = new JCheckBox();
            this.cbxGenerateSQLFile.setBounds(new Rectangle(292, 84, 279, 21));
            this.cbxGenerateSQLFile.setText(RM.R("label.PreferenceDialog.generateSQLFile"));
        }
        return this.cbxGenerateSQLFile;
    }

    private JTextField getTxtDataTypePluginDir() {
        if (this.txtDataTypePluginDir == null) {
            this.txtDataTypePluginDir = new JTextFieldEx();
            this.txtDataTypePluginDir.setBounds(new Rectangle(150, 265, 369, 21));
        }
        return this.txtDataTypePluginDir;
    }

    private JTextField getTxtDateFormat() {
        if (this.txtDateFormat == null) {
            this.txtDateFormat = new JTextFieldEx();
            this.txtDateFormat.setBounds(new Rectangle(131, 146, 149, 22));
            this.txtDateFormat.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    PreferenceDialog.this.txtDateFormatKeyReleased();
                }
            });
        }
        return this.txtDateFormat;
    }

    protected void txtDateFormatKeyReleased() {
        String strFormat = this.getTxtDateFormat().getText();
        if (StringUtils.isEmpty((String)strFormat)) {
            this.getTxtDateExample().setText("");
        } else {
            try {
                this.getTxtDateExample().setText(this.getCurTime(strFormat));
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, String.format(RM.R("label.PreferenceDialog.error.dateFormat"), strFormat, ex.getMessage()));
                this.getTxtDateFormat().selectAll();
            }
        }
    }

    private JTDButton getBtnOK() {
        if (this.btnOK == null) {
            this.btnOK = new JTDButton();
            this.btnOK.setBounds(new Rectangle(496, 367, 71, 20));
            this.btnOK.setText(RM.R("label.info.btnOK"));
            this.btnOK.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PreferenceDialog.this.onOK();
                }
            });
        }
        return this.btnOK;
    }

    protected void onOK() {
        try {
            this.saveConfig();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, String.valueOf(RM.R("label.PreferenceDialog.error.saveConfig")) + e.getMessage());
            return;
        }
        catch (ValidataException e) {
            JOptionPane.showMessageDialog(this, e.getMessage());
            e.getControl().grabFocus();
            if (e.getControl() instanceof JTextField) {
                JTextField txt = (JTextField)e.getControl();
                txt.selectAll();
            }
            return;
        }
        this.dispose();
    }

    private JTDButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JTDButton();
            this.btnCancel.setBounds(new Rectangle(403, 367, 71, 20));
            this.btnCancel.setText(RM.R("label.info.btnCancel"));
            this.btnCancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PreferenceDialog.this.dispose();
                }
            });
        }
        return this.btnCancel;
    }

    private JTDButton getBtnApply() {
        if (this.btnApply == null) {
            this.btnApply = new JTDButton();
            this.btnApply.setBounds(new Rectangle(484, 301, 74, 19));
            this.btnApply.setText(RM.R("label.info.btnApply"));
            this.btnApply.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PreferenceDialog.this.apply();
                }
            });
        }
        return this.btnApply;
    }

    protected void apply() {
        block3: {
            try {
                this.saveConfig();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, String.valueOf(RM.R("label.PreferenceDialog.error.saveConfig")) + e.getMessage());
            }
            catch (ValidataException e) {
                JOptionPane.showMessageDialog(this, e.getMessage());
                e.getControl().grabFocus();
                if (!(e.getControl() instanceof JTextField)) break block3;
                JTextField txt = (JTextField)e.getControl();
                txt.selectAll();
            }
        }
    }

    private JTDButton getBtnDefault() {
        if (this.btnDefault == null) {
            this.btnDefault = new JTDButton();
            this.btnDefault.setBounds(new Rectangle(320, 301, 144, 19));
            this.btnDefault.setText(RM.R("label.PreferenceDialog.storeDefault"));
            this.btnDefault.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PreferenceDialog.this.restoreDefaultPreference();
                }
            });
        }
        return this.btnDefault;
    }

    protected void restoreDefaultPreference() {
        if (this.preference instanceof XmlPreference) {
            XmlPreference xmlPreference = new XmlPreference(new DefPreference());
            this.dataExchange(xmlPreference, true);
        }
    }

    private JTDButton getBtnSelDatatypeDir() {
        if (this.btnSelDatatypeDir == null) {
            this.btnSelDatatypeDir = new JTDButton();
            this.btnSelDatatypeDir.setBounds(new Rectangle(532, 266, 26, 21));
            this.btnSelDatatypeDir.setText("...");
            this.btnSelDatatypeDir.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PreferenceDialog.this.selectDir(PreferenceDialog.this.txtDataTypePluginDir);
                }
            });
        }
        return this.btnSelDatatypeDir;
    }

    private JTDButton getBtnSelWorkspaceDir() {
        if (this.btnSelWorkspaceDir == null) {
            this.btnSelWorkspaceDir = new JTDButton();
            this.btnSelWorkspaceDir.setText("...");
            this.btnSelWorkspaceDir.setBounds(new Rectangle(531, 235, 26, 21));
            this.btnSelWorkspaceDir.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PreferenceDialog.this.selectDir(PreferenceDialog.this.txtWorkspace);
                }
            });
        }
        return this.btnSelWorkspaceDir;
    }

    protected void selectDir(JTextField textField) {
        String curDir = textField.getText().trim();
        JFileChooser directoryChooser = new JFileChooser(curDir);
        directoryChooser.setDialogTitle(RM.R("label.PreferenceDialog.fileChooser.title"));
        directoryChooser.setFileSelectionMode(1);
        if (directoryChooser.showOpenDialog(this) == 0) {
            String dirPath = directoryChooser.getSelectedFile().getAbsolutePath();
            textField.setText(dirPath);
        }
    }

    public void enableAll(boolean enable) {
        this.getCbxAutoConnWhenProgramStartup().setEnabled(enable);
        this.getCbxClearBefInsert().setEnabled(enable);
        this.getCbxCloseIDAutoInsert().setEnabled(enable);
        this.getCbxGenerateSQLFile().setEnabled(enable);
        this.getCbxNotIncludeIDEntityClumn().setEnabled(enable);
        this.getCbxReadDBInfoFromFileWhenConnError().setEnabled(enable);
        this.getCbxSaveDbMetaInfo().setEnabled(enable);
        this.getTxtDataTypePluginDir().setEditable(enable);
        this.getTxtWorkspace().setEnabled(enable);
        this.getTxtDateFormat().setEditable(enable);
        this.getTxtDefaultRowToGenerate().setEditable(enable);
        this.getTxtMaxDate().setEditable(enable);
        this.getTxtMinDate().setEditable(enable);
        this.getTxtTextFieldMax().setEditable(enable);
        this.getTxtTextFieldMin().setEditable(enable);
        this.getBtnDeleteCurrentProjectPreferenceConfig().setEnabled(enable);
        this.getBtnApply().setEnabled(enable);
        this.getBtnDefault().setEnabled(enable);
        this.getBtnOK().setEnabled(enable);
    }

    private JComboBox getComBoxScope() {
        if (this.comBoxScope == null) {
            this.comBoxScope = new JComboBox();
            this.comBoxScope.setBounds(new Rectangle(161, 4, 120, 21));
            this.comBoxScope.addItem(RM.R("label.PreferenceDialog.allProject"));
            this.comBoxScope.addItem(RM.R("label.PreferenceDialog.currentProject"));
        }
        return this.comBoxScope;
    }

    private JTDButton getBtnDeleteCurrentProjectPreferenceConfig() {
        if (this.btnDeleteCurrentProjectPreferenceConfig == null) {
            this.btnDeleteCurrentProjectPreferenceConfig = new JTDButton();
            this.btnDeleteCurrentProjectPreferenceConfig.setBounds(new Rectangle(299, 4, 257, 21));
            this.btnDeleteCurrentProjectPreferenceConfig.setText(RM.R("label.PreferenceDialog.deleteCurrentProjectProferenceConfig"));
            this.btnDeleteCurrentProjectPreferenceConfig.setToolTipText(RM.R("label.PreferenceDialog.deleteCurrentProjectProferenceConfig.tooltip"));
            this.btnDeleteCurrentProjectPreferenceConfig.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PreferenceDialog.this.deleteCurProjectPreferenceConfig();
                }
            });
        }
        return this.btnDeleteCurrentProjectPreferenceConfig;
    }

    protected void deleteCurProjectPreferenceConfig() {
        File configFile = new File(this.workspace, "preference.config.xml");
        if (configFile.exists()) {
            configFile.delete();
            JOptionPane.showMessageDialog(this, RM.R("label.PreferenceDialog.deleteCurConfig.success"));
        }
        this.getComBoxScope().setSelectedIndex(0);
    }

    public void saveConfig() throws IOException, ValidataException {
        this.validateConsoleValue();
        this.dataExchange(this.preference, false);
        if (this.preference != null && this.preference instanceof XmlPreference) {
            XmlPreference xmlPreference = (XmlPreference)this.preference;
            if (StringUtils.isEmpty((String)this.getWorkspace())) {
                xmlPreference.saveConfig(null);
            } else {
                xmlPreference.saveConfig(new File(this.getWorkspace()));
            }
        }
    }

    private void validateConsoleValue() throws ValidataException {
        String strRows = this.getTxtDefaultRowToGenerate().getText().trim();
        if (StringUtils.isEmpty((String)strRows)) {
            throw new ValidataException(this.txtDefaultRowToGenerate, RM.R("label.PreferenceDialog.error.rowNumberIsNull"));
        }
        try {
            Long.valueOf(strRows);
        }
        catch (NumberFormatException ex) {
            throw new ValidataException(this.txtDefaultRowToGenerate, String.format(RM.R("label.PreferenceDialog.error.invalidNumber"), strRows));
        }
        String strFormat = this.getTxtDateFormat().getText().trim();
        if (StringUtils.isEmpty((String)strFormat)) {
            throw new ValidataException(this.txtDateFormat, RM.R("label.PreferenceDialog.error.dateFormat.isNull"));
        }
        this.dateFormat.applyPattern(strFormat);
        try {
            this.dateFormat.format(new java.util.Date());
        }
        catch (IllegalArgumentException ex) {
            throw new ValidataException(this.txtDateFormat, String.format(RM.R("label.PreferenceDialog.error.dateFormat"), strFormat, ex.getMessage()));
        }
        String strMinDate = this.getTxtMinDate().getText().trim();
        if (StringUtils.isEmpty((String)strMinDate)) {
            throw new ValidataException(this.txtMinDate, RM.R("label.PreferenceDialog.error.minDate.isNull"));
        }
        try {
            this.dateFormat.parse(strMinDate);
        }
        catch (ParseException e) {
            throw new ValidataException(this.txtMinDate, String.format(RM.R("label.PreferenceDialog.error.minDate"), strMinDate));
        }
        String strMaxDate = this.getTxtMaxDate().getText().trim();
        if (StringUtils.isEmpty((String)strMaxDate)) {
            throw new ValidataException(this.txtMaxDate, RM.R("label.PreferenceDialog.error.maxDate.isNull"));
        }
        try {
            this.dateFormat.parse(strMaxDate);
        }
        catch (ParseException e) {
            throw new ValidataException(this.txtMaxDate, String.format(RM.R("label.PreferenceDialog.error.maxDate"), strMaxDate));
        }
        String strTextMinLength = this.txtTextFieldMin.getText().trim();
        if (StringUtils.isEmpty((String)strTextMinLength)) {
            throw new ValidataException(this.txtTextFieldMin, RM.R("label.PreferenceDialog.error.txtFieldMin.isNull"));
        }
        try {
            Long.valueOf(strTextMinLength);
        }
        catch (NumberFormatException ex) {
            throw new ValidataException(this.txtTextFieldMin, String.format(RM.R("label.PreferenceDialog.error.invalidNumber"), strTextMinLength));
        }
        String strTextMaxLength = this.txtTextFieldMax.getText().trim();
        if (StringUtils.isEmpty((String)strTextMaxLength)) {
            throw new ValidataException(this.txtTextFieldMax, RM.R("label.PreferenceDialog.error.txtFieldMax.isNull"));
        }
        try {
            Long.valueOf(strTextMaxLength);
        }
        catch (NumberFormatException ex) {
            throw new ValidataException(this.txtTextFieldMax, String.format(RM.R("label.PreferenceDialog.error.invalidNumber"), strTextMaxLength));
        }
    }

    public java.util.Date strToDate(String strDate) throws ParseException {
        return new Date(this.dateFormat.parse(strDate).getTime());
    }

    public String dateToString(java.util.Date date) {
        return this.dateFormat.format(date);
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    private JTextField getTxtDateExample() {
        if (this.txtDateExample == null) {
            this.txtDateExample = new JTextFieldEx();
            this.txtDateExample.setBounds(new Rectangle(407, 146, 149, 22));
            this.txtDateExample.setEditable(false);
        }
        return this.txtDateExample;
    }

    private JTextField getTxtWorkspace() {
        if (this.txtWorkspace == null) {
            this.txtWorkspace = new JTextField();
            this.txtWorkspace.setBounds(new Rectangle(150, 235, 368, 22));
        }
        return this.txtWorkspace;
    }

    public static void main(String[] args) {
    }
}

