/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.ui.project;

import com.testDataBuilder.resources.RM;
import com.testDataBuilder.ui.core.CenterDialog;
import com.testDataBuilder.ui.core.JTDButton;
import com.testDataBuilder.ui.help.Helper;
import com.testDataBuilder.util.Global;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ProjectDialog
extends CenterDialog {
    static final Logger logger = Logger.getLogger(ProjectDialog.class);
    private static final long serialVersionUID = 1999L;
    public static final String PROJ_CONFIG_DIR = "res/folder/";
    public static final String PROJECT_FILE_NAME = "project.xml";
    private String initTitle = RM.R("label.ProjectDialog.initTitle");
    private JPanel jContentPane = null;
    private JLabel labProjectName = null;
    private JTextField txtProjectName = null;
    private JLabel labProjectPath = null;
    private JTextField txtProjectPath = null;
    private JTDButton btnOK = null;
    private JTDButton btnCancel = null;
    private JTDButton btnSelDir = null;
    private boolean isOK = false;
    private String projectPath = null;
    private JPanel innerPanel = null;

    public ProjectDialog() {
        this.initialize();
        this.center();
    }

    public ProjectDialog(Frame arg0) throws HeadlessException {
        super(arg0);
        this.initialize();
        this.center();
    }

    private void initialize() {
        this.setLayout(null);
        this.setSize(new Dimension(384, 236));
        this.setResizable(false);
        this.setContentPane(this.getJContentPane());
        this.setTitle(this.initTitle);
        Helper.getInstance().enableHelpKey(this.getRootPane(), "detail.project.newProject");
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.labProjectPath = new JLabel();
            this.labProjectPath.setText(RM.R("label.ProjectDialog.projectDir"));
            this.labProjectPath.setBounds(new Rectangle(8, 83, 66, 18));
            this.labProjectName = new JLabel();
            this.labProjectName.setText(RM.R("label.ProjectDialog.projectName"));
            this.labProjectName.setBounds(new Rectangle(8, 29, 64, 18));
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(null);
            this.jContentPane.add((Component)this.getInnerPanel(), null);
            this.jContentPane.add((Component)this.getBtnCancel(), null);
            this.jContentPane.add((Component)this.getBtnOK(), null);
        }
        return this.jContentPane;
    }

    private JTextField getTxtProjectName() {
        if (this.txtProjectName == null) {
            this.txtProjectName = new JTextField();
            this.txtProjectName.setText("newProject");
            this.txtProjectName.setBounds(new Rectangle(87, 27, 223, 24));
        }
        return this.txtProjectName;
    }

    private JTextField getTxtProjectPath() {
        if (this.txtProjectPath == null) {
            this.txtProjectPath = new JTextField();
            this.txtProjectPath.setBounds(new Rectangle(87, 80, 223, 24));
            File dir = new File(Global.getInstance().P.getWorkspace());
            dir.mkdir();
            this.txtProjectPath.setText(dir.getAbsolutePath());
        }
        return this.txtProjectPath;
    }

    private JTDButton getBtnOK() {
        if (this.btnOK == null) {
            this.btnOK = new JTDButton();
            this.btnOK.setText(RM.R("label.info.btnOK"));
            this.btnOK.setBounds(new Rectangle(289, 167, 69, 24));
            this.btnOK.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProjectDialog.this.createProject(e);
                }
            });
        }
        return this.btnOK;
    }

    protected void createProject(ActionEvent e) {
        String projectName = this.getTxtProjectName().getText().trim();
        if (StringUtils.isEmpty((String)projectName)) {
            JOptionPane.showMessageDialog(this, RM.R("label.ProjectDialog.invalid.projectNameIsNull"));
            this.txtProjectName.grabFocus();
            this.txtProjectName.selectAll();
            return;
        }
        this.projectPath = this.getTxtProjectPath().getText().trim();
        if (StringUtils.isEmpty((String)this.projectPath)) {
            JOptionPane.showMessageDialog(this, RM.R("label.ProjectDialog.invalid.ProjectDirIsNull"));
            this.txtProjectPath.grabFocus();
            this.txtProjectPath.selectAll();
            return;
        }
        this.projectPath = String.valueOf(this.projectPath) + Global.SEP + projectName;
        if (Global.isValidWorkspace(this.projectPath)) {
            JOptionPane.showMessageDialog(this, String.format(RM.R("label.ProjectDialog.dirIsAnExistProject"), this.projectPath));
            this.txtProjectPath.grabFocus();
            this.txtProjectPath.selectAll();
            return;
        }
        File projectDir = null;
        try {
            projectDir = new File(this.projectPath);
            FileUtils.forceMkdir((File)projectDir);
            FileUtils.copyDirectory((File)new File(PROJ_CONFIG_DIR), (File)projectDir);
            File projectXmlFile = new File(projectDir, PROJECT_FILE_NAME);
            String content = FileUtils.readFileToString((File)projectXmlFile, (String)"utf-8");
            content = content.replace("projectName", projectName);
            FileUtils.writeStringToFile((File)projectXmlFile, (String)content, (String)"utf-8");
            this.isOK = true;
            super.dispose();
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(this, String.valueOf(RM.R("label.ProjectDialog.error.createProject")) + e1.getMessage());
            if (projectDir != null) {
                try {
                    FileUtils.forceDelete((File)projectDir);
                }
                catch (IOException ex) {
                    logger.error((Object)"delete project dir", (Throwable)ex);
                }
            }
            return;
        }
    }

    private boolean copyFile(String url, File file) throws IOException {
        InputStream is = null;
        OutputStream os = null;
        try {
            is = this.getClass().getResourceAsStream(url);
            os = FileUtils.openOutputStream((File)file);
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        finally {
            try {
                if (os != null) {
                    os.flush();
                    ((FileOutputStream)os).close();
                }
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex) {
                logger.error((Object)"close stream", (Throwable)ex);
            }
        }
        return true;
    }

    public boolean isOK() {
        return this.isOK;
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    private JTDButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JTDButton();
            this.btnCancel.setText(RM.R("label.info.btnCancel"));
            this.btnCancel.setBounds(new Rectangle(204, 167, 69, 24));
            this.btnCancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProjectDialog.this.dispose();
                }
            });
        }
        return this.btnCancel;
    }

    private JTDButton getBtnSelDir() {
        if (this.btnSelDir == null) {
            this.btnSelDir = new JTDButton();
            this.btnSelDir.setText("...");
            this.btnSelDir.setBounds(new Rectangle(316, 81, 26, 23));
            this.btnSelDir.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProjectDialog.this.selProjectPath(e);
                }
            });
        }
        return this.btnSelDir;
    }

    protected void selProjectPath(ActionEvent e) {
        String curDir = this.getTxtProjectPath().getText().trim();
        JFileChooser directoryChooser = new JFileChooser(curDir);
        directoryChooser.setDialogTitle(RM.R("label.ProjectDialog.dirChooser.title"));
        directoryChooser.setFileSelectionMode(1);
        if (directoryChooser.showOpenDialog(this) == 0) {
            String dirPath = directoryChooser.getSelectedFile().getAbsolutePath();
            this.getTxtProjectPath().setText(dirPath);
        }
    }

    private JPanel getInnerPanel() {
        if (this.innerPanel == null) {
            this.innerPanel = new JPanel();
            this.innerPanel.setLayout(null);
            this.innerPanel.setBounds(new Rectangle(13, 12, 350, 138));
            this.innerPanel.setBorder(BorderFactory.createEtchedBorder(0));
            this.innerPanel.add((Component)this.labProjectName, null);
            this.innerPanel.add((Component)this.getTxtProjectName(), null);
            this.innerPanel.add((Component)this.labProjectPath, null);
            this.innerPanel.add((Component)this.getTxtProjectPath(), null);
            this.innerPanel.add((Component)this.getBtnSelDir(), null);
        }
        return this.innerPanel;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProjectDialog thisClass = new ProjectDialog();
                thisClass.setDefaultCloseOperation(3);
                thisClass.setVisible(true);
            }
        });
    }
}

