/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.ui.project;

import com.testDataBuilder.ui.project.ProjectInfo;
import com.testDataBuilder.util.BeanXMLMapping;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecentProjects {
    public static final String REC_PROJS_FILE = "recentProjects.xml";
    static final Logger logger = Logger.getLogger(RecentProjects.class);
    private static RecentProjects instance = null;
    private List<ProjectInfo> recentProjectList = null;
    public static final int MAX_SIZE = 10;
    private boolean changed = false;

    public static synchronized RecentProjects getInstance() {
        if (instance == null) {
            try {
                instance = RecentProjects.initFromFile();
            }
            catch (IOException ex) {
                logger.error((Object)"initFromFile", (Throwable)ex);
            }
            if (instance == null) {
                instance = new RecentProjects();
            }
        }
        return instance;
    }

    public static RecentProjects initFromFile() throws IOException {
        File file = new File(REC_PROJS_FILE);
        if (file.exists()) {
            String xml = FileUtils.readFileToString((File)file, (String)"utf8");
            return RecentProjects.fromXml(xml);
        }
        return null;
    }

    public List<ProjectInfo> getRecentProjectList() {
        if (this.recentProjectList == null) {
            this.recentProjectList = new ArrayList<ProjectInfo>();
        }
        return this.recentProjectList;
    }

    public void setRecentProjectList(List<ProjectInfo> recentProjectList) {
        this.recentProjectList = recentProjectList;
    }

    public void addProject(ProjectInfo projectInfo) {
        if (this.getRecentProjectList().contains(projectInfo)) {
            this.getRecentProjectList().remove(projectInfo);
        } else if (this.getRecentProjectList().size() >= 10) {
            this.getRecentProjectList().remove(9);
        }
        this.getRecentProjectList().add(0, projectInfo);
        this.setChanged(true);
    }

    public boolean removeProjectByName(String projectName) {
        for (ProjectInfo projectInfo : this.getRecentProjectList()) {
            if (!projectInfo.getProjectName().equalsIgnoreCase(projectName)) continue;
            return this.getRecentProjectList().remove(projectInfo);
        }
        return false;
    }

    public boolean removeProjectByPath(String projectPath) {
        for (ProjectInfo projectInfo : this.getRecentProjectList()) {
            if (!projectInfo.getProjectPath().equalsIgnoreCase(projectPath)) continue;
            return this.getRecentProjectList().remove(projectInfo);
        }
        return false;
    }

    public void addProject2RecentList(String projectName, String projectPath) {
        ProjectInfo projectInfo = new ProjectInfo(projectName, projectPath);
        this.addProject(projectInfo);
        try {
            this.storeToXmlFile();
        }
        catch (IOException e) {
            logger.error((Object)"addProject2RecentList", (Throwable)e);
        }
    }

    public void storeToXmlFile() throws IOException {
        String xml = this.toString();
        FileUtils.writeStringToFile((File)new File(REC_PROJS_FILE), (String)xml, (String)"utf8");
    }

    public void removeProjectByPathAndSave(String projectPath) {
        this.removeProjectByPath(projectPath);
        try {
            this.storeToXmlFile();
        }
        catch (IOException e) {
            logger.error((Object)"addProject2RecentList", (Throwable)e);
        }
    }

    public String toString() {
        try {
            return BeanXMLMapping.toXML(this);
        }
        catch (IOException e) {
            logger.error((Object)"toString", (Throwable)e);
            return null;
        }
    }

    public static RecentProjects fromXml(String xml) throws IOException {
        return (RecentProjects)BeanXMLMapping.fromXML(xml, RecentProjects.class);
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }
}

