/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.ui.role;

import com.testDataBuilder.config.TableConfig;
import com.testDataBuilder.ui.util.ColumnInfo;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ColumnTableModel
extends AbstractTableModel {
    private List<TableConfig> tableConfigs = new ArrayList<TableConfig>();
    List<ColumnInfo> columnInfos = null;

    public ColumnTableModel(List<ColumnInfo> columnInfos) {
        this.columnInfos = columnInfos;
    }

    public ColumnTableModel(List<TableConfig> tableConfigs, List<ColumnInfo> columnInfos) {
        this.tableConfigs = tableConfigs;
        this.columnInfos = columnInfos;
    }

    @Override
    public int getColumnCount() {
        return this.columnInfos.size();
    }

    @Override
    public int getRowCount() {
        if (this.tableConfigs == null) {
            return 0;
        }
        return this.tableConfigs.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        TableConfig tableConfig = this.tableConfigs.get(rowIndex);
        Object value = null;
        switch (columnIndex) {
            case 0: {
                value = tableConfig.getIsGenerate();
                break;
            }
            case 1: {
                value = tableConfig.getTableName();
                break;
            }
            case 2: {
                value = tableConfig.getCount();
                break;
            }
            default: {
                value = "";
            }
        }
        return value;
    }

    @Override
    public int findColumn(String columnName) {
        return this.columnInfos.indexOf(columnName);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        Object value = this.getValueAt(0, columnIndex);
        if (value == null) {
            return Object.class;
        }
        return value.getClass();
    }

    @Override
    public String getColumnName(int column) {
        ColumnInfo columnInfo = this.columnInfos.get(column);
        return columnInfo.getName();
    }

    public int getColumnWidth(int column) {
        ColumnInfo columnInfo = this.columnInfos.get(column);
        return columnInfo.getWidth();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        TableConfig columnConfig = this.getData().get(rowIndex);
        switch (columnIndex) {
            case 0: {
                columnConfig.setIsGenerate((Boolean)aValue);
                break;
            }
            case 1: {
                break;
            }
        }
    }

    public List<TableConfig> getData() {
        return this.tableConfigs;
    }

    public void setData(List<TableConfig> data) {
        if (data == null) {
            data = new LinkedList<TableConfig>();
        }
        this.tableConfigs = data;
    }

    public List<ColumnInfo> getColumnInfos() {
        return this.columnInfos;
    }

    public void setColumnInfos(List<ColumnInfo> columnInfos) {
        this.columnInfos = columnInfos;
    }
}

