/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.ui.role;

import com.testDataBuilder.core.baseType.JavaTypes;
import com.testDataBuilder.core.role.EnumObj;
import com.testDataBuilder.exception.BaseException;
import com.testDataBuilder.exception.ValidataException;
import com.testDataBuilder.resources.RM;
import com.testDataBuilder.ui.core.CenterDialog;
import com.testDataBuilder.ui.core.JTDButton;
import com.testDataBuilder.ui.core.JTextFieldEx;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.lang.StringUtils;

public class EnumValueDialog
extends CenterDialog {
    private JPanel jContentPane = null;
    private JPanel innerPanel = null;
    private JTDButton btnOK = null;
    private JTDButton btnCancel = null;
    private JLabel label = null;
    private JTextField txtValue = null;
    private JLabel jLabel = null;
    private JTextField txtPercent = null;
    private EnumObj enumObj = null;
    private Class valueValidator = null;
    private boolean isOK = false;

    public EnumValueDialog(JDialog parent, EnumObj enumObj, Class valueValidator) {
        super(parent);
        this.enumObj = enumObj;
        this.valueValidator = valueValidator;
        this.initialize();
        this.dataExchange(enumObj, true);
    }

    private void initialize() {
        this.setSize(new Dimension(375, 228));
        this.setTitle(RM.R("label.EnumValueDialog.title"));
        this.setResizable(false);
        this.setContentPane(this.getJContentPane());
    }

    public void dataExchange(EnumObj enumObj, boolean isToControl) {
        if (isToControl) {
            if (enumObj == null) {
                enumObj = new EnumObj();
            }
            if (enumObj.getPercent() != null) {
                this.getTxtPercent().setText(enumObj.getPercent().toString());
            }
            if (enumObj.getValue() != null) {
                this.getTxtValue().setText(enumObj.getValue().toString());
            }
        } else {
            Object value;
            try {
                value = JavaTypes.getInstance().valueOf(this.valueValidator, this.getTxtValue().getText().trim());
            }
            catch (BaseException e) {
                JOptionPane.showMessageDialog(this, String.valueOf(RM.R("label.EnumValueDialog.error.addEnumError")) + e.getMessage());
                return;
            }
            enumObj.setValue(value);
            enumObj.setPercent(Integer.valueOf(this.getTxtPercent().getText().trim()));
        }
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(null);
            this.jContentPane.add((Component)this.getInnerPanel(), null);
            this.jContentPane.add((Component)this.getBtnOK(), null);
            this.jContentPane.add((Component)this.getBtnCancel(), null);
        }
        return this.jContentPane;
    }

    private JPanel getInnerPanel() {
        if (this.innerPanel == null) {
            this.jLabel = new JLabel();
            this.jLabel.setBounds(new Rectangle(23, 64, 63, 25));
            this.jLabel.setText(RM.R("label.EnumValueDialog.label.percent"));
            this.label = new JLabel();
            this.label.setBounds(new Rectangle(23, 22, 63, 25));
            this.label.setText(RM.R("label.EnumValueDialog.label.value"));
            this.innerPanel = new JPanel();
            this.innerPanel.setLayout(null);
            this.innerPanel.setBounds(new Rectangle(14, 15, 343, 145));
            this.innerPanel.setBorder(BorderFactory.createEtchedBorder(0));
            this.innerPanel.add((Component)this.label, null);
            this.innerPanel.add((Component)this.getTxtValue(), null);
            this.innerPanel.add((Component)this.jLabel, null);
            this.innerPanel.add((Component)this.getTxtPercent(), null);
        }
        return this.innerPanel;
    }

    private JTDButton getBtnOK() {
        if (this.btnOK == null) {
            this.btnOK = new JTDButton();
            this.btnOK.setBounds(new Rectangle(192, 167, 77, 21));
            this.btnOK.setText(RM.R("label.info.btnOK"));
            this.btnOK.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    EnumValueDialog.this.onOK();
                }
            });
        }
        return this.btnOK;
    }

    protected void onOK() {
        try {
            this.validateControlValue();
        }
        catch (ValidataException e) {
            JOptionPane.showMessageDialog(this, e.getMessage());
            if (e.getControl() instanceof JTextField) {
                JTextField txt = (JTextField)e.getControl();
                txt.grabFocus();
                txt.selectAll();
            }
            return;
        }
        if (this.enumObj == null) {
            this.enumObj = new EnumObj();
        }
        this.dataExchange(this.enumObj, false);
        this.isOK = true;
        this.dispose();
    }

    private void validateControlValue() throws ValidataException {
        String strValue = this.getTxtValue().getText();
        if (StringUtils.isEmpty((String)strValue)) {
            throw new ValidataException(this.txtValue, RM.R("label.EnumValueDialog.validation.valueIsNull"));
        }
        try {
            JavaTypes.getInstance().valueOf(this.valueValidator, strValue);
        }
        catch (Exception e) {
            throw new ValidataException(this.txtValue, String.valueOf(RM.R("label.EnumValueDialog.validation.invalidValue")) + e.getMessage());
        }
        String strPercent = this.getTxtPercent().getText().trim();
        if (StringUtils.isEmpty((String)strPercent)) {
            throw new ValidataException(this.txtPercent, RM.R("label.EnumValueDialog.validation.percentIsNull"));
        }
        try {
            Integer.valueOf(strPercent);
        }
        catch (NumberFormatException ex) {
            throw new ValidataException(this.txtPercent, RM.R("label.EnumValueDialog.validation.percentValueInvalid"));
        }
    }

    private JTDButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JTDButton();
            this.btnCancel.setBounds(new Rectangle(281, 167, 77, 21));
            this.btnCancel.setText(RM.R("label.info.btnCancel"));
            this.btnCancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    EnumValueDialog.this.dispose();
                }
            });
        }
        return this.btnCancel;
    }

    private JTextField getTxtValue() {
        if (this.txtValue == null) {
            this.txtValue = new JTextFieldEx();
            this.txtValue.setBounds(new Rectangle(94, 22, 225, 24));
        }
        return this.txtValue;
    }

    private JTextField getTxtPercent() {
        if (this.txtPercent == null) {
            this.txtPercent = new JTextFieldEx();
            this.txtPercent.setBounds(new Rectangle(94, 64, 225, 24));
        }
        return this.txtPercent;
    }

    public EnumObj getEnumObj() {
        return this.enumObj;
    }

    public void setEnumObj(EnumObj enumObj) {
        this.enumObj = enumObj;
    }

    public boolean isOK() {
        return this.isOK;
    }

    public void setOK(boolean isOK) {
        this.isOK = isOK;
    }
}

