/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.ui.role;

import com.testDataBuilder.config.WorkspaceDataCache;
import com.testDataBuilder.config.preference.IPreference;
import com.testDataBuilder.core.GenerateAndInsertData;
import com.testDataBuilder.core.IProcess;
import com.testDataBuilder.core.SQLRecorder;
import com.testDataBuilder.exception.JavaCodeRuntimeException;
import com.testDataBuilder.resources.RM;
import com.testDataBuilder.ui.core.CenterDialog;
import com.testDataBuilder.ui.core.JTDButton;
import com.testDataBuilder.ui.core.ProgressPanel;
import com.testDataBuilder.ui.database.JSQLFileChooser;
import com.testDataBuilder.ui.help.Helper;
import com.testDataBuilder.ui.main.MainFrame;
import com.testDataBuilder.ui.main.OpenWorkspaceUtil;
import com.testDataBuilder.ui.role.GenearterExecutor;
import com.testDataBuilder.ui.role.JTableTable;
import com.testDataBuilder.util.Global;
import com.testDataBuilder.util.TimeUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class GenerateDataDialog
extends CenterDialog
implements IProcess {
    static Logger logger = Logger.getLogger(GenerateDataDialog.class);
    private JPanel jContentPane = null;
    private ProgressPanel innerPanel = null;
    private JTDButton btnBegin = null;
    private JTDButton btnRunInBackground = null;
    private JTDButton btnGenPreferences = null;
    private JPanel recordFilePanel = null;
    private JCheckBox cbxGenerateSQLFile = null;
    private JTDButton btnOpenScriptDir;
    private JTextField txtSQLFilePath = null;
    private JTDButton btnSelSQLFile = null;
    public static final String BTN_BEING_BEING = RM.R("label.GenerateDataDialog.btnStart");
    public static final String BTN_BEING_STOP = RM.R("label.GenerateDataDialog.btnStop");
    private IPreference p;
    private WorkspaceDataCache workspaceDataCache;
    int minHeight;
    int maxHeight;
    private SQLRecorder sqlRecorder;
    private boolean isRunInBackground;
    private GenerateAndInsertData generateAndInsertData;
    private JTDButton btnClose;
    private JTabbedPane jOptionTabbedPane;
    private JScrollPane jDetailScrollPane;
    private JTableTable jTableTable;

    public MainFrame getParent() {
        return (MainFrame)super.getParent();
    }

    public GenerateDataDialog() {
        this.p = Global.getInstance().P;
        this.workspaceDataCache = null;
        this.maxHeight = this.minHeight = 165;
        this.sqlRecorder = null;
        this.isRunInBackground = false;
        this.generateAndInsertData = null;
        this.btnClose = null;
        this.jOptionTabbedPane = null;
        this.jDetailScrollPane = null;
        this.jTableTable = null;
        this.initialize();
        this.setDefaultCloseOperation(0);
        this.center();
    }

    public GenerateDataDialog(MainFrame parent, WorkspaceDataCache workspaceDataCache) {
        super(parent);
        this.p = Global.getInstance().P;
        this.workspaceDataCache = null;
        this.maxHeight = this.minHeight = 165;
        this.sqlRecorder = null;
        this.isRunInBackground = false;
        this.generateAndInsertData = null;
        this.btnClose = null;
        this.jOptionTabbedPane = null;
        this.jDetailScrollPane = null;
        this.jTableTable = null;
        this.workspaceDataCache = workspaceDataCache;
        this.initialize();
        this.center();
    }

    private void initialize() {
        this.setSize(new Dimension(490, 432));
        this.setResizable(false);
        this.setTitle(RM.R("label.GenerateDataDialog.title"));
        this.setDefaultCloseOperation(0);
        this.maxHeight = this.getHeight();
        this.setContentPane(this.getJContentPane());
        this.initOptionPanel();
        Helper.getInstance().enableHelpKey(this.getRootPane(), "detail.role.generateData");
    }

    private void initOptionPanel() {
        this.getCbxGenerateSQLFile().setSelected(this.p.getGenerateSQLFile());
        this.getJTableTable().setData(this.workspaceDataCache.getTableConfigs());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(null);
            this.jContentPane.add((Component)this.getInnerPanel(), null);
            this.jContentPane.add((Component)this.getJOptionTabbedPane(), null);
        }
        return this.jContentPane;
    }

    private ProgressPanel getInnerPanel() {
        if (this.innerPanel == null) {
            this.innerPanel = new ProgressPanel();
            this.innerPanel.setLayout(null);
            this.innerPanel.setBounds(14, 13, 452, 112);
            this.innerPanel.setBorder(BorderFactory.createEtchedBorder(0));
            this.innerPanel.add(this.getBtnBegin());
            this.innerPanel.add(this.getBtnGenPreferences());
            this.innerPanel.add(this.getBtnRunInBackground());
            this.innerPanel.add(this.getBtnClose());
        }
        return this.innerPanel;
    }

    private JTDButton getBtnBegin() {
        if (this.btnBegin == null) {
            this.btnBegin = new JTDButton();
            this.btnBegin.setBounds(256, 74, 78, 24);
            this.btnBegin.setText(BTN_BEING_BEING);
            this.btnBegin.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GenerateDataDialog.this.beginOrStopInsert();
                }
            });
        }
        return this.btnBegin;
    }

    protected void beginOrStopInsert() {
        if (this.generateAndInsertData == null) {
            this.getBtnBegin().setText(BTN_BEING_STOP);
            this.getBtnClose().setEnabled(false);
            this.generateAndInsertData = new GenerateAndInsertData();
            this.generateAndInsertData.setProcessBar(this);
            if (this.getCbxGenerateSQLFile().isSelected()) {
                File sqlFile = new File(this.getTxtSQLFilePath().getText().trim());
                this.sqlRecorder = new SQLRecorder(sqlFile);
                this.generateAndInsertData.setSqlRecorder(this.sqlRecorder);
            }
            GenearterExecutor executor = new GenearterExecutor(this.generateAndInsertData, this, this.workspaceDataCache);
            new Thread(executor).start();
        } else {
            int result = JOptionPane.showConfirmDialog(this, RM.R("label.GenerateDataDialog.confirmStop"));
            if (result == 0) {
                this.getBtnBegin().setText(BTN_BEING_BEING);
                this.getBtnClose().setEnabled(true);
                this.generateAndInsertData.setBread(true);
                this.generateAndInsertData = null;
            }
        }
    }

    private JTDButton getBtnRunInBackground() {
        if (this.btnRunInBackground == null) {
            this.btnRunInBackground = new JTDButton();
            this.btnRunInBackground.setBounds(47, 74, 93, 24);
            this.btnRunInBackground.setText(RM.R("label.GenerateDataDialog.btnRunInBack"));
            this.btnRunInBackground.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GenerateDataDialog.this.runInBackground();
                }
            });
        }
        return this.btnRunInBackground;
    }

    public boolean isRunInBackground() {
        return this.isRunInBackground;
    }

    public void setIsRunInBackground(boolean isRunInBackground) {
        this.isRunInBackground = isRunInBackground;
    }

    protected void runInBackground() {
        this.setVisible(false);
        this.isRunInBackground = true;
    }

    private JTDButton getBtnGenPreferences() {
        if (this.btnGenPreferences == null) {
            this.btnGenPreferences = new JTDButton();
            this.btnGenPreferences.setBounds(159, 74, 78, 24);
            this.btnGenPreferences.setText(RM.R("label.GenerateDataDialog.btnOption"));
            this.btnGenPreferences.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GenerateDataDialog.this.showOrHidePreference();
                }
            });
        }
        return this.btnGenPreferences;
    }

    protected void showOrHidePreference() {
        if (this.getHeight() == this.minHeight) {
            this.setSize(this.getWidth(), this.maxHeight);
        } else {
            this.setSize(this.getWidth(), this.minHeight);
        }
        this.paintAll(this.getGraphics());
    }

    private JPanel getRecordFilePanel() {
        if (this.recordFilePanel == null) {
            this.recordFilePanel = new JPanel();
            this.recordFilePanel.setLayout(null);
            this.recordFilePanel.setBorder(BorderFactory.createEtchedBorder(0));
            this.recordFilePanel.add((Component)this.getCbxGenerateSQLFile(), null);
            this.recordFilePanel.add((Component)this.getTxtSQLFilePath(), null);
            this.recordFilePanel.add((Component)this.getBtnSelSQLFile(), null);
            this.recordFilePanel.add(this.getBtnOpenScriptDir());
        }
        return this.recordFilePanel;
    }

    private JCheckBox getCbxGenerateSQLFile() {
        if (this.cbxGenerateSQLFile == null) {
            this.cbxGenerateSQLFile = new JCheckBox();
            this.cbxGenerateSQLFile.setBounds(new Rectangle(13, 10, 132, 19));
            this.cbxGenerateSQLFile.setText(RM.R("label.GenerateDataDialog.btnGenSQLFile"));
            this.cbxGenerateSQLFile.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    GenerateDataDialog.this.cbxGenerateSQLFileChange();
                }
            });
        }
        return this.cbxGenerateSQLFile;
    }

    protected void cbxGenerateSQLFileChange() {
        String temp;
        boolean isSeld = this.getCbxGenerateSQLFile().isSelected();
        this.getTxtSQLFilePath().setEnabled(isSeld);
        this.getBtnSelSQLFile().setEnabled(isSeld);
        if (isSeld && StringUtils.isEmpty((String)(temp = this.getTxtSQLFilePath().getText()))) {
            String sqlFileName = this.getFileName();
            this.getTxtSQLFilePath().setText(sqlFileName);
        }
    }

    public String getFileName() {
        String t = TimeUtils.formatData(new Date(), "yyyyMMdd_HHmmss");
        File dir = new File(this.workspaceDataCache.getGeneratedSQLDir());
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String fileName = new File(dir, "GenerateData_" + t + ".sql").getAbsolutePath();
        return fileName;
    }

    private JTextField getTxtSQLFilePath() {
        if (this.txtSQLFilePath == null) {
            this.txtSQLFilePath = new JTextField();
            this.txtSQLFilePath.setBounds(new Rectangle(17, 38, 377, 23));
            this.txtSQLFilePath.setEnabled(false);
        }
        return this.txtSQLFilePath;
    }

    private JTDButton getBtnSelSQLFile() {
        if (this.btnSelSQLFile == null) {
            this.btnSelSQLFile = new JTDButton();
            this.btnSelSQLFile.setBounds(new Rectangle(405, 38, 27, 22));
            this.btnSelSQLFile.setEnabled(false);
            this.btnSelSQLFile.setText("...");
            this.btnSelSQLFile.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GenerateDataDialog.this.SelFile();
                }
            });
        }
        return this.btnSelSQLFile;
    }

    protected void SelFile() {
        JSQLFileChooser fileChooser = new JSQLFileChooser(this.getTxtSQLFilePath().getText());
        if (fileChooser.showOpenDialog(this) == 0) {
            String filePath = fileChooser.getSelectedFile().getAbsolutePath();
            this.getTxtSQLFilePath().setText(filePath);
        }
    }

    public void setInfo(String info) {
        this.getInnerPanel().getTxtInfo().setText(info);
    }

    public void setProcessBarPos(int pos) {
        this.getInnerPanel().getProcessBar().setValue(pos %= 101);
    }

    public void onGenerateOver(Exception ex, SQLRecorder tmpSqlRecorder) {
        this.generateAndInsertData = null;
        String info = null;
        if (ex != null) {
            info = ex instanceof SQLException ? String.format(RM.R("label.GenerateDataDialog.info.SQLException"), ex.getMessage()) : (ex instanceof IOException ? String.format(RM.R("label.GenerateDataDialog.info.IOException"), ex.getMessage()) : (ex instanceof JavaCodeRuntimeException ? ex.getMessage() : String.format(RM.R("label.GenerateDataDialog.info.exception"), ex.getClass().getName())));
            logger.error((Object)info, (Throwable)ex);
        } else {
            File sqlFile = null;
            if (tmpSqlRecorder != null && tmpSqlRecorder.getSqlFile() != null) {
                sqlFile = tmpSqlRecorder.getSqlFile();
            }
            info = sqlFile == null ? RM.R("label.GenerateDataDialog.info.over") : String.valueOf(RM.R("label.GenerateDataDialog.info.genOverAndGenTheSQLFile")) + sqlFile.getAbsolutePath() + "]";
        }
        this.getBtnBegin().setText(BTN_BEING_BEING);
        this.getBtnClose().setEnabled(true);
        this.setProcessBarPos(0);
        this.setInfo(info);
        JOptionPane.showMessageDialog(this, info);
    }

    private JTDButton getBtnClose() {
        if (this.btnClose == null) {
            this.btnClose = new JTDButton();
            this.btnClose.setBounds(350, 74, 78, 24);
            this.btnClose.setText(RM.R("label.info.btnClose"));
            this.btnClose.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GenerateDataDialog.this.onClose();
                }
            });
        }
        return this.btnClose;
    }

    protected void onClose() {
        this.dispose();
    }

    private JTabbedPane getJOptionTabbedPane() {
        if (this.jOptionTabbedPane == null) {
            this.jOptionTabbedPane = new JTabbedPane();
            this.jOptionTabbedPane.setBounds(new Rectangle(14, 145, 452, 246));
            this.jOptionTabbedPane.addTab(RM.R("label.GenerateDataDialog.tabTitle.genDetail"), null, this.getJDetailScrollPane(), RM.R("label.GenerateDataDialog.tabTitle.genDetail.alt"));
            this.jOptionTabbedPane.addTab(RM.R("label.GenerateDataDialog.tabTitle.recordFile"), null, this.getRecordFilePanel(), RM.R("label.GenerateDataDialog.tabTitle.recordFile.alt"));
        }
        return this.jOptionTabbedPane;
    }

    private JScrollPane getJDetailScrollPane() {
        if (this.jDetailScrollPane == null) {
            this.jDetailScrollPane = new JScrollPane();
            this.jDetailScrollPane.setViewportView(this.getJTableTable());
        }
        return this.jDetailScrollPane;
    }

    private JTableTable getJTableTable() {
        if (this.jTableTable == null) {
            this.jTableTable = new JTableTable();
        }
        return this.jTableTable;
    }

    private JButton getBtnOpenScriptDir() {
        if (this.btnOpenScriptDir == null) {
            this.btnOpenScriptDir = new JTDButton();
            this.btnOpenScriptDir.setText(RM.R("label.GenerateDataDialog.btnOpenScriptDir"));
            this.btnOpenScriptDir.setBounds(337, 9, 95, 22);
            this.btnOpenScriptDir.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GenerateDataDialog.this.openScriptDir();
                }
            });
        }
        return this.btnOpenScriptDir;
    }

    protected void openScriptDir() {
        File file = new File(this.getTxtSQLFilePath().getText().trim());
        String dir = null;
        dir = file.getParent();
        if (dir != null) {
            OpenWorkspaceUtil.openWorkspaceInExplorer(dir, this);
        }
    }
}

