/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.ui.role;

import com.testDataBuilder.resources.RM;
import com.testDataBuilder.ui.help.Helper;
import com.testDataBuilder.ui.role.RoleDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class JRoleMenuBar
extends JMenuBar {
    RoleDialog parent = null;
    JMenu roleMenu = null;
    JMenu helpMenu = null;

    public JRoleMenuBar(RoleDialog parent) {
        this.parent = parent;
        this.add(this.getRoleMenu());
        this.add(this.getHelp());
    }

    public JMenu getRoleMenu() {
        if (this.roleMenu == null) {
            this.roleMenu = new JMenu();
            this.roleMenu.setText(RM.R("label.JRoleMenuBar.title"));
            this.roleMenu.add(this.getNewRoleItem());
            this.roleMenu.add(this.getDeleteSelRoleItem());
            this.roleMenu.addSeparator();
            this.roleMenu.add(this.getPreviewGenItem());
            this.roleMenu.addSeparator();
            this.roleMenu.add(this.getExitItem());
        }
        return this.roleMenu;
    }

    public JMenu getHelp() {
        if (this.helpMenu == null) {
            this.helpMenu = new JMenu();
            this.helpMenu.setText(RM.R("label.JRoleMenuBar.help"));
            this.helpMenu.add(this.getHelpContentItem());
            this.helpMenu.add(this.getAboutItem());
        }
        return this.helpMenu;
    }

    protected JPopupMenu getTablePopupMenu() {
        JPopupMenu root = new JPopupMenu("TablePopupMenu");
        root.add(this.getNewRoleItem());
        root.add(this.getDeleteAllRoleItem());
        root.addSeparator();
        root.add(this.getPreviewGenItem());
        return root;
    }

    protected JPopupMenu getRolePopupMenu() {
        JPopupMenu root = new JPopupMenu("roleMenu");
        root.add(this.getNewRoleItem());
        root.add(this.getDeleteSelRoleItem());
        return root;
    }

    public JMenuItem getNewRoleItem() {
        JMenuItem addNewItem = new JMenuItem(RM.R("label.JRoleMenuBar.addNewRole"));
        addNewItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JRoleMenuBar.this.parent.addRole(e);
            }
        });
        return addNewItem;
    }

    public JMenuItem getDeleteAllRoleItem() {
        JMenuItem deleteAllItem = new JMenuItem(RM.R("label.JRoleMenuBar.deleteAllRole"));
        deleteAllItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JRoleMenuBar.this.parent.deleteAll();
            }
        });
        return deleteAllItem;
    }

    public JMenuItem getDeleteSelRoleItem() {
        JMenuItem deleteSelItem = new JMenuItem(RM.R("label.JRoleMenuBar.deleteSelRole"));
        deleteSelItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JRoleMenuBar.this.parent.deleteSelRole();
            }
        });
        return deleteSelItem;
    }

    public JMenuItem getPreviewGenItem() {
        JMenuItem previewGenItem = new JMenuItem(RM.R("label.JRoleMenuBar.previewGen"));
        previewGenItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JRoleMenuBar.this.parent.genToPreview();
            }
        });
        return previewGenItem;
    }

    public JMenuItem getExitItem() {
        JMenuItem exitItem = new JMenuItem(RM.R("label.JRoleMenuBar.exit"));
        exitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JRoleMenuBar.this.parent.dispose();
            }
        });
        return exitItem;
    }

    public JMenuItem getHelpContentItem() {
        JMenuItem helpContentItem = new JMenuItem(RM.R("label.JRoleMenuBar.helpContent"));
        helpContentItem.addActionListener(Helper.getInstance().getHelpListener());
        return helpContentItem;
    }

    public JMenuItem getAboutItem() {
        JMenuItem aboutItem = new JMenuItem(RM.R("label.JRoleMenuBar.about"));
        aboutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(JRoleMenuBar.this.parent, RM.R("label.JRoleMenuBar.copyright"), RM.R("label.JRoleMenuBar.copyright.title"), 0);
            }
        });
        return aboutItem;
    }
}

