/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.ui.role;

import com.testDataBuilder.config.TableConfig;
import com.testDataBuilder.resources.RM;
import com.testDataBuilder.ui.role.ColumnTableModel;
import com.testDataBuilder.ui.util.ColumnInfo;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTableTable
extends JTable {
    private List<ColumnInfo> columnNames = null;
    JMenuItem selectAllAllMenuItem = null;
    JMenuItem dsselectAllAllMenuItem = null;

    public JTableTable() {
        this.init();
    }

    protected void init() {
        this.setModel(new ColumnTableModel(this.getColumnNames()));
        this.setSelectionMode(1);
        int i = 0;
        while (i < this.getColumnModel().getColumnCount()) {
            TableColumn fieldColumn = this.getColumnModel().getColumn(i);
            fieldColumn.setPreferredWidth(this.getColumnNames().get(i).getWidth());
            ++i;
        }
        this.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 3) {
                    JTableTable.this.showPopupMenu(e);
                }
                super.mouseReleased(e);
            }
        });
    }

    public void showPopupMenu(MouseEvent e) {
        JPopupMenu menu = this.getTablePopupMenu();
        menu.show(this, e.getX(), e.getY());
    }

    private List<ColumnInfo> getColumnNames() {
        if (this.columnNames == null) {
            this.columnNames = new ArrayList<ColumnInfo>();
            this.columnNames.add(new ColumnInfo(RM.R("label.JTableTable.columnName.isGenerate"), 5));
            this.columnNames.add(new ColumnInfo(RM.R("label.JTableTable.columnName.tableName"), 150));
            this.columnNames.add(new ColumnInfo(RM.R("label.JTableTable.columnName.count"), 20));
        }
        return this.columnNames;
    }

    public ColumnTableModel getDataModel() {
        return (ColumnTableModel)this.dataModel;
    }

    public List<TableConfig> getData() {
        return this.getDataModel().getData();
    }

    public void setData(List<TableConfig> columnData) {
        this.getDataModel().setData(columnData);
        this.clearSelection();
        this.updateUI();
    }

    @Override
    public Class<?> getColumnClass(int column) {
        Object value = this.getValueAt(0, column);
        if (value == null) {
            return Object.class;
        }
        return value.getClass();
    }

    @Override
    public void selectAll() {
        if (this.getData() != null) {
            for (TableConfig tableConfig : this.getData()) {
                tableConfig.setIsGenerate(Boolean.TRUE);
            }
            this.updateUI();
        }
    }

    public void diselectAll() {
        if (this.getData() != null) {
            for (TableConfig tableConfig : this.getData()) {
                tableConfig.setIsGenerate(Boolean.FALSE);
            }
            this.updateUI();
        }
    }

    public JPopupMenu getTablePopupMenu() {
        JPopupMenu root = new JPopupMenu("table");
        root.add(this.getSelectAllMenuItem());
        root.add(this.getDiselectAllMenuItem());
        return root;
    }

    public JMenuItem getSelectAllMenuItem() {
        if (this.selectAllAllMenuItem == null) {
            this.selectAllAllMenuItem = new JMenuItem(RM.R("label.JTableTable.poput.selectAll"));
            this.selectAllAllMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableTable.this.selectAll();
                }
            });
        }
        return this.selectAllAllMenuItem;
    }

    public JMenuItem getDiselectAllMenuItem() {
        if (this.dsselectAllAllMenuItem == null) {
            this.dsselectAllAllMenuItem = new JMenuItem(RM.R("label.JTableTable.poput.diselectAll"));
            this.dsselectAllAllMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableTable.this.diselectAll();
                }
            });
        }
        return this.dsselectAllAllMenuItem;
    }
}

