/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.ui.role;

import com.testDataBuilder.dynamicCompile.DynamicCompiler;
import com.testDataBuilder.exception.BaseException;
import com.testDataBuilder.resources.RM;
import com.testDataBuilder.ui.core.CenterDialog;
import com.testDataBuilder.ui.help.Helper;
import com.testDataBuilder.ui.main.queryConsole.JEditTextArea;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.syntax.jedit.tokenmarker.JavaTokenMarker;
import org.syntax.jedit.tokenmarker.TokenMarker;

public class JavaEditorDialog
extends CenterDialog {
    static final Logger logger = Logger.getLogger(JavaEditorDialog.class);
    private JEditTextArea txtJavaCode;
    private JTextField txtReturnFields;
    private JComboBox cbxReturnType;
    private JLabel jLabel2;
    private JButton btnHelp;
    private JButton btnValidation;
    private JButton btnCancel;
    private JButton btnOK;
    private JLabel jLabel1;
    private int JavaCodeBottom = 0;
    private int bottom = 0;
    private int right = 0;
    private int mid = 0;
    boolean isOK = false;

    public void setReturnType(Object returnType) {
        this.getCbxReturnType().setSelectedItem(returnType);
    }

    public void setReturnFields(String returnFields) {
        this.getTxtReturnFields().setText(returnFields);
    }

    public void setJavaCode(String javaCode) {
        this.getTxtJavaCode().setText(javaCode);
        this.txtJavaCode.setFirstLine(10);
    }

    public Object getReturnType() {
        return this.getCbxReturnType().getSelectedItem();
    }

    public String getReturnFields() {
        return this.getTxtReturnFields().getText();
    }

    public String getJavaCode() {
        return this.getTxtJavaCode().getText();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JDialog dialog = new JDialog();
                JavaEditorDialog inst = new JavaEditorDialog(dialog);
                inst.setVisible(true);
            }
        });
    }

    public JavaEditorDialog(JDialog parent) {
        super(parent);
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.getContentPane().setLayout(null);
            this.setSize(638, 459);
            this.setResizable(true);
            this.setModal(true);
            this.setMinimumSize(new Dimension(400, 300));
            this.getContentPane().add(this.getBtnOK());
            this.getContentPane().add(this.getBtnCancel());
            this.getContentPane().add(this.getBtnValidation());
            this.getContentPane().add(this.getJLabel1());
            this.getContentPane().add(this.getJLabel2());
            this.getContentPane().add(this.getCbxReturnType());
            this.getContentPane().add(this.getTxtReturnFields());
            this.getContentPane().add((Component)((Object)this.getTxtJavaCode()));
            this.getContentPane().add(this.getBtnHelp());
            this.calc();
            this.getContentPane().addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent e) {
                    JavaEditorDialog.this.frameResized(e);
                }
            });
            Helper.getInstance().enableHelpKey(this.getContentPane(), "detail.role.userRole.javaRole");
            this.center();
        }
        catch (Exception e) {
            logger.error((Object)"initGUI", (Throwable)e);
        }
    }

    private void calc() {
        this.JavaCodeBottom = this.getHeight() - this.txtJavaCode.getY() - this.txtJavaCode.getHeight();
        this.bottom = this.getHeight() - this.btnCancel.getY() - this.btnCancel.getHeight();
        this.right = this.getWidth() - this.btnCancel.getX() - this.btnCancel.getWidth();
        this.mid = this.btnCancel.getX() - this.btnOK.getX() - this.btnOK.getWidth();
    }

    protected void frameResized(ComponentEvent e) {
        int txtJavaCodeWidth = this.getWidth() - (this.txtJavaCode.getX() * 2 + 5);
        int txtJavaCodeHeight = this.getHeight() - this.txtJavaCode.getY() - this.JavaCodeBottom;
        this.txtJavaCode.setSize(txtJavaCodeWidth, txtJavaCodeHeight);
        int x = this.getWidth() - this.right - this.btnCancel.getWidth();
        int y = this.getHeight() - this.bottom - this.btnCancel.getHeight();
        this.btnCancel.setLocation(x, y);
        x = x - this.btnOK.getWidth() - this.mid;
        this.btnOK.setLocation(x, y);
        x = x - this.btnValidation.getWidth() - this.mid;
        this.btnValidation.setLocation(x, y);
        this.paintComponents(this.getGraphics());
    }

    private JLabel getJLabel1() {
        if (this.jLabel1 == null) {
            this.jLabel1 = new JLabel();
            this.jLabel1.setText(RM.R("label.RoleDialog.label.returnType"));
            this.jLabel1.setBounds(12, 14, 81, 22);
        }
        return this.jLabel1;
    }

    private JLabel getJLabel2() {
        if (this.jLabel2 == null) {
            this.jLabel2 = new JLabel();
            this.jLabel2.setText(RM.R("label.RoleDialog.label.returnFields"));
            this.jLabel2.setBounds(312, 14, 79, 22);
        }
        return this.jLabel2;
    }

    private JComboBox getCbxReturnType() {
        if (this.cbxReturnType == null) {
            this.cbxReturnType = new JComboBox();
            this.cbxReturnType.addItem("simpleObj");
            this.cbxReturnType.addItem("complexObj");
            this.cbxReturnType.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    JavaEditorDialog.this.returnTypeBoxStateChanged(e);
                }
            });
            this.cbxReturnType.setBounds(105, 14, 130, 22);
        }
        return this.cbxReturnType;
    }

    protected void returnTypeBoxStateChanged(ItemEvent e) {
        String returnType = (String)this.getCbxReturnType().getSelectedItem();
        if ("simpleObj".equalsIgnoreCase(returnType)) {
            this.getTxtReturnFields().setEnabled(false);
        } else {
            this.getTxtReturnFields().setEnabled(true);
        }
    }

    private JTextField getTxtReturnFields() {
        if (this.txtReturnFields == null) {
            this.txtReturnFields = new JTextField();
            this.txtReturnFields.setBounds(409, 15, 208, 22);
            this.txtReturnFields.setEnabled(false);
        }
        return this.txtReturnFields;
    }

    private JEditTextArea getTxtJavaCode() {
        if (this.txtJavaCode == null) {
            this.txtJavaCode = new JEditTextArea();
            this.txtJavaCode.setTokenMarker((TokenMarker)new JavaTokenMarker());
            this.txtJavaCode.setBounds(12, 49, 606, 337);
        }
        return this.txtJavaCode;
    }

    private JButton getBtnOK() {
        if (this.btnOK == null) {
            this.btnOK = new JButton();
            this.btnOK.setText(RM.R("label.info.btnOK"));
            this.btnOK.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JavaEditorDialog.this.onOK();
                }
            });
            this.btnOK.setBounds(456, 400, 73, 22);
        }
        return this.btnOK;
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setText(RM.R("label.info.btnCancel"));
            this.btnCancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JavaEditorDialog.this.onCancel();
                }
            });
            this.btnCancel.setBounds(546, 400, 73, 22);
        }
        return this.btnCancel;
    }

    protected void onCancel() {
        this.dispose();
    }

    protected void onOK() {
        this.isOK = true;
        this.dispose();
    }

    private JButton getBtnValidation() {
        if (this.btnValidation == null) {
            this.btnValidation = new JButton();
            this.btnValidation.setText(RM.R("label.JavaEditorDialog.btn.validation"));
            this.btnValidation.setBounds(355, 400, 83, 22);
            this.btnValidation.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JavaEditorDialog.this.validateJavaCode();
                }
            });
        }
        return this.btnValidation;
    }

    public void validateJavaCode() {
        String javaSource = this.getJavaCode();
        DynamicCompiler dynamicCompiler = new DynamicCompiler();
        try {
            logger.debug((Object)("javaSource:" + javaSource));
            dynamicCompiler.validateJavaSource(javaSource);
            JOptionPane.showMessageDialog(this, "\u7f16\u8bd1\u6210\u529f!");
        }
        catch (BaseException e) {
            JOptionPane.showMessageDialog(this, e.getMessage());
            logger.error((Object)"\u52a8\u6001\u7f16\u8bd1Java\u4ee3\u7801\u51fa\u9519", (Throwable)e);
        }
    }

    public boolean isOK() {
        return this.isOK;
    }

    public void setOK(boolean isOK) {
        this.isOK = isOK;
    }

    private JButton getBtnHelp() {
        if (this.btnHelp == null) {
            this.btnHelp = new JButton();
            this.btnHelp.setText("Help");
            this.btnHelp.setBounds(261, 400, 75, 22);
            this.btnHelp.addActionListener(Helper.getInstance().getHelpListener());
        }
        return this.btnHelp;
    }
}

