/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.ui.role;

import com.testDataBuilder.config.TableConfig;
import com.testDataBuilder.config.TestDataConfig;
import com.testDataBuilder.core.Insert2Table;
import com.testDataBuilder.exception.JavaCodeRuntimeException;
import com.testDataBuilder.ui.main.queryConsole.QueryDialog;
import com.testDataBuilder.ui.role.RoleDialog;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

class ProgressRunner
implements Runnable {
    static Logger logger = Logger.getLogger(ProgressRunner.class);
    RoleDialog roleDialog = null;
    TestDataConfig testDataConfig = null;
    TableConfig tableConfig = null;

    public ProgressRunner(RoleDialog roleDialog, TestDataConfig testDataConfig, TableConfig tableConfig) {
        this.roleDialog = roleDialog;
        this.testDataConfig = testDataConfig;
        this.tableConfig = tableConfig;
    }

    public void run() {
        Connection defConn = null;
        TableConfig tableConfig = null;
        try {
            defConn = this.testDataConfig.getDefConnection();
            defConn.setAutoCommit(false);
            tableConfig = this.roleDialog.getCurRoleFactory().getTableConfig();
            if (tableConfig == null) {
                return;
            }
            try {
                Insert2Table insert2Table = new Insert2Table(tableConfig, this.testDataConfig);
                insert2Table.setProcessBar(this.roleDialog.getMsgLine());
                insert2Table.insert();
                String sql = "select * from " + tableConfig.getTableName();
                QueryDialog queryDialog = new QueryDialog(this.roleDialog);
                String defConnName = this.testDataConfig.getDefDatabaseConfig().getName();
                ArrayList<String> allConnNames = new ArrayList<String>(1);
                allConnNames.add(defConnName);
                queryDialog.initConnectionCombox(allConnNames, defConnName);
                queryDialog.setSQLString(sql);
                queryDialog.setQueryType("sqlquery");
                queryDialog.setModal(true);
                queryDialog.setVisible(true);
            }
            catch (JavaCodeRuntimeException ex) {
                logger.error((Object)"\u751f\u6210\u9884\u89c8\u65f6\u51fa\u73b0\u8fd0\u884c\u65f6\u5f02\u5e38.", (Throwable)ex);
            }
            catch (SQLException ex) {
                logger.error((Object)"\u751f\u6210\u9884\u89c8\u65f6\u51fa\u9519", (Throwable)ex);
            }
            catch (IOException ex) {
                logger.error((Object)"\u751f\u6210\u9884\u89c8\u65f6\u51fa\u73b0IO\u5f02\u5e38", (Throwable)ex);
            }
        }
        finally {
            this.roleDialog.getMsgLine().clearText();
            if (defConn != null) {
                try {
                    defConn.rollback();
                }
                catch (SQLException ex) {
                    logger.error((Object)"\u751f\u6210\u9884\u89c8\u56de\u6eda\u65f6\u51fa\u9519", (Throwable)ex);
                }
            }
        }
    }
}

