/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.ui.role;

import com.testDataBuilder.config.TableConfig;
import com.testDataBuilder.config.TestDataConfig;
import com.testDataBuilder.config.WorkspaceDataCache;
import com.testDataBuilder.core.baseType.JavaTypes;
import com.testDataBuilder.core.role.EnumList;
import com.testDataBuilder.core.role.EnumObj;
import com.testDataBuilder.core.role.JavaRole;
import com.testDataBuilder.core.role.JavaSource;
import com.testDataBuilder.core.role.Role;
import com.testDataBuilder.core.role.RoleFactory;
import com.testDataBuilder.dynamicCompile.DynamicCompiler;
import com.testDataBuilder.exception.BaseException;
import com.testDataBuilder.exception.CompileException;
import com.testDataBuilder.exception.ValidataException;
import com.testDataBuilder.resources.RM;
import com.testDataBuilder.ui.core.CenterDialog;
import com.testDataBuilder.ui.core.JTDButton;
import com.testDataBuilder.ui.core.JTextFieldEx;
import com.testDataBuilder.ui.core.ProgressLable;
import com.testDataBuilder.ui.help.Helper;
import com.testDataBuilder.ui.main.MainFrame;
import com.testDataBuilder.ui.main.queryConsole.ConnectionComboBox;
import com.testDataBuilder.ui.main.queryConsole.JEditTextArea;
import com.testDataBuilder.ui.main.queryConsole.QueryDialog;
import com.testDataBuilder.ui.preference.PreferenceDialog;
import com.testDataBuilder.ui.role.EnumValueDialog;
import com.testDataBuilder.ui.role.GetEnumValueFromFileOrDB;
import com.testDataBuilder.ui.role.JEnumTable;
import com.testDataBuilder.ui.role.JRoleMenuBar;
import com.testDataBuilder.ui.role.JRoleToolBar;
import com.testDataBuilder.ui.role.JRoleTree;
import com.testDataBuilder.ui.role.JavaEditorDialog;
import com.testDataBuilder.ui.role.JavaTypeComboBox;
import com.testDataBuilder.ui.role.ProgressRunner;
import com.testDataBuilder.util.Global;
import com.testDataBuilder.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.syntax.jedit.tokenmarker.JavaTokenMarker;
import org.syntax.jedit.tokenmarker.TSQLTokenMarker;
import org.syntax.jedit.tokenmarker.TokenMarker;

public class RoleDialog
extends CenterDialog {
    static Logger logger = Logger.getLogger(PreferenceDialog.class);
    private static final long serialVersionUID = 1L;
    private JSplitPane jSplitPane = null;
    private JPanel jContentPane = null;
    private JRoleToolBar jToolBar = null;
    private JScrollPane leftPane = null;
    private JPanel rightPanel = null;
    private JRoleTree roleTree = null;
    private JLabel jLabel = null;
    private JTextField txtName = null;
    private JLabel jLabel10;
    private JComboBox cbxReturnType;
    private JLabel jLabel1 = null;
    private JavaTypeComboBox cbxType = null;
    private JLabel jLabel2 = null;
    private JComboBox cbxMethod = null;
    private JLabel labMin = null;
    private JTextField txtMin = null;
    private JLabel labMax = null;
    private JTextField txtMax = null;
    private JLabel jLabel3 = null;
    private JScrollPane jEnumlPane = null;
    private JEnumTable jEnumTable = null;
    private JLabel jLabel4 = null;
    private JTextField txtPrefix = null;
    private JLabel jLabel5 = null;
    private JTextField txtSuffix = null;
    private JTDButton btnAddEnum = null;
    private JTDButton btnDelEnum = null;
    private JLabel jLabel6 = null;
    private JScrollPane jSQLPane = null;
    private JEditTextArea txtSQL = null;
    private JTDButton btnShowSQLQueryDialog = null;
    private JTDButton btnSave = null;
    private JTDButton btnOK = null;
    private JTDButton btnClose = null;
    private WorkspaceDataCache workspaceDataCache;
    Role curRole = null;
    RoleFactory curRoleFactory = null;
    protected Object cbxInva;
    private JButton btnEditInNewWindow;
    private JTextField txtReturnFields;
    private JLabel jLabel9;
    private JEditTextArea txtJavaSource;
    private JLabel jLabel7 = null;
    private ConnectionComboBox comboxConnection = null;
    private JTDButton btnSelEnum = null;
    private JLabel jLabel8 = null;
    private JPanel jJavaSourcePanel;
    private JTextField txtNullPercent = null;
    private JTabbedPane jMethodTabbedPane = null;
    private JPanel jIncRandomPanel = null;
    private JPanel jEnumPanel = null;
    private JPanel jSQLQueryPanel = null;
    private ProgressLable msgLine = null;

    public ProgressLable getMsgLine() {
        if (this.msgLine == null) {
            this.msgLine = new ProgressLable(" ");
        }
        return this.msgLine;
    }

    public RoleDialog(JFrame parent, WorkspaceDataCache workspaceDataCache) {
        super(parent);
        this.workspaceDataCache = workspaceDataCache;
        this.initialize();
        this.center();
        this.initControl();
    }

    public MainFrame getParent() {
        return (MainFrame)super.getParent();
    }

    private void initialize() {
        this.setSize(650, 500);
        this.setDefaultCloseOperation(2);
        this.setJMenuBar(new JRoleMenuBar(this));
        this.setContentPane(this.getJContentPane());
        this.setTitle(RM.R("label.RoleDialog.title"));
        this.enableControl(false);
        Helper.getInstance().enableHelpKey(this.getRootPane(), "detail.role.userRole");
    }

    public JRoleMenuBar getJMenuBar() {
        return (JRoleMenuBar)super.getJMenuBar();
    }

    private void initControl() {
        this.getRoleTree().setData(this.workspaceDataCache);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJSplitPane(), "Center");
            this.jContentPane.add((Component)this.getMsgLine(), "South");
        }
        return this.jContentPane;
    }

    private JRoleToolBar getJToolBar() {
        if (this.jToolBar == null) {
            this.jToolBar = new JRoleToolBar(this);
        }
        return this.jToolBar;
    }

    protected void showTablePopupMenu(Component invoker, int x, int y) {
        JPopupMenu pupupMenu = this.getJMenuBar().getTablePopupMenu();
        pupupMenu.show(invoker, x, y);
    }

    protected void deleteSelRole() {
        if (this.curRole != null) {
            try {
                int result = JOptionPane.showConfirmDialog(this, RM.R("label.RoleDialog.info.confirm.delete"));
                if (result == 0) {
                    this.getCurRoleFactory().deleteItem(this.curRole);
                    this.getRoleTree().updateUI();
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, String.valueOf(RM.R("label.RoleDialog.error.delete")) + e.getMessage());
            }
        }
    }

    protected void deleteAll() {
        int result = JOptionPane.showConfirmDialog(this, RM.R("label.RoleDialog.info.confirm.deleteAll"));
        if (result == 0) {
            try {
                this.getCurRoleFactory().deleteAll();
                this.getRoleTree().updateUI();
            }
            catch (Exception e1) {
                logger.error((Object)"deleteAll", (Throwable)e1);
                JOptionPane.showMessageDialog(this, String.valueOf(RM.R("label.RoleDialog.error.deleteAll")) + e1.getMessage());
            }
        }
    }

    public Role addRole(ActionEvent e) {
        if (!this.getRoleTree().isSelectionEmpty()) {
            Role role = this.getCurRoleFactory().addDefaultRole();
            this.getRoleTree().updateUI();
            this.getTxtName().grabFocus();
            int[] index = this.getRoleTree().getSelectionRows();
            if (index.length == 1) {
                int selRow = index[0] + this.getCurRoleFactory().getRoles().size();
                this.getRoleTree().setSelectionRow(selRow);
            } else {
                System.out.println("error sel much rows\u3002[" + index.length);
            }
            return role;
        }
        return null;
    }

    private JSplitPane getJSplitPane() {
        if (this.jSplitPane == null) {
            this.jSplitPane = new JSplitPane();
            this.jSplitPane.setDividerSize(3);
            this.jSplitPane.setLeftComponent(this.getLeftPane());
            this.jSplitPane.setRightComponent(this.getRightPanel());
            this.jSplitPane.setDividerLocation(180);
            this.jSplitPane.setResizeWeight(0.4);
        }
        return this.jSplitPane;
    }

    private JScrollPane getLeftPane() {
        if (this.leftPane == null) {
            this.leftPane = new JScrollPane();
            this.leftPane.setViewportView(this.getRoleTree());
        }
        return this.leftPane;
    }

    private JPanel getRightPanel() {
        if (this.rightPanel == null) {
            this.jLabel8 = new JLabel();
            this.jLabel8.setBounds(237, 54, 69, 23);
            this.jLabel8.setText(RM.R("label.RoleDialog.label.nullPercent"));
            this.jLabel7 = new JLabel();
            this.jLabel7.setText(RM.R("label.RoleDialog.label.useConnection"));
            this.jLabel7.setBounds(11, 7, 75, 24);
            this.jLabel6 = new JLabel();
            this.jLabel6.setText(RM.R("label.RoleDialog.label.sqlQuery"));
            this.jLabel6.setBounds(new Rectangle(670, 222, 60, 19));
            this.jLabel5 = new JLabel();
            this.jLabel5.setBounds(237, 87, 67, 25);
            this.jLabel5.setText(RM.R("label.RoleDialog.label.suffix"));
            this.jLabel4 = new JLabel();
            this.jLabel4.setBounds(23, 87, 64, 25);
            this.jLabel4.setText(RM.R("label.RoleDialog.label.prefix"));
            this.jLabel3 = new JLabel();
            this.jLabel3.setBounds(new Rectangle(673, 172, 60, 22));
            this.jLabel3.setText(RM.R("label.RoleDialog.label.enumValue"));
            this.labMax = new JLabel();
            this.labMax.setText(RM.R("label.RoleDialog.label.maxLength"));
            this.labMax.setBounds(67, 88, 69, 25);
            this.labMin = new JLabel();
            this.labMin.setText(RM.R("label.RoleDialog.label.minLength"));
            this.labMin.setBounds(68, 54, 69, 25);
            this.jLabel2 = new JLabel();
            this.jLabel2.setBounds(new Rectangle(24, 124, 63, 25));
            this.jLabel2.setText(RM.R("label.RoleDialog.label.generateMethod"));
            this.jLabel1 = new JLabel();
            this.jLabel1.setBounds(23, 55, 69, 23);
            this.jLabel1.setText(RM.R("label.RoleDialog.label.javaType"));
            this.jLabel = new JLabel();
            this.jLabel.setBounds(23, 16, 69, 25);
            this.jLabel.setText(RM.R("label.RoleDialog.label.genName"));
            this.rightPanel = new JPanel();
            this.rightPanel.setLayout(null);
            this.rightPanel.setPreferredSize(new Dimension(437, 442));
            this.rightPanel.add((Component)this.jLabel, null);
            this.rightPanel.add((Component)this.getTxtName(), null);
            this.rightPanel.add((Component)this.jLabel1, null);
            this.rightPanel.add((Component)this.getCbxType(), null);
            this.rightPanel.add((Component)this.jLabel2, null);
            this.rightPanel.add((Component)this.getCbxMethod(), null);
            this.rightPanel.add((Component)this.jLabel3, null);
            this.rightPanel.add((Component)this.jLabel4, null);
            this.rightPanel.add((Component)this.getTxtPrefix(), null);
            this.rightPanel.add((Component)this.jLabel5, null);
            this.rightPanel.add((Component)this.getTxtSuffix(), null);
            this.rightPanel.add((Component)this.getBtnSave(), null);
            this.rightPanel.add((Component)this.getBtnOK(), null);
            this.rightPanel.add((Component)this.getBtnClose(), null);
            this.rightPanel.add((Component)this.jLabel8, null);
            this.rightPanel.add((Component)this.getTxtNullPercent(), null);
            this.rightPanel.add((Component)this.getJMethodTabbedPane(), null);
            this.rightPanel.add((Component)this.jLabel6, null);
        }
        return this.rightPanel;
    }

    private JRoleTree getRoleTree() {
        if (this.roleTree == null) {
            this.roleTree = new JRoleTree();
            this.roleTree.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    RoleDialog.this.treeMouseClicked(e);
                }
            });
            this.roleTree.addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent arg0) {
                    RoleDialog.this.treeSelChange();
                }
            });
        }
        return this.roleTree;
    }

    protected void treeSelChange() {
        RoleFactory roleFactory;
        if (this.getRoleTree().getSelectionPath() == null) {
            return;
        }
        Object[] paths = this.getRoleTree().getSelectionPath().getPath();
        if (this.isSelRole(paths)) {
            Role dataGeneraor = (Role)paths[2];
            if (dataGeneraor != this.curRole) {
                this.curRole = dataGeneraor;
                this.synchorControl(this.curRole);
            }
        } else {
            this.curRole = null;
            this.synchorControl(this.curRole);
        }
        if (this.isSelTableAndRoles(paths) && (roleFactory = (RoleFactory)paths[1]) != this.curRoleFactory) {
            this.curRoleFactory = roleFactory;
        }
    }

    protected void treeMouseClicked(MouseEvent e) {
        JTree tree = (JTree)e.getComponent();
        TreePath treePath = null;
        if (e.getButton() == 3) {
            treePath = tree.getPathForLocation(e.getX(), e.getY());
            if (treePath == null) {
                return;
            }
            tree.setSelectionPath(treePath);
        }
        if ((treePath = tree.getSelectionPath()) == null) {
            return;
        }
        Object[] paths = treePath.getPath();
        if (e.getButton() == 3 && this.isSelTable(paths)) {
            this.showTablePopupMenu(e.getComponent(), e.getX(), e.getY());
        } else if (e.getButton() == 3 && this.isSelRole(paths)) {
            this.showRolePopupMenu(e.getComponent(), e.getX(), e.getY());
        }
    }

    private void showRolePopupMenu(Component component, int x, int y) {
        JPopupMenu rolePopupMenu = this.getJMenuBar().getRolePopupMenu();
        rolePopupMenu.show(component, x, y);
    }

    private boolean isSelTable(Object[] paths) {
        return paths != null && paths.length == 2;
    }

    private boolean isSelTableAndRoles(Object[] paths) {
        return paths != null && paths.length >= 2;
    }

    private boolean isSelRole(Object[] paths) {
        return paths != null && paths.length == 3;
    }

    protected void synchorControl(Role role) {
        this.dataExchange(role, true);
    }

    public void setSelectPath(Object ... selPath) {
        this.getRoleTree().setSelectPath(selPath);
    }

    private void enableControl(boolean enable) {
        this.getTxtName().setEnabled(enable);
        this.getCbxType().setEnabled(enable);
        this.getCbxMethod().setEnabled(enable);
        this.getTxtMin().setEnabled(enable);
        this.getTxtMax().setEnabled(enable);
        this.getTxtPrefix().setEnabled(enable);
        this.getTxtSuffix().setEnabled(enable);
        this.getJEnumTable().setEnabled(enable);
        this.getComboxConnection().setEnabled(enable);
        this.getTxtSQL().setEnabled(enable);
        this.getBtnSave().setEnabled(enable);
        this.getBtnOK().setEnabled(enable);
        this.getBtnAddEnum().setEnabled(enable);
        this.getBtnDelEnum().setEnabled(enable);
        this.getBtnShowSQLQueryDialog().setEnabled(enable);
        this.getBtnSelEnum().setEnabled(enable);
        this.getTxtNullPercent().setEnabled(enable);
        this.getCbxReturnType().setEnabled(enable);
        this.getTxtJavaSource().setEnabled(enable);
    }

    protected void dataExchange(Role role, boolean isToControl) {
        if (isToControl) {
            if (role != null) {
                this.enableControl(true);
                this.getTxtName().setText(role.getName());
                this.getCbxType().setSelectedItem(role.getType());
                this.getCbxMethod().setSelectedItem(role.getMethod());
                this.getTxtMin().setText(role.getStringMin());
                this.getTxtMax().setText(role.getStringMax());
                this.getTxtPrefix().setText(role.getPrefix());
                this.getTxtSuffix().setText(role.getSuffix());
                this.getTxtNullPercent().setText(String.valueOf(role.getNullPercent()));
                EnumList<EnumObj> tempEnumList = Role.cloneEnumList(role.getEnumerate());
                this.getJEnumTable().setData(tempEnumList);
                if (role.isSQLQueryMethod() || role.isSQLFuncMethod()) {
                    this.getTxtSQL().setText(role.getSQL());
                    if (StringUtils.isEmpty((String)role.getSourceName())) {
                        this.getComboxConnection().setSelectedIndex(0);
                    } else {
                        this.getComboxConnection().setSelectedItem(role.getSourceName());
                    }
                } else if (role.isJavaMethod()) {
                    this.getCbxReturnType().setSelectedItem(role.getJavaSource().getReturnType());
                    this.getTxtReturnFields().setText(role.getJavaSource().getReturnFields());
                    this.getTxtJavaSource().setText(role.getJavaSource().getJavaCode());
                    this.getTxtJavaSource().setFirstLine(14);
                }
            } else {
                this.getTxtName().setText("");
                this.getCbxType().setSelectedItem(1);
                this.getCbxMethod().setSelectedItem(1);
                this.getTxtNullPercent().setText("");
                this.getTxtMin().setText("");
                this.getTxtMax().setText("");
                this.getTxtPrefix().setText("");
                this.getTxtSuffix().setText("");
                this.getJEnumTable().setData(null);
                this.getTxtSQL().setText("");
                this.getCbxReturnType().setSelectedIndex(0);
                this.getTxtJavaSource().setText("");
                this.getTxtReturnFields().setText("");
                this.getComboxConnection().setSelectedIndex(0);
                this.enableControl(false);
            }
        } else {
            role.setName(this.getTxtName().getText().trim());
            String type = this.getCbxType().getSelectedItem().toString();
            Class javaType = this.getCbxType().getSelectedClass();
            role.setType(javaType);
            role.setNullPercent(Float.valueOf(this.getTxtNullPercent().getText().trim()).floatValue());
            role.setPrefix(this.getTxtPrefix().getText().trim());
            role.setSuffix(this.getTxtSuffix().getText().trim());
            String method = this.getCbxMethod().getSelectedItem().toString();
            role.setMethod(method);
            if ("increment".equalsIgnoreCase(method) || "random".equalsIgnoreCase(method)) {
                if (type.equalsIgnoreCase("DATE")) {
                    try {
                        role.setMaxDate(Global.getInstance().parseDateTime(this.getTxtMax().getText().trim()));
                    }
                    catch (BaseException e) {
                        logger.error((Object)"ConfigDatatype", (Throwable)e);
                    }
                    try {
                        role.setMinDate(Global.getInstance().parseDateTime(this.getTxtMin().getText().trim()));
                    }
                    catch (BaseException e) {
                        logger.error((Object)"ConfigDatatype", (Throwable)e);
                    }
                } else {
                    try {
                        double max = JavaTypes.getInstance().getDbValue(javaType, this.getTxtMax().getText().trim());
                        role.setMax(max);
                        double min = JavaTypes.getInstance().getDbValue(javaType, this.getTxtMin().getText().trim());
                        role.setMin(min);
                    }
                    catch (BaseException ex) {
                        logger.error((Object)"RoleDialog", (Throwable)ex);
                    }
                }
            } else if ("enum".equalsIgnoreCase(method)) {
                EnumList<EnumObj> tempEnumList = Role.cloneEnumList(this.getJEnumTable().getData());
                role.setEnumerate(tempEnumList);
            } else if ("sqlquery".equalsIgnoreCase(method) || "sqlfunc".equalsIgnoreCase(method)) {
                role.setSQL(this.getTxtSQL().getText().trim());
                role.setSourceName((String)this.getComboxConnection().getSelectedItem());
            } else if ("java".equals(method)) {
                try {
                    String returnType = (String)this.getCbxReturnType().getSelectedItem();
                    JavaSource javaSource = role.getJavaSource();
                    if (javaSource == null) {
                        javaSource = new JavaSource();
                        role.setJavaSource(javaSource);
                    }
                    javaSource.setReturnType(returnType);
                    if ("simpleObj".equalsIgnoreCase(returnType)) {
                        javaSource.setJavaCode(this.getTxtJavaSource().getText());
                    } else {
                        javaSource.setJavaCode(this.getTxtJavaSource().getText());
                        javaSource.setReturnFields(this.getTxtReturnFields().getText());
                    }
                }
                catch (BaseException ex) {
                    logger.error((Object)"setJavaCode", (Throwable)ex);
                }
            }
        }
    }

    private JTextField getTxtName() {
        if (this.txtName == null) {
            this.txtName = new JTextFieldEx();
            this.txtName.setBounds(98, 16, 340, 25);
        }
        return this.txtName;
    }

    private JavaTypeComboBox getCbxType() {
        if (this.cbxType == null) {
            List<Class> types = JavaTypes.getInstance().getAllTypes();
            this.cbxType = new JavaTypeComboBox(types);
            this.cbxType.setBounds(98, 53, 121, 27);
            this.cbxType.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    RoleDialog.this.typeChange();
                }
            });
            this.cbxType.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    RoleDialog.this.cbxInvasible();
                }

                public void popupMenuCanceled(PopupMenuEvent e) {
                }

                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }
            });
        }
        return this.cbxType;
    }

    protected void cbxInvasible() {
        Class type = this.getCbxType().getSelectedClass();
        double min = JavaTypes.getInstance().getMin(type, 0, 0);
        String strMin = JavaTypes.getInstance().getStringValue(type, min);
        double max = JavaTypes.getInstance().getMax(type, 0, 0);
        String strMax = JavaTypes.getInstance().getStringValue(type, max);
        this.getTxtMin().setText(strMin);
        this.getTxtMax().setText(strMax);
    }

    protected void typeChange() {
        Class type = this.getCbxType().getSelectedClass();
        if (type != null && type.equals(JavaTypes.STRING)) {
            this.labMax.setText(RM.R("label.RoleDialog.label.maxLength"));
            this.labMin.setText(RM.R("label.RoleDialog.label.minLength"));
        } else {
            this.labMax.setText(RM.R("label.RoleDialog.label.maxValue"));
            this.labMin.setText(RM.R("label.RoleDialog.label.minValue"));
        }
    }

    private JComboBox getCbxMethod() {
        if (this.cbxMethod == null) {
            this.cbxMethod = new JComboBox();
            this.cbxMethod.setBounds(99, 123, 120, 27);
            this.cbxMethod.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    RoleDialog.this.methodBoxStateChanged(e);
                }
            });
            this.cbxMethod.addItem("increment");
            this.cbxMethod.addItem("random");
            this.cbxMethod.addItem("enum");
            this.cbxMethod.addItem("sqlquery");
            this.cbxMethod.addItem("sqlfunc");
            this.cbxMethod.addItem("java");
        }
        return this.cbxMethod;
    }

    protected void methodBoxStateChanged(ItemEvent e) {
        String method = (String)this.getCbxMethod().getSelectedItem();
        int index = 0;
        if ("increment".equalsIgnoreCase(method) || "random".equalsIgnoreCase(method)) {
            index = 0;
        } else if ("enum".equalsIgnoreCase(method)) {
            index = 1;
        } else if ("sqlquery".equalsIgnoreCase(method) || "sqlfunc".equalsIgnoreCase(method)) {
            index = 2;
            this.getCbxType().setSelectedItem(JavaTypes.OBJECT);
        } else if ("java".equalsIgnoreCase(method)) {
            index = 3;
            this.getCbxType().setSelectedItem(JavaTypes.OBJECT);
            String javaSource = this.getTxtJavaSource().getText();
            if (StringUtils.isEmpty((String)javaSource)) {
                try {
                    javaSource = JavaRole.getJavaSourceTemplate();
                }
                catch (IOException ex) {
                    logger.error((Object)"methodBoxStateChanged", (Throwable)ex);
                }
                this.getTxtJavaSource().setText(javaSource);
            }
        }
        this.selectTab(index);
    }

    protected void selectTab(int index) {
        this.getJMethodTabbedPane().setSelectedIndex(index);
        int count = this.getJMethodTabbedPane().getTabCount();
        int i = 0;
        while (i < count) {
            boolean enable = i == index;
            this.getJMethodTabbedPane().setEnabledAt(i, enable);
            ++i;
        }
    }

    private JTextField getTxtMin() {
        if (this.txtMin == null) {
            this.txtMin = new JTextFieldEx();
            this.txtMin.setBounds(153, 54, 106, 25);
        }
        return this.txtMin;
    }

    private JTextField getTxtMax() {
        if (this.txtMax == null) {
            this.txtMax = new JTextFieldEx();
            this.txtMax.setBounds(153, 90, 106, 25);
        }
        return this.txtMax;
    }

    private JScrollPane getJEnumlPane() {
        if (this.jEnumlPane == null) {
            this.jEnumlPane = new JScrollPane();
            this.jEnumlPane.setBounds(12, 12, 323, 161);
            this.jEnumlPane.setViewportView(this.getJEnumTable());
        }
        return this.jEnumlPane;
    }

    private JEnumTable getJEnumTable() {
        if (this.jEnumTable == null) {
            this.jEnumTable = new JEnumTable();
            this.jEnumTable.setFont(new Font("Dialog", 1, 14));
            this.jEnumTable.setToolTipText(RM.R("label.RoleDialog.enumTable.alt"));
            this.jEnumTable.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        RoleDialog.this.editCurEnum();
                    }
                }
            });
        }
        return this.jEnumTable;
    }

    private JTextField getTxtPrefix() {
        if (this.txtPrefix == null) {
            this.txtPrefix = new JTextFieldEx();
            this.txtPrefix.setBounds(99, 87, 120, 27);
        }
        return this.txtPrefix;
    }

    private JTextField getTxtSuffix() {
        if (this.txtSuffix == null) {
            this.txtSuffix = new JTextFieldEx();
            this.txtSuffix.setBounds(312, 88, 126, 25);
        }
        return this.txtSuffix;
    }

    private JTDButton getBtnAddEnum() {
        if (this.btnAddEnum == null) {
            this.btnAddEnum = new JTDButton();
            this.btnAddEnum.setFont(new Font("Dialog", 1, 14));
            this.btnAddEnum.setBounds(353, 47, 44, 24);
            this.btnAddEnum.setText("+");
            this.btnAddEnum.setToolTipText(RM.R("label.RoleDialog.info.addEnum.alt"));
            this.btnAddEnum.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    RoleDialog.this.addEnum();
                }
            });
        }
        return this.btnAddEnum;
    }

    protected void addEnum() {
        this.addOrEditEnum(null);
    }

    protected void editCurEnum() {
        EnumObj enumObj = this.getJEnumTable().getSelEnumObj();
        this.addOrEditEnum(enumObj);
    }

    protected void addOrEditEnum(EnumObj enumObj) {
        EnumObj tempEnumObj = null;
        if (enumObj != null) {
            tempEnumObj = new EnumObj(enumObj);
        }
        EnumValueDialog enumValueDialog = new EnumValueDialog(this, tempEnumObj, this.getCbxType().getSelectedClass());
        enumValueDialog.setModal(true);
        enumValueDialog.setVisible(true);
        if (enumValueDialog.isOK()) {
            tempEnumObj = enumValueDialog.getEnumObj();
            if (enumObj == null) {
                if (this.getJEnumTable().getData().contains(tempEnumObj)) {
                    String info = String.format(RM.R("label.RoleDialog.error.enumNameExist"), tempEnumObj.toString());
                    JOptionPane.showMessageDialog(this, info, "\u8b66\u544a", 2);
                } else {
                    this.getJEnumTable().getData().add(tempEnumObj);
                    this.getJEnumTable().updateUI();
                }
            } else {
                enumObj.setValue(tempEnumObj.getValue());
                enumObj.setPercent(tempEnumObj.getPercent());
            }
        }
    }

    private JTDButton getBtnDelEnum() {
        if (this.btnDelEnum == null) {
            this.btnDelEnum = new JTDButton();
            this.btnDelEnum.setFont(new Font("Dialog", 1, 18));
            this.btnDelEnum.setBounds(353, 82, 44, 24);
            this.btnDelEnum.setText("-");
            this.btnDelEnum.setToolTipText(RM.R("label.RoleDialog.info.delEnum.alt"));
            this.btnDelEnum.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    RoleDialog.this.delEnum();
                }
            });
        }
        return this.btnDelEnum;
    }

    protected void delEnum() {
        int selRow = this.getJEnumTable().getSelectedRow();
        if (selRow == -1 || selRow >= this.getJEnumTable().getData().size()) {
            JOptionPane.showMessageDialog(this, RM.R("label.RoleDialog.error.noRowIsSelect"));
        } else {
            int returnV = JOptionPane.showConfirmDialog(this, RM.R("label.RoleDialog.info.confirmDeleteEnum"), "enum", 2);
            if (returnV == 0) {
                this.getJEnumTable().deleteCurrentItem();
            }
        }
    }

    private JScrollPane getJSQLPane() {
        if (this.jSQLPane == null) {
            this.jSQLPane = new JScrollPane();
            this.jSQLPane.setFont(new Font("Dialog", 0, 14));
            this.jSQLPane.setBounds(13, 42, 383, 131);
            this.jSQLPane.setViewportView((Component)((Object)this.getTxtSQL()));
        }
        return this.jSQLPane;
    }

    private JEditTextArea getTxtSQL() {
        if (this.txtSQL == null) {
            this.txtSQL = new JEditTextArea();
            this.txtSQL.setTokenMarker((TokenMarker)new TSQLTokenMarker());
            this.txtSQL.setToolTipText(RM.R("label.RoleDialog.info.txtSQl.alt"));
            this.txtSQL.setPreferredSize(new Dimension(344, 109));
        }
        return this.txtSQL;
    }

    private JTDButton getBtnShowSQLQueryDialog() {
        if (this.btnShowSQLQueryDialog == null) {
            this.btnShowSQLQueryDialog = new JTDButton();
            this.btnShowSQLQueryDialog.setText("...");
            this.btnShowSQLQueryDialog.setBounds(347, 7, 49, 24);
            this.btnShowSQLQueryDialog.setOpaque(false);
            this.btnShowSQLQueryDialog.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    RoleDialog.this.showEditSqlDialog();
                }
            });
        }
        return this.btnShowSQLQueryDialog;
    }

    protected void showEditSqlDialog() {
        QueryDialog sqlEditDialog = new QueryDialog(this);
        List<String> allConnNames = this.getParent().getTestDataConfig().getAllConnNames();
        sqlEditDialog.initConnectionCombox(allConnNames, this.getComboxConnection().getSelectedItem());
        sqlEditDialog.setSQLString(this.getTxtSQL().getText().trim());
        sqlEditDialog.setQueryType((String)this.getCbxMethod().getSelectedItem());
        sqlEditDialog.setModal(true);
        sqlEditDialog.setVisible(true);
        if (sqlEditDialog.isOK()) {
            this.getComboxConnection().setSelectedItem(sqlEditDialog.getSelConnName());
            this.getTxtSQL().setText(sqlEditDialog.getSQLString());
        }
    }

    private JTDButton getBtnSave() {
        if (this.btnSave == null) {
            this.btnSave = new JTDButton();
            this.btnSave.setBounds(202, 387, 69, 23);
            this.btnSave.setText(RM.R("label.info.btnSave"));
            this.btnSave.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    block2: {
                        try {
                            RoleDialog.this.saveConfig();
                        }
                        catch (ValidataException e1) {
                            JOptionPane.showMessageDialog(RoleDialog.this, String.valueOf(RM.R("label.RoleDialog.error.saveError")) + e1.getMessage());
                            e1.getControl().grabFocus();
                            if (!(e1.getControl() instanceof JTextComponent)) break block2;
                            JTextComponent txtControl = (JTextComponent)e1.getControl();
                            txtControl.selectAll();
                        }
                    }
                }
            });
        }
        return this.btnSave;
    }

    protected void saveConfig() throws ValidataException {
        if (this.curRole == null) {
            return;
        }
        this.validateControlValue();
        String oldName = this.curRole.getName();
        this.dataExchange(this.curRole, false);
        try {
            this.getCurRoleFactory().saveOrUpdateToFile(this.curRole, oldName);
            this.getRoleTree().updateUI();
            String newName = this.curRole.getName();
            if (!oldName.equals(newName)) {
                TableConfig tableConfig = this.getCurRoleFactory().getTableConfig();
                if (tableConfig != null) {
                    tableConfig.updateAllRefs(oldName, newName);
                    tableConfig.saveConfig();
                } else {
                    System.out.println("isGlobal..");
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"RoleFrame", (Throwable)e);
            JOptionPane.showMessageDialog(this, String.valueOf(RM.R("label.RoleDialog.error.saveConfigError")) + e.getMessage());
            return;
        }
    }

    private void validateControlValue() throws ValidataException {
        String oldName;
        String method;
        String name = this.txtName.getText();
        if (StringUtils.isEmpty((String)name)) {
            throw new ValidataException(this.txtName, RM.R("label.RoleDialog.error.validation.nameIsNull"));
        }
        Class type = this.getCbxType().getSelectedClass();
        String strNullPercent = this.txtNullPercent.getText().trim();
        if (StringUtils.isNotEmpty((String)strNullPercent)) {
            try {
                float v = Float.valueOf(strNullPercent).floatValue();
                if (v < 0.0f || v > 1.0f) {
                    throw new ValidataException(this.txtNullPercent, RM.R("label.RoleDialog.error.validation.percentValueInvalid"));
                }
            }
            catch (Exception ex) {
                throw new ValidataException(this.txtNullPercent, RM.R("label.RoleDialog.error.validation.percentValueInvalid"));
            }
        }
        if ("increment".equalsIgnoreCase(method = (String)this.getCbxMethod().getSelectedItem()) || "random".equalsIgnoreCase(method)) {
            if (type.equals(JavaTypes.OBJECT)) {
                throw new ValidataException(this.cbxType, RM.R("label.RoleDialog.error.validation.methodTypeNotMatch"));
            }
            String strMin = this.txtMin.getText().trim();
            String strMax = this.txtMax.getText().trim();
            if (StringUtils.isNotEmpty((String)strMin)) {
                try {
                    JavaTypes.getInstance().valueOf(type, strMin);
                }
                catch (Exception ex) {
                    throw new ValidataException(this.txtMin, ex.getMessage());
                }
            }
            if (StringUtils.isNotEmpty((String)strMax)) {
                try {
                    JavaTypes.getInstance().valueOf(type, strMax);
                }
                catch (Exception e) {
                    throw new ValidataException(this.txtMax, e.getMessage());
                }
            }
        } else if ("enum".equalsIgnoreCase(method)) {
            if (this.getJEnumTable().getData() == null || this.getJEnumTable().getData().isEmpty()) {
                throw new ValidataException(this.getJEnumTable(), RM.R("label.RoleDialog.error.validation.enumValueIsNull"));
            }
        } else if ("sqlquery".equalsIgnoreCase(method)) {
            String sql = this.getTxtSQL().getText();
            if (StringUtils.isEmpty((String)sql)) {
                throw new ValidataException((JComponent)((Object)this.txtSQL), RM.R("label.RoleDialog.error.validation.sqlIsNull"));
            }
        } else if ("java".equals(method)) {
            String returnFields;
            String returnType = (String)this.getCbxReturnType().getSelectedItem();
            if ("complexObj".equalsIgnoreCase(returnType) && StringUtils.isEmpty((String)(returnFields = this.getTxtReturnFields().getText()))) {
                throw new ValidataException(this.txtReturnFields, RM.R("label.RoleDialog.error.validation.returnFieldsIsNull"));
            }
            String javaSource = this.getTxtJavaSource().getText();
            if (StringUtils.isEmpty((String)javaSource)) {
                throw new ValidataException((JComponent)((Object)this.txtJavaSource), RM.R("label.RoleDialog.error.validation.javaSourceIsNull"));
            }
            if (this.curRole.getJavaSource() == null || !StringUtil.equals(javaSource, this.curRole.getJavaSource().getJavaCode())) {
                DynamicCompiler dynamicCompiler = new DynamicCompiler();
                try {
                    dynamicCompiler.validateJavaSource(javaSource);
                }
                catch (BaseException e) {
                    throw new CompileException((JComponent)((Object)this.txtJavaSource), e.getMessage());
                }
            }
        }
        if (!(oldName = this.curRole.getName()).equals(name) && this.getWorkspaceDataCache().getRole(this.curRoleFactory.toString(), name) != null) {
            throw new ValidataException(this.txtName, RM.R("label.RoleDialog.error.validation.nameExist"));
        }
    }

    public RoleFactory getCurRoleFactory() {
        return this.curRoleFactory;
    }

    private JTDButton getBtnOK() {
        if (this.btnOK == null) {
            this.btnOK = new JTDButton();
            this.btnOK.setBounds(288, 387, 69, 23);
            this.btnOK.setText(RM.R("label.info.btnOK"));
            this.btnOK.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        RoleDialog.this.saveConfig();
                    }
                    catch (ValidataException e1) {
                        JOptionPane.showMessageDialog(RoleDialog.this, e1.getMessage());
                        if (e1.getControl() instanceof JTextComponent) {
                            JTextComponent txtControl = (JTextComponent)e1.getControl();
                            txtControl.grabFocus();
                            txtControl.selectAll();
                        }
                        return;
                    }
                    RoleDialog.this.dispose();
                }
            });
        }
        return this.btnOK;
    }

    private JTDButton getBtnClose() {
        if (this.btnClose == null) {
            this.btnClose = new JTDButton();
            this.btnClose.setBounds(369, 387, 69, 23);
            this.btnClose.setText(RM.R("label.info.btnClose"));
            this.btnClose.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    RoleDialog.this.dispose();
                }
            });
        }
        return this.btnClose;
    }

    public WorkspaceDataCache getWorkspaceDataCache() {
        return this.workspaceDataCache;
    }

    public void setConfigDataCatch(WorkspaceDataCache workspaceDataCache) {
        this.workspaceDataCache = workspaceDataCache;
    }

    private ConnectionComboBox getComboxConnection() {
        if (this.comboxConnection == null) {
            this.comboxConnection = new ConnectionComboBox();
            this.comboxConnection.setBounds(98, 7, 213, 24);
            List<String> connNames = this.getParent().getTestDataConfig().getAllConnNames();
            this.comboxConnection.setConnNames(connNames);
        }
        return this.comboxConnection;
    }

    private JTDButton getBtnSelEnum() {
        if (this.btnSelEnum == null) {
            this.btnSelEnum = new JTDButton();
            this.btnSelEnum.setText("...");
            this.btnSelEnum.setBounds(353, 12, 44, 24);
            this.btnSelEnum.setToolTipText(RM.R("label.RoleDialog.info.enum.alt"));
            this.btnSelEnum.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    RoleDialog.this.getEnumFromFile();
                }
            });
        }
        return this.btnSelEnum;
    }

    protected void getEnumFromFile() {
        EnumList tempEnumList = new EnumList((Collection<? extends EnumObj>)((Collection<EnumObj>)Arrays.asList(new Object[this.getJEnumTable().getData().size()])));
        Collections.copy(tempEnumList, this.getJEnumTable().getData());
        GetEnumValueFromFileOrDB getEnumValueFromFileOrDB = new GetEnumValueFromFileOrDB((Dialog)this, tempEnumList);
        getEnumValueFromFileOrDB.setModal(true);
        getEnumValueFromFileOrDB.setVisible(true);
        if (getEnumValueFromFileOrDB.isOK()) {
            this.getJEnumTable().setData(getEnumValueFromFileOrDB.getEnumList());
        }
    }

    private JTextField getTxtNullPercent() {
        if (this.txtNullPercent == null) {
            this.txtNullPercent = new JTextFieldEx();
            this.txtNullPercent.setBounds(312, 54, 126, 25);
        }
        return this.txtNullPercent;
    }

    private JTabbedPane getJMethodTabbedPane() {
        if (this.jMethodTabbedPane == null) {
            this.jMethodTabbedPane = new JTabbedPane();
            this.jMethodTabbedPane.setBounds(25, 163, 413, 212);
            this.jMethodTabbedPane.addTab("increment&random", this.getJIncRandomPanel());
            this.jMethodTabbedPane.addTab("enum", this.getJEnumPanel());
            this.jMethodTabbedPane.addTab("sqlquery", this.getJSQLQueryPanel());
            this.jMethodTabbedPane.addTab("java", null, this.getJJavaSourcePanel(), null);
        }
        return this.jMethodTabbedPane;
    }

    private JPanel getJIncRandomPanel() {
        if (this.jIncRandomPanel == null) {
            this.jIncRandomPanel = new JPanel();
            this.jIncRandomPanel.setLayout(null);
            this.jIncRandomPanel.add((Component)this.labMin, null);
            this.jIncRandomPanel.add((Component)this.getTxtMin(), null);
            this.jIncRandomPanel.add((Component)this.labMax, null);
            this.jIncRandomPanel.add((Component)this.getTxtMax(), null);
        }
        return this.jIncRandomPanel;
    }

    private JPanel getJEnumPanel() {
        if (this.jEnumPanel == null) {
            this.jEnumPanel = new JPanel();
            this.jEnumPanel.setLayout(null);
            this.jEnumPanel.add((Component)this.getJEnumlPane(), null);
            this.jEnumPanel.add((Component)this.getBtnAddEnum(), null);
            this.jEnumPanel.add((Component)this.getBtnDelEnum(), null);
            this.jEnumPanel.add((Component)this.getBtnSelEnum(), null);
        }
        return this.jEnumPanel;
    }

    private JPanel getJSQLQueryPanel() {
        if (this.jSQLQueryPanel == null) {
            this.jSQLQueryPanel = new JPanel();
            this.jSQLQueryPanel.setLayout(null);
            this.jSQLQueryPanel.add((Component)this.jLabel7, null);
            this.jSQLQueryPanel.add((Component)this.getComboxConnection(), null);
            this.jSQLQueryPanel.add((Component)this.getBtnShowSQLQueryDialog(), null);
            this.jSQLQueryPanel.add((Component)this.getJSQLPane(), null);
        }
        return this.jSQLQueryPanel;
    }

    public void genToPreview() {
        TestDataConfig testDataConfig = WorkspaceDataCache.getInstance().getTestDataConfig();
        if (testDataConfig != null) {
            TableConfig tableConfig = this.getCurRoleFactory().getTableConfig();
            if (tableConfig != null) {
                new Thread(new ProgressRunner(this, testDataConfig, tableConfig)).start();
            }
        } else {
            JOptionPane.showMessageDialog(this, "\u51fa\u9519\u4e86..testDataBuilder\u4e3anull");
        }
    }

    private JPanel getJJavaSourcePanel() {
        if (this.jJavaSourcePanel == null) {
            this.jJavaSourcePanel = new JPanel();
            this.jJavaSourcePanel.setLayout(null);
            this.jJavaSourcePanel.setPreferredSize(new Dimension(372, 173));
            this.jJavaSourcePanel.add((Component)((Object)this.getTxtJavaSource()));
            this.jJavaSourcePanel.add(this.getJLabel9());
            this.jJavaSourcePanel.add(this.getTxtReturnFields());
            this.jJavaSourcePanel.add(this.getBtnEditInNewWindow());
            this.jJavaSourcePanel.add(this.getCbxReturnType());
            this.jJavaSourcePanel.add(this.getJLabel10());
        }
        return this.jJavaSourcePanel;
    }

    private JEditTextArea getTxtJavaSource() {
        if (this.txtJavaSource == null) {
            this.txtJavaSource = new JEditTextArea();
            this.txtJavaSource.setTokenMarker((TokenMarker)new JavaTokenMarker());
            this.txtJavaSource.setBounds(12, 63, 384, 110);
        }
        return this.txtJavaSource;
    }

    private JLabel getJLabel9() {
        if (this.jLabel9 == null) {
            this.jLabel9 = new JLabel();
            this.jLabel9.setText(RM.R("label.RoleDialog.label.returnFields"));
            this.jLabel9.setBounds(12, 34, 81, 22);
        }
        return this.jLabel9;
    }

    private JTextField getTxtReturnFields() {
        if (this.txtReturnFields == null) {
            this.txtReturnFields = new JTextField();
            this.txtReturnFields.setBounds(120, 35, 276, 22);
            this.txtReturnFields.setEnabled(false);
        }
        return this.txtReturnFields;
    }

    private JButton getBtnEditInNewWindow() {
        if (this.btnEditInNewWindow == null) {
            this.btnEditInNewWindow = new JButton();
            this.btnEditInNewWindow.setText("...");
            this.btnEditInNewWindow.setToolTipText(RM.R("label.RoleDialog.label.btnEditJavaInNewWindow"));
            this.btnEditInNewWindow.setBounds(289, 7, 107, 22);
            this.btnEditInNewWindow.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    RoleDialog.this.showJavaSourceEditor();
                }
            });
        }
        return this.btnEditInNewWindow;
    }

    protected void showJavaSourceEditor() {
        JavaEditorDialog editorDialog = new JavaEditorDialog(this);
        editorDialog.setReturnType(this.getCbxReturnType().getSelectedItem());
        editorDialog.setReturnFields(this.getTxtReturnFields().getText());
        editorDialog.setJavaCode(this.getTxtJavaSource().getText());
        editorDialog.setVisible(true);
        if (editorDialog.isOK()) {
            this.getCbxReturnType().setSelectedItem(editorDialog.getReturnType());
            this.getTxtReturnFields().setText(editorDialog.getReturnFields());
            this.getTxtJavaSource().setText(editorDialog.getJavaCode());
        }
    }

    private JComboBox getCbxReturnType() {
        if (this.cbxReturnType == null) {
            this.cbxReturnType = new JComboBox();
            this.cbxReturnType.addItem("simpleObj");
            this.cbxReturnType.addItem("complexObj");
            this.cbxReturnType.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    RoleDialog.this.returnTypeBoxStateChanged(e);
                }
            });
            this.cbxReturnType.setBounds(120, 7, 157, 22);
        }
        return this.cbxReturnType;
    }

    protected void returnTypeBoxStateChanged(ItemEvent e) {
        String returnType = (String)this.getCbxReturnType().getSelectedItem();
        if ("simpleObj".equalsIgnoreCase(returnType)) {
            this.getTxtReturnFields().setEnabled(false);
        } else {
            this.getTxtReturnFields().setEnabled(true);
        }
    }

    private JLabel getJLabel10() {
        if (this.jLabel10 == null) {
            this.jLabel10 = new JLabel();
            this.jLabel10.setText(RM.R("label.RoleDialog.label.returnType"));
            this.jLabel10.setBounds(12, 7, 81, 22);
        }
        return this.jLabel10;
    }
}

