/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.util;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.InvalidPropertiesFormatException;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.swing.UIManager;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppProperty
extends Properties {
    public static final String LOOK_AND_FEEL_JAVA_DEF = "javax.swing.plaf.metal.MetalLookAndFeel";
    public static final String LOOK_AND_FEEL_SYS_DEF = UIManager.getSystemLookAndFeelClassName();
    private static final String TDS_CONFIG = "tdsConfig.xml";
    public static final String RECENT_PROJECTS = "recentProjects";
    public static final String LAST_WORKSPACE = "lastWorkspace";
    public static final String LOOK_AND_FEEL = "lookAndFeel";
    public static final String LOCALE = "locale";
    public static final String SHOW_CONFIG_DIALOG = "showConfigDialog";
    private static AppProperty instance = null;
    boolean propertyChange = false;

    public static AppProperty getInstance() {
        if (instance == null) {
            instance = new AppProperty();
        }
        return instance;
    }

    private AppProperty() {
    }

    public AppProperty loadFromDefXmlFile() throws InvalidPropertiesFormatException, IOException {
        File file = new File(TDS_CONFIG);
        if (file.exists()) {
            this.loadFromXML(FileUtils.openInputStream((File)file));
        }
        return this;
    }

    public void storeToDefXmlFile() throws IOException {
        if (this.propertyChange) {
            this.propertyChange = false;
            File file = new File(TDS_CONFIG);
            this.storeToXML((OutputStream)FileUtils.openOutputStream((File)file), "TestDataBuilder.SysConfigFile", "utf-8");
        }
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        this.propertyChange = true;
        return super.put(key, value);
    }

    @Override
    public synchronized void putAll(Map<? extends Object, ? extends Object> t) {
        this.propertyChange = true;
        super.putAll(t);
    }

    @Override
    public synchronized Object remove(Object key) {
        this.propertyChange = true;
        return super.remove(key);
    }

    @Override
    public synchronized Object setProperty(String key, String value) {
        this.propertyChange = true;
        return super.setProperty(key, value);
    }

    public String getLastWorkspace() {
        return this.getProperty(LAST_WORKSPACE);
    }

    public void setLastWorkspace(String lastWorkspace) {
        this.setProperty(LAST_WORKSPACE, lastWorkspace);
    }

    public String getRecentProjects() {
        return this.getProperty(RECENT_PROJECTS);
    }

    public void setRecentProjects(String recentProjects) {
        this.setProperty(RECENT_PROJECTS, recentProjects);
    }

    public String getLookAndFeel() {
        String lookAndFeel = this.getProperty(LOOK_AND_FEEL);
        if (StringUtils.isEmpty((String)lookAndFeel)) {
            lookAndFeel = LOOK_AND_FEEL_JAVA_DEF;
        }
        return lookAndFeel;
    }

    public void setLookAndFeel(String lookAndFeel) {
        this.setProperty(LOOK_AND_FEEL, lookAndFeel);
    }

    public String getLocale() {
        String locale = this.getProperty(LOCALE);
        if (StringUtils.isEmpty((String)locale)) {
            locale = Locale.getDefault().toString();
            this.setLocale(locale);
        }
        return locale;
    }

    public void setLocale(String locale) {
        this.setProperty(LOCALE, locale);
    }

    public boolean getShowConfigDialog() {
        String strShowConfigDialog = this.getProperty(SHOW_CONFIG_DIALOG);
        return strShowConfigDialog == null || !strShowConfigDialog.equalsIgnoreCase("FALSE");
    }

    public void setShowConfigDialog(boolean showConfigDialog) {
        this.setProperty(SHOW_CONFIG_DIALOG, Boolean.toString(showConfigDialog));
    }
}

