/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.util;

import com.wutka.jox.JOXBeanInputStream;
import com.wutka.jox.JOXBeanOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class BeanXMLMapping {
    static Logger logger = Logger.getLogger(BeanXMLMapping.class);

    public static Object fromXML(String xml, Class className) throws IOException {
        ByteArrayInputStream xmlData = new ByteArrayInputStream(xml.getBytes("utf-8"));
        JOXBeanInputStream joxIn = new JOXBeanInputStream((InputStream)xmlData);
        try {
            Object object = joxIn.readObject(className);
            return object;
        }
        finally {
            try {
                xmlData.close();
                joxIn.close();
            }
            catch (Exception ex) {
                logger.error((Object)"BeanXMLMapping", (Throwable)ex);
            }
        }
    }

    public static String toXML(Object bean) throws IOException {
        ByteArrayOutputStream xmlData = new ByteArrayOutputStream();
        JOXBeanOutputStream joxOut = new JOXBeanOutputStream((OutputStream)xmlData, "utf-8");
        try {
            joxOut.writeObject(BeanXMLMapping.beanName(bean), bean);
            String string = xmlData.toString("utf-8");
            return string;
        }
        finally {
            try {
                xmlData.close();
                joxOut.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static String beanName(Object bean) {
        String fullClassName = bean.getClass().getName();
        String classNameTemp = fullClassName.substring(fullClassName.lastIndexOf(".") + 1, fullClassName.length());
        return String.valueOf(classNameTemp.substring(0, 1)) + classNameTemp.substring(1);
    }
}

