/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.util;

import com.testDataBuilder.config.preference.IPreference;
import com.testDataBuilder.config.preference.Preferences;
import com.testDataBuilder.core.baseType.JavaTypes;
import com.testDataBuilder.exception.BaseException;
import com.testDataBuilder.util.AppProperty;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class Global {
    static Logger logger = Logger.getLogger(Global.class);
    public static final String PROJECT_CONFIG = "project.xml";
    public static final String SEP = System.getProperty("file.separator");
    public static final String LINE_SEP = System.getProperty("line.separator");
    public SimpleDateFormat dataFormater = null;
    public IPreference P = null;
    public static final String ICON_TREE_DIR = "/resources/icon/tree/";
    private static Global instance = null;
    public static String APP_VERSION = "1.0";
    private AppProperty appProperties = AppProperty.getInstance();
    public static final String SYSTEM_PROPERTIES_COMMENT = "TestDataBuilder.\u914d\u7f6e\u6587\u4ef6";
    private String workspace = null;

    private Global() {
    }

    public void initlize() {
        String lastWorkspace = this.appProperties.getLastWorkspace();
        if (StringUtils.isNotEmpty((String)lastWorkspace)) {
            if (Global.isValidWorkspace(lastWorkspace)) {
                this.workspace = lastWorkspace;
            } else {
                this.saveLastWorkspace(null);
            }
        }
        File dir = null;
        if (StringUtils.isNotEmpty((String)this.getWorkspace())) {
            dir = new File(this.getWorkspace());
        }
        this.P = Preferences.getPreference(dir);
        this.dataFormater = new SimpleDateFormat(this.P.getDateFormat());
        this.initJavaTypes(this.P.getDataTypePluginDir());
    }

    public void initJavaTypes(String typeConfigDir) {
        JavaTypes.getInstance().init(typeConfigDir);
    }

    public Class loadTypeClass(String className) throws MalformedURLException, ClassNotFoundException {
        return JavaTypes.getInstance().loadTypeClass(className);
    }

    public static boolean isValidWorkspace(String workspaceDir) {
        File dir = new File(workspaceDir);
        if (dir.exists()) {
            File projectFile = new File(dir, PROJECT_CONFIG);
            return projectFile.exists();
        }
        return false;
    }

    public static synchronized Global getInstance() {
        if (instance == null) {
            instance = new Global();
        }
        return instance;
    }

    public String formatDateTime(Date date) {
        return this.dataFormater.format(date);
    }

    public Date parseDateTime(String strDatetime) throws BaseException {
        try {
            return new Date(this.dataFormater.parse(strDatetime).getTime());
        }
        catch (ParseException e) {
            throw new BaseException(e);
        }
    }

    public void updateRecentProjectList(String recentProjectsXml) {
        this.appProperties.setRecentProjects(recentProjectsXml);
        try {
            this.appProperties.storeToDefXmlFile();
        }
        catch (IOException e) {
            logger.error((Object)"addProject2RecentList", (Throwable)e);
        }
    }

    public void setLookAndFeel(String lookAndFeel) {
        this.appProperties.setLookAndFeel(lookAndFeel);
        try {
            this.appProperties.storeToDefXmlFile();
        }
        catch (IOException ex) {
            logger.error((Object)"setLookAndFeel", (Throwable)ex);
        }
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public void setWorkspaceLastWorkspace(String workspace) {
        this.setWorkspace(workspace);
        this.saveLastWorkspace(workspace);
    }

    public void saveLastWorkspace(String workspace) {
        if (StringUtils.isEmpty((String)workspace)) {
            this.appProperties.remove("lastWorkspace");
        } else {
            this.appProperties.setLastWorkspace(workspace);
        }
        try {
            this.appProperties.storeToDefXmlFile();
        }
        catch (IOException ex) {
            logger.error((Object)"saveLastWorkspace", (Throwable)ex);
        }
    }

    public String getProjectConfigFile() {
        return String.valueOf(this.getWorkspace()) + SEP + PROJECT_CONFIG;
    }

    public AppProperty getAppProperties() {
        return this.appProperties;
    }

    public void setAppProperties(AppProperty appProperties) {
        this.appProperties = appProperties;
    }
}

