/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.util;

import com.testDataBuilder.config.WorkspaceDataCache;
import com.testDataBuilder.dbMetaInfo.Table;
import com.testDataBuilder.util.StringUtil;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCUtil {
    private static final Logger logger = Logger.getLogger(JDBCUtil.class);
    private static Map<Integer, String> map = null;

    public static String getSQLStrType(int type) {
        String strType;
        if (map == null) {
            map = new HashMap<Integer, String>();
            map.put(-7, "bit");
            map.put(-6, "tinyint");
            map.put(5, "smallint");
            map.put(4, "int");
            map.put(-5, "bigint");
            map.put(6, "float");
            map.put(7, "real");
            map.put(8, "double");
            map.put(2, "numeric");
            map.put(3, "decimal");
            map.put(1, "char");
            map.put(12, "varchar");
            map.put(-1, "longVarcahr");
            map.put(91, "data");
            map.put(92, "time");
            map.put(93, "timestamp");
            map.put(-2, "binary");
            map.put(-3, "binary");
            map.put(-4, "binary");
            map.put(2004, "blob");
            map.put(2005, "clob");
            map.put(1111, "other");
        }
        if ((strType = map.get(type)) == null) {
            strType = "unknow[" + type + "]";
            logger.error((Object)("un mapped type[" + type));
        }
        return strType;
    }

    public static Class getJavaType(int sqlType, int columnSize, int decimalDigits) {
        Class rv = String.class;
        if (sqlType == 1 || sqlType == 12) {
            rv = String.class;
        } else if (sqlType == 6 || sqlType == 7) {
            rv = Float.class;
        } else if (sqlType == 4) {
            rv = Integer.class;
        } else if (sqlType == 8) {
            rv = Double.class;
        } else if (sqlType == 91) {
            rv = Date.class;
        } else if (sqlType == 93) {
            rv = Date.class;
        } else if (sqlType == 92) {
            rv = Date.class;
        } else if (sqlType == 5) {
            rv = Short.class;
        } else if (sqlType == -7) {
            rv = Boolean.class;
        } else if (sqlType == -5) {
            rv = Long.class;
        } else if (sqlType == 2 || sqlType == 3) {
            rv = decimalDigits == 0 ? (columnSize == 1 ? Byte.class : (columnSize < 5 ? Short.class : (columnSize < 10 ? Integer.class : Long.class))) : (columnSize < 9 ? Float.class : Double.class);
        }
        return rv;
    }

    public static List<String> getAllFields(String sql) {
        String strFields = StringUtil.subString(sql, "select", "from");
        ArrayList<String> allFields = new ArrayList<String>();
        if (StringUtils.isEmpty((String)strFields)) {
            logger.warn((Object)String.format("getAllFields.sql[%s] \u4e3a\u7a7a.", sql));
        } else if (strFields != null && strFields.contains("*")) {
            String tableName = StringUtil.subString(sql, "from\\s+", "\\s+");
            Table table = WorkspaceDataCache.getInstance().getDatabase().getTable(tableName);
            if (table != null) {
                allFields.addAll(table.getAllFields());
            } else {
                logger.error((Object)("SQL\u8bed\u53e5[" + sql + "]\u53ef\u80fd\u4e0d\u5408\u6cd5\uff0c\u672a\u627e\u5230\u8868[" + tableName + "]"));
            }
        } else {
            String[] arrFields;
            String[] stringArray = arrFields = strFields.trim().split(",");
            int n = arrFields.length;
            int n2 = 0;
            while (n2 < n) {
                String field = stringArray[n2];
                field = field.trim();
                int dotIndex = field.lastIndexOf(46);
                int spaceIndex = field.lastIndexOf(" ");
                if (spaceIndex == -1) {
                    spaceIndex = dotIndex;
                }
                field = field.substring(spaceIndex + 1);
                field = field.replace("'", "");
                allFields.add(field);
                ++n2;
            }
        }
        return allFields;
    }

    public static void main(String[] args) {
        String sql = "select _Application.id  , _Department.id as departmentId from Application as _Application,Department as _Department";
        List<String> fields = JDBCUtil.getAllFields(sql);
        for (String s : fields) {
            System.out.println(s);
        }
    }
}

