/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class RadixConverter {
    public static final int DWORD_BYTES = 4;
    int _radix;
    char[] _charMap;

    public RadixConverter(int radix, char[] charMap) throws Exception {
        if (radix < 2 || radix > charMap.length) {
            throw new Exception("Invalid Radix or Charmap");
        }
        this._radix = radix;
        this._charMap = charMap;
    }

    public RadixConverter(int radix, String strCharMap) throws Exception {
        if (radix < 2 || radix > strCharMap.length()) {
            throw new Exception("Invalid Radix or Charmap");
        }
        this._radix = radix;
        this._charMap = new char[radix];
        strCharMap.getChars(0, radix, this._charMap, 0);
    }

    public int getUnitStringLength() {
        long dwTemp = 0xFFFFFFFFL;
        long dwCharsPerUnit = 0L;
        while (dwTemp != 0L) {
            dwTemp /= (long)this._radix;
            ++dwCharsPerUnit;
        }
        return (int)dwCharsPerUnit;
    }

    public int getMaxRadixStringLength(int dwBytesLen) {
        int dwUnits = dwBytesLen / 4;
        return dwUnits * this.getUnitStringLength();
    }

    public String encodeDWORD(int dwValue) {
        int dwCharsPerUnit = this.getUnitStringLength();
        char[] szEncoded = new char[dwCharsPerUnit];
        long dwTmp = (long)dwValue & 0xFFFFFFFFL;
        int i = 0;
        while (i < szEncoded.length) {
            szEncoded[i] = this._charMap[0];
            ++i;
        }
        i = 0;
        while (i < dwCharsPerUnit) {
            long dwRemain = dwTmp % (long)this._radix;
            dwTmp /= (long)this._radix;
            szEncoded[dwCharsPerUnit - 1 - i] = this._charMap[(int)dwRemain];
            ++i;
        }
        return new String(szEncoded);
    }

    public String encodeHexBytes(byte[] hexBuf) {
        if (hexBuf == null) {
            return null;
        }
        int dwHexBufLen = hexBuf.length;
        StringBuffer sbEncoded = new StringBuffer();
        int dwCharsPerUnit = this.getMaxRadixStringLength(4);
        int dwOddBytes = dwHexBufLen % 4;
        if (dwOddBytes != 0) {
            return null;
        }
        int dwOffset = 0;
        while (dwOffset < dwHexBufLen) {
            long dwUnitValue = 0L;
            int i = 0;
            while (i < 4) {
                dwUnitValue = dwUnitValue * 256L + (long)(hexBuf[dwOffset++] & 0xFF);
                ++i;
            }
            sbEncoded.append(this.encodeDWORD((int)dwUnitValue));
        }
        return sbEncoded.toString();
    }

    public int findInCharMap(char ch) {
        int i = 0;
        while (i < this._charMap.length) {
            if (ch == this._charMap[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int decodeDWORD(String szEncoded) throws Exception {
        int dwMaxChars = this.getMaxRadixStringLength(4);
        long dwValue = 0L;
        int i = 0;
        while (i < dwMaxChars) {
            int pChPos = this.findInCharMap(szEncoded.charAt(i));
            if (pChPos == -1) {
                throw new Exception("Invalid Charset");
            }
            dwValue = dwValue * (long)this._radix + (long)pChPos;
            ++i;
        }
        return (int)dwValue;
    }

    public byte[] decodeHexBytes(String szEncoded) throws Exception {
        int dwCharsPerUnit;
        if (szEncoded == null) {
            return null;
        }
        int dwEncStrLen = szEncoded.length();
        int dwOddBytes = dwEncStrLen % (dwCharsPerUnit = this.getUnitStringLength());
        if (dwOddBytes != 0) {
            return null;
        }
        byte[] hexBuf = new byte[dwEncStrLen / dwCharsPerUnit * 4];
        char[] pbUnitBuf = new char[dwCharsPerUnit + 1];
        int dwEncStrOffset = dwOddBytes;
        int dwDecBytesOffset = 0;
        while (dwEncStrOffset < dwEncStrLen) {
            int dwUnitValue = 0;
            dwUnitValue = this.decodeDWORD(szEncoded.substring(dwEncStrOffset, dwEncStrOffset + dwCharsPerUnit));
            int i = 0;
            while (i < 4) {
                hexBuf[dwDecBytesOffset++] = (byte)(dwUnitValue >> (3 - i) * 8 & 0xFF);
                ++i;
            }
            dwEncStrOffset += dwCharsPerUnit;
        }
        return hexBuf;
    }

    public static byte[] intToByte(int n) {
        byte[] buf = new byte[4];
        int i = 0;
        while (i < buf.length) {
            buf[i] = i == 0 ? (byte)n : (byte)(n >> 8 * i);
            ++i;
        }
        return buf;
    }

    public static byte[] longToByte(long l) {
        byte[] buf = new byte[8];
        int i = 0;
        while (i < buf.length) {
            buf[i] = i == 0 ? (byte)l : (byte)(l >> 8 * i);
            ++i;
        }
        return buf;
    }

    public static int byteToInt(byte[] buf) {
        return ((buf[3] & 0xFF) << 24) + ((buf[2] & 0xFF) << 16) + ((buf[1] & 0xFF) << 8) + (buf[0] & 0xFF);
    }

    public static int byteToLong(byte[] buf) {
        return ((buf[7] & 0xFF) << 56) + ((buf[6] & 0xFF) << 48) + ((buf[5] & 0xFF) << 40) + ((buf[4] & 0xFF) << 32) + ((buf[3] & 0xFF) << 24) + ((buf[2] & 0xFF) << 16) + ((buf[1] & 0xFF) << 8) + (buf[0] & 0xFF);
    }

    public static Set toHashSet(List list) {
        HashSet hs = new HashSet();
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                hs.add(list.get(i));
                ++i;
            }
        }
        return hs;
    }

    public static List toList(Set set) {
        ArrayList list = new ArrayList();
        if (set != null) {
            Iterator it = set.iterator();
            while (it.hasNext()) {
                list.add(it.next());
            }
        }
        return list;
    }

    public static List toList(Collection coll) {
        ArrayList list = new ArrayList();
        if (coll != null) {
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                list.add(it.next());
            }
        }
        return list;
    }

    public static Boolean parseBoolean(Boolean value) {
        if (value == null || !value.booleanValue()) {
            return new Boolean(false);
        }
        return new Boolean(true);
    }

    public static long ipStrToLong(String ip) throws Exception {
        String[] num = ip.split("\\.");
        if (num.length != 4) {
            throw new Exception("Wrong number of octets");
        }
        long r = 0L;
        int i = 0;
        while (i < 4) {
            int t = Integer.parseInt(num[i]);
            if (t < 0 || t > 255) {
                throw new Exception("Range exceeded for octet at " + i);
            }
            r <<= 8;
            r |= (long)t;
            ++i;
        }
        return r;
    }

    public static String ipLongToStr(long ip) {
        StringBuffer b = new StringBuffer(15);
        b.append(Integer.toString((int)(ip >> 24 & 0xFFL)));
        b.append('.');
        b.append(Integer.toString((int)(ip >> 16 & 0xFFL)));
        b.append('.');
        b.append(Integer.toString((int)(ip >> 8 & 0xFFL)));
        b.append('.');
        b.append(Integer.toString((int)(ip & 0xFFL)));
        return b.toString();
    }

    public static String bytesToHexString(byte[] b) throws Exception {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < b.length) {
            int tmp = b[i] & 0xFF;
            String sTemp = Integer.toHexString(tmp);
            if (tmp < 16) {
                sTemp = "0" + sTemp;
            }
            sb.append(sTemp);
            ++i;
        }
        return sb.toString();
    }

    public static byte[] hexStringToBytes(String s) throws Exception {
        byte[] result = new byte[s.length() / 2];
        int i = 0;
        while (i < s.length() / 2) {
            result[i] = (byte)Integer.parseInt(s.substring(2 * i, 2 * i + 2), 16);
            ++i;
        }
        return result;
    }
}

