/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.dom4j.CDATA;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.SAXValidator;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.FlyweightCDATA;
import org.dom4j.util.XMLErrorHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class XmlFileUtil {
    static Logger logger = Logger.getLogger(XmlFileUtil.class);
    private String fileName;
    protected Document doc;

    public XmlFileUtil() {
        this.fileName = "config.xml";
    }

    public XmlFileUtil(String fileName) {
        this.fileName = fileName;
    }

    public XmlFileUtil(File file) {
        this.fileName = file.getAbsolutePath();
    }

    public void createFile(String content) throws SAXException, IOException {
        this.doc = XmlFileUtil.string2Document(content);
        this.saveDoc();
    }

    private Document getDoc() throws SAXException, IOException, DocumentException {
        if (this.doc == null) {
            this.openDoc();
        }
        return this.doc;
    }

    public Document getDoc(boolean validate, String xsdFile) throws SAXException, IOException, DocumentException {
        if (this.doc == null) {
            if (validate) {
                this.openDoc(xsdFile);
            } else {
                this.openDoc();
            }
        }
        return this.doc;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        if (fileName == null || fileName.equals("")) {
            throw new IllegalArgumentException("file name cannot be null.");
        }
        this.fileName = fileName;
        this.doc = null;
    }

    public Document openDoc() throws SAXException, IOException, DocumentException {
        SAXReader saxReader = new SAXReader();
        File file = new File(this.fileName);
        InputStreamReader read = null;
        try {
            read = new InputStreamReader((InputStream)new FileInputStream(file), "utf-8");
            this.doc = saxReader.read((Reader)read);
        }
        finally {
            if (read != null) {
                read.close();
                read = null;
            }
        }
        return this.doc;
    }

    public Document openDoc(String xsdFile) throws SAXException, IOException, DocumentException {
        SAXReader saxReader = new SAXReader();
        File file = new File(this.fileName);
        InputStreamReader read = new InputStreamReader((InputStream)new FileInputStream(file), "utf-8");
        saxReader.setValidation(true);
        saxReader.setFeature("http://xml.org/sax/features/validation", true);
        saxReader.setFeature("http://apache.org/xml/features/validation/schema", true);
        saxReader.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", (Object)xsdFile);
        this.doc = saxReader.read((Reader)read);
        XMLErrorHandler errorHandler = new XMLErrorHandler();
        SAXValidator validator = new SAXValidator();
        validator.setErrorHandler((ErrorHandler)errorHandler);
        validator.validate(this.doc);
        return this.doc;
    }

    public Document saveDoc() throws IOException, SAXException {
        File file = new File(this.getFileName());
        try {
            String tempXml = XmlFileUtil.formatXml(this.getDoc(), "utf-8");
            FileUtils.writeStringToFile((File)file, (String)tempXml, (String)"utf-8");
        }
        catch (DocumentException e) {
            logger.error((Object)"saveDoc", (Throwable)e);
        }
        return this.doc;
    }

    public static Document string2Document(String str) {
        Document doc = null;
        try {
            doc = new SAXReader().read((Reader)new StringReader(str));
        }
        catch (DocumentException e) {
            logger.error((Object)"string2Document", (Throwable)e);
            return null;
        }
        return doc;
    }

    public static Document inputStream2Document(InputStream is) {
        Document document = null;
        SAXReader saxReader = new SAXReader();
        try {
            InputStreamReader read = new InputStreamReader(is, "UTF-8");
            BufferedReader reader = new BufferedReader(read);
            document = saxReader.read((Reader)reader);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"XmlFileUtils", (Throwable)e);
        }
        catch (DocumentException e) {
            logger.error((Object)"XmlFileUtils", (Throwable)e);
        }
        return document;
    }

    public static String formatXml(Document doc, String encoding) {
        StringWriter writer = new StringWriter();
        OutputFormat format = OutputFormat.createPrettyPrint();
        if (encoding == null || encoding.equals("")) {
            format.setEncoding("utf-8");
        } else {
            format.setEncoding(encoding);
        }
        XMLWriter xmlwriter = new XMLWriter((Writer)writer, format);
        try {
            xmlwriter.write(doc);
        }
        catch (Exception e) {
            logger.error((Object)"XmlFileUtils", (Throwable)e);
        }
        return writer.toString();
    }

    public static String formatXml(Element ele, String encoding) {
        Document doc = DocumentHelper.createDocument();
        doc.setRootElement(ele);
        return XmlFileUtil.formatXml(doc, encoding);
    }

    public static String formatW3CXml(org.w3c.dom.Document doc, String encoding) {
        StringWriter writer = new StringWriter();
        OutputFormat format = OutputFormat.createPrettyPrint();
        if (encoding == null || encoding.equals("")) {
            format.setEncoding("utf-8");
        } else {
            format.setEncoding(encoding);
        }
        XMLWriter xmlwriter = new XMLWriter((Writer)writer, format);
        try {
            xmlwriter.write((Object)doc);
        }
        catch (Exception e) {
            logger.error((Object)"formatW3CXml", (Throwable)e);
        }
        return writer.toString();
    }

    public static String formatW3CXml(org.w3c.dom.Document doc) {
        return XmlFileUtil.formatW3CXml(doc, null);
    }

    public static String formatXml(String xml, String encoding) {
        Document doc = XmlFileUtil.string2Document(xml);
        if (doc != null) {
            return XmlFileUtil.formatXml(doc, encoding);
        }
        return xml;
    }

    public static String formatXml(String xml) {
        return XmlFileUtil.formatXml(xml, null);
    }

    public static Element string2Element(String xml) {
        return XmlFileUtil.string2Document(xml).getRootElement();
    }

    public static String stringToXml(String value) {
        if (value == null) {
            return null;
        }
        value = value.replaceAll("\n", "&#xA;");
        value = value.replaceAll("\r", "&#xD;");
        value = value.replaceAll("\t", "&#x9;");
        return value;
    }

    public static String xmlToString(String xml) {
        if (xml == null) {
            return xml;
        }
        xml = xml.replaceAll("&#xA;", "\n");
        xml = xml.replaceAll("&#xD;", "\r");
        xml = xml.replaceAll("&#x9;", "\t");
        return xml;
    }

    public static void main(String[] args) throws SAXException, IOException, DocumentException {
        File file = new File("E:\\a.xml");
        XmlFileUtil xmlFile = new XmlFileUtil(file);
        Element root = xmlFile.getDoc().getRootElement();
        Element roleEle = root.element("role");
        String text = roleEle.getText();
        text = String.valueOf(text) + "\r\n" + System.currentTimeMillis();
        FlyweightCDATA cdata = new FlyweightCDATA(text);
        roleEle.clearContent();
        roleEle.add((CDATA)cdata);
        root.add((CDATA)cdata);
        xmlFile.saveDoc();
        System.out.println(text);
    }

    private static Document openDoc1() throws SAXException, IOException, DocumentException {
        XmlFileUtil xml = new XmlFileUtil("D:\\a.xml");
        return xml.getDoc();
    }

    private static Document openDoc2() throws SAXException, IOException, DocumentException {
        String content = FileUtils.readFileToString((File)new File("D:\\a.xml"));
        return XmlFileUtil.string2Document(content);
    }
}

