/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.util.pkg;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.InvalidPropertiesFormatException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarBuilder {
    public String workspaceDir = System.getProperty("user.dir");
    public static final String SEP = System.getProperty("file.separator");
    public final String META_INF = "META-INF";
    public final String MANIFEST_FILE_NAME = "MANIFEST.MF";
    public final String LINE_SEP = System.getProperty("line.separator");
    public static final String TEMP_CONFIG = "JarBuilder.config.xml";
    String baseDir = null;
    String destDir = null;
    String version = null;
    String mainClass = null;
    String jarName = null;
    public static final String BASE_DIR = "baseDir";
    public static final String VERSION = "version";
    public static final String MAIN_CLASS = "mainClass";
    public static final String JAR_NAME = "jarName";
    public static final String DEST_DIR = "destDir";
    private static List<String> excludeDirs = null;
    static BufferedReader read = new BufferedReader(new InputStreamReader(System.in));

    public void saveConfig(Properties properties, File configFile) {
        if (properties != null && properties.size() > 0) {
            try {
                properties.storeToXML(new FileOutputStream(configFile), "");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Properties loadFromConfig(File file) {
        Properties properties = new Properties();
        try {
            properties.loadFromXML(new FileInputStream(file));
        }
        catch (InvalidPropertiesFormatException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return properties;
    }

    public static void main(String[] args) throws IOException {
        JarBuilder jarBuilder = new JarBuilder();
        jarBuilder.build();
    }

    public static List<String> getExcludeDirs() {
        if (excludeDirs == null) {
            excludeDirs = new ArrayList<String>();
            excludeDirs.add("helpdoc");
            excludeDirs.add("language");
        }
        return excludeDirs;
    }

    public static void makeJar(File directory, File zipFile, Manifest manifest) throws FileNotFoundException {
        block14: {
            DeflaterOutputStream jos = null;
            try {
                try {
                    jos = new JarOutputStream((OutputStream)new FileOutputStream(zipFile), manifest);
                    String[] fileNames = directory.list();
                    if (fileNames != null) {
                        int i = 0;
                        while (i < fileNames.length) {
                            JarBuilder.recurseFiles(new File(directory, fileNames[i]), (JarOutputStream)jos, "");
                            ++i;
                        }
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    if (jos == null) break block14;
                    try {
                        jos.flush();
                        ((ZipOutputStream)jos).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (jos != null) {
                    try {
                        jos.flush();
                        ((ZipOutputStream)jos).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private static void recurseFiles(File file, JarOutputStream jos, String pathName) throws IOException, FileNotFoundException {
        if (file.isDirectory()) {
            if (!JarBuilder.getExcludeDirs().contains(file.getName())) {
                pathName = String.valueOf(pathName) + file.getName() + "/";
                jos.putNextEntry(new JarEntry(pathName));
                String[] fileNames = file.list();
                if (fileNames != null) {
                    int i = 0;
                    while (i < fileNames.length) {
                        JarBuilder.recurseFiles(new File(file, fileNames[i]), jos, pathName);
                        ++i;
                    }
                }
                jos.closeEntry();
            }
        } else if (JarBuilder.isNotJarFile(file)) {
            JarEntry jarEntry = new JarEntry(String.valueOf(pathName) + file.getName());
            System.out.println(String.valueOf(pathName) + file.getName());
            FileInputStream fin = new FileInputStream(file);
            BufferedInputStream in = new BufferedInputStream(fin);
            jos.putNextEntry(jarEntry);
            int len = -1;
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) >= 0) {
                jos.write(buf, 0, len);
            }
            in.close();
            jos.closeEntry();
        }
    }

    public void build() throws IOException {
        File tempConfig = new File(TEMP_CONFIG);
        boolean useConfig = false;
        if (tempConfig.exists()) {
            Properties properties = this.loadFromConfig(tempConfig);
            this.baseDir = properties.getProperty(BASE_DIR);
            this.destDir = properties.getProperty(DEST_DIR);
            this.version = properties.getProperty(VERSION);
            this.mainClass = properties.getProperty(MAIN_CLASS);
            this.jarName = properties.getProperty(JAR_NAME);
            System.out.println("the last configure is:");
            System.out.println("    baseDir: " + this.baseDir);
            System.out.println("    destDir: " + this.destDir);
            System.out.println("    version: " + this.version);
            System.out.println("  MainClass: " + this.mainClass);
            System.out.println("    jarName: " + this.jarName);
            System.out.println("=======================================");
            String result = JarBuilder.getInput("use the last configure file to run\uff1f(Y/N)");
            if (result != null && result.equalsIgnoreCase("Y")) {
                useConfig = true;
            }
        }
        if (!useConfig) {
            String curDir = System.getProperty("user.dir");
            this.baseDir = JarBuilder.getInput("please input the basic directory(default is :" + curDir + ")" + this.LINE_SEP + " :");
            if (this.baseDir == null || this.baseDir.equals("")) {
                this.baseDir = curDir;
            }
            this.destDir = JarBuilder.getInput("please input the dest directory(default is :" + this.baseDir + ")" + this.LINE_SEP);
            if (this.destDir == null || this.destDir.equals("")) {
                this.destDir = this.baseDir;
            }
            this.version = JarBuilder.getInput("please input the jar version(default is 1.0):");
            if (this.version == null || this.version.equals("")) {
                this.version = "1.0";
            }
            this.mainClass = JarBuilder.getInput("please input the main class(full name):");
            String className = this.mainClass.substring(this.mainClass.lastIndexOf(".") + 1);
            this.jarName = JarBuilder.getInput("please input the jar package name(default is " + className + ".jar):");
            if (this.jarName == null || this.jarName.equals("")) {
                this.jarName = String.valueOf(className) + ".jar";
            }
            if (!this.jarName.endsWith(".jar")) {
                this.jarName = String.valueOf(this.jarName) + ".jar";
            }
            Properties pros = new Properties();
            pros.setProperty(BASE_DIR, this.baseDir);
            pros.setProperty(DEST_DIR, this.destDir);
            pros.setProperty(VERSION, this.version);
            pros.setProperty(MAIN_CLASS, this.mainClass);
            pros.setProperty(JAR_NAME, this.jarName);
            this.saveConfig(pros, tempConfig);
        }
        this.autoBuildByConfigFile(tempConfig, false);
    }

    public void autoBuildByConfigFile(File configFile, boolean showLog) throws FileNotFoundException, IOException {
        Properties properties = this.loadFromConfig(configFile);
        this.baseDir = properties.getProperty(BASE_DIR);
        this.destDir = properties.getProperty(DEST_DIR);
        this.version = properties.getProperty(VERSION);
        this.mainClass = properties.getProperty(MAIN_CLASS);
        this.jarName = properties.getProperty(JAR_NAME);
        this.autoBuildByParam(this.baseDir, this.destDir, this.version, this.mainClass, this.jarName, showLog);
    }

    public void autoBuildByParam(String baseDir, String destDir, String version, String mainClass, String jarName, boolean showLog) throws FileNotFoundException, IOException {
        if (showLog) {
            System.out.println("========================= config=========================");
            System.out.println("    baseDir: " + baseDir);
            System.out.println("    destDir: " + destDir);
            System.out.println("    version: " + version);
            System.out.println("  MainClass: " + mainClass);
            System.out.println("    jarName: " + jarName);
            System.out.println("========================= end =========================");
        }
        String fileName = this.getManifestFile(baseDir, version, mainClass, jarName);
        Manifest manifest = new Manifest(new FileInputStream(fileName));
        File jarFile = new File(destDir, jarName);
        JarBuilder.makeJar(new File(baseDir), jarFile, manifest);
        System.out.println("jar file store in directory:" + jarFile.getAbsolutePath());
    }

    protected void finalize() throws Throwable {
        JarBuilder.deleteDirectory(new File(this.baseDir, "META-INF"));
        super.finalize();
    }

    public String getManifestFile(String baseDir, String version, String mainClass, String excludeJar) {
        if (version == null || version.equals("")) {
            version = "1.0";
        }
        StringBuffer buffer = new StringBuffer("Manifest-Version: " + version + this.LINE_SEP);
        LinkedList<String> jarFiles = new LinkedList<String>();
        this.getJarFiles(new File(baseDir), jarFiles, baseDir);
        if (jarFiles.size() > 0) {
            buffer.append("Class-Path: " + this.LINE_SEP);
            for (String jarName : jarFiles) {
                if (jarName.equalsIgnoreCase(excludeJar)) continue;
                buffer.append(" " + jarName + "  " + this.LINE_SEP);
            }
        }
        buffer.append("Main-Class: " + mainClass + this.LINE_SEP);
        try {
            File parentDir = new File(String.valueOf(baseDir) + SEP + "META-INF");
            if (!parentDir.exists()) {
                parentDir.mkdir();
            }
            return JarBuilder.saveFile(new File(parentDir, "MANIFEST.MF"), buffer.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<String> getJarFiles(File baseDir, List<String> jarFiles, String strBaseDir) {
        if (baseDir.isDirectory()) {
            File[] files;
            File[] fileArray = files = baseDir.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    this.getJarFiles(file, jarFiles, strBaseDir);
                } else if (JarBuilder.isJarFile(file)) {
                    System.out.println("jar:" + file.getAbsolutePath());
                    jarFiles.add(file.getAbsolutePath().replace(String.valueOf(strBaseDir) + SEP, ""));
                }
                ++n2;
            }
        }
        return jarFiles;
    }

    private static String getInput(String prompt) {
        System.out.print(prompt);
        String retValue = null;
        try {
            retValue = read.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return retValue;
    }

    public static String saveFile(File file, String content) throws Exception {
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        bw.write(content);
        bw.flush();
        bw.close();
        return file.getAbsolutePath();
    }

    public static void deleteDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        JarBuilder.cleanDirectory(directory);
        if (!directory.delete()) {
            String message = "Unable to delete directory " + directory + ".";
            throw new IOException(message);
        }
    }

    public static void cleanDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        File[] files = directory.listFiles();
        if (files == null) {
            throw new IOException("Failed to list contents of " + directory);
        }
        IOException exception = null;
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            try {
                JarBuilder.forceDelete(file);
            }
            catch (IOException ioe) {
                exception = ioe;
            }
            ++i;
        }
        if (exception != null) {
            throw exception;
        }
    }

    public static void forceDelete(File file) throws IOException {
        if (file.isDirectory()) {
            JarBuilder.deleteDirectory(file);
        } else {
            if (!file.exists()) {
                throw new FileNotFoundException("File does not exist: " + file);
            }
            if (!file.delete()) {
                String message = "Unable to delete file: " + file;
                throw new IOException(message);
            }
        }
    }

    public static boolean isNotJarFile(File file) {
        String fileName = file.getName();
        return !fileName.endsWith(".jar") && !fileName.endsWith("MANIFEST.MF") && !fileName.endsWith("META-INF");
    }

    public static boolean isJarFile(File file) {
        String fileName = file.getName();
        return fileName.endsWith("jar") || fileName.endsWith("zip");
    }
}

