/*
 * Decompiled with CFR 0.152.
 */
package com.testDataBuilder.util.pkg;

import com.testDataBuilder.util.pkg.JarBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedList;
import org.apache.commons.io.FileUtils;

public class TDBPackager {
    public String workspaceDir = System.getProperty("user.dir");
    String baseDir = String.valueOf(this.workspaceDir) + FILE_SEP + "bin";
    String version = "1.0";
    String mainClass = "TestDataBuilder";
    String jarName = "TestDataBuilder.jar";
    public static final String FILE_SEP = System.getProperty("file.separator");
    static BufferedReader read = new BufferedReader(new InputStreamReader(System.in));

    public static void main(String[] args) throws IOException {
        TDBPackager tdbPackager = new TDBPackager();
        tdbPackager.build();
    }

    public void build() throws FileNotFoundException, IOException {
        JarBuilder jarBuilder = new JarBuilder();
        jarBuilder.autoBuildByParam(this.baseDir, this.baseDir, this.version, this.mainClass, this.jarName, true);
        String curDir = System.getProperty("user.dir");
        String fromDir = String.valueOf(curDir) + "/bin";
        String toDir = curDir;
        String releaseDir = String.valueOf(toDir) + FILE_SEP + "TestDataBuilder";
        LinkedList<String> copyDirectorys = new LinkedList<String>();
        LinkedList<String> copyFiles = new LinkedList<String>();
        copyDirectorys.add("lib");
        copyDirectorys.add("res");
        copyDirectorys.add("projects");
        copyFiles.add("run.bat");
        copyFiles.add("TestDataBuilder.jar");
        File relDir = new File(releaseDir);
        if (relDir.exists()) {
            JarBuilder.forceDelete(relDir);
        }
        for (String dir : copyDirectorys) {
            FileUtils.copyDirectory((File)new File(fromDir, dir), (File)new File(releaseDir, dir));
        }
        for (String file : copyFiles) {
            FileUtils.copyFile((File)new File(fromDir, file), (File)new File(releaseDir, file));
        }
        System.out.println("package all file to " + toDir);
    }

    private static String getInput(String prompt) {
        System.out.print(prompt);
        try {
            return read.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

