/*
 * Decompiled with CFR 0.152.
 */
package resources.datatype;

import com.testDataBuilder.core.baseType.TypeAdapter;
import com.testDataBuilder.exception.InvalidIPValueException;
import com.testDataBuilder.util.RandomUtil;
import org.apache.log4j.Logger;

public class IP
extends TypeAdapter {
    static Logger logger = Logger.getLogger(IP.class);
    private String value = "127.0.0.1";
    public static final long MAX_VALUE = 0xFFFFFFFFL;
    public static final long MIN_VALUE = 0L;

    public IP() {
    }

    public IP(String strIP) throws InvalidIPValueException {
        this.setValue(strIP);
    }

    public IP(long value) throws InvalidIPValueException {
        this.setValue(value);
    }

    public static void main(String[] args) throws InvalidIPValueException {
        System.out.println(new IP("255.255.255.255").toLong());
    }

    public boolean checkValue(String value) throws InvalidIPValueException {
        try {
            int i = Integer.valueOf(value);
            return i >= 0 && i < 256;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void checkIP(String strIP) throws InvalidIPValueException {
        if (strIP == null || strIP.equals("")) {
            throw new InvalidIPValueException(strIP);
        }
        String[] ips = strIP.split("\\.");
        if (ips.length != 4) {
            throw new InvalidIPValueException(strIP);
        }
        int i = 0;
        while (i < ips.length) {
            if (!this.checkValue(ips[i])) {
                throw new InvalidIPValueException(strIP);
            }
            ++i;
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) throws InvalidIPValueException {
        this.checkIP(value);
        this.value = value;
    }

    public void setValue(long lip) throws InvalidIPValueException {
        int[] ips = new int[]{(int)(lip >> 24) & 0xFF, (int)(lip >> 16) & 0xFF, (int)(lip >> 8) & 0xFF, (int)(lip & 0xFFL)};
        StringBuffer sbIP = new StringBuffer();
        sbIP.append(ips[0]);
        sbIP.append("." + ips[1]);
        sbIP.append("." + ips[2]);
        sbIP.append("." + ips[3]);
        this.setValue(sbIP.toString());
    }

    public long toLong() {
        long value = 0L;
        String ipv = this.getValue();
        String[] ips = ipv.split("\\.");
        int i = 0;
        while (i < ips.length) {
            int temp = Integer.valueOf(ips[i]);
            value += (long)temp << (3 - i) * 8;
            ++i;
        }
        return value;
    }

    public static IP randomIP() throws InvalidIPValueException {
        return IP.randomIP(0L, 0xFFFFFFFFL);
    }

    public static IP randomIP(long min, long max) throws InvalidIPValueException {
        long value = (long)((double)min + Math.random() * (double)(max - min));
        return new IP(value);
    }

    public static IP randomIP(String strMin, String strMax) throws InvalidIPValueException {
        long min = new IP(strMin).toLong();
        long max = new IP(strMax).toLong();
        return IP.randomIP(min, max);
    }

    public String toString() {
        if (this.getValue() != null) {
            return this.getValue().toString();
        }
        return null;
    }

    public String dbToString(double dbValue) {
        try {
            return new IP((long)dbValue).toString();
        }
        catch (InvalidIPValueException e) {
            logger.error((Object)"TIP", (Throwable)e);
            return null;
        }
    }

    public double getMax() {
        return 4.294967295E9;
    }

    public double getMin() {
        return 0.0;
    }

    public String getName() {
        return "IP";
    }

    public String randomValue(double min, double max) {
        double dbRandom = RandomUtil.randomDouble(min, max);
        try {
            return new IP((long)dbRandom).toString();
        }
        catch (InvalidIPValueException e) {
            logger.error((Object)"TIP", (Throwable)e);
            return null;
        }
    }

    public double stringTodb(String value) throws InvalidIPValueException {
        return this.valueOf(value).toLong();
    }

    public IP valueOf(String value) throws InvalidIPValueException {
        return new IP(value);
    }
}

