/*
 * Decompiled with CFR 0.152.
 */
package resources.datatype.address;

import com.testDataBuilder.core.baseType.IType;
import com.testDataBuilder.core.baseType.TypeAdapter;
import com.testDataBuilder.exception.BaseException;
import com.testDataBuilder.util.BeanXMLMapping;
import com.testDataBuilder.util.RandomUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.log4j.Logger;
import resources.datatype.address.CityList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChinaAddress
extends TypeAdapter {
    static Logger logger = Logger.getLogger(ChinaAddress.class);
    private List<CityList> stateList = new ArrayList<CityList>(30);
    private int length = 0;

    @Override
    public Object randomValue(double min, double max) {
        return this.randomStateCity();
    }

    @Override
    public IType init(String basePath) throws BaseException {
        InputStream is = null;
        try {
            try {
                is = this.getClass().getResourceAsStream("city.xml");
                String xml = IOUtils.toString((InputStream)is);
                this.setStateList(ChinaAddress.fromXml(xml).getStateList());
            }
            catch (IOException e) {
                throw new BaseException(e);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                    is = null;
                }
                catch (IOException e) {
                    logger.error((Object)"ChinaAddress", (Throwable)e);
                }
            }
        }
        return this;
    }

    public String toXmlString() throws IOException {
        return BeanXMLMapping.toXML(this);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }

    public CityList get(String state) {
        CityList citys = null;
        for (CityList tempCityList : this.stateList) {
            if (!tempCityList.getState().equalsIgnoreCase(state)) continue;
            citys = tempCityList;
        }
        if (citys == null) {
            citys = new CityList();
            citys.setState(state);
            this.stateList.add(citys);
        }
        return citys;
    }

    public boolean addCity(String state, String city) {
        CityList citys = this.get(state);
        if (!citys.getCitys().contains(city)) {
            citys.getCitys().add(city);
            return true;
        }
        return false;
    }

    public void showInfo() {
        int i = 0;
        while (i < this.stateList.size()) {
            CityList citys = this.stateList.get(i);
            System.out.println("================= " + citys.getState() + "=====================");
            for (String city : citys.getCitys()) {
                System.out.println("    " + city);
            }
            System.out.println();
            ++i;
        }
    }

    public static ChinaAddress fromXml(String xml) throws IOException {
        return (ChinaAddress)BeanXMLMapping.fromXML(xml, ChinaAddress.class);
    }

    public static void main(String[] args) throws Exception {
        ChinaAddress addressMap = new ChinaAddress();
        addressMap.init(null);
        int i = 0;
        while (i < 100) {
            String address = addressMap.randomStateCity();
            System.out.println(address);
            ++i;
        }
    }

    public List<CityList> getStateList() {
        return this.stateList;
    }

    public void setStateList(List<CityList> stateList) {
        this.stateList = stateList;
    }

    public CityList randomState() {
        if (this.length == 0) {
            this.length = this.stateList.size();
        }
        int index = RandomUtil.randomInt(0, this.length - 1);
        return this.stateList.get(index);
    }

    public String randomStateCity() {
        return this.randomState().randomStateCity();
    }
}

