from mathutils import Vector
import numpy as np
import numbers
import math
from .routine import evaluateCurve


#-------------------------------- Interpolation stufs -------------------------------------
ow, sin, cos, pi, sqrt, asin  = math.pow, math.sin, math.cos, math.pi, math.sqrt, math.asin

# t is the current time (or position) of the tween. This can be seconds or frames, steps, seconds, ms, whatever – as long as the unit is the same as is used for the total time [3].
# b is the beginning value of the property.
# c is the change between the beginning and destination value of the property.
# d is the total time of the tween.

def linear(t, b, c, d):
  return c * t / d + b


def customCurve(t, b, c, d):
  return linear(t, b, c, d)


def inCubic(t, b, c, d):
    t = t / d
    return c * pow(t, 3) + b

def outCubic(t, b, c, d):
    t = t / d - 1
    return c * (pow(t, 3) + 1) + b

def inOutCubic(t, b, c, d):
    t = t / d * 2
    if t < 1 :
        return c / 2 * t * t * t + b
    else:
        t = t - 2
        return c / 2 * (t * t * t + 2) + b

def outInCubic(t, b, c, d):
    if t < d / 2 :
        return outCubic(t * 2, b, c / 2, d)
    else:
        return inCubic((t * 2) - d, b + c / 2, c / 2, d)

def inQuart(t, b, c, d):
    t = t / d
    return c * pow(t, 4) + b

def outQuart(t, b, c, d):
    t = t / d - 1
    return -c * (pow(t, 4) - 1) + b

def inOutQuart(t, b, c, d):
    t = t / d * 2
    if t < 1 :
        return c / 2 * pow(t, 4) + b
    else:
        t = t - 2
        return -c / 2 * (pow(t, 4) - 2) + b

def outInQuart(t, b, c, d):
    if t < d / 2 :
        return outQuart(t * 2, b, c / 2, d)
    else:
        return inQuart((t * 2) - d, b + c / 2, c / 2, d)

def inQuint(t, b, c, d):
    t = t / d
    return c * pow(t, 5) + b

def outQuint(t, b, c, d):
    t = t / d - 1
    return c * (pow(t, 5) + 1) + b

def inOutQuint(t, b, c, d):
    t = t / d * 2
    if t < 1 :
        return c / 2 * pow(t, 5) + b
    else:
        t = t - 2
        return c / 2 * (pow(t, 5) + 2) + b

def outInQuint(t, b, c, d):
    if t < d / 2 :
        return outQuint(t * 2, b, c / 2, d)
    else:
        return inQuint((t * 2) - d, b + c / 2, c / 2, d)

def inSine(t, b, c, d):
    return -c * cos(t / d * (pi / 2)) + c + b     

def outSine(t, b, c, d):
    return c * sin(t / d * (pi / 2)) + b

def inOutSine(t, b, c, d):
    return -c / 2 * (cos(pi * t / d) - 1) + b

def outInSine(t, b, c, d):
    if t < d / 2 :
        return outSine(t * 2, b, c / 2, d)
    else:
        return inSine((t * 2) -d, b + c / 2, c / 2, d)

def inExpo(t, b, c, d):
    if t == 0 :
        return b
    else:
        return c * pow(2, 10 * (t / d - 1)) + b - c * 0.001

def outExpo(t, b, c, d):
    if t == d :
        return b + c
    else:
        return c * 1.001 * (-pow(2, -10 * t / d) + 1) + b

def inOutExpo(t, b, c, d):
    if t == 0 : return b 
    if t == d : return b + c 
    t = t / d * 2
    if t < 1 :
        return c / 2 * pow(2, 10 * (t - 1)) + b - c * 0.0005
    else:
        t = t - 1
        return c / 2 * 1.0005 * (-pow(2, -10 * t) + 2) + b

def outInExpo(t, b, c, d):
    if t < d / 2 :
        return outExpo(t * 2, b, c / 2, d)
    else:
        return inExpo((t * 2) - d, b + c / 2, c / 2, d)


def inCirc(t, b, c, d):
    t = t / d
    return -c * (sqrt(1 - t*t) - 1) + b

def outCirc(t, b, c, d):
    t = t / d - 1
    return c * sqrt(1 - t*t) + b

def inOutCirc(t, b, c, d):
    t = t / d * 2
    if t < 1 :
        return -c / 2 * (sqrt(1 - t * t) - 1) + b
    else:
        t = t - 2
        return c / 2 * (sqrt(1 - t * t) + 1) + b

def outInCirc(t, b, c, d):
    if t < d / 2 :
        return outCirc(t * 2, b, c / 2, d)
    else:
        return inCirc((t * 2) - d, b + c / 2, c / 2, d)


def inElastic(t, b, c, d): 
    s=1.70158
    p=0
    a=c
    if(t==0):
        return b
    t = t/d
    if (t==1):
        return b+c
    p=d*.3;
    a=c
    s=p/4
    t = t-1
    return -(a*math.pow(2,10*(t)) * math.sin( (t*d-s)*(2*math.pi)/p )) + b;


def outElastic(t, b, c, d):
    if (t==0) :
        return b; 
    t=t/d 
    if (t==1):
        return b+c;  
    p=d*.3;
    a=c; 
    s=p/4;
    return (a*pow(2,-10*t) * math.sin( (t*d-s)*(2*math.pi)/p ) + c + b);


def inOutElastic(t, b, c, d):
    if (t==0):
        return b;
    t=t/(d/2)
    if (t==2):
        return b+c; 
    p=d*(.3*1.5);
    a=c; 
    s=p/4;
     
    if (t < 1):
        t=t-1
        postFix =a*pow(2,10*(t)); # postIncrement is evil
        return -.5*(postFix* math.sin( (t*d-s)*(2*math.pi)/p )) + b;
    t=t-1
    postFix =  a*pow(2,-10*(t)); # postIncrement is evil
    return postFix * math.sin( (t*d-s)*(2*math.pi)/p )*.5 + c + b;



def inBack(t, b, c, d, s):
    if not s : s = 1.70158 
    t = t / d
    return c * t * t * ((s + 1) * t - s) + b

def outBack(t, b, c, d, s):
    if not s : s = 1.70158 
    t = t / d - 1
    pro = np.add(c * (t * t * ((s + 1) * t + s) + 1), b)
    if isinstance(pro, numbers.Number):
        return pro
    return Vector(pro)

def inOutBack(t, b, c, d, s):
    if not s : s = 1.70158 
    s = s * 1.525
    t = t / d * 2
    if t < 1 :
        return c / 2 * (t * t * ((s + 1) * t - s)) + b
    else:
        t = t - 2
        return c / 2 * (t * t * ((s + 1) * t + s) + 2) + b

def outInBack(t, b, c, d, s):
    if t < d / 2 :
        return outBack(t * 2, b, c / 2, d, s)
    else:
        return inBack((t * 2) - d, b + c / 2, c / 2, d, s)

def outBounce(t, b, c, d, VN):
    t = t / d
    if t < 1 / 2.75:
        return Vector(np.add(c * (7.5625 * t * t), b))
    elif t < 2 / 2.75  :
        t = t - (1.5 / 2.75)
        return Vector(np.add(c * (7.5625 * t * t + 0.75), b))
    elif t < 2.5 / 2.75 :
        t = t - (2.25 / 2.75)
        return Vector(np.add(c * (7.5625 * t * t + 0.9375), b))
    else:
        t = t - (2.625 / 2.75)
        return Vector(np.add(c * (7.5625 * t * t + 0.984375), b))

def inBounce(t, b, c, d, VN):
  return c - Vector(np.add(outBounce(d - t, VN, c, d, VN) , b))

def inOutBounce(t, b, c, d, VN):
    if t < d / 2:
        return inBounce(t * 2, VN, c, d, VN) * 0.5 + b
    else:
        return outBounce(t * 2 - d, VN, c, d, VN) * 0.5 + c * .5 + b

def outInBounce(t, b, c, d, VN):
    if t < d / 2:
        return outBounce(t * 2, b, c / 2, d, VN)
    else:
        return inBounce((t * 2) - d, b + c / 2, c / 2, d, VN)


def MatchInterpo(inter, v):
    # v = [t0, b1, c2, d3, s4, VN5 ]

    if inter in ["linear", "customCurve"]:
        return linear(v[0], v[1], v[2], v[3])

    if inter == "inCubic":
        return inCubic(v[0], v[1], v[2], v[3])

    if inter == "outCubic":
        return outCubic(v[0], v[1], v[2], v[3])

    if inter == "inOutCubic":
        return inOutCubic(v[0], v[1], v[2], v[3])

    if inter == "outInCubic":
        return outInCubic(v[0], v[1], v[2], v[3])

    if inter == "inQuart":
        return inQuart(v[0], v[1], v[2], v[3])

    if inter == "outQuart":
        return outQuart(v[0], v[1], v[2], v[3])

    if inter == "inOutQuart":
        return inOutQuart(v[0], v[1], v[2], v[3])

    if inter == "outInQuart":
        return outInQuart(v[0], v[1], v[2], v[3])

    if inter == "inQuint":
        return inQuint(v[0], v[1], v[2], v[3])

    if inter == "outQuint":
        return outQuint(v[0], v[1], v[2], v[3])

    if inter == "inOutQuint":
        return inOutQuint(v[0], v[1], v[2], v[3])

    if inter == "outInQuint":
        return outInQuint(v[0], v[1], v[2], v[3])

    if inter == "inSine":
        return inSine(v[0], v[1], v[2], v[3])

    if inter == "outSine":
        return outSine(v[0], v[1], v[2], v[3])

    if inter == "inOutSine":
        return inOutSine(v[0], v[1], v[2], v[3])

    if inter == "outInSine":
        return outInSine(v[0], v[1], v[2], v[3])

    if inter == "inExpo":
        return inExpo(v[0], v[1], v[2], v[3])

    if inter == "outExpo":
        return outExpo(v[0], v[1], v[2], v[3])

    if inter == "inOutExpo":
        return inOutExpo(v[0], v[1], v[2], v[3])

    if inter == "outInExpo":
        return outInExpo(v[0], v[1], v[2], v[3])

    if inter == "inCirc":
        return inCirc(v[0], v[1], v[2], v[3])

    if inter == "outCirc":
        return outCirc(v[0], v[1], v[2], v[3])

    if inter == "inOutCirc":
        return inOutCirc(v[0], v[1], v[2], v[3])

    if inter == "outInCirc":
        return outInCirc(v[0], v[1], v[2], v[3])

    if inter == "inElastic":
        return inElastic(v[0], v[1], v[2], v[3])

    if inter == "outElastic":
        return outElastic(v[0], v[1], v[2], v[3])

    if inter == "inOutElastic":
        return inOutElastic(v[0], v[1], v[2], v[3])

    # if inter == "outInElastic":
    #     return outInElastic(v[0], v[1], v[2], v[3])

    if inter == "inBack":
        return inBack(v[0], v[1], v[2], v[3], v[4])

    if inter == "outBack":
        return outBack(v[0], v[1], v[2], v[3], v[4])

    if inter == "inOutBack":
        return inOutBack(v[0], v[1], v[2], v[3], v[4])

    if inter == "outInBack":
        return outInBack(v[0], v[1], v[2], v[3], v[4])

    if inter == "outBounce":
        return outBounce(v[0], v[1], v[2], v[3], v[5])

    if inter == "inBounce":
        return inBounce(v[0], v[1], v[2], v[3], v[5])

    if inter == "inOutBounce":
        return inOutBounce(v[0], v[1], v[2], v[3], v[5])

    if inter == "outInBounce":
        return outInBounce(v[0], v[1], v[2], v[3], v[5])

    # default
    return linear(v[0], v[1], v[2], v[3])

