from bpy.types import PropertyGroup
from bpy.props import (EnumProperty,
                       PointerProperty,
                       StringProperty,)
import bpy
import random

from .routine import Collection_objs
from .routine import interpolatoinCurve
from .routine import make_collection
from .routine import getCharSett
from .routine import getSettings
from .routine import shaderPart


def kernSelection(self, context):
    op = getSettings()
    if op:
        for c in Collection_objs(op.id_data, "chars", False):
            c.hide_select = not op.char_hide_selection


def filtre(CH=""):#filtre par chaine Loc, Rot, Scal, Vide ?
    chan = bpy.data.window_managers["WinMan"].tx_menu

    # Default chanel
    Location = ["start_at", "ofs", "duration", "full_txt", "charS_ob_nm", "interpolation", "back", "rand_loc",
                "vis_on", "wiggle_OnLoc", "wiggle_TVL", "wiggle_OnLoc_lock", 
                "aft_loc", "curve_interp_l", "curve_interp_l_value", "sinWave_onLoc", "sinWave_Loc"]

    targetCh = lambda mu,ch,t: mu if not bool(ch) else ch==t

    if targetCh(chan.TXLoc, CH, "TXLoc"):
        return Location
    if targetCh(chan.TXRot, CH, "TXRot"):
        return ["rot_start_at", "rot_ofs", "rot_duration", "full_txt", "charS_ob_nm", "rot_interpolation", 
                "rot_back", "rand_rot", "vis_on", "wiggle_OnRot", "wiggle_TVR", "wiggle_OnRot_lock", 
                "aft_rot", "curve_interp_r", "curve_interp_r_value", "sinWave_onRot", "sinWave_Rot"]
    if targetCh(chan.TXScl, CH, "TXScl"):
        return ["scl_start_at", "scl_ofs", "scl_duration", "full_txt", "charS_ob_nm", "scl_interpolation", 
                "scl_back", "rand_scl", "vis_on", "wiggle_OnScl", "wiggle_TVS", "wiggle_OnScl_lock", 
                "aft_scl", "curve_interp_s", "curve_interp_s_value", "sinWave_onScl", "sinWave_Scl"]
    if targetCh(chan.TXVid, CH, "TXVid"):
        return ["visibility_at", "visibility_of", "visibility_dt", "full_txt", "charS_ob_nm", "vis_interpolation", 
                "vis_back", "rand_vis", "vis_on", "wiggle_OnVis", "wiggle_TVV", "wiggle_OnVis_lock", 
                                                    # NO wiggle_OnVis, wiggle_TVV, wiggle_OnVis_lock
                "vis_on", "curve_interp_v", "curve_interp_v_value", "sinWave_onVis", "sinWave_Vis"]
    else:
        bpy.data.window_managers["WinMan"].tx_menu.TXLoc = True
        return Location


def Tx_BuildSettings(aimeName, full_txt):
    # Générer Group option par obj
    C = bpy.context
    scene = C.scene

    mainColl = make_collection(aimeName,C.scene.collection)
    options = mainColl.ik_TextFx.add()
    
    options.full_txt = full_txt
    
    return options, mainColl



def Interpolation_Fade(self, context):
    """Interpolation from menu and asign to text animation"""
    if not bpy.context.scene.Pxy_uiUpdating:
        op = getSettings(check=False)
        op.fading = self.ik_txt_fading
        matComp = shaderPart(op)
        if (matComp["shader"] is not None) and (matComp["fading"] is not None):
            matComp["mat"].node_tree.links.new(matComp["shader"].inputs["Alpha"], matComp["fading"].outputs[self.ik_txt_fading])


def randomizeCol(self, context):
    matComp = shaderPart(self)
    if self.rand_col:
        if (matComp["shader"] is not None) and (matComp["fading"] is not None):
            matComp["mat"].node_tree.links.new(matComp["shader"].inputs["Base Color"], matComp["randcolor"].outputs[0])
    else:
        # remove only the desired link
        if matComp["shader"] is not None:
            if len(matComp["shader"].inputs["Base Color"].links):
                l = matComp["shader"].inputs["Base Color"].links[0]
                matComp["mat"].node_tree.links.remove(l)
                matComp["mat"].node_tree.update_tag()



class text_options(bpy.types.PropertyGroup):
   
    #Randozer fonction for Loc, Scal, Rot, visibility
    def randL( self, context ):
        if not self.preset_updating:
            l = eval(self.rand_loc_val)
            random.shuffle( l )
            self.rand_loc_val =  str(l)

    def randR( self, context ):
        if not self.preset_updating:
            l = eval(self.rand_rot_val)
            random.shuffle( l )
            self.rand_rot_val =  str(l)

    def randS( self, context ):
        if not self.preset_updating:
            l = eval(self.rand_scl_val)
            random.shuffle( l )
            self.rand_scl_val =  str(l)

    def randV( self, context ):
        if not self.preset_updating:
            l = eval(self.rand_vis_val)
            random.shuffle( l )
            self.rand_vis_val =  str(l)

    def setCurveAx(self, context):
        if not self.types == "CURVE": return

        ax = ['UP_Z','UP_Y'][int(self.curve_ax)]
        if not self.preset_updating:

            for idx,sett in enumerate(eval(self.paires)):
                sett, master, txtAppearance, loc_obj = getCharSett(self, idx=idx)

                sett[0].constraints["tx_pose"].up_axis = ax
                txtAppearance.constraints["tx_pose"].up_axis = ax


    def updateFramepose(self, context):
        """update proxy/frame/apearance/text pose on the curve"""
        if not self.types == "CURVE": return
        if not self.preset_updating:
            sett, master, txtAppearance, loc_obj = getCharSett(self, idx=0)
            txtAppearance.constraints["tx_pose"].offset_factor = self.center_font


    def customCurve_l(self, context):
        interpolatoinCurve(self.name+"_"+"curve_interp_l")


    def customCurve_r(self, context):
        interpolatoinCurve(self.name+"_"+"curve_interp_r")


    def customCurve_s(self, context):
        interpolatoinCurve(self.name+"_"+"curve_interp_s")


    def customCurve_v(self, context):
        interpolatoinCurve(self.name+"_"+"curve_interp_v")


    def updateGeoOffset(self, context):
        coll = self.id_data

        for c in Collection_objs(coll.id_data, groupe="chars", coll=False):
            c.data.offset_x = self.ofsset_font_x
            c.data.offset_y = self.ofsset_font_y


    def setAffecting(self, context): 
        if not self.types == "CURVE" and not self.preset_updating:
            for idx,sett in enumerate(eval(self.paires)):
                sett, master, txtAppearance, loc_obj = getCharSett(self, idx=idx)
                childOf = sett[1].constraints["Child Of"]
            
                childOf.use_location_x = childOf.use_location_y = childOf.use_location_z = self.aft_loc
                sett[1].constraints["COPY_LOCATION"].mute = self.aft_loc

                childOf.use_rotation_x = childOf.use_rotation_y = childOf.use_rotation_z = self.aft_rot
                sett[1].constraints["COPY_ROTATION"].mute =  self.aft_rot
                
                childOf.use_scale_x = childOf.use_scale_y = childOf.use_scale_z = self.aft_scl
                sett[1].constraints["COPY_SCALE"].mute = self.aft_scl
        
        self.static_pose = not self.aft_loc

   
    def updateInputFont(self, context):
        _, _, txtAppearance, _ = getCharSett(self, idx=0)
        if not self.font == None:
            txtAppearance.data.font = self.font
        else:
            self.font = bpy.data.fonts["Bfont"]
        
        if not self.preset_updating and self.font != None:
            bpy.ops.object.syncchar_operator(syc_from="font")


    def updateFontGeo(self, context):
        textProp = ["size",
                    "shear",
                    "space_character",
                    "space_line",
                    "extrude",
                    "offset",
                    "bevel_depth",
                    "bevel_resolution",
                    "resolution_u",
                    "render_resolution_u",]

        if self.types == "CURVE": 
            sett, master, txtAppearance, loc_obj = getCharSett(self, idx=0)
            textElements=[txtAppearance]
        else: 
            textElements=Collection_objs(self.id_data, groupe="main")#+Collection_objs(self.txtAppearance, groupe="chars")
        
        for prop in textProp:
            for el in textElements:
                if getattr(el.data,prop,None)!=None:
                    setattr(el.data,prop, getattr(self,prop))

        if not self.preset_updating:
            bpy.ops.object.syncchar_operator('INVOKE_DEFAULT', syc_from="geo")


    def updateMaterial(self, context):
        """Apply materials to children from Parent obj"""
        child = Collection_objs(self.id_data, groupe="chars", coll=False)   

        Mat = self.material

        if Mat is not None:

            for ob in child:
                if ob.type == 'FONT':
                    
                    ob.data.materials.clear()
                    ob.data.materials.append(Mat) 
        else:
            for ob in child:
                if ob.type == 'FONT':
                    ob.data.materials.clear()  
            self.rand_col = False
        
        if self.material == None: 
            #then no need fading feature
            bpy.context.scene.ik_tx_interpo_tool.ik_txt_fading = "none"
            self.fading = "none"



    preset_updating: bpy.props.BoolProperty(default=False, description="Avoide infinit loop whene load a new preset")

    #Common
    pose_start: bpy.props.PointerProperty(name="Position effector", description="Use an object to determine where the animation should start in the string", type=bpy.types.Object) #add a texture pointer
    radial: bpy.props.BoolProperty( default=False, description="Animation start from the middle of the string")#list[chars sorted]
    rad_center: bpy.props.BoolProperty( default=False, description="Animation start from the middle of the string")#list[chars sorted]
    
    sinWave_onLoc: bpy.props.BoolProperty(name="Wave", default=False, description="Use sinuce interpolations")#list[chars sorted]
    sinWave_onRot: bpy.props.BoolProperty(name="Wave", default=False, description="Use sinuce interpolations")#list[chars sorted]
    sinWave_onScl: bpy.props.BoolProperty(name="Wave", default=False, description="Use sinuce interpolations")#list[chars sorted]
    sinWave_onVis: bpy.props.BoolProperty(name="Wave", default=False, description="Use sinuce interpolations")#list[chars sorted]
    
    sinWave_Loc: bpy.props.FloatProperty(name="Wave period", default=5, min=1, max=80000000, description="Time period")
    sinWave_Rot: bpy.props.FloatProperty(name="Wave period", default=5, min=1, max=80000000, description="Time period")
    sinWave_Scl: bpy.props.FloatProperty(name="Wave period", default=5, min=1, max=80000000, description="Time period")
    sinWave_Vis: bpy.props.FloatProperty(name="Wave period", default=5, min=1, max=80000000, description="Time period")

    global_loop_delay: bpy.props.IntProperty(name="Delay", default=0, min=0, max=80000000, description="Additional time before animation reverse play")
    global_loop_infinit: bpy.props.IntProperty(name="Repeat", default=0, min=0, description="How many time the animation should repeat, 0 means endless.")#list[chars sorted]
    global_loop: bpy.props.BoolProperty( default=False, description="loop the entire animation")#list[chars sorted]
    global_loop_pingp: bpy.props.BoolProperty( default=True, description="loop ping pong")#list[chars sorted]
    
    baking_txt: bpy.props.BoolProperty( default=False, description="Baking detection")#list[chars sorted]
    full_txt: bpy.props.StringProperty(name="Body text", default  = "IK-Text Effects", description = "Original string from user")
    
    kerning: bpy.props.StringProperty(name="Kerning", default  = "{}", description = "Spacing")
    posKey: bpy.props.StringProperty(name="Kerning pose", default  = "[]", description = "filter space bare")
    types: bpy.props.StringProperty(name="Types", default  = "FONT", description ="Type of animation setup")
    charS_ob_nm: bpy.props.StringProperty(name="Root obj name", default  = ",", description ="List of char font objects")
    paires: bpy.props.StringProperty(name="Paires", default  = "[]", description = "Paire of char, targets, id")
    
    #Animation
    wiggle_OnLoc: bpy.props.BoolProperty(name="Wiggle position", default= False, description = "Wiggle on position")
    wiggle_OnRot: bpy.props.BoolProperty(name="Wiggle rotation", default= False, description = "Wiggle on rotation")
    wiggle_OnScl: bpy.props.BoolProperty(name="Wiggle scale", default= False, description = "Wiggle on scale")
    wiggle_OnVis: bpy.props.BoolProperty(name="Wiggle visibility", default= False, description = "Wiggle on visibility")

    wiggle_OnLoc_lock: bpy.props.BoolProperty(name="limit loc", default= True, description = "Limit the random walk")
    wiggle_OnRot_lock: bpy.props.BoolProperty(name="limit rot", default= True, description = "Limit the random walk")
    wiggle_OnScl_lock: bpy.props.BoolProperty(name="limit scl", default= True, description = "Limit the random walk")
    wiggle_OnVis_lock: bpy.props.BoolProperty(name="limit vis", default= True, description = "Limit the random walk")


    #Time Offset for eache char // not used in the UI
    wiggle_TimeL: bpy.props.StringProperty(name="Wiggle time Loc", default="[]", description="List[ Char[F,A,P] ] # as Time Offset for 1 char ")
    wiggle_TimeR: bpy.props.StringProperty(name="Wiggle time Rot", default="[]", description="List[ Char[F,A,P] ] ")
    wiggle_TimeS: bpy.props.StringProperty(name="Wiggle time Scl", default="[]", description="List[ Char[F,A,P] ] ")
    wiggle_TimeV: bpy.props.StringProperty(name="Wiggle time Scl", default="[]", description="List[ Char[F,A,P] ] ")
   
    # V.ectors L.cation
    wiggle_TVL: bpy.props.FloatVectorProperty(   
                            name="Wiggle Location", 
                            description="Frequency, Amplitude, Probability", 
                            default=(0.3, 0.2, 1), min=0.0, max=100.0,step=3, 
                            precision=2, options={'ANIMATABLE'}, 
                            size=3, update=None
                        )        
    wiggle_TVR: bpy.props.FloatVectorProperty(   
                            name="Wiggle rotation", 
                            description="Frequency, Amplitude, Probability", 
                            default=(0.3, 0.2, 0.5), min=0.0, max=100.0,step=3, 
                            precision=2, options={'ANIMATABLE'}, 
                            size=3, update=None
                        )        
    wiggle_TVS: bpy.props.FloatVectorProperty(   
                            name="Wiggle scale", 
                            description="Frequency, Amplitude, Probability", 
                            default=(0.3, 0.2, 0.5), min=0.0, max=100.0,step=3, 
                            precision=2, options={'ANIMATABLE'}, 
                            size=3, update=None
                        )     
    wiggle_TVV: bpy.props.FloatVectorProperty(   
                            name="Wiggle visibility", 
                            description="Frequency, Amplitude, Probability", 
                            default=(0.3, 0.2, 0.5), min=0.0, max=100.0,step=3, 
                            precision=2, options={'ANIMATABLE'}, 
                            size=3, update=None
                        )
    #FONT Apearence
    size: bpy.props.FloatProperty(
                            name="Font size", 
                            default= 1.0, 
                            min=0, 
                            update=updateFontGeo,
                            description = "Controls the size of the whole text")

    shear: bpy.props.FloatProperty(
                            name="Shear", 
                            default= 0., 
                            min=0,
                            update=updateFontGeo, 
                            description = "Controls the inclination of the whole text. This is not the same thing as italics style")

    space_character: bpy.props.FloatProperty(
                            name="Char spacing", 
                            default= 1., 
                            min=0, 
                            update=updateFontGeo,
                            description = "Adjust text character spacing")

    space_line: bpy.props.FloatProperty(
                            name="Lines", 
                            default= 1.0, 
                            min=0, 
                            update=updateFontGeo,
                            description = "Adjust text line spacing")

    extrude: bpy.props.FloatProperty(
                            name="Extrude", 
                            default= 0., 
                            min=0, 
                            update=updateFontGeo,
                            description = "Will extrude the text along both the positive and negative local Z axes")

    offset: bpy.props.FloatProperty(
                            name="Offset", 
                            default= 0., 
                            min=0, 
                            update=updateFontGeo,
                            description = "Adjust the witdh of the text")

    bevel_depth: bpy.props.FloatProperty(
                            name="Depth", 
                            default= 0., 
                            min=0, 
                            update=updateFontGeo,
                            description = "Changes the size of the bevel (when not using a bevel object)")

    bevel_resolution: bpy.props.IntProperty(
                            name="Resolution", 
                            default= 4, 
                            min=0, 
                            update=updateFontGeo,
                            description = "Alters the smoothness of the bevel")

    resolution_u: bpy.props.IntProperty(
                            name="Preview U", 
                            default= 12, 
                            min=0, 
                            update=updateFontGeo,
                            description = "Number of subdivisions")

    render_resolution_u: bpy.props.IntProperty(
                            name="Render U", 
                            default= 0, 
                            min=0, 
                            update=updateFontGeo,
                            description = "Number of subdivisions (zero uses preview resolution)")


    # CURVE OPTIONS
    ofsset_font_x: bpy.props.FloatProperty(name="Offset x", default  = 0.0, min=-100.0, max=100.0, description = "Offset x from the char geomerty origine", update=updateGeoOffset)
    ofsset_font_y: bpy.props.FloatProperty(name="Offset y", default  = 0.0, min=-100.0, max=100.0, description = "Offset y from the char geomerty origine", update=updateGeoOffset)

    center_font: bpy.props.FloatProperty(name="Place", default  = 0.5, min=.0, max=100.0, description = "Place font to curve", update=updateFramepose)
    spacing_char: bpy.props.FloatProperty(name="Spacing", default  = 10, min=1.0, max=1000, description = "Character spacing")
    normal_curve: bpy.props.BoolProperty(name="Normal", default  = True, description = "Follow normal")
    curve_ax: bpy.props.BoolProperty(name="Y forward", default=False, description="set Y forward", update=setCurveAx)#list[chars sorted]
    
    
    txtAppearance: bpy.props.StringProperty(name="Appearance", default="", description="name of text appearance setting")
    
    static_pose: bpy.props.BoolProperty(name="Static pose", default  = False, description = "Static position on the curve")# update=setAffecting
    start_pose: bpy.props.FloatProperty(name="Start position", default  = 0.5, min=0, max=1, description = "Start position on the curve")
    font_scale: bpy.props.FloatProperty(name="End scale", default  = 1.0, min=0.01, max=3000, description = "Font uniform scale")

    #Animation
    #loop: bpy.props.BoolProperty(name="Loop", default  = False, description = "Loop animation")
    start_at: bpy.props.IntProperty(name="Start loc", default=20, min=0, max=80000000, description = "Frame where position animation should start" )
    rot_start_at: bpy.props.IntProperty(name="Start rot", default=20, min=0, max=80000000, description = "Frame where rotation animation should start" )
    scl_start_at: bpy.props.IntProperty(name="Start scale", default=20, min=0, max=80000000, description = "Frame where scale animation should start" )
    visibility_at: bpy.props.IntProperty(name="Start visibility", default  = 20, min=0, max=5000, description = "Frame where visibility animation should start" )

    ofs: bpy.props.IntProperty(name="Offset loc", default  = 1, min=0, max=5000, description="Animation delay between char")
    rot_ofs: bpy.props.IntProperty(name="Offset rot", default  = 1, min=0, max=5000, description="Animation delay between char")
    scl_ofs: bpy.props.IntProperty(name="Offset scale", default  = 1, min=0, max=5000, description="Animation delay between char")
    visibility_of: bpy.props.IntProperty(name="Offset visibility", default  = 1, min=0, max=5000, description="Animation delay between char")

    duration: bpy.props.IntProperty(name="Duration loc", default  = 25, min=1, max=5000, description="Duration of the animation for one char, total is (start_frame + duration + string_lenght * offset)")
    rot_duration: bpy.props.IntProperty(name="Duration rot", default  = 25, min=1, max=5000, description="Duration of the animation for one char, total is (start_frame + duration + string_lenght * offset)")
    scl_duration: bpy.props.IntProperty(name="Duration scale", default  = 25, min=1, max=5000, description="Duration of the animation for one char, total is (start_frame + duration + string_lenght * offset)")
    visibility_dt: bpy.props.IntProperty(name="Duration visibility", default  = 25, min=1, max=5000, description="Duration of the animation for one char, total is (start_frame + duration + string_lenght * offset)")

    curve_interp_l: bpy.props.BoolProperty(name="Custom", default  = False, update=customCurve_l, description="Use custom interpolation curves for location")
    curve_interp_r: bpy.props.BoolProperty(name="Custom", default  = False, update=customCurve_r, description="Use custom interpolation curves for rotation")
    curve_interp_s: bpy.props.BoolProperty(name="Custom", default  = False, update=customCurve_s, description="Use custom interpolation curves for scale")
    curve_interp_v: bpy.props.BoolProperty(name="Custom", default  = False, update=customCurve_v, description="Use custom interpolation curves for visibility")
    
    curve_interp_l_value: bpy.props.StringProperty(name="Custom", default  = "[[0.0,0.0],[1.0,1.0]]", description="Use custom interpolation curves for location")
    curve_interp_r_value: bpy.props.StringProperty(name="Custom", default  = "[[0.0,0.0],[1.0,1.0]]", description="Use custom interpolation curves for rotation")
    curve_interp_s_value: bpy.props.StringProperty(name="Custom", default  = "[[0.0,0.0],[1.0,1.0]]", description="Use custom interpolation curves for scale")
    curve_interp_v_value: bpy.props.StringProperty(name="Custom", default  = "[[0.0,0.0],[1.0,1.0]]", description="Use custom interpolation curves for visibility")
    
    interpolation: bpy.props.StringProperty(name="Interpolation loc", default  = "inOutBack", description="Animation interpolation for the position")
    rot_interpolation: bpy.props.StringProperty(name="Interpolation rot", default  = "inOutBack", description="Animation interpolation for the rotation")
    scl_interpolation: bpy.props.StringProperty(name="Interpolation scale", default  = "inOutBack", description="Animation interpolation for the scale")
    vis_interpolation: bpy.props.StringProperty(name="Interpolation visibility", default  = "inOutBack", description="Animation interpolation for the visibility")

    back: bpy.props.FloatProperty(name="Back loc", default  = 0.5, min=0.0, max=100, description = "Back effect location")
    rot_back: bpy.props.FloatProperty(name="Back rot", default  = 0.5, min=0.0, max=100, description = "Back effect rotation")
    scl_back: bpy.props.FloatProperty(name="Back scale", default  = 0.5, min=0.0, description = "Back effect scale")
    vis_back: bpy.props.FloatProperty(name="Back visibility", default  = 0.5, min=0.0, max=100, description = "Back effect visibility")

    rand_loc: bpy.props.BoolProperty(name="Rand loc", default=False, description = "Enable random position", update=randL)#update=set radom        
    rand_rot: bpy.props.BoolProperty(name="Rand rot", default=False, description = "Enable random rotation", update=randR)     
    rand_scl: bpy.props.BoolProperty(name="Rand scalel", default=False, description = "Enable random scale", update=randS)  
    rand_vis: bpy.props.BoolProperty(name="Rand visibility", default=False, description = "Enable random visibility", update=randV)#update=set radom        

    rand_loc_val: bpy.props.StringProperty(description = "Value of random in location")#list[chars sorted]
    rand_rot_val: bpy.props.StringProperty(description = "Value of random in rotation")
    rand_scl_val: bpy.props.StringProperty(description = "Value of random in scale")
    rand_vis_val: bpy.props.StringProperty(description = "Value of random in visibility")#list[chars sorted]


    aft_scl: bpy.props.BoolProperty(name="scale", default=True, description = "Enable scale animation", update=setAffecting)#update=set radom        
    aft_rot: bpy.props.BoolProperty(name="rotation", default=True, description = "Enable rotation animation", update=setAffecting)#update=set radom        
    aft_loc: bpy.props.BoolProperty(name="location", default=True, description = "Enable location animation", update=setAffecting)#update=set radom        
    vis_on: bpy.props.BoolProperty( default=False, description= "Enable visibility animation")#list[chars sorted]

    font: bpy.props.PointerProperty(name="Font", description="Choose a font", type=bpy.types.VectorFont, update=updateInputFont) #add a texture pointer
    material: bpy.props.PointerProperty(name="Material", description="Material to use on this text", type=bpy.types.Material, update=updateMaterial) #add a texture pointer
    # has to be registred
    fading: bpy.props.StringProperty(default="none", name="Fading", description = "Fading effect")
    rand_col: bpy.props.BoolProperty(default=False, name="Random color", description = "Randomize color", update=randomizeCol)
    # preset
    data_structure_v: bpy.props.IntProperty(name="Duration loc", default=2, description = "Verion of the data structure")
    # kerning
    char_hide_selection: bpy.props.BoolProperty(
        name="Allow selection",
        update=kernSelection,
        default=False)


def Interpolation_Mode(self, context):
    """Interpolation from menu and asign to text animation"""
    if not bpy.context.scene.Pxy_uiUpdating:
        ch = bpy.context.scene.ik_tx_interpo_tool.ik_txt_interpo
        op = getSettings(check=False)
        call_interpolation = "bpy.data.collections['{o}'].ik_TextFx[0].{i}='{c}'".format(o = op.id_data.name, i=filtre()[5], c = ch )
        exec(call_interpolation)



class Interpolation_Mode_sett(PropertyGroup):

    ik_txt_interpo: EnumProperty(
        name="Interpolation Mode:",
        description="Apply interpolation to active range.",
        update = Interpolation_Mode,        
        items = (
        ('linear',   "Linear",     "","IPO_LINEAR",1),

        ('inSine',     "Sinusoidal in", "","IPO_SINE",2),
        ('outSine',     "Sinusoidal out", "","MOVE_DOWN_VEC",3),
        ('inOutSine',     "Sinusoidal inOut", "","MOVE_DOWN_VEC",4),
        ('outInSine',     "Sinusoidal outIn", "","MOVE_DOWN_VEC",5),

        ('inCubic',    "Cubic in",      "","IPO_CUBIC",6),
        ('outCubic',    "Cubic out",      "","MOVE_DOWN_VEC",7),
        ('inOutCubic',    "Cubic inOut",      "","MOVE_DOWN_VEC",8),
        ('outInCubic',    "Cubic outIn",      "","MOVE_DOWN_VEC",9),

        ('inQuart',    "Quartic in",    "","IPO_QUART",10),
        ('outQuart',    "Quartic out",    "","MOVE_DOWN_VEC",11),
        ('inOutQuart',    "Quartic inOut",    "","MOVE_DOWN_VEC",12),
        ('outInQuart',    "Quartic outIn",    "","MOVE_DOWN_VEC",13),

        ('inQuint',    "Quintic in",    "","IPO_QUINT",14),
        ('outQuint',    "Quintic out",    "","MOVE_DOWN_VEC",15),
        ('inOutQuint',    "Quintic inOut",    "","MOVE_DOWN_VEC",16),
        ('outInQuint',    "Quintic outIn",    "","MOVE_DOWN_VEC",17),

        ('inExpo',     "Exponential in", "","IPO_EXPO",18),
        ('outExpo',     "Exponential out", "","MOVE_DOWN_VEC",19),
        ('inOutExpo',     "Exponential inOut", "","MOVE_DOWN_VEC",20),
        ('outInExpo',     "Exponential outIn", "","MOVE_DOWN_VEC",21),

        ('inCirc',     "Circular in",    "","IPO_CIRC",22),
        ('outCirc',     "Circular out",    "","MOVE_DOWN_VEC",23),
        ('inOutCirc',     "Circular inOut",    "","MOVE_DOWN_VEC",24),
        ('outInCirc',     "Circular outIn",    "","MOVE_DOWN_VEC",25),

        ('inBack',     "Back in",        "","IPO_BACK",26),
        ('outBack',     "Back out",        "","MOVE_DOWN_VEC",27),
        ('inOutBack',     "Back inOut",        "","MOVE_DOWN_VEC",28),
        ('outInBack',     "Back outIn",        "","MOVE_DOWN_VEC",29),

        ('inBounce',   "Bounce in",      "","IPO_BOUNCE",30),
        ('outBounce',   "Bounce out",      "","MOVE_DOWN_VEC",31),
        ('inOutBounce',   "Bounce inOut",      "","MOVE_DOWN_VEC",32),
        ('outInBounce',   "Bounce outIn",      "","MOVE_DOWN_VEC",33),

        ('inElastic',  "Elastic in",     "","IPO_ELASTIC",34),        
        ('outElastic',  "Elastic out",     "","MOVE_DOWN_VEC",35),        
        ('inOutElastic',  "Elastic inOut",     "","MOVE_DOWN_VEC",36)),        
        # ('outInElastic',  "Elastic outIn",     "","MOVE_DOWN_VEC",36)),        
        default='inBack', 
        )

    ik_txt_fading: EnumProperty(
        name="Fading Effect:",
        description="Apply a fading effect using shader transparency",
        update = Interpolation_Fade,        
        items = (
        ('none',   "No fading",     "","RADIOBUT_OFF",1),
        ('edge',   "Edge",     "","IPO_CONSTANT",2),
        # ('block',     "Block", "","MOD_BUILD",3),
        ('smooth',  "Smooth",     "","SMOOTHCURVE",3)),        
        default='none', 
        )

   
# Preset Props
AnimationProp =  [
                "vis_on",
                "wiggle_OnLoc",
                "wiggle_OnRot",
                "wiggle_OnScl",
                "wiggle_OnLoc_lock",
                "wiggle_OnRot_lock",
                "wiggle_OnScl_lock",
                
                "center_font",
                # "spacing_char",
                "normal_curve",
                "aft_loc",
                "aft_rot",
                "aft_scl",

                "static_pose",
                "start_pose",
                "font_scale",
                "start_at",
                "rot_start_at",
                "scl_start_at",
                "visibility_at",
                "ofs",
                "rot_ofs",
                "scl_ofs",
                "visibility_of",
                "duration",
                "rot_duration",
                "scl_duration",
                "visibility_dt",
                "interpolation",
                "rot_interpolation",
                "scl_interpolation",
                "vis_interpolation",
                "back",
                "rot_back",
                "scl_back",
                "vis_back",
                "rand_loc",
                "rand_rot",
                "rand_scl",
                "rand_vis",
                "wiggle_TVL",
                "wiggle_TVR",
                "wiggle_TVS",

                "global_loop_delay",
                "global_loop_infinit",
                "global_loop",
                "global_loop_pingp",

                "curve_ax",
                "radial",
                "rad_center",

                "curve_interp_l",
                "curve_interp_r",
                "curve_interp_s",
                "curve_interp_v",
                # registred from OT_TxAddPresetLayer class 
                # "curve_interp_l_value",
                # "curve_interp_r_value",
                # "curve_interp_s_value",
                # "curve_interp_v_value",

                "ofsset_font_x",
                "ofsset_font_y",

                "sinWave_onLoc",
                "sinWave_onRot",
                "sinWave_onScl",
                "sinWave_onVis",
                "sinWave_Loc",
                "sinWave_Rot",
                "sinWave_Scl",
                "sinWave_Vis",
                "fading",
                "rand_col",
                ]
textProp = [
                'use_fake_user', 
                'tag', 
                'path_duration', 
                'use_path', 
                'use_path_follow', 
                'use_stretch', 
                'use_deform_bounds', 
                'use_radius', 
                'bevel_resolution', 
                'offset', 
                'extrude', 
                'bevel_depth', 
                'resolution_u', 
                'resolution_v', 
                'render_resolution_u', 
                'render_resolution_v', 
                'eval_time', 
                'bevel_object', 
                'taper_object', 
                'dimensions', 
                'fill_mode', 
                'twist_mode', 
                'bevel_factor_mapping_start', 
                'bevel_factor_mapping_end', 
                'twist_smooth', 
                'use_fill_deform', 
                'use_fill_caps', 
                'use_map_taper', 
                'use_auto_texspace', 
                #'use_uv_as_generated', 
                'bevel_factor_start', 
                'bevel_factor_end', 
                'align_x', 
                'align_y', 
                'overflow', 
                'size', 
                'small_caps_scale', 
                'space_line', 
                'space_word', 
                'space_character', 
                'shear', 
                #'offset_x', 
                #'offset_y', 
                'underline_position', 
                'underline_height', 
                'active_textbox', 
                'family', 
                'follow_curve', 
                #'font', 
                #'font_bold', 
                #'font_italic', 
                #'font_bold_italic', 
                'use_fast_edit', 
                ]

