import bpy
from mathutils import Matrix
from bpy.types import Panel
from bpy.types import Menu

from .motion import *
from .texProp import *
from .routine import *
from .display import *



# ExportHelper is a helper class, defines filename and
# invoke() function which calls the file selector.
from bl_operators.presets import AddPresetBase
from bpy_extras.io_utils import ImportHelper
from bpy.props import StringProperty, BoolProperty, EnumProperty
from bpy.types import Operator
import json



import os 
import shutil 

def updateProxySlider():
    bpy.context.scene.Pxy_uiUpdating = True
    
    props = filtre()
    op = getSettings(check=False)
    
    bpy.context.scene.Pxy_Frequency  = getattr(op, props[10], (0,0,0))[0]
    bpy.context.scene.Pxy_Amplitude  = getattr(op, props[10], (0,0,0))[1]
    bpy.context.scene.Pxy_Probability = getattr(op, props[10], (0,0,0))[2] 

    bpy.context.scene.ik_tx_interpo_tool.ik_txt_interpo = getattr(op, props[5], "linear" )
    bpy.context.scene.ik_tx_interpo_tool.ik_txt_fading = getattr(op, "fading", "smooth" )
    
    bpy.context.scene.Pxy_uiUpdating = False


def updateWigleSettings(scene, context):

    if not scene.Pxy_uiUpdating:
        # do not change values whene ui updaping
        props = filtre()
        op = getSettings(check=False)
        setattr(op, props[10],(
                            scene.Pxy_Frequency, 
                            scene.Pxy_Amplitude, 
                            scene.Pxy_Probability
                            )
                )

def deselect_others(ob, context):
    """For tool menu select, deselects others if one selected"""
    selected = IKTXTEFFECTS_PT_view3d_panel.selected
    ob[selected] = False
    keys = [key for key in ob.keys() if ob[key]]  # all the True keys
    if len(keys) <= 0:
        ob[selected] = True  # reselect
        updateProxySlider()
        return None
    for key in keys:
        IKTXTEFFECTS_PT_view3d_panel.selected = key
        ob[key] = True
    updateProxySlider()




class fontFilePickerOp(bpy.types.Operator, ImportHelper):
    """Load a font from your hard drive"""
    bl_idname = "object.font_file_pik_op"
    bl_label = "Load a font"


    def execute(self, context):
        Settings = getSettings(check=False)    
        _, _, txtAppearance, _ = getCharSett(Settings, idx=0)

        if os.path.exists(self.properties.filepath): 
            txtAppearance.data.font = loadFont(path=self.properties.filepath)[0]
            Settings.font = txtAppearance.data.font            
            return{'FINISHED'}

        return{'CANCELLED'}




class addMaterialOp(bpy.types.Operator):
    """Assign material"""
    bl_idname = "object.material_add_fx"
    bl_label = "Assign material"

    def execute(self, context):
        path = os.path.join(os.path.join(bpy.utils.user_resource('SCRIPTS')), 'addons', "textEffect", "presets", "shaderTools.blend", "Material")
        material_name = "MatFxTemp"

        Settings = getSettings(check=False)
        _, _, txtAppearance, _ = getCharSett(Settings, idx=0)
        name = Settings.name.replace("IK", "Fx")
        # Get material
        mat = bpy.data.materials.get(name)
        if mat is not None:
            bpy.data.materials.remove(mat)

        bpy.ops.wm.append(filename=material_name, directory=path)
        # create material
        mat = bpy.data.materials.get(material_name)
        mat.name = name

        # Assign it to object
        if txtAppearance.data.materials:
            # assign to 1st material slot
            txtAppearance.data.materials[0] = mat
        else:
            # no slots
            txtAppearance.data.materials.append(mat)
        
        Settings.material = mat
        Settings.fading = Settings.fading
        Settings.rand_col = Settings.rand_col
        txtAppearance.select_set(True)
        return{'FINISHED'}



#bouton menu loc rot scal
class TxLocRotScl(bpy.types.PropertyGroup):
    """Texts Options from C.scene.text_options"""
    TXLoc: BoolProperty(name="location", default=False, description ="Display location settings", update=deselect_others)
    TXRot: BoolProperty(name="rotation", default=False, description = "Display rotation settings", update=deselect_others)
    TXScl: BoolProperty(name="scale", default=False, description = "Display scale settings", update=deselect_others)
    TXVid: BoolProperty(name="vide", default=False, description = "Display visibility settings", update=deselect_others)

   
class ResetTxOperator(bpy.types.Operator):
    """Set letters to default position"""
    bl_idname = "object.tx_reset_kerning_operator"
    bl_label = "Reset kerning"
    bl_options = {'REGISTER', 'UNDO'}

    @classmethod
    def poll(cls, context):
        return getSettings(check=True) != False

    def execute(self, context):
        op = getSettings()
        for ob in Collection_objs(op.id_data, "chars", False):
            if "_IK_char_" in ob.name:
                value = ob.get("iktx_loc", None)
                if value is not None:
                    if ob.name+"_st_Trg" in bpy.data.objects:
                        bpy.data.objects[ob.name+"_st_Trg"].location = value
                    if ob.name+"_ed_Trg" in bpy.data.objects:
                        bpy.data.objects[ob.name+"_ed_Trg"].location = value
        
        return {'FINISHED'}

   
class AddTxtOperator(bpy.types.Operator):
    """Add text to 3D scene"""
    bl_idname = "object.add_txt_operator"
    bl_label = "Add 3D text"
    bl_options = {'REGISTER', 'UNDO'}


    @classmethod
    def poll(cls, context):
        return len(bpy.context.scene.edit_ik_text.rstrip())>0


    def execute(self, context):

        Text = bpy.context.scene.edit_ik_text.rstrip()

        if len(Text) < 1 : return {'CANCELLED'}
        LFont = loadFont()

        if len(context.selected_objects)>0:
            if getattr(context.selected_objects[0],"type",False) == "CURVE":
                """ cur setup """

                #Reset curve transformation
                acObject = context.active_object
                obL,obR,obS = tuple(acObject.location), tuple(acObject.rotation_euler), tuple(acObject.scale)
                acObject.location, acObject.rotation_euler, acObject.scale = (0,0,0),(0,0,0),(1,1,1)

                txt_prxy_curve = bpy.data.objects[context.object.name] #root proxy
                name_text = InitTxt(Text, LFont)
                frag = "_".join(name_text.split("_")[-2:])
                txt_prxy_curve.name = "".join([c for c in txt_prxy_curve.name.split("_")[0] if c.isalpha()])+"_"+frag

                setCyclesV(bpy.data.objects[name_text])

                Kerning, allSpaceKern = kerning(Text, LFont)
                list_c, posKey   = AddChar(Kerning, allSpaceKern, LFont, txt_prxy_curve.name)    
                Settings, mainColl = Tx_BuildSettings(txt_prxy_curve.name.replace("IK", "Fx"), Text)
                Settings.kerning = str(allSpaceKern)
                Settings.txtAppearance = name_text
                Settings.posKey = str(posKey)
                Settings.name = txt_prxy_curve.name
                Settings.full_txt = Text

                SetUpChar(list_c, allSpaceKern, Settings, mainColl, txt_prxy_curve, name_text)
                curveStartPose(txt_prxy_curve, Settings)
                #Restor curve transformation
                acObject.location, acObject.rotation_euler, acObject.scale = obL,obR,obS

                return {'FINISHED'}

        
        bpy.ops.object.text_add(enter_editmode=False)
        bpy.context.view_layer.update()

        
        ob = context.active_object
        ob.location=bpy.context.scene.cursor.location 
        ob.rotation_euler=bpy.context.scene.cursor.rotation_euler
        setFont(ob, loadFont())

        ob.data.body = Text 
        bpy.ops.object.convert_txt_operator()
        
        return {'FINISHED'}


        


class AddTxt_fromEditor_Operator(bpy.types.Operator):
    """Add current text to 3D scene"""
    bl_idname = "object.add_txt_from_editor_operator"
    bl_label = "Add 3D text"
    bl_options = {'REGISTER', 'UNDO'}


    @classmethod
    def poll(cls, context):
        return len(getattr(context.edit_text, "lines", [])) > 0


    def execute(self, context):

        Text = "\n".join([l.body for l in  context.edit_text.lines])

        def firstValideLine(Text):
            for l in Text.split("\n"):
                if len(l.strip())>0:
                    return l.strip()
            return ""


        ####################################################################
        # PLACE ON CURVE
        if len(context.selected_objects)>0:
            if getattr(context.selected_objects[0],"type",False) == "CURVE":
                """ cur setup """

                bpy.context.scene.edit_ik_text = firstValideLine(Text)
                bpy.ops.object.add_txt_operator()
                return {'FINISHED'}

        

        ####################################################################
        # REGULAR cancel if no text
        if len(firstValideLine(Text))==0: return {'CANCELLED'}

        bpy.ops.object.text_add(enter_editmode=False)
        bpy.context.view_layer.update()

        
        ob = context.active_object
        ob.location=bpy.context.scene.cursor.location 
        ob.rotation_euler=bpy.context.scene.cursor.rotation_euler
        setFont(ob, loadFont())

        ob.data.body = Text 
        bpy.ops.object.convert_txt_operator()


        return {'FINISHED'}

# AAA
def getPartPose(items):
    
    def getPose(name):
        if name in bpy.context.scene.objects:
            return [
                list(bpy.context.scene.objects[name].rotation_euler),
                list(bpy.context.scene.objects[name].location),
                list(bpy.context.scene.objects[name].scale),
                ]
        else:[]

    return {
        "main":getPose(items[0]),
        "loc":getPose(items[1]),
        "locked":getPose(items[2]),
        }

def ReplaceRegularTextFromEditor(context, Settings, mainColl, acObject, part, Text):
    acObject.data.body = Text 
    acObject.data.align_x = 'LEFT'
    acObject.data.align_y = 'TOP_BASELINE'
    acObject.data.offset_x = 0
    acObject.data.offset_y = 0

    LFont = [acObject.data.font] #loadFont()

    acObject.display_type = 'BOUNDS'
    acObject.hide_render = True

    setCyclesV(acObject)

    acObject.select_set(True)
    context.view_layer.objects.active = acObject
    
    #reset text root object pose
    acObject.location, acObject.rotation_euler, acObject.scale = (0,0,0),(0,0,0),(1,1,1)

    Kerning, allSpaceKern = kerning(Text, LFont, acObject)
    list_c, posKey   = AddChar(Kerning, allSpaceKern, LFont, Settings.name)    
    Settings.posKey = str(posKey)
    Settings.full_txt = Text


    SetUpChar(list_c, allSpaceKern, Settings, mainColl, acObject)

    #save location
    _, _, txtAppearance, loc_obj = getCharSett(Settings, idx=0)
    
    #restor positions
    txtAppearance.rotation_euler, txtAppearance.location, txtAppearance.scale = part["main"][0], part["main"][1], part["main"][2] 
    loc_obj.rotation_euler, loc_obj.location, loc_obj.scale = part["loc"][0], part["loc"][1], part["loc"][2] 

    if Settings.material is not None:
        Settings.material = Settings.material

    lokedName = loc_obj.name.replace("_LOC", "_LOCKED")
    if lokedName in context.scene.objects:
        ob = context.scene.objects[lokedName]
        ob.rotation_euler, ob.location, ob.scale = part["locked"][0], part["locked"][1], part["locked"][2]


def ReplaceCurveTextFromEditor(context, Settings, mainColl, part, Text):
    #Reset curve transformation
    acObject = context.active_object
    name_text = Settings.txtAppearance
    # FIXME: Replace bug from duplicated text
    print(name_text, list(bpy.data.objects[name_text].constraints))
    constr = bpy.data.objects[name_text].constraints[-1]

    ConSvAl = [constr.offset_factor,
        constr.use_curve_follow,
        constr.use_fixed_location, 
        constr.up_axis]

    obL,obR,obS = tuple(acObject.location), tuple(acObject.rotation_euler), tuple(acObject.scale)
    acObject.location, acObject.rotation_euler, acObject.scale = (0,0,0),(0,0,0),(1,1,1)

    txt_prxy_curve = bpy.data.objects[Settings.name] #root proxy

    setCyclesV(bpy.data.objects[name_text])
    LFont = [bpy.data.objects[name_text].data.font]
    Kerning, allSpaceKern = kerning(Text, LFont)
    list_c, posKey   = AddChar(Kerning, allSpaceKern, LFont, txt_prxy_curve.name)    
    Settings.kerning = str(allSpaceKern)
    Settings.posKey = str(posKey)
    Settings.full_txt = Text

    SetUpChar(list_c, allSpaceKern, Settings, mainColl, txt_prxy_curve, name_text)
    curveStartPose(txt_prxy_curve, Settings)
    
    #Restor curve transformation
    bpy.data.objects[name_text].constraints.remove(bpy.data.objects[name_text].constraints[-1])

    acObject.location, acObject.rotation_euler, acObject.scale = obL,obR,obS

    NewConstr = bpy.data.objects[name_text].constraints[-1]
    NewConstr.offset_factor = ConSvAl[0]
    NewConstr.use_curve_follow = ConSvAl[1]
    NewConstr.use_fixed_location  = ConSvAl[2]
    NewConstr.up_axis = ConSvAl[3]

    #force update target axe
    tru = Settings.curve_ax
    Settings.curve_ax = not Settings.curve_ax
    Settings.curve_ax = not Settings.curve_ax
    
    Settings.normal_curve = not Settings.normal_curve
    Settings.normal_curve = not Settings.normal_curve





class ReplaceTxt_fromEditor_Operator(bpy.types.Operator):
    """Replace animated text"""
    bl_idname = "object.replace_txt_from_editor_operator"
    bl_label = "Replace text"
    bl_options = {'REGISTER', 'UNDO'}

    area: bpy.props.StringProperty(default="")


    @classmethod
    def poll(cls, context):
        return getSettings(check=True) 


    def execute(self, context):

        # remove unnessary char
        if self.area=="TEditor":
            Text = "\n".join([l.body.replace("\t","    ").rstrip() for l in  context.edit_text.lines])
        else:
            Text = bpy.context.scene.edit_ik_text.strip()
        
        if len(Text.strip()) < 1 : return {'CANCELLED'}

        Settings = getSettings()
        mainColl = Settings.id_data
        Settings.full_txt = Text

        #save location
        _, master, txtAppearance, loc_obj = getCharSett(Settings, idx=0)
        part = getPartPose([txtAppearance.name, loc_obj.name, loc_obj.name.replace("_LOC", "_LOCKED")])


        # free users object
        mooveToCollection(master, bpy.context.scene.collection, True)

        # remove
        HardRemov(Settings.id_data, keepColl=True)
        

        #rebuild
        if Settings.types == 'FONT':
            ReplaceRegularTextFromEditor(context, Settings, mainColl, master, part, Text)
        if Settings.types == 'CURVE':
            ReplaceCurveTextFromEditor(context, Settings, mainColl, part, Text.split('\n')[0])

        text_prop_copier(context)

        return {'FINISHED'}


class LoadTxt_fromEditor_Operator(bpy.types.Operator):
    """Edit selected text animation"""
    bl_idname = "object.load_txt_from_editor_operator"
    bl_label = "Edite text"
    bl_options = {'REGISTER', 'UNDO'}


    @classmethod
    def poll(cls, context):
        return getSettings(check=True)


    def execute(self, context):

        Settings = getSettings()
        name = Settings.name

        if not name in bpy.data.texts:
            bpy.data.texts.new(name)

        bpy.data.texts[name].clear()
        bpy.data.texts[name].write(Settings.full_txt)
        context.area.spaces[0].text = bpy.data.texts[name]
    

        return {'FINISHED'}

        


class ConvertTxtOperator(bpy.types.Operator):
    """Convert text animation"""
    bl_idname = "object.convert_txt_operator"
    bl_label = "Convert to text animation"
    bl_options = {'REGISTER', 'UNDO'}


    def execute(self, context):
        """ Covert selected text to animation
        """

        acObject = context.active_object
        obL,obR,obS = tuple(acObject.location), tuple(acObject.rotation_euler), tuple(acObject.scale) 

        # convert tab to spaceBare
        Text = acObject.data.body.replace("\t","    ") 
        # remove unnessary char
        Text = "\n".join([line.rstrip() for line in Text.split("\n")])
        acObject.data.body = Text 
        acObject.data.align_x = 'LEFT'
        acObject.data.align_y = 'TOP_BASELINE'
        acObject.data.offset_x = 0
        acObject.data.offset_y = 0

        LFont = [acObject.data.font] #loadFont()

        if len(Text.strip()) < 1 : return {'CANCELLED'}

        #init text root object
        acObject.location, acObject.rotation_euler, acObject.scale = (0,0,0),(0,0,0),(1,1,1)

        name_text = newName(Text)
        acObject.name = name_text
        acObject.data.name = name_text
        txt_obj = acObject
        txt_obj.display_type = 'BOUNDS'
        txt_obj.hide_render = True

        setCyclesV(txt_obj)

        Kerning, allSpaceKern = kerning(Text, LFont, acObject)
        list_c, posKey   = AddChar(Kerning, allSpaceKern, LFont, name_text)    
        Settings, mainColl = Tx_BuildSettings(name_text.replace("IK", "Fx"), Text)
        Settings.txtAppearance = name_text
        Settings.posKey = str(posKey)
        Settings.name = name_text
        Settings.full_txt = Text

        SetUpChar(list_c, allSpaceKern, Settings, mainColl, txt_obj)

        txt_obj.location, txt_obj.rotation_euler, txt_obj.scale = obL,obR,obS

        text_prop_copier(context)

        return {'FINISHED'}


class SyncCharOperator(bpy.types.Operator):
    """Update animation settup"""
    bl_idname = "object.syncchar_operator"
    bl_label = "Apply the selected font to curent text"
    bl_options = {'REGISTER', 'UNDO'}

    syc_from: bpy.props.StringProperty(default="")


    @classmethod
    def poll(cls, context):
        return getSettings(check=True)

    def execute(self, context):
        obj = context.active_object
        obj.select_set(state=False)

        Settings = getSettings()
        sett, master, txtAppearance, loc_obj = getCharSett(Settings, idx=0)
        apearanceObj = txtAppearance

        #Reset transformation
        acObject = apearanceObj
        obL,obR,obS = tuple(acObject.location), tuple(acObject.rotation_euler), tuple(acObject.scale)
        acObject.location, acObject.rotation_euler, acObject.scale = (0,0,0),(0,0,0),(1,1,1)

        # select apearance object
        apearanceObj.select_set(state=True)
        context.view_layer.objects.active = apearanceObj

        LFont = [apearanceObj.data.font]
        selProp = [
                "size",
                "shear",
                "space_character",
                "space_line",
                "extrude",
                "offset",
                "bevel_depth",
                "bevel_resolution",
                "resolution_u",
                "render_resolution_u",
                ]


        text_prop_copier(context) 

        
        Kerning, allSpaceKern = kerning(Settings.full_txt, [LFont], apearanceObj)
        updatCharPose(Kerning, allSpaceKern, Settings)

        Settings.kerning =str(allSpaceKern)

        obj.select_set(state=True)
        context.view_layer.objects.active = obj

        #restor transformation
        acObject.location, acObject.rotation_euler, acObject.scale = obL,obR,obS

        if self.syc_from == "": # preset call
            print("TEXTFX: Update preset")
            Settings.preset_updating = True
            Settings.font = LFont[0]
            bpy.context.view_layer.update()

            if Settings.types == "CURVE": 
                apearanceObj=Collection_objs(Settings.id_data, groupe="chars")[0]
            else: 
                apearanceObj=Collection_objs(Settings.id_data, groupe="chars")[0]

            for p in selProp:
                if getattr(Settings,p,None)!=None:
                    setattr(Settings,p, getattr(apearanceObj.data,p))
                    # print(p, getattr(apearanceObj.data,p))
            Settings.preset_updating = False

        if not self.syc_from in ["font", "geo"]:   
            listToCostomCurveAll(Settings)

        return {'FINISHED'}




class DuplicateTxOperator(bpy.types.Operator):
    """Duplicate active text"""
    bl_idname = "object.duplicate_tx_op"
    bl_label = "Duplicate"
    bl_options = {'REGISTER', 'UNDO'}


    @classmethod
    def poll(cls, context):
        return getSettings(check=True)

    def execute(self, context):
        op = getSettings(check=False)

        # make sur setup is ready for duplication
        getReadyCopy(op, op.id_data)


        # bake custom curves
        costomCurveToListAll(op)

        listContent = []
        listColl = []

        listColl = duplicateCollection(bpy.context.scene.collection, op.id_data, 
                        linked=False, listContent=listContent, listColl=listColl)
        
        # Update names of the copy                       
        getReadyCopy(op, listColl[0])

        newCopySettings = listColl[0].ik_TextFx.add()
        newCopySettings.types = op.types
        _, master, txtAppearance, loc_obj = getCharSett(newCopySettings, idx=0)

        print(">>>: txtAppearance", txtAppearance)
        # Alow dedicated custom curve when copy finish
        newCopySettings.txtAppearance = txtAppearance.name
        newCopySettings.name = txtAppearance.name

        # do not copy this settings
        excl = ["txtAppearance", "name"]

        for prop in [p.identifier for p in newCopySettings.bl_rna.properties if not p.is_readonly and not p.identifier in excl]:
            newCopySettings.preset_updating = True
            setattr(newCopySettings, prop, getattr(op, prop)) 

        # restore custom curve
        listToCostomCurveAll(newCopySettings)

        newCopySettings.preset_updating = False

        c = bpy.context.scene.frame_current
        bpy.context.scene.frame_set(c)

        bpy.ops.object.select_all(action='DESELECT')
        master.select_set(True)
        context.view_layer.objects.active = master
        bpy.ops.transform.translate('INVOKE_DEFAULT')

        return {'FINISHED'}





class ErassTxOperator(bpy.types.Operator):
    """Erase animated text"""
    bl_idname = "object.erase_tx_op"
    bl_label = "Erase text"
    bl_options = {'REGISTER', 'UNDO'}


    @classmethod
    def poll(cls, context):
        return getSettings(check=True)

    def execute(self, context):
        removeAnimationSetUp(getSettings(check=False))
        return {'FINISHED'}



class BatchBakeTxOperator(bpy.types.Operator):
    """Batch bake sellected texts"""
    bl_idname = "object.batch_bake_tx_op"
    bl_label = "Batch bake"
    bl_options = {'REGISTER', 'UNDO'}


    @classmethod
    def poll(cls, context):
        return len(context.selected_objects)>0

    def execute(self, context):
        S = scene   = bpy.context.scene
        C = context = bpy.context

        NSettings = {getObjSettings(o) for o in bpy.context.selected_objects}

        for Settings in NSettings:
            if Settings==None: continue

            bpy.ops.object.select_all(action='DESELECT')
            _, master, txtAppearance, loc_obj = getCharSett(Settings, idx=0)
            
            bpy.context.scene.objects[master.name].select_set(True)
            C.view_layer.objects.active = bpy.data.objects[master.name]
            print("TextFX Batch bake: %s"%master.name)
            bpy.ops.object.bake_tx_op()

        return {'FINISHED'}



class BakeTxOperator(bpy.types.Operator):
    """Bake IK 3D text"""
    bl_idname = "object.bake_tx_op"
    bl_label = "Bake text"
    bl_options = {'REGISTER', 'UNDO'}


    @classmethod
    def poll(cls, context):
        return len(context.selected_objects)>0

    def execute(self, context):
        S = scene   = bpy.context.scene
        C = context = bpy.context

        start = S.frame_start 
        end   = S.frame_end 
        curent = S.frame_current 

        obj  = C.active_object

        Settings   = getSettings(check=False)
        types = Settings.types
        name = Settings.name

        # Enable extra features for baking properly
        Settings.baking_txt = True

        _, master, txtAppearance, loc_obj = getCharSett(Settings, idx=0)
        
        txtAppearanceName = master.name

        # unlink ui display
        corphandle = Collection_objs(Settings.id_data, groupe="corphandle", coll=False)

        ##################################
        if types == "CURVE":
            print("Bake Curve %s"%txtAppearanceName)
            bakeTxCurveNow(txtAppearanceName, Settings)
        else:
            print("Bake Regular %s"%txtAppearanceName)
            bakeTxFrame(txtAppearance, Settings)

        bpy.ops.object.select_all(action='DESELECT')
        
        
        
        scenCleaning(Settings.id_data)
        
        if txtAppearanceName in context.scene.objects:
            master.hide_viewport = False
            master.hide_select = False
            master.select_set(True)

            bpy.ops.object.convert(target='MESH')

        removeCustomCurvesAll(name)

        # restor user frame range
        S.frame_start = start
        S.frame_end = end
        S.frame_current = curent

        return {'FINISHED'}


class PastOperator(bpy.types.Operator):
    """Copy settings to others channels (loc, rot, scale, vis)"""
    bl_idname = "object.past_tx_operator"
    bl_label = "Copy settings to others"
    bl_options = {'REGISTER', 'UNDO'}

    @classmethod
    def poll(cls, context):
        return getSettings(check=True)

    def execute(self, context):


        Settings = getSettings(check=False)
        # returne active channel props
        sett = [ "bpy.data.collections['{o}'].ik_TextFx[0].{i}".format(o = Settings.id_data.name, i= atr ) for atr in filtre() ] 

        # backe custom interpolation curves 
        Settings.curve_interp_l_value = curveToList(Settings.name+"_"+"curve_interp_l")
        Settings.curve_interp_r_value = curveToList(Settings.name+"_"+"curve_interp_r")
        Settings.curve_interp_s_value = curveToList(Settings.name+"_"+"curve_interp_s")
        Settings.curve_interp_v_value = curveToList(Settings.name+"_"+"curve_interp_v")

        # properties to change by channel
        A    = [ "bpy.data.collections['{o}'].ik_TextFx[0].{i}".format(o = Settings.id_data.name, i= atr ) for atr in filtre("TXLoc") ] 
        B    = [ "bpy.data.collections['{o}'].ik_TextFx[0].{i}".format(o = Settings.id_data.name, i= atr ) for atr in filtre("TXRot") ] 
        C    = [ "bpy.data.collections['{o}'].ik_TextFx[0].{i}".format(o = Settings.id_data.name, i= atr ) for atr in filtre("TXScl") ] 
        D    = [ "bpy.data.collections['{o}'].ik_TextFx[0].{i}".format(o = Settings.id_data.name, i= atr ) for atr in filtre("TXVid") ] 

        liste = [ A, B, C, D ]

        for atr in liste :
            for a, s in zip(atr, sett):
                exec(a+" = "+s)

        # restore custom interpolation curves
        ListToCurve(Settings.name+"_"+"curve_interp_l", Settings.curve_interp_l_value)
        ListToCurve(Settings.name+"_"+"curve_interp_r", Settings.curve_interp_r_value)
        ListToCurve(Settings.name+"_"+"curve_interp_s", Settings.curve_interp_s_value)
        ListToCurve(Settings.name+"_"+"curve_interp_v", Settings.curve_interp_v_value)


        return {'FINISHED'}



class RootOperator(bpy.types.Operator):
    """Toggl select handle"""
    bl_idname = "object.root_tx_operator"
    bl_label = "Toggl select handles"
    bl_options = {'REGISTER', 'UNDO'}

    @classmethod
    def poll(cls, context):
        
 
        return "_IK" in getattr(context.active_object,"name","666None999") 

    def execute(self, context):

        def selectobBayName(name):
            bpy.ops.object.select_all(action='DESELECT')
            context.view_layer.objects.active = bpy.data.objects[ name ]
            context.active_object.select_set(state=True)
            bpy.ops.view3D.view_selected(use_all_regions=False)


        name = context.active_object.name
        op = getSettings(check=False)

        _, master, txtAppearance, loc_obj = getCharSett(op, idx=0)

        if not op: return {'FINISHED'}

        if op.types == "CURVE":
            if name == txtAppearance.name:
                selectobBayName(master.name)
            else:
                selectobBayName(txtAppearance.name)

        elif not name.split(".")[0].endswith("_IK"):
            selectobBayName(name.replace("_LOC",""))
        else:
            bpy.ops.object.select_all(action='DESELECT')
            context.view_layer.objects.active = loc_obj
            context.active_object.select_set(state=True)
            _ = bpy.context.object.empty_display_size
            bpy.context.object.empty_display_size = 4
            bpy.ops.view3D.view_selected(use_all_regions=False)
            bpy.context.object.empty_display_size = _

        return {'FINISHED'}



class LockPosOperator(bpy.types.Operator):
    """Lock start at curent Location"""
    bl_idname = "object.lock_sttxt_operator"
    bl_label = "Lock position"
    bl_options = {'REGISTER', 'UNDO'}

    @classmethod
    def poll(cls, context):
        
        return getattr(context.active_object,"name","666None999").split(".")[0].endswith("_IK_LOC") == True

    def execute(self, context):
        
        C     = context
        obn   = C.active_object.name
        obloc = C.active_object.matrix_world.translation


        bpy.ops.object.select_all(action='DESELECT')

        if not obn.replace("LOC","LOCKED") in C.scene.objects:
            bpy.ops.object.empty_add(type='CUBE', radius=0.2, align='WORLD', location=obloc)
            C.active_object.name =obn.replace("LOC","LOCKED")

            C.view_layer.objects.active = bpy.data.objects[ obn]
            if not obn.replace("LOC","LOCKED") in  C.active_object.constraints:
                bpy.ops.object.constraint_add(type='COPY_LOCATION')
                C.active_object.constraints["Copy Location"].name =obn.replace("LOC","LOCKED")
            C.active_object.constraints[obn.replace("LOC","LOCKED")].target = bpy.data.objects[obn.replace("LOC","LOCKED")]
            C.active_object.constraints[obn.replace("LOC","LOCKED")].show_expanded = False

            mooveToCollection(bpy.data.objects[obn.replace("LOC","LOCKED")], find_collection(bpy.data.objects[ obn]), unlink=True)

            C.active_object.constraints[obn.replace("LOC","LOCKED")].mute = False

        else:
            if obn.replace("LOC","LOCKED") in  C.active_object.constraints:
                C.active_object.constraints[obn.replace("LOC","LOCKED")].mute = True
                C.view_layer.objects.active = bpy.data.objects[ obn.replace("LOC","LOCKED") ]
                C.object.select_set(state=True)
                bpy.ops.object.delete(use_global=False)

                C.view_layer.objects.active = bpy.data.objects[ obn]
                C.object.select_set(state=True)
                bpy.ops.object.origin_clear()#clearn origine alt+O

        return {'FINISHED'}





def ShowMessageBox(message = "", title = "Message Box", icon = 'INFO'):

    def draw(self, context):
        self.layout.label(text=message)

    bpy.context.window_manager.popup_menu(draw, title = title, icon = icon)






class presetExportOperator(bpy.types.Operator):
    """Export all presets to selected folder"""
    bl_idname = "object.preset_export_tx_operator"
    bl_label = "Export Presets"


    def execute(self, context):

        outFolder  = str(bpy.context.scene.ik_preset_path).strip()  
        presets_folder = bpy.utils.user_resource('SCRIPTS')

        presetFolder = os.path.join(presets_folder, "presets", 'textEffects', 'presets') 

            
        try:
            files = os.listdir(presetFolder)
            [shutil.copy(os.path.join(presetFolder,f), outFolder) for f in files if not f.endswith("__pycache__")]
            ShowMessageBox("Successfully exported", "presets")
        except Exception as e:
            ShowMessageBox("Fail to export presets to selected folder", "Path trouble", 'ERROR')
        
        return {'FINISHED'}




class presetImportOperator(bpy.types.Operator):
    """Import all presets from selected folder"""
    bl_idname = "object.preset_import_tx_operator"
    bl_label = "Import Presets"

    def execute(self, context):

        presets_folder = str(bpy.context.scene.ik_preset_path).strip() 
        outFolder = bpy.utils.user_resource('SCRIPTS')

        outFolder = os.path.join(outFolder, "presets", 'textEffects', 'presets') 
           
        try:
            files = os.listdir(presets_folder)
            [shutil.copy(os.path.join(presets_folder,f), outFolder) for f in files if not f.endswith("__pycache__")]
            ShowMessageBox("Successfully imported", "presets")
        except Exception as e:
            print("Import preset Fail: ", os.path.join(presets_folder,"content \n\t"), outFolder)
            ShowMessageBox("Fail to import presets from the selected folder", "Path trouble", 'ERROR')
       
        return {'FINISHED'}






class OT_TxAddPresetLayer(AddPresetBase, Operator):
    """Intermediat operator for preset fonts""" 
    bl_idname = 'tx.add_preset_layer' 
    bl_label = 'Add A preset' 
    preset_menu = 'IKPRESET_MT_view3d_panel' 

    def upPreset(self, context):
        print(self)

    @classmethod
    def poll(cls, context):
        return getSettings(check=True)

   
    def execute(self, context):
        bpy.ops.file.make_paths_absolute() ## need for copy

        op = getSettings(check=False)
        _, master, txtAppearance, loc_obj = getCharSett(op, idx=0)

        bpy.ops.tx.add_preset(name = self.name)
        local_presets = os.path.join(bpy.utils.user_resource('SCRIPTS'))
        presetFile = os.path.join(local_presets, 'presets', 'textEffects', 'presets',"%s.py"%self.name)
        
        font = bpy.data.curves[txtAppearance.name].font
        fontPath = font.filepath if font.name != ['Bfont', 'Bfont Regular'][int(bpy.app.version >=  (3, 0, 0))] else ['Bfont', 'Bfont Regular'][int(bpy.app.version >=  (3, 0, 0))]


        if not os.path.exists(os.path.join(local_presets,"textEffects","presets",os.path.basename(fontPath))):
            shutil.copy2(fontPath, os.path.join(local_presets,"textEffects","presets")) if font.name != ['Bfont', 'Bfont Regular'][int(bpy.app.version >=  (3, 0, 0))] else None
        
        with open(presetFile,"a") as f:
            f.write("\nlooks.font = loadF('%s')"%os.path.basename(fontPath))
            f.write("\nlooks.font_bold = loadF('%s')"%os.path.basename(fontPath))
            f.write("\nlooks.font_italic = loadF('%s')"%os.path.basename(fontPath))
            f.write("\nlooks.font_bold_italic = loadF('%s')"%os.path.basename(fontPath))
            # convert custom curve to list of points for saving
            
            f.write("\nSettings.curve_interp_l_value = '%s'"%curveToList(op.name+"_"+"curve_interp_l"))
            f.write("\nSettings.curve_interp_r_value = '%s'"%curveToList(op.name+"_"+"curve_interp_r"))
            f.write("\nSettings.curve_interp_s_value = '%s'"%curveToList(op.name+"_"+"curve_interp_s"))
            f.write("\nSettings.curve_interp_v_value = '%s'"%curveToList(op.name+"_"+"curve_interp_v"))
            f.write("\nbpy.ops.object.syncchar_operator()")
        
        return {'FINISHED'}



class OT_TxAddPreset(AddPresetBase, Operator): 
    bl_idname = 'tx.add_preset' 
    bl_label = 'Add A preset' 
    preset_menu = 'IKPRESET_MT_view3d_panel' 


    @classmethod
    def poll(cls, context):
        return getSettings(check=True)
   
    # Common variable used for all preset values 
    preset_defines = [
                     "import os", 
                     'Settings = [coll.ik_TextFx[0] for coll in bpy.context.scene.collection.children if bpy.context.object.name in coll.all_objects][0] ',
                     'looks = [ob.data for ob in  Settings.id_data.all_objects if ob.name.split(".")[0].endswith("_IK") and ob.type=="FONT"][0]',
                     
                     "presets_folder = os.path.join(bpy.utils.user_resource('SCRIPTS'), 'presets')",
                     "local_presets = os.path.join(presets_folder, 'textEffects', 'presets')",
                     "loadF = lambda x :  bpy.data.fonts.load(os.path.join(local_presets,x),check_existing=True)  if os.path.exists(os.path.join(local_presets,x)) else bpy.data.fonts[['Bfont', 'Bfont Regular'][int(bpy.app.version >=  (3, 0, 0))]]",
                     ] 
    # Properties to store in the preset 
    preset_values = [ "Settings.%s"%prop for prop in AnimationProp  ] 

    preset_values += ["looks.%s"%prop for prop in textProp]
    # Directory to store the presets 
    preset_subdir = os.path.join('textEffects','presets') 



class IKPRESET_MT_view3d_panel(Menu): 

    bl_label = 'Text Effects preset' 
    preset_subdir = os.path.join('textEffects','presets') 
    preset_operator = 'script.execute_preset' 
    draw = Menu.draw_preset
    bl_idname = "IKPRESET_MT_view3d_panel"
    #update=upPreset
