
bl_info = {
    "name": "Text Effects",
    "author": "IK3D -- Issanou Kamardine",
    "version": (0, 99),
    "tag":"V0-99W4",
    "blender": (2, 80, 0),
    "location": "View3D > Text Effects",
    "description": "Parametric text effects for motion designers",
    "category": "Motion Design",
    }


import bpy
from .TextEffects import *

import os 
import shutil 


classes = (
    text_options, 
    fontFilePickerOp,
    addMaterialOp,

    TxLocRotScl,
    AddTxtOperator,
    ResetTxOperator,#
    AddTxt_fromEditor_Operator,
    LoadTxt_fromEditor_Operator,
    ReplaceTxt_fromEditor_Operator,
    ConvertTxtOperator,
    SyncCharOperator,
    DuplicateTxOperator,

    ErassTxOperator,
    BakeTxOperator,
    BatchBakeTxOperator,
    PastOperator,
    RootOperator,
    LockPosOperator,

    Interpolation_Mode_sett,
    IKTXTTEXT_PT_view3d_panel,
    IKTXTTEXT_PT_text_editor,
    TEXTUPDATE_PT_text_editor,
    IKTXTEFFECTS_PT_view3d_panel,
    IKTXTAPAR_PT_view3d_panel,

    TEXTGEOFONT_PT_view3d_panel,
    TEXTGEOKERNING_PT_view3d_panel,#
    TEXTGEO_PT_view3d_panel,
    TEXTMAT_PT_view3d_panel,
    
    IKTXTEXTRA_PT_view3d_panel,
    TEXTEASIN_PT_view3d_panel,
    TEXTLOOP_PT_view3d_panel,
    TEXTMARRAY_PT_view3d_panel,
    TEXTPRESET_PT_view3d_panel,
    TEXTPATH_PT_view3d_panel,

    OT_TxAddPresetLayer,
    presetExportOperator,
    presetImportOperator,
    OT_TxAddPreset,
    IKPRESET_MT_view3d_panel,
)


 

def FactoryPresetFolder():
    def updateContentFiles():
        # Get a list of all the files in your bundled presets folder 
        files = os.listdir(factory_presets)
        # Copy them 
        for f in files:
            shutil.copyfile(os.path.join(factory_presets, f), os.path.join(local_presets,f))
    
    factory_presets = os.path.join(bpy.utils.user_resource('SCRIPTS'), "addons", "textEffect", "presets")
    presets_folder = os.path.join(bpy.utils.user_resource('SCRIPTS'), "presets")
    local_presets = os.path.join(presets_folder, 'textEffects', 'presets') 

    if not os.path.isdir(local_presets):
        # makedirs() will also create all the parent folders (like "object") 
        os.makedirs(local_presets)
        updateContentFiles()

    #if there is a local preset folder then update pressets
    else:
        updateContentFiles()
                    




def register():
    from bpy.utils import register_class
    for cls in classes:
        try:
            register_class(cls)
        except Exception as e:
            print("Unable to register Class", cls)

    #bpy.utils.register_module(__name__)
    bpy.types.Collection.ik_TextFx = bpy.props.CollectionProperty(type=text_options)

    bpy.types.Scene.ik_tx_interpo_tool = PointerProperty(type=Interpolation_Mode_sett)
    bpy.types.WindowManager.tx_menu = bpy.props.PointerProperty(type=TxLocRotScl, update=deselect_others)


    bpy.types.Scene.ik_preset_path = bpy.props.StringProperty(
        name = "Preset Path",
        default = "",
        description = "Path to the folder",
        subtype = 'FILE_PATH'
        )

    bpy.types.Scene.edit_ik_text = bpy.props.StringProperty(
        name        = "Edit text", 
        default     = "Text", 
        description = "Type new text",
        )


    # wigle Frequency, Amplitude, Probability
    bpy.types.Scene.Pxy_uiUpdating = bpy.props.BoolProperty(default=False)
    bpy.types.Scene.Pxy_Frequency =  bpy.props.FloatProperty(
        name="Frequency", 
        default= 0., 
        min=0,
        max=100,
        update=updateWigleSettings, 
        description = "Recurrence of shaking"
        )
    bpy.types.Scene.Pxy_Amplitude =  bpy.props.FloatProperty(
        name="Amplitude", 
        default= 0., 
        min=0,
        max=100,
        update=updateWigleSettings, 
        description = "Weight"
        )
    bpy.types.Scene.Pxy_Probability = bpy.props.FloatProperty(
        name="Probability",
        default=0.,
        min=0,
        max=100,
        update=updateWigleSettings,
        description="Maximum possible values of the noise")
    
    # kerning option
    bpy.types.Scene.iktx_kerning_pose_x = bpy.props.FloatProperty(
        name="Pose x",
        default=0.,
        min=-1,
        max=1,
        set=kerning_refine_x,
        description="Refine letter in x position")
    bpy.types.Scene.iktx_kerning_pose_y = bpy.props.FloatProperty(
        name="Pose y",
        default=0.,
        min=-1,
        max=1,
        set=kerning_refine_y,
        description="refine letter in y position")

    FactoryPresetFolder()

    handlers =[ IkTx_MOTION ] 
    for name in handlers: bpy.app.handlers.frame_change_pre.append(name)

    handlers =[ IkTx_copyReady ] 
    for name in handlers: bpy.app.handlers.depsgraph_update_post .append(name)
    print("TEXT_FX %s READY"%bl_info["tag"])



def unregister():

    handlers =[  "IkTx_MOTION" ]

    # ANIMATION HANDLER
    for name in handlers:
        my_handler_list = bpy.app.handlers.frame_change_pre# alias
        fin = len(my_handler_list)
        
        for idx, func in enumerate(reversed(my_handler_list)):
            if func.__name__.startswith(name) :
                my_handler_list.pop(fin-1-idx)

    handlers =[ "IkTx_copyReady" ]          
    # ANIMATION HANDLER
    for name in handlers:
        my_handler_list = bpy.app.handlers.depsgraph_update_post# alias
        fin = len(my_handler_list)
        
        for idx, func in enumerate(reversed(my_handler_list)):
            if func.__name__.startswith(name) :
                my_handler_list.pop(fin-1-idx)

        
    from bpy.utils import unregister_class
    for cls in reversed(classes):
        try:
            unregister_class(cls)
        except Exception as e:
            print(cls)

    #bpy.utils.unregister_module(__name__)
    del bpy.types.WindowManager.tx_menu
    del bpy.types.Scene.ik_tx_interpo_tool

    del bpy.types.Scene.edit_ik_text
    del bpy.types.Scene.ik_preset_path
    del bpy.types.Scene.Pxy_Frequency
    del bpy.types.Scene.Pxy_Amplitude
    del bpy.types.Scene.Pxy_Probability
    del bpy.types.Scene.iktx_kerning_pose_x
    del bpy.types.Scene.iktx_kerning_pose_y
    # del bpy.types.Object.ik_TextFx

    
if __name__ == "__main__":
    register()
