import bpy
from bpy.types import Panel
from bl_ui.properties_object import ObjectButtonsPanel, OBJECT_PT_transform

from .routine import getSettings
from .routine import getCharSett
from .routine import shaderPart
from .texProp import filtre
       


class TEXTUPDATE_PT_text_editor(bpy.types.Panel, ObjectButtonsPanel):
    bl_space_type = 'TEXT_EDITOR'
    bl_region_type = 'UI'
    bl_label = "Update"
    bl_parent_id = 'IKTXTTEXT_PT_text_editor' #onglais
    bl_category = "Text Effects"

    def draw(self, context):
        layout = self.layout

        row = layout.row()
        #if obj.get("ik_textEffects",None)!=None and obj.type == "FONT":
        row.operator("object.load_txt_from_editor_operator", text="Edit", icon="EYEDROPPER")  
        row.operator("object.replace_txt_from_editor_operator", text="Replace", icon="OUTLINER_DATA_GP_LAYER").area = "TEditor"

        obj = context.object
        activeSelect = obj in context.selected_objects

        def message():
            row = layout.row()
            row.label(text="Select animated text", icon="INFO")

        if obj != None:
            if not getSettings(check=True) : message()
        else: message()

            


class IKTXTTEXT_PT_text_editor(bpy.types.Panel):
    bl_label = "Text"
    bl_space_type = "TEXT_EDITOR"
    bl_region_type = "UI"
    bl_category = "Text Effects"
    #bl_options = {'DEFAULT_CLOSED'}

    def draw(self, context):
        layout = self.layout

        obj = context.object
        activeSelect = obj in context.selected_objects

        row = layout.row()        
        row.operator("object.add_txt_from_editor_operator", icon="PRESET_NEW")
        row.operator("object.erase_tx_op", icon="TRASH")
           

        if len(getattr(context.edit_text, "lines", [])) == 0:
            row = layout.row()
            row.label(text="Create a new text data-block", icon="INFO")

        

     

class IKTXTTEXT_PT_view3d_panel(bpy.types.Panel):
    """Creates a Panel in the 3D view tools"""
    bl_label = "Text"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_context = 'objectmode'
    bl_category = "Text Effects"


    def draw(self, context):
        layout = self.layout

        typ = None
        obj = context.object
        if obj != None:
            typ = obj.type

        activeSelect = obj in context.selected_objects

        row = layout.row(align=True)
        row.prop(context.scene, "edit_ik_text", text="", icon="WORDWRAP_ON")

        row = layout.row()  
        if typ == "FONT" and (not getSettings(check=True)):
            row.operator("object.convert_txt_operator", text="Animate", icon="ADD")  #convert 
        else:
            row.operator("object.add_txt_operator", icon="PLUS")
        row.operator("object.erase_tx_op", icon="TRASH")

        row = layout.row()
        row.operator("object.replace_txt_from_editor_operator", text="Replace", icon="OUTLINER_DATA_GP_LAYER").area = "3DVIEW"
        row.operator("object.duplicate_tx_op", icon="DUPLICATE")




class TEXTEASIN_PT_view3d_panel(bpy.types.Panel, ObjectButtonsPanel):
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_label = " "
    bl_parent_id = 'IKTXTEFFECTS_PT_view3d_panel' #onglais
    bl_context = 'objectmode'
    bl_category = "Text Effects"
    bl_options = {'DEFAULT_CLOSED'}

    def draw_header(self, context):
        chan = bpy.data.window_managers["WinMan"].tx_menu
        lab = ["Loc", "OUTLINER_DATA_EMPTY"]
        if chan.TXLoc: lab = ["Loc interpolation", "OUTLINER_DATA_EMPTY"]
        if chan.TXRot: lab = ["Rot interpolation", "ORIENTATION_GIMBAL"]
        if chan.TXScl: lab = ["Scale interpolation", "ORIENTATION_LOCAL"]
        if chan.TXVid: lab = ["Vis interpolation", "HIDE_OFF"]

        layout = self.layout
        row = layout.row()
        row.label(text=lab[0], icon=lab[1])

    def draw(self, context):
        tx_bool = bpy.context.window_manager.tx_menu

        layout = self.layout

        scene = context.scene
        interpolation_tool = scene.ik_tx_interpo_tool # --------------------------Interpolation

        if context.active_object in context.selected_objects:

            op = getSettings(check=False)
            if op:

                ftr = filtre()  # >> call channel props 
                """Props 
                [ 
                "start_at" 0, "ofs" 1, 
                "duration" 2, "full_txt" 3, 
                "charS_ob_nm" 4, "interpolation" 5, 
                "back" 6, "rand" 7, "vis_on" 8, 
                "wiggle_OnLoc" 9, "wiggle_TV(L/R/S)" 10,
                "wiggle_OnLoc_lock" 11,
                "Enable transformation" 17,
                ]
                """

                intrp = getattr(op, ftr[5], "None")
                wigg = getattr(op, ftr[9], False)
                
                row = layout.row()
                row.prop(op, ftr[13], icon="FCURVE")

                if getattr(op, ftr[13], False):
                    ng = bpy.data.node_groups # --------------------curve maping 
                    if getattr(ng,  'txFxCurveData' , None) == None :
                        cName = op.name+"_%s"%ftr[13]
                        
                        if cName in ng['txFxCurveData'].nodes:
                            ipaint  = ng['txFxCurveData'].nodes[cName]
                            box = layout.box()
                            col = box.column(align = True)
                            col.template_curve_mapping(ipaint, "mapping")
                else:
                    row = layout.row()
                    row.prop(interpolation_tool, "ik_txt_interpo", text="")  # ---------------Interpolation

                    if "Back" in intrp:
                        row = layout.row()
                        row.prop(op, ftr[6], slider=True)


                layout.row().separator()

                box = self.layout.box()
                col = box.column()

                row = col.split(align=True)
                row.prop(op, ftr[15], text="Wave", icon="MOD_WAVE" )#bool rand
                row = row.split(align=True)
                row.active = getattr(op, ftr[15], False)
                row.prop(op, ftr[16], text="Periode", icon="PIVOT_BOUNDBOX" )#bool rand
              

                box = self.layout.box()
                col = box.column()

                row = col.split(align=True)
                row.prop(op, ftr[9], text="Wiggle", icon="FORCE_TURBULENCE" )#bool rand
                row = row.split(align=True)
                row.active = wigg
                row.prop(op, ftr[11], text="Limit Walk", icon="PIVOT_BOUNDBOX" )#bool rand
                
                if wigg:
                    row = box.row(align=True)
                    row.prop(scene, "Pxy_Frequency", slider = True )
                    row = box.row(align=True)
                    row.prop(scene, "Pxy_Amplitude", slider = True )
                    row = box.row(align=True)
                    row.prop(scene, "Pxy_Probability", slider = True )



                    


class TEXTLOOP_PT_view3d_panel(bpy.types.Panel, ObjectButtonsPanel):
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_label = "Loop"
    bl_parent_id = 'IKTXTEFFECTS_PT_view3d_panel' #onglais
    bl_context = 'objectmode'
    bl_category = "Text Effects"
    bl_options = {'DEFAULT_CLOSED'}

    def draw(self, context):
        tx_bool = bpy.context.window_manager.tx_menu

        layout = self.layout

        scene = context.scene
        interpolation_tool = scene.ik_tx_interpo_tool # --------------------------Interpolation

        if context.active_object in context.selected_objects:
            op = getSettings(check=False)
            if op:                
                row = layout.row(align=True)
                row.prop(op, "global_loop", text='Loop', icon="FORCE_HARMONIC")#Auto apply
                row.prop(op, "global_loop_pingp", text='Mirrored', icon="MOD_MIRROR")#Auto apply
                row = layout.row()
                row.prop(op, "global_loop_infinit")#Auto apply
                row = layout.row()
                row.prop(op, "global_loop_delay", text='Add time')#Auto apply

                


class TEXTMARRAY_PT_view3d_panel(bpy.types.Panel, ObjectButtonsPanel):
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_label = "Motion array"
    bl_parent_id = 'IKTXTEFFECTS_PT_view3d_panel' #onglais
    bl_context = 'objectmode'
    bl_category = "Text Effects"
    bl_options = {'DEFAULT_CLOSED'}

    def draw(self, context):
        tx_bool = bpy.context.window_manager.tx_menu

        layout = self.layout

        scene = context.scene
        interpolation_tool = scene.ik_tx_interpo_tool # --------------------------Interpolation

        if context.active_object in context.selected_objects:
            op = getSettings(check=False)
            if op:
                row = layout.row()
                row.prop(op, "pose_start", text='', icon="SORTSIZE")#Auto apply
                #row.prop(op, "rad_center", text='Centred', icon="MOD_INSTANCE")#Auto apply
                row = layout.row()
                row.prop(op, "radial", text='Radial', icon="MOD_INSTANCE")#Auto apply

                




class TEXTPRESET_PT_view3d_panel(bpy.types.Panel, ObjectButtonsPanel):
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_label = "Preset"
    bl_parent_id = 'IKTXTTEXT_PT_view3d_panel' #onglais
    bl_context = 'objectmode'
    bl_category = "Text Effects"
    bl_options = {'DEFAULT_CLOSED'}


    def draw(self, context):
        tx_bool = bpy.context.window_manager.tx_menu

        layout = self.layout

        scene = context.scene

        row = layout.row(align=True) 
        
        enable=False
        if context.active_object in context.selected_objects:
            op = getSettings(check=True)
            if op:
                enable=True
        
        if enable:
            row.menu('IKPRESET_MT_view3d_panel', text=bpy.types.IKPRESET_MT_view3d_panel.bl_label)
        else:
            row.label(text="Select animated text", icon="INFO")

        row.operator('tx.add_preset_layer', text='', icon='ADD') 
        row.operator('tx.add_preset', text='', icon='REMOVE').remove_active = True
        
        row = layout.row()
        row.prop(context.scene, 'ik_preset_path', text="")
        row.operator("object.preset_import_tx_operator", text="", icon="IMPORT")
        row.operator("object.preset_export_tx_operator", text="", icon="EXPORT")



class IKTXTEFFECTS_PT_view3d_panel(bpy.types.Panel):
    """Creates a Panel in the 3D view tools"""
    bl_label = "Effects"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_context = 'objectmode'
    bl_category = "Text Effects"
    selected = "tool_objectTrace"
    bl_options = {'DEFAULT_CLOSED'}

    def draw(self, context):
        tx_bool = bpy.context.window_manager.tx_menu
        scene = context.scene

        if context.active_object in context.selected_objects:
            op = getSettings(check=False)
            if op:

                """Props 
                [ 
                "start_at" 0, "ofs" 1, 
                "duration" 2, "full_txt" 3, 
                "charS_ob_nm" 4, "interpolation" 5, 
                "back" 6, "rand" 7, "vis_on" 8, 
                "wiggle_OnLoc" 9, "wiggle_TV(L/R/S)" 10,
                "wiggle_OnLoc_lock" 11,
                "Enable transformation" 12,
                ]
                """
                
                ftr = filtre()  # >> call channel props 

                layout = self.layout
                row = layout.row(align=True)

                # Filters
                row.prop(tx_bool, "TXLoc", text="loc", icon="OUTLINER_DATA_EMPTY")#Auto apply
                row.prop(tx_bool, "TXRot", text="rot", icon="ORIENTATION_GIMBAL")#Auto apply
                row.prop(tx_bool, "TXScl", text="scale", icon="ORIENTATION_LOCAL")#Auto apply
                row.prop(tx_bool, "TXVid", text="vis", icon="HIDE_OFF")#Auto apply


                #if op.types == "CURVE" and tx_bool.TXLoc:
                    
                row = layout.row(align=True)
                row.prop(op, ftr[0] )# start at
                row.prop(op, ftr[12], text="")  # icon=["MUTE_IPO_OFF","PLAY_SOUND"][int(getattr(op,ftr[12]))] )  # ENABLE Transformation
                
                row = layout.row(align=True)
                row.prop(op, ftr[1] )# ofs
                row.prop(op, ftr[7], text="", icon="RNDCURVE" )  # rand

                row = layout.row()
                row.prop(op, ftr[2])  # duratio         


                row = layout.row()
                row.operator("object.past_tx_operator", text="Copy", icon="CENTER_ONLY")
                if len(context.selected_objects) == 1:
                    row.operator("object.bake_tx_op", icon="FILE_TICK", text ="Bake text" )
                else:
                    row.operator("object.batch_bake_tx_op", icon="SELECT_DIFFERENCE", text ="Batch bake" )
                
                

class TEXTPATH_PT_view3d_panel(bpy.types.Panel, ObjectButtonsPanel):
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_label = "Path settings"
    bl_parent_id = 'IKTXTEFFECTS_PT_view3d_panel' #onglais
    bl_context = 'objectmode'
    bl_category = "Text Effects"
    bl_options = {'DEFAULT_CLOSED'}

    def draw(self, context):
        tx_bool = bpy.context.window_manager.tx_menu

        layout = self.layout

        scene = context.scene
        interpolation_tool = scene.ik_tx_interpo_tool # --------------------------Interpolation

        if context.active_object in context.selected_objects:
            op = getSettings(check=False)
            if op:
                
                enable = True
                if not op.types == "CURVE": 
                    row = layout.row(align=True)
                    row.label(text='Select a curve then use "Add 3D text"', icon="INFO")
                    row = layout.row(align=True)
                    row.label(text='button to access path features.')
                    enable = False

                
                row = layout.row(align=True)
                row.active = enable
                if op.static_pose: row.enabled = False
                row.prop(op, "start_pose", icon="DRIVER_DISTANCE" )

                row = layout.row(align=True)
                row.active = enable
                row.prop(op, "center_font" )# center
                row.prop(op, "space_character")# spacing

                row = layout.row(align=True)
                row.active = enable
                row.prop(op, "normal_curve", icon="ORIENTATION_NORMAL" )# spacingrow = layout.row(align=True)
                row.prop(op, "curve_ax", icon="AXIS_SIDE" )# spacing


class TEXTGEO_PT_view3d_panel(bpy.types.Panel, ObjectButtonsPanel):
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_label = "Geometry"
    bl_parent_id = 'IKTXTAPAR_PT_view3d_panel' #onglais
    bl_context = 'objectmode'
    bl_category = "Text Effects"
    bl_options = {'DEFAULT_CLOSED'}

    def draw(self, context):
        layout = self.layout

        if context.active_object in context.selected_objects:

            #CURVE
            op = getSettings(check=False)
            if op:
                row = layout.row(align=True)
                row.prop(op, "extrude")
                #row = layout.row(align=True)
                row.prop(op, "offset")

                row = layout.row(align=True)
                row.label(text="Bevel:")
                row = layout.row(align=True)
                row.prop(op, "bevel_depth", text="Depth")
                # row = layout.row(align=True)
                row.prop(op, "bevel_resolution", text="Resolution")

                row = layout.row()
                row.label(text="Offset:")
                row = layout.row(align=True)
                row.prop(op, "ofsset_font_x")
                row.prop(op, "ofsset_font_y")

                row = layout.row(align=True)
                row.label(text="Resolution:")
                row = layout.row(align=True)
                row.prop(op, "resolution_u", text="Preview U")
                # row = layout.row(align=True)
                row.prop(op, "render_resolution_u", text="Render U")



class TEXTGEOFONT_PT_view3d_panel(bpy.types.Panel, ObjectButtonsPanel):
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_label = "Font"
    bl_parent_id = 'IKTXTAPAR_PT_view3d_panel'  # onglais
    bl_context = 'objectmode'
    bl_category = "Text Effects"
    bl_options = {'DEFAULT_CLOSED'}

    def draw(self, context):
        layout = self.layout
        if context.active_object in context.selected_objects:
            # CURVE
            op = getSettings(check=False)
            if op:
                sett, master, txtAppearance, loc_obj = getCharSett(op, idx=0)
                row = layout.row(align=True)
                row.prop(op, "size")
                # row = layout.row(align=True)
                row.prop(op, "shear")
                row = layout.row()
                row.label(text="Spacing:")
                row = layout.row(align=True)
                row.prop(op, "space_character", text="Characters")
                # row = layout.row(align=True)
                row.prop(op, "space_line", text="Lines")
                # row.prop(curve, "space_word")



class TEXTGEOKERNING_PT_view3d_panel(bpy.types.Panel, ObjectButtonsPanel):
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_label = "Kerning tool"
    bl_parent_id = 'IKTXTAPAR_PT_view3d_panel'  # onglais
    bl_context = 'objectmode'
    bl_category = "Text Effects"
    bl_options = {'DEFAULT_CLOSED'}

    def draw(self, context):
        layout = self.layout
        if context.active_object in context.selected_objects:

            op = getSettings(check=False)
            if op:
                sel_icon = ["RESTRICT_SELECT_ON",
                            "RESTRICT_SELECT_OFF"][op.char_hide_selection]

                # row = layout.row(align=True)
                # row.prop(op, "char_hide_selection", icon=sel_icon)

                ctv = "_IK_char" in context.active_object.name

                row = layout.row(align=True)
                row.active = ctv
                if op.types == "CURVE":
                    row.label(text="Not available on curve", icon="INFO")
                else:
                    row.prop(context.scene, "iktx_kerning_pose_x", slider=True)
                    row.prop(context.scene, "iktx_kerning_pose_y", slider=True)

                    if not ctv:
                        row = layout.row(align=True)
                        row.label(
                            text="Select at least one letter", icon="INFO")
                            
                    row = layout.row(align=True)
                    row.operator("object.tx_reset_kerning_operator")

                

class TEXTMAT_PT_view3d_panel(bpy.types.Panel, ObjectButtonsPanel):
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_label = "Material Fx"
    bl_parent_id = 'IKTXTAPAR_PT_view3d_panel'  # onglais
    bl_context = 'objectmode'
    bl_category = "Text Effects"
    bl_options = {'DEFAULT_CLOSED'}

    def draw(self, context):
        layout = self.layout
        # layout.use_property_split = True
        # layout.use_property_decorate = False  # No animation.

        if context.active_object in context.selected_objects:
            # CURVE
            op = getSettings(check=False)
            if op:
                interpolation_tool = context.scene.ik_tx_interpo_tool  # --------------------------Interpolation
                shaderP = shaderPart(op)

                get = False
                if op.material is not None:
                    rdt = "Randome color"
                    row = layout.row(align=True)
                    if shaderP["shader"] is not None:
                        row.prop(shaderP["shader"].inputs['Base Color'], 'default_value', text="")
                        rdt = ""
                    row.prop(op, 'rand_col', text=rdt, icon="RNDCURVE")

                    if shaderP["randcolor"] is not None and op.rand_col:
                        box = layout.box()
                        row = box.column(align=False)
                        row.template_color_ramp(shaderP["randcolor"], "color_ramp", expand=False)
                    
                    row = layout.row()
                    row.prop(interpolation_tool, "ik_txt_fading", text="")  # ---------------Interpolation
                    get = True

                    if op.fading == "smooth":
                        row = layout.row()
                        row.prop(shaderP["fading"].inputs['Sharpness'], 'default_value', text="")

                if not get:
                    row = layout.row()
                    row.label(text="Assign a material above", icon="INFO")




class IKTXTAPAR_PT_view3d_panel(bpy.types.Panel):
    """Creates a Panel in the 3D view tools"""
    bl_label = "Appearance"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_context = 'objectmode'
    bl_category = "Text Effects"
    bl_options = {'DEFAULT_CLOSED'}

    def draw(self, context):
        layout = self.layout

        if context.active_object in context.selected_objects:

            # CURVE
            op = getSettings(check=False)
            if op:
                sett, master, txtAppearance, loc_obj = getCharSett(op, idx=0)

                row = layout.row(align=True)
                row.prop(op, 'material', text="")
                row.operator("object.material_add_fx", icon="PLUS", text="")
                # fading
                row = layout.row(align=True)
                row.prop(op, "font", text="")
                row.operator("object.font_file_pik_op", icon="FILE_FOLDER", text="")




class IKTXTEXTRA_PT_view3d_panel(bpy.types.Panel):
    """Creates a Panel in the 3D view tools"""
    bl_label = "Extra"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_context = 'objectmode'
    bl_category = "Text Effects"
    bl_options = {'DEFAULT_CLOSED'}

    @classmethod
    def poll(cls, context):
        view = context.space_data
        return (view)

    def draw(self, context):

        view = context.space_data.overlay
        layout = self.layout
                   
        row = layout.row(align=True)
        row.label(text="Handles:")  

        row = layout.row(align=True)
        row.operator("object.root_tx_operator", text="start / end", icon="RESTRICT_VIEW_OFF")

        row = layout.row(align=True)
        row.operator("object.lock_sttxt_operator", text="freeze")
                    
        row = layout.row(align=True)
        row.label(text="Display:")
                    
        row = layout.row(align=True)
        row.prop(view, "show_relationship_lines", text="Lines", icon="CURVE_PATH")
        row.prop(view, "show_overlays", icon="SCENE", text="View")
