import bpy
import random
from random import randint
from bpy.app.handlers import persistent
from mathutils import Vector
from mathutils import Matrix
import numpy as np


from .interpolations import *
from .routine import *


# live list char by distance
distanceCach = {}


def charTime(t,StrAt,dura):
    """convert/clamp time to local chrt time for interpolation"""
    if t<0: return 0
    if t>dura: return dura
    return t


def interLocation(t, em, sett, Settings, rad=False ):
    """Location interpolation methode"""

    sett, master, txtAppearance, loc_obj = getCharSett(Settings, sett[3]) 

    obj_text  = sett[0]
    end_trg   = sett[2]
    start_trg = sett[1]
    idx       = sett[3] if not rad else em # Time position


    V_ref     = IIID_Vector(end_trg, start_trg, 0)

    loc_idx = idx
    if Settings.pose_start is not None: 
        i=distanceCach[Settings.id_data.name]
        loc_idx = i.index(idx);
    if Settings.rand_loc:
        i=eval(Settings.rand_loc_val)
        loc_idx = i[idx];


    StrAt = Settings.start_at + ( Settings.ofs *loc_idx)
    interpolation = Settings.interpolation

    localTime = t-StrAt
    
    # if Settings.pose_start is not None: 
    #     print(obj_text.name, "em%i,"%em, sett[3], loc_idx, localTime)
    
    if Settings.sinWave_onLoc and localTime>0:
        localTime = sin(localTime/Settings.sinWave_Loc)*Settings.duration
    else:
        localTime = charTime(localTime,StrAt,Settings.duration)

    # if idx ==0:print(localTime)



    if Settings.curve_interp_l:
        localTime = evaluateCurve(Settings.name+"_"+"curve_interp_l", localTime, Settings.duration,idx) 
        interpolation = "customCurve"
    
    oldloc = obj_text.matrix_world.translation #curant pose  

    loc = MatchInterpo( 
                    interpolation, 
                    [ localTime, 
                    start_trg.matrix_world.translation , 
                    V_ref, 
                    Settings.duration, 
                    Settings.back , 
                    Vector((0,0,0)) ]
                    ) 

    if not Settings.wiggle_OnLoc_lock and localTime>=(Settings.duration): 
        alterate = IIID_Vector(oldloc, loc, -1)
        loc += alterate

    if Settings.wiggle_OnLoc:
        vec = Settings.wiggle_TVL #match user param
        FAFBFC = eval(Settings.wiggle_TimeL)
        Frequency, Amplitude, Probability, FA, FB, FC = vec[0], vec[1], vec[2], FAFBFC[loc_idx][0], FAFBFC[loc_idx][1], FAFBFC[loc_idx][2]
        loc = Wiggled(loc, Frequency, Amplitude, Probability, FA, FB, FC)
    
    obj_text.matrix_world.translation = loc



def statiConstraint(n,p, Settings, curvePose, curvePoseRad, rad = False):
    """Set aniamtion static pose Interpolation methode"""
    if Settings.static_pose:
        cpose = curvePose[n] if not rad else curvePoseRad[n][n]
        bpy.data.objects[ p[1] ].constraints["tx_pose"].offset_factor = cpose # switch to pop update
    else:
        bpy.data.objects[ p[1] ].constraints["tx_pose"].offset_factor = Settings.start_pose # switch to pop update
     

def interConstraint(t, em,sett, Settings, curvePose, rad=False ):
    """Path constraint Interpolation methode"""
    sett, master, txtAppearance, loc_obj = getCharSett(Settings, sett[3]) 

    obj_text  = sett[0].constraints["tx_pose"]
    end_trg   = sett[2].constraints["tx_pose"]
    start_trg = sett[1].constraints["tx_pose"]
    idx       = sett[3] if not rad else em # Time position

    V_ref     = IIID_Vector(end_trg.offset_factor, start_trg.offset_factor, 3)

    loc_idx = idx
    if Settings.pose_start is not None: 
        i=distanceCach[Settings.id_data.name]
        loc_idx = i.index(idx)
    if Settings.rand_loc : 
        i=eval(Settings.rand_loc_val)
        loc_idx = i[idx];


    StrAt = Settings.start_at + ( Settings.ofs *loc_idx)
    interpolation = Settings.interpolation

    localTime = t-StrAt
    
    if Settings.sinWave_onLoc and localTime>0:
        localTime = sin(localTime/Settings.sinWave_Loc)*Settings.duration
    else:
        localTime = charTime(localTime,StrAt,Settings.duration)

    if Settings.curve_interp_l:
        localTime = evaluateCurve(Settings.name+"_"+"curve_interp_l", localTime, Settings.duration,idx) 
        interpolation = "customCurve"

    oldloc = start_trg.offset_factor

    loc = MatchInterpo( 
                    interpolation,
                    [ localTime, 
                    Vector((start_trg.offset_factor,0,0)) , 
                    V_ref, 
                    Settings.duration, 
                    Settings.back , 
                    Vector((0,0,0)) ]) #animed
    
    if not Settings.wiggle_OnLoc_lock and localTime>=(Settings.duration): 
        alterate = IIID_Vector(oldloc, loc[0], 3)
        loc += alterate


    if Settings.wiggle_OnLoc:
        vec = Settings.wiggle_TVL #match user param
        FAFBFC = eval(Settings.wiggle_TimeL)
        Frequency, Amplitude, Probability, FA, FB, FC = vec[0], vec[1], vec[2], FAFBFC[loc_idx][0], FAFBFC[loc_idx][1], FAFBFC[loc_idx][2]
        loc = Wiggled(loc, Frequency, Amplitude, Probability, FA, FB, FC)
    
    obj_text.offset_factor = loc[0]


def interRotation(t, em, sett, Settings, rad=False ):
    """rotation Interpolation methode"""

    sett, master, txtAppearance, loc_obj = getCharSett(Settings, sett[3]) 

    obj_text  = sett[0]
    end_trg   = sett[2]
    start_trg = sett[1]
    idx       = sett[3] if not rad else em # Time position

    based_rotat_obj =  loc_obj if Settings.aft_rot else end_trg

    if Settings.types == "CURVE":
        based_rotat_obj = txtAppearance if Settings.aft_rot else end_trg

    rotat = based_rotat_obj.rotation_euler
    b_rot = Vector(( rotat[0], rotat[1], rotat[2] ))

    V_ref_R  = IIID_Vector(end_trg, start_trg, 1)


    rot_idx = idx
    if Settings.pose_start is not None:
        i=distanceCach[Settings.id_data.name]
        rot_idx = i.index(idx)
    if Settings.rand_rot: 
        i=eval(Settings.rand_rot_val)
        rot_idx = i[idx];

    r_StrAt = Settings.rot_start_at  + (Settings.rot_ofs *rot_idx)
    interpolation = Settings.rot_interpolation

    localTime = t-r_StrAt

    if Settings.sinWave_onRot and localTime>0:
        localTime = sin(localTime/Settings.sinWave_Rot)*Settings.rot_duration
    else:
        localTime = charTime(localTime,r_StrAt,Settings.rot_duration)

    if Settings.curve_interp_r:
        localTime = evaluateCurve(Settings.name+"_"+"curve_interp_r", localTime, Settings.rot_duration)
        interpolation = "customCurve"

    # if idx ==0:print(localTime)
    

    oldRot = obj_text.rotation_euler #curant pose  
    oldRot = Vector(( oldRot[0], oldRot[1], oldRot[2] )) #curant pose  

    #Rotation
    rot_line = MatchInterpo( 
                    interpolation,
                    [localTime, 
                    V_ref_R, b_rot, 
                    Settings.rot_duration, 
                    Settings.rot_back, 
                    0])

 
    if Settings.wiggle_OnRot:
        if not Settings.wiggle_OnRot_lock and localTime>=(Settings.rot_duration):
            rot_line = Vector( obj_text.rotation_euler[0:3] )

        vec = Settings.wiggle_TVR #match user param
        FAFBFC = eval(Settings.wiggle_TimeR)
        Frequency, Amplitude, Probability, FA, FB, FC = vec[0], vec[1], vec[2], FAFBFC[rot_idx][0], FAFBFC[rot_idx][1], FAFBFC[rot_idx][2]
        rot_line = ( Wiggled( rot_line , Frequency, Amplitude, Probability, FA, FB, FC) ).to_tuple()

    if Settings.wiggle_OnRot and (not Settings.wiggle_OnRot_lock) and localTime>=(Settings.rot_duration):
        obj_text.rotation_euler = rot_line
    else:
        obj_text.rotation_euler = ( ( b_rot[0] - rot_line[0] ), ( b_rot[1] - rot_line[1] ), ( b_rot[2] - rot_line[2] ) )




def interScale(t, em, sett, Settings, rad=False ):
    """Scale Interpolation methode"""
    sett, master, txtAppearance, loc_obj = getCharSett(Settings, sett[3]) 

    txt_obj   = master

    based_Scal_obj = loc_obj if Settings.aft_scl else txt_obj

    if Settings.types == "CURVE":
        based_Scal_obj = txtAppearance if Settings.aft_scl else txt_obj
    
    obj_text  = sett[0]
    end_trg   = sett[2]
    start_trg = sett[1]
    idx       = sett[3] if not rad else em # Time position


    b_scal = based_Scal_obj.matrix_world.to_scale()
    c_scal = txt_obj.scale

    end_trg.scale = (Settings.font_scale,Settings.font_scale,Settings.font_scale)

    if Settings.types == "CURVE":
        V_ref_S  = IIID_Vector(end_trg, based_Scal_obj, 2)
    else:
        V_ref_S  = IIID_Vector(end_trg, start_trg, 2)


    scl_idx = idx
    if Settings.pose_start is not None:
        i=distanceCach[Settings.id_data.name]
        scl_idx = i.index(idx)
    if Settings.rand_scl : 
        i=eval(Settings.rand_scl_val)
        scl_idx = i[idx];

    s_StrAt   = Settings.scl_start_at  + ( Settings.scl_ofs *scl_idx)
    interpolation = Settings.scl_interpolation

    localTime = t-s_StrAt

    if Settings.sinWave_onScl and localTime>0:
        localTime = sin(localTime/Settings.sinWave_Scl)*Settings.scl_duration
    else:
        localTime = charTime(localTime,s_StrAt,Settings.scl_duration)

    if Settings.curve_interp_s:
        localTime = evaluateCurve(Settings.name+"_"+"curve_interp_s", localTime, Settings.scl_duration)
        interpolation = "customCurve"

    # if idx==0: print(localTime)

    oldloc = Vector( obj_text.matrix_world.to_scale() )
   
    scl_line = MatchInterpo( 
                            interpolation, 
                            [localTime,  
                            b_scal , V_ref_S , 
                            Settings.scl_duration ,  
                            Settings.scl_back , 
                            Vector((0,0,0))])
        
    if not Settings.wiggle_OnScl_lock and localTime>=(Settings.scl_duration): 
        alterate = IIID_Vector(oldloc, scl_line, -1)
        scl_line += alterate


    if Settings.wiggle_OnScl:
        vec = Settings.wiggle_TVS #match user param
        FAFBFC = eval(Settings.wiggle_TimeS)
        Frequency, Amplitude, Probability, FA, FB, FC = vec[0], vec[1], vec[2], FAFBFC[scl_idx][0], FAFBFC[scl_idx][1], FAFBFC[scl_idx][2]
        scl_line = ( Wiggled( scl_line , Frequency, Amplitude, Probability, FA, FB, FC) ).to_tuple()
        scl_line = (abs(scl_line[0]), abs(scl_line[0]), abs(scl_line[0]))
    
    resizeChild(obj_text, scl_line )



def interVisibility(t, em, sett, Settings, rad=False ):
    """Visiblity Interpolation methode"""

    sett, master, txtAppearance, loc_obj = getCharSett(Settings, sett[3]) 

    obj_text  = sett[0]
    end_trg   = sett[2]
    start_trg = sett[1]
    idx       = sett[3] if not rad else em # Time position


    vis_idx = idx
    if Settings.pose_start is not None:
        i=distanceCach[Settings.id_data.name]
        vis_idx = i.index(idx)
    if Settings.rand_vis : 
        i=eval(Settings.rand_vis_val)
        vis_idx = i[idx];

    v_StrAt   = Settings.visibility_at  + ( Settings.visibility_of *vis_idx)
    interpolation = Settings.vis_interpolation

    localTime = t-v_StrAt

    if Settings.sinWave_onVis:
        localTime = sin(localTime/Settings.sinWave_Vis)*Settings.visibility_dt
    else:
        localTime = charTime(localTime, v_StrAt, Settings.visibility_dt)

    if Settings.curve_interp_v:
        localTime = evaluateCurve(Settings.name+"_"+"curve_interp_v", localTime, Settings.visibility_dt) 
        interpolation = "customCurve", 
        
    
    #Visibility
    if Settings.vis_on : view, obj_text.hide_viewport , obj_text.hide_render = not localTime, not localTime, not localTime
    else: view, obj_text.hide_viewport, obj_text.hide_render = False, False, False


    if Settings.vis_on or Settings.fading != "none":

        call = MatchInterpo( 
                        interpolation, 
                        [localTime, 
                        0, 
                        len( Settings.full_txt ),  
                        Settings.visibility_dt, 
                        Settings.vis_back, 
                        0])

        if not Settings.wiggle_OnVis_lock and localTime>=(Settings.visibility_dt): 
            alterate = IIID_Vector(call, int(obj_text.hide_render), 3)[0]
            call += alterate

        
        if Settings.fading != "none":
            obj_text.color[1] = call
            if Settings.baking_txt:
                # Bake pass, get custom fcurve  
                action = bpy.data.actions[obj_text.name]
                colorY = action.fcurves.find("color", index=1)
                colorY.keyframe_points.insert(bpy.context.scene.frame_current , call)  

        callP=0
        if Settings.wiggle_OnVis:
            vec = Settings.wiggle_TVV #match user param
            FAFBFC = eval(Settings.wiggle_TimeV)
            Frequency, Amplitude, Probability, FA, FB, FC = vec[0], vec[1], vec[2], FAFBFC[vis_idx][0], FAFBFC[vis_idx][1], FAFBFC[vis_idx][2]
            callP = call-Wiggled(Vector((call,0,0)), Frequency, Amplitude, Probability, FA, FB, FC)[0]
         

        if Settings.vis_on and Settings.fading == "none":

            if (vis_idx >= call): 
                view, obj_text.hide_viewport , obj_text.hide_render = True, True, True
            else: 
                view = False 
                if not Settings.baking_txt:
                    vvvv = callP*10>0.5
                    obj_text.hide_viewport , obj_text.hide_render = vvvv, vvvv

    if Settings.fading != "none":
        view, obj_text.hide_viewport , obj_text.hide_render = False, False, False
        
    if Settings.baking_txt: 
        # Bake pass, get custom fcurve 
        action = bpy.data.actions[obj_text.name]
        fv = action.fcurves.find("hide_viewport")
        fv.keyframe_points.insert(bpy.context.scene.frame_current , int(view))   


          

@persistent
def IkTx_copyReady(scene):

    # Push animation setup to scene collection for handling
    pushColl(coll=scene.collection)

    # make sur new setup collection is ready for animation
    for coll in scene.collection.children:
        if not len(coll.ik_TextFx): continue
        getReadyCopy(coll.ik_TextFx[0], coll)


@persistent
def IkTx_MOTION(scene):
    """ 
    update motion in the 3d scene using  eval(Settings.paires)[ txt_char.name, start_trg.name, end_trg.name, idx ]
    """

    def curveMaping():
        raw = list(eval(Settings.kerning).values())
        raw = [e[0] for e,p in zip(raw,eval(Settings.posKey)) if p==1]# pose filter space bare
        
        lengGths = [IIID_Vector(centre,i,3)[0] for i in raw] # distance from center
        DIV = np.divide(lengGths,interM)
        return np.add(normlize(raw), DIV) # rePose using normalize kerning list
    
    def Sort(name, data, distanceCach, target_ob):
        """Flow sort from target object"""
        size = len(data)
        kd = kdtree.KDTree(size)

        for i, sett in enumerate(data):
            el = sett[2]
            kd.insert(bpy.context.scene.objects[el].matrix_world.to_translation(), i)
        kd.balance()

        cach = []
        for i in kd.find_n(target_ob.matrix_world.to_translation(), size):
            cach.append(i[1])
        distanceCach[name] = cach



    start = bpy.context.scene.frame_start
    t = bpy.context.scene.frame_current 
        
    for coll in bpy.context.scene.collection.children:
        if not len(coll.ik_TextFx): continue


        Settings = coll.ik_TextFx[0]
        # Animation path settinggs
        centre = Settings.center_font
        interM = Settings.spacing_char

        if delUnUsable(Settings): continue
        
        t, endFrame = looper(Settings, t)
        # print("CTime: %3d | Loop: %3d / %i"%(bpy.context.scene.frame_current, t, endFrame))

        ppaire = eval(Settings.paires)

        if (Settings.pose_start is not None):
            n = Settings.id_data.name
            if n in distanceCach: # reset cach
                del distanceCach[n]
            if not n in distanceCach: # update cach
                Sort(n, ppaire, distanceCach, Settings.pose_start)



        if Settings.types == "CURVE":
            # Animation on curve path
            curvePose = curveMaping()
            curvePoseRad = radialSortList(curvePose) #if Settings.radial else curvePose
            
            if Settings.radial and not Settings.static_pose: #Radial Animation
                for em, sett in enumerate(radialSortList(ppaire)):
                    if sett[0]:
                        interConstraint(t, em, sett[0], Settings, curvePose, True) 
                        bpy.data.objects[ sett[0][2] ].constraints["tx_pose"].offset_factor = curvePoseRad[em][0]#[em]
                        bpy.data.objects[ sett[0][0] ].constraints["tx_pose"].use_curve_follow = Settings.normal_curve # switch to pop update

                    if sett[1]:
                        interConstraint(t, em, sett[1], Settings, curvePose, True) 
                        bpy.data.objects[ sett[1][2] ].constraints["tx_pose"].offset_factor = curvePoseRad[em][1]#[em]
                        bpy.data.objects[ sett[1][0] ].constraints["tx_pose"].use_curve_follow = Settings.normal_curve # switch to pop update
                    
            else:
                for n,p in enumerate(ppaire):
                    statiConstraint(n,p, Settings, curvePose, curvePoseRad, False)
                    interConstraint(t, n, p, Settings, curvePose,False)
                    bpy.data.objects[ p[2] ].constraints["tx_pose"].offset_factor = curvePose[n]
                    bpy.data.objects[ p[0] ].constraints["tx_pose"].use_curve_follow = Settings.normal_curve # switch to pop update

        
        # RADIAL ANIMATION    
        if Settings.radial:
            # default / MESH / FONT Animation
            for em, sett in enumerate(radialSortList(ppaire)):            
                #LOCATION
                if not Settings.types == "CURVE": # already processed
                    interLocation(t, em, sett[0], Settings, True) if sett[0] else None 
                    interLocation(t, em, sett[1], Settings, True) if sett[1] else None

                #ROTATE
                interRotation(t, em, sett[0], Settings, True) if sett[0] else None 
                interRotation(t, em, sett[1], Settings, True) if sett[1] else None 
                #SCALE
                interScale(t, em, sett[0], Settings, True) if sett[0] else None 
                interScale(t, em, sett[1], Settings, True) if sett[1] else None  
                #VIDE
                interVisibility(t, em, sett[0], Settings, True) if sett[0] else None 
                interVisibility(t, em, sett[1], Settings, True) if sett[1] else None  
        
        #LINEAR ANIMATION
        else:
            for em, sett in enumerate(ppaire):                                   
                #LOCATION
                if not Settings.types == "CURVE": # already processed
                    interLocation(t, em, sett, Settings, False)

                #ROTATE
                interRotation(t, em, sett, Settings, False)
                #SCALE
                interScale(t, em, sett, Settings, False)
                #VIDE
                interVisibility(t, em, sett, Settings, False)            

        
      