import bpy
import random
import string
import datetime
from mathutils import Vector
from mathutils import kdtree
import numpy as np
import math
from math import acos
from math import cos
from math import pi

import itertools
import re

def kerning_move(ob, ax=0, value=0):
    if ob.name+"_st_Trg" in bpy.data.objects:
        bpy.data.objects[ob.name+"_st_Trg"].location[ax] = ob["iktx_loc"][ax]+value
    if ob.name+"_ed_Trg" in bpy.data.objects:
        bpy.data.objects[ob.name+"_ed_Trg"].location[ax] = ob["iktx_loc"][ax]+value


def kerning_refine_x(scene, value):
    for ob in bpy.context.selected_objects:
        if "_IK_char_" in ob.name:
            kerning_move(ob, ax=0, value=value)

def kerning_refine_y(scene, value):
    for ob in bpy.context.selected_objects:
        if "_IK_char_" in ob.name:
            kerning_move(ob, ax=1, value=value)


def shaderPart(Settings):
    """Return material shader coponnent of the Settings for easy acess"""
    component = {"valide": False, "mat": None, "shader": None, "time": None, "randcolor": None, "fading": None}
    if Settings.material is not None:
        component['mat'] = Settings.material
        if getattr(Settings.material, "node_tree", None) is not None:
            component["shader"] = Settings.material.node_tree.nodes.get("shader", None)
            # component["time"] = Settings.material.node_tree.nodes.get("time", None)
            component["randcolor"] = Settings.material.node_tree.nodes.get("ColorRand", None)
            component["fading"] = Settings.material.node_tree.nodes.get("TextFxFading", None)
            component["valide"] = True
    return component

def curveNodeTree():
    if 'txFxCurveData' not in bpy.data.node_groups:
        ng = bpy.data.node_groups.new('txFxCurveData', 'ShaderNodeTree')
        ng.use_fake_user = True
    return bpy.data.node_groups['txFxCurveData'].nodes

def RemoveCurve(Name):
    """del useless data curves"""
    ng  = bpy.data.node_groups #------------urv maping 
    ICD = ng['txFxCurveData'].nodes if 'txFxCurveData' in ng else []
    
    if Name in ICD:
        print("Removed Custom curve:%s" % Name)
        ICD.remove(ICD[Name]) if ICD is not None else None


def interpolatoinCurve(targetName, replace=False):
    if replace and targetName in curveNodeTree():
        node = bpy.data.node_groups['txFxCurveData'].nodes[targetName]
        bpy.data.node_groups['txFxCurveData'].nodes.remove(node)

    if targetName not in curveNodeTree():
        cn = curveNodeTree().new('ShaderNodeRGBCurve')
        cn.name = targetName
        print("New Custome curve:", targetName)
    return bpy.data.node_groups['txFxCurveData'].nodes[targetName]


percToValue = lambda x, maximum: round(x * maximum / 100)


def evaluateCurve(targetName, t, d, idx=0):
    position = t / d if t / d < 1 else 1

    curve = interpolatoinCurve(targetName).mapping
    curve.initialize()
    if (2, 82, 0) <= bpy.app.version:
        interpo = curve.evaluate(curve.curves[3], position) 
        # if idx==0:print(t, position)
    else:
        interpo = curve.curves[3].evaluate(position) 

    # print(t, position)
    return interpo * d


def ListToCurve(targetName, data):
    liste = eval(data)
    curve = interpolatoinCurve(targetName, replace=True)
    for i,p in enumerate(liste):
        if i>1:curve.mapping.curves[3].points.new(p[0], p[1])
        else:curve.mapping.curves[3].points[i].location=p
    

def curveToList(targetName):
    return str([list(l.location) for l in interpolatoinCurve(targetName).mapping.curves[3].points])


def costomCurveToListAll(Settings):
    # backe custom interpolation curves to list
    Settings.curve_interp_l_value = curveToList(Settings.name+"_"+"curve_interp_l")
    Settings.curve_interp_r_value = curveToList(Settings.name+"_"+"curve_interp_r")
    Settings.curve_interp_s_value = curveToList(Settings.name+"_"+"curve_interp_s")
    Settings.curve_interp_v_value = curveToList(Settings.name+"_"+"curve_interp_v")

def listToCostomCurveAll(Settings):
    # restore custom interpolation curves
    ListToCurve(Settings.name+"_"+"curve_interp_l", Settings.curve_interp_l_value)
    ListToCurve(Settings.name+"_"+"curve_interp_r", Settings.curve_interp_r_value)
    ListToCurve(Settings.name+"_"+"curve_interp_s", Settings.curve_interp_s_value)
    ListToCurve(Settings.name+"_"+"curve_interp_v", Settings.curve_interp_v_value)

def removeCustomCurvesAll(name):
    # remove unused custom curves from the project
    RemoveCurve(name+"_"+"curve_interp_l")
    RemoveCurve(name+"_"+"curve_interp_r")
    RemoveCurve(name+"_"+"curve_interp_s")
    RemoveCurve(name+"_"+"curve_interp_v")


def avalableOp(op):
    name = getName(op)
    if name in bpy.data.collections:
        return len(bpy.data.collections[name].ik_TextFx)
    return False



def getObjSettings(obj):
    if obj is not None:
        for coll in bpy.context.scene.collection.children:
            if obj.name in coll.all_objects and len(coll.ik_TextFx):
                return coll.ik_TextFx[0] 
    return None

    
def getSettings(check=False):
    if bpy.context.object is not None:
        for coll in bpy.context.scene.collection.children:
            if bpy.context.object.name in coll.all_objects and len(coll.ik_TextFx):
                return coll.ik_TextFx[0] if not check else bool(coll.ik_TextFx[0])
    return False

def wiggle(Frequency, Amplitude, Probability, FA, FB, FC):
    t = bpy.context.scene.frame_current
    x, y, z = random.Random(t/ FA), random.Random(t/ FB), random.Random(t/ FC)    #animated
    xU, yU, zU = random.Random(FA), random.Random(FB), random.Random(FC) #fix

    rX, rY, rZ = 0, 0, 0
    if abs(x.uniform(-1, 1)) < Probability:
        rX = (math.cos(t * (xU.uniform(0, Frequency / 10.0))) + (x.uniform(-1, 1) * Probability) / 10.0) * x.uniform(0, Amplitude / 100.0)
    if abs(y.uniform(-1, 1)) < Probability:
        rY = (math.cos(t * (yU.uniform(0, Frequency / 10.0))) + (y.uniform(-1, 1) * Probability) / 10.0) * y.uniform(0, Amplitude / 100.0)
    if abs(z.uniform(-1, 1)) < Probability:
        rZ = (math.cos(t * (zU.uniform(0, Frequency / 10.0))) + (z.uniform(-1, 1) * Probability) / 10.0) * z.uniform(0, Amplitude / 100.0)
    return (rX, rY, rZ)


def Wiggled(WiggleMe, Frequency, Amplitude, Probability, FA, FB, FC):
    x, y, z = wiggle(Frequency, Amplitude, Probability, FA, FB, FC)

    Wiggler = Vector((x, y, z))
    return WiggleMe + (- Wiggler)


def resizeChild(ob, trgScale):
    #prevent divid/0 and negatif scal
    scale_ratio = np.divide(np.clip(np.abs(trgScale),0.01, None), np.clip(np.abs(ob.matrix_world.to_scale()),0.01, None))#[ ng / g for ng, g in zip(trgScale, ob.matrix_world.to_scale() ) ]
    ob.scale = np.multiply(ob.scale, scale_ratio)#[ axis * ratio for axis, ratio in zip(ob.scale, scale_ratio) ]


def timeRange(Settings):
    scn = bpy.context.scene

    lenght = len(eval(Settings.paires))
    smaller = [Settings.start_at , Settings.rot_start_at, Settings.scl_start_at, Settings.visibility_at]
    greater = [Settings.start_at + Settings.duration + lenght * Settings.ofs,
                Settings.rot_start_at + Settings.rot_duration + lenght * Settings.rot_ofs,
                Settings.scl_start_at + Settings.scl_duration + lenght * Settings.scl_ofs,
                Settings.visibility_at + Settings.visibility_dt + lenght * Settings.visibility_of, ]   
    
    if (Settings.global_loop and Settings.global_loop_infinit == 0) or Settings.sinWave_onVis :
        print("case animation loop infinit %i start:%i end:%i"%(Settings.global_loop_infinit, scn.frame_start, scn.frame_end))
        return scn.frame_start, scn.frame_end
    
    elif Settings.global_loop and Settings.global_loop_infinit > 0:
        start, end = min(smaller), max(greater)
        frames = end-start
        _end = start + (frames + Settings.global_loop_delay)*(Settings.global_loop_infinit*2)

        print("case animation repeat %i start:%i end:%i frames:%i _end:%i"%(Settings.global_loop_infinit, start, end, frames, _end))
        return start, _end
   
    else:
        start, end = min(smaller), max(greater)
        length = end-start
        print("case animation start:%i end:%i"%(start, end))
        return start, start + (length + Settings.global_loop_delay)





def looper(Settings, t):
    """Loop animation"""
    t = bpy.context.scene.frame_current
    endF = 0
    if Settings.global_loop:

        string = len(eval(Settings.paires))
        # find the grater type [loc,rot,scal,vis] used as time period
        greater = [Settings.start_at + Settings.duration + string * Settings.ofs,
                Settings.rot_start_at + Settings.rot_duration + string * Settings.rot_ofs,
                Settings.scl_start_at + Settings.scl_duration + string * Settings.scl_ofs,
                Settings.visibility_at + Settings.visibility_dt + string * Settings.visibility_of, ]   

        endF = max(greater) + Settings.global_loop_delay

        if (t >= int(Settings.global_loop_infinit)*(endF*2)) and (Settings.global_loop_infinit!=0):
            t = int(Settings.global_loop_infinit)*(endF*2)

        # ZIG ZAG /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\
        loop = acos(cos(t*pi*2/(endF*2)))/pi*endF

        if Settings.global_loop_pingp:
            t = loop
        else:
            t = t%(endF*2)
    
    return t, endF






def radialSortList(A, revers = False):
    """Radial sort list from midel"""
    B = list(reversed(A[0:len(A)//2]))
    C = A[len(A)//2:]  
    
    if revers:
        B = list(reversed(B))
        C = list(reversed(C))
          
    return list(itertools.zip_longest(B,C))



def IIID_Vector(obj0, obj1, LRS):
    """buld 3D vector"""
    if LRS == -1:#Vectors
        x1, y1, z1 = obj1   
        x2, y2, z2 = obj0   
        return Vector((x2-x1, y2-y1, z2-z1))

    if LRS == 0:#Loc
        x1, y1, z1 = obj1.matrix_world.translation   
        x2, y2, z2 = obj0.matrix_world.translation   
        return Vector((x2-x1, y2-y1, z2-z1))
    
    if LRS == 1:#Rot
        vec   = Vector((obj0.rotation_euler[0], obj0.rotation_euler[1], obj0.rotation_euler[2]))
        vecNeg = vec * -1
        x1, y1, z1 = vecNeg
        x2, y2, z2 = vec
        return Vector((x2-x1, y2-y1, z2-z1))
    
    if LRS == 2:#Scale
        x1, y1, z1 = obj1.matrix_world.to_scale()
        x2, y2, z2 = obj0.matrix_world.to_scale()
        return Vector((x2-x1, y2-y1, z2-z1))

    if LRS == 3:#1D
        x1, y1, z1 = obj1,0,0
        x2, y2, z2 = obj0,0,0
        return Vector((x2-x1, y2-y1, z2-z1))



def normlize(a):
    """return a normalized list"""
    if len(a) <= 1:
        return [0]
    amin, amax = min(a), max(a)
    for i, val in enumerate(a):
        a[i] = (val - amin) / (amax - amin)
    return a


def setCyclesV(obj):
    if bpy.app.version >=  (3,0, 0):
        obj.visible_camera = False
        obj.visible_diffuse = False
        obj.visible_glossy = False
        obj.visible_transmission = False
        obj.visible_volume_scatter = False
        obj.visible_shadow = False
    else:
        obj.cycles_visibility.camera       = False
        obj.cycles_visibility.diffuse      = False
        obj.cycles_visibility.glossy       = False
        obj.cycles_visibility.transmission = False
        obj.cycles_visibility.scatter      = False
        obj.cycles_visibility.shadow       = False



def removeAnimationSetUp(Settings):
    """ Hard remove setup from scene """

    mainColl = Settings.id_data
    name = Settings.name
    Types = Settings.types

    allOb = Collection_objs(mainColl, "all")

    if Types == "CURVE":
        main = Collection_objs(mainColl, "main")
        allOb.remove(main[0]) if len(main) else None

    bpy.ops.object.select_all(action='DESELECT')
    for ob in allOb:
        if ob == None:continue #echap les objets qui existe pas
        ob.hide_select = False 
        ob.select_set(state=True)
        # print("ROUTINE DEL %s"%ob.name)
        bpy.ops.object.delete(use_global=False)

    allColl = Collection_objs(mainColl, groupe="all", coll=True)
    for c in allColl:
        bpy.data.collections.remove(allColl[c])

    removeCustomCurvesAll(name)




def Collection_objs(main, groupe="all", coll=False):
    if not len(main.children):return []

    body, targets, chars, handle = main.children[0], {}, {}, {}

    for c in main.children[0].children:
        if c.name.endswith("_targets"):
            targets = c; continue;
        if c.name.endswith("_chars"):
            chars = c; continue;
        if c.name.endswith("_HANDLE"):
            handle = c; continue;

    # print("COLLECTION:", body, targets, chars, handle)

    if coll:
        return {"main":main,"body":body,"targets":targets,"chars":chars,"handle":handle}

    if groupe=="all":
        return {o for o in list(main.all_objects)+
        list(body.all_objects)+
        list(targets.all_objects)+
        list(chars.all_objects)+
        list(handle.all_objects)
        }

    if groupe=="rzidu":
        return {o for o in 
        list(targets.all_objects)+
        list(handle.all_objects)
        }

    if groupe== "body":
        return list(body.objects)
    if groupe== "targets":
        return  list(targets.objects)
    if groupe== "chars":
        return list(chars.objects)
    if groupe== "handle":
        return list(handle.objects)
    if groupe== "main":
        return list(main.objects)
    if groupe== "corphandle":
        return list(body.objects)+list(main.objects)


def copyCollContent(from_col, to_col, linked, listContent):
    for o in from_col.objects:
        dupe = o.copy()
        listContent.append(dupe)
        if not linked and o.data:
            dupe.data = dupe.data.copy()
        to_col.objects.link(dupe)


def duplicateCollection(parentColl, coll2Duplicate, linked=False, listContent=[], listColl=[]):
    cc = bpy.data.collections.new(coll2Duplicate.name)
    listColl.append(cc)
    copyCollContent(coll2Duplicate, cc, linked, listContent)

    for c in coll2Duplicate.children:
        duplicateCollection(cc, c, linked, listContent)

    parentColl.children.link(cc)

    return listColl


def getCharSett(Settings, idx=0):# sett, master, txtAppearance, loc_obj
    """ Get animation char conponnent using relative collection path """

    master = None
    loc_obj = None
    txtAppearance = None

    allColl = Collection_objs(Settings.id_data, groupe="all", coll=True)
    # charObject, startTarget, endTarget, idx
    sett = [None,None,None,idx]

    for frame in allColl["main"].objects:
        if frame.name.endswith("_IK"):
           txtAppearance=master=frame
           break 

    count = 1
    for hand in allColl["handle"].objects:
        if count > 2:break
        if hand.name.endswith("_IK") and Settings.types == "CURVE":
           txtAppearance=hand
           count +=1
            
        if hand.name.endswith("_IK_LOC"):
           loc_obj=hand
           count +=1
            

    for char in allColl["chars"].objects:
        if "_char_" in char.name and char.name.endswith("_%i"%idx):
           sett[0]=char
           break 
    
    count = 1
    for trg in allColl["targets"].objects:
        if count > 2:break
        if "_%i_st_Trg"%idx in trg.name:
            sett[1] = trg
            count +=1

        if "_%i_ed_Trg"%idx in trg.name:
            sett[2] = trg
            count +=1


    return sett, master, txtAppearance, loc_obj


def scenCleaning(mainColl):
    """ Clean the scene after baking """
    C = bpy.context; D = bpy.data
    # oldName = obj.name
    purName = mainColl.name.split('_')[0]

    for ob in Collection_objs(mainColl,"rzidu",False):
        if ob == None:continue #echap les objets qui existe pas
        ob.hide_viewport = False 
        ob.hide_select = False
        ob.select_set(state=True)
        bpy.ops.object.delete(use_global=False)

    collections = Collection_objs(mainColl,"",True)

    for ob in Collection_objs(mainColl,"chars",False):
        mooveToCollection(ob, collections["body"], True)
        ob.name = purName + ob.name.split("_IK")[1]
    for ob in Collection_objs(mainColl,"main",False):
        ob.name = purName + "_frame"

    for col in collections:
        if col == "targets":
            D.collections.remove(collections[col]); continue
        if col == "handle":
            D.collections.remove(collections[col]); continue
        if col == "chars":
            D.collections.remove(collections[col]); continue
        if col == "body":
            collections[col].name = purName+"_body"; continue
        if col == "main":
            collections[col].name = purName+"_main"; continue

        collections[col].name = purName
        
    
    mainColl.ik_TextFx.remove(0)


def HardRemov(mainColl, keepColl=False):
    """Remove only objects and collections not settings"""

    bpy.ops.object.select_all(action='DESELECT')
    for ob in Collection_objs(mainColl, "all", False):
        if "_Trg" in ob.name or "_IK_LOC" in ob.name or "_IK_char" in ob.name:
            #print("del:%s"%ob.name)
            ob.hide_viewport = False 
            ob.hide_select = False
            ob.select_set(state=True)
            bpy.ops.object.delete(use_global=False)
        else:
            #print("move out:%s"%ob.name)
            mooveToCollection(ob, bpy.context.scene.collection, True)
    
    if not keepColl:
        allColl = Collection_objs(mainColl, "all", True)
        for coll in allColl:
            bpy.data.collections.remove(allColl[coll])


def delUnUsable(Settings):
    """check vulerables objects """

    _, master, txtAppearance, loc_obj = getCharSett(Settings, idx=0)

    vital =  {"1":master, "2":txtAppearance, "3":loc_obj }
    vitalfix = vital.copy()

    for ob in vitalfix:
        if vital[ob] == None:
            del vital[ob]

    
    if len(vital) == 3:return False
    else:
        HardRemov(Settings.id_data) 
        return True



def list_get(l, idx, default):
    """sayftly get element from list"""
    try:
        return l[idx]
    except IndexError:
        return default



def find_collection(item):
    collections = item.users_collection
    if len(collections) > 0:
        return collections[0]
    return bpy.context.scene.collection



def make_collection(collection_name, parent_collection=False):
    if collection_name in bpy.data.collections:# Does the collection already exist?
        return bpy.data.collections[collection_name]
    else:
        new_collection = bpy.data.collections.new(collection_name)
        if parent_collection:
            parent_collection.children.link(new_collection) # Add the new collection under a parent
        return new_collection

def mooveToCollection(obj, target_Collection, unlink=False):
    obj_collection = find_collection(obj)
    if obj.name in target_Collection.objects:
        obj_collection.objects.unlink(obj)
        return

    target_Collection.objects.link(obj)  # put the cube in the new collection
    if unlink:
        obj_collection.objects.unlink(obj)  # remove it from the old collection


def convert2alpha(shar):
    num2words = {
                0:'Zero',1:'One', 2:'Two', 3:'Three', 4:'Four', 5:'Five', 
                6:'Six', 7:'Seven', 8:'Eight', 9:'Nine', 10:'Ten'
                }
    
    if shar.isalpha():
        return shar
    if shar.isdigit():
        return num2words[int(shar)]
    else:
        return "Nul"  
        

def newName(body):
    now = datetime.datetime.now()

    C = bpy.context
    
    name = "".join([convert2alpha(c) for c in body.title()])
    randName = "%s%s%s"%(random.choice(string.ascii_letters), random.choice(string.ascii_letters), random.choice(string.ascii_letters))
    
    name = name if len(name) else randName.lower() # fix if numeric result to "empty"_date_IK name

    if len (name) >= 15:
        name = name[:15]

    num = len([o for o in bpy.data.objects if o.name.startswith(name)])
    num  += len([o for o in C.view_layer.objects if o.name.startswith(name)])
    idx = "".join([chr(int(chif) + ord('a')) for chif in str(num)+now.strftime('%H%S%f')]) + "_IK" 
    name = name+"_"+ idx

    return name


def InitTxt(body, LFont):
    """Build text root"""
    C = bpy.context

    bpy.context.scene.cursor.location = (0,0,0) 

    name = newName(body)
    bpy.ops.object.text_add(align='WORLD', enter_editmode=False, location=(0, 0, 0))

    C.active_object.name = name
    C.active_object.data.name = name
    setFont(C.active_object, LFont)

    bpy.data.objects[name].data.body = body


    bpy.ops.object.select_all(action='DESELECT')
    C.object.display_type = 'BOUNDS'

    bpy.context.object.hide_render = True

    return name


# >> ------------------ Kerning --------------------

def loadFont(path=""):
    if len(path)>0:
        
        try:
            loadedFont = [bpy.data.fonts.load(path, check_existing=True)]
        except RuntimeError:
            print("Error Load font")
            return []
        return loadedFont
    else:
        return []


def setFont(ob, Font):
    if len(Font) > 0:
        ob.data.font = Font[0]




def kerning(Text, LFont, obj2convert=False):
    """Brutforce space kerning"""
    C = bpy.context

    Kerning = {}
    allSpaceKern = {}
    lineSpace = 0
    
    # testing font object
    if obj2convert:
        bpy.ops.object.duplicate_move(OBJECT_OT_duplicate={"linked":False, "mode":'TRANSLATION'})
        ob = C.active_object
    else:
        bpy.ops.object.text_add(align='WORLD', enter_editmode=False)
        ob = C.active_object
        setFont(ob, LFont)
    
    
    # eval interline
    if "\n" in Text:
        ob.data.body = "aA"
        bpy.context.view_layer.update()
        uneLigne = ob.dimensions[1]
        
        ob.data.body = "aA\nzZ"
        bpy.context.view_layer.update()
        deuxLign = ob.dimensions[1]
        
        lineSpace = -(deuxLign - uneLigne)

    # iterate over lines \n
    for numLine, TextLine in enumerate(Text.split("\n")):

        # iterate over chars
        for num in range(len(TextLine)):
            # escape empty
            if TextLine[num] == " ":
                continue       
            
            # applay interline value
            line = (lineSpace*numLine)

            spaceSaver=""
            sSaveLengh=0
            # ensur empty space is evaluated bay add "*    toString" 
            if TextLine.startswith(" "):
                spaceSaver="'"
                ob.data.body = spaceSaver
                bpy.context.view_layer.update()
                sSaveLengh = ob.dimensions[0]
            
            ob.data.body = spaceSaver+TextLine[:num+1]
            bpy.context.view_layer.update()
            paire = ob.dimensions[0]

            ob.data.body = TextLine[num]
            bpy.context.view_layer.update()
            lettre = ob.dimensions[0]

            xpose = paire-lettre-sSaveLengh
            Kerning[ "%i_%i_%s"%(numLine,num,TextLine[num]) ] = [lettre,paire, TextLine[num], line]
            allSpaceKern["%i_%i_%s"%(numLine,num,TextLine[num])] = (xpose, line,0)

            #print("MESURE:%s"%TextLine[:num+1].replace(" ","_"), (xpose, line, 0))

    # remove test object
    ob.select_set(True)
    bpy.ops.object.delete(use_global=False)

    return Kerning, allSpaceKern 


# >> ------------------ End Kerning -----------------

def AddChar(Kerning, allSpaceKern, LFont, name):
    """Add slised text"""
    C = bpy.context
    scene = C.scene

    list_c = []
    posKey = []
    for c in Kerning:

        posKey.append(1)
        bpy.ops.object.text_add(align='WORLD', enter_editmode=False)

        if len(name) >= 15:
            name = "_".join(name.split("_")[-2:])
        
        ob_name = C.active_object.name = name + "_char_" + Kerning[c][2] +"_"+ str(len(list_c))
        setFont(C.active_object, LFont)    
        list_c.append([ob_name, c])

        ob = scene.objects[ob_name]
        ob.data.body = Kerning[c][2]
        bpy.context.view_layer.update()

        try:
            ob.location = allSpaceKern[c]
            ob["iktx_loc"] = allSpaceKern[c]
            ob.lock_location = True, True, True
            ob.lock_rotation = True, True, True
            ob.lock_scale = True, True, True

            # stor offset location in color for later use in fading 
            ob.color[0] = allSpaceKern[c][0] if allSpaceKern[c][0] > 0 else 0.001 # prevent multyply by 0 
        except KeyError:
            pass

    for o_name in list_c:
        char_ob = scene.objects[o_name[0]]

        if char_ob.select_get() == False:
            char_ob.select_set(state=True)


    return list_c, posKey




def updatCharPose(Kerning, allSpaceKern, Settings):
    """Add slised text"""
    C = bpy.context

    pidx = 0
    for c in Kerning:

        if Kerning[c][2] == " ":#avoid space bare
            continue
        sett, _, _, _ = getCharSett(Settings, idx=pidx)

        if not Settings.types =="CURVE":
            sett[1].location = allSpaceKern[c]
            sett[2].location = allSpaceKern[c]

        bpy.context.view_layer.update()

        pidx += 1


def treeColl(coll, liste, copy=False):
    """Collect collection recursively, and tel if the structure folder is a copy"""
    for c in coll.children:
        # check if setup names should be remaped
        if "." in c.name:copy=True
        liste.append(c)
        treeColl(c, liste)
    return liste, copy


def pushColl(coll=None):
    """recurcivly travel to collection in the scene and push animated collection on top"""
    for c in list(coll.children):
        # check if collection should be on top for animation handling
        if not c.name in bpy.context.scene.collection.children and len(c.ik_TextFx):
            bpy.context.scene.collection.children.link(c)
            coll.children.unlink(c)
        pushColl(c)


def getReadyCopy(op, coll):
    """Rename text coponnent to avoide .dot in the names because it cause a lot of trouble"""

    listColl = [coll]
    listContent = list(coll.all_objects)
    childColl, copy = treeColl(coll, listColl)

    # cancel rename if not copy 
    if not copy:return

    oldCode = listColl[1].name.split("_")[1]
    newCode = newName(op.full_txt).split("_")[1]

    # update copynames
    for objct in childColl+listContent:
        copyNum = "."+objct.name.split('.')[-1]
        objct.name = objct.name.replace(oldCode, newCode).replace(copyNum, "")
        if getattr(objct, "data", False):
            objct.data.name = objct.name.replace(oldCode, newCode).replace(copyNum, "")


    # update parenting
    for ob in listContent:

        if getattr(ob,"parent",False):
            ob.parent = bpy.context.scene.objects[ob.parent.name.replace(oldCode, newCode)]

        # update constraint
        for co in list(ob.constraints):
            if getattr(co, "target"):
                co.target = bpy.context.scene.objects[co.target.name.replace(oldCode, newCode)]



def readySet(list_c, allSpaceKern, txt_obj, Settings, mainColl, proxyText=None):
    C = bpy.context

    #build handller
    bpy.ops.object.empty_add(type='CONE', radius=0.2, location=(0, 0, 0))
    
    C.active_object.name = txt_obj.name + "_LOC" 
    LOC = C.active_object

    C.view_layer.objects.active = bpy.data.objects[txt_obj.name]
    bpy.ops.object.parent_set(type='OBJECT', keep_transform=True)


    setup = Collection_objs(Settings.id_data, coll=True)
    
    setup = {
        "main":mainColl,
        "body":make_collection(txt_obj.name+"_body",mainColl),
        "targets":make_collection(txt_obj.name+"_targets",bpy.data.collections[txt_obj.name+"_body"]),
        "chars":make_collection(txt_obj.name+"_chars",bpy.data.collections[txt_obj.name+"_body"]),
        "handle":make_collection(txt_obj.name+"_HANDLE",bpy.data.collections[txt_obj.name+"_body"]),
        } if type(setup)==list else setup


    _ = setup["body"]
    target_coll = setup["targets"]
    chars_coll  = setup["chars"]
    handle_coll = setup["handle"]

    mooveToCollection(txt_obj, mainColl, True)
    mooveToCollection(LOC, handle_coll, True)


    CharsSettings = []
    for idx, o_name in enumerate(list_c):   
        ob_ofst = allSpaceKern[o_name[1]]
        txt_char = bpy.data.objects[o_name[0]]

        #target move start/end
        bpy.ops.object.empty_add(type='SINGLE_ARROW', radius=0.05, location=ob_ofst)
        end_trg = C.active_object
        end_trg.name = txt_char.name + "_ed_Trg"
        
        txt_char.select_set(state=True) # parent char to end target
        C.view_layer.objects.active = bpy.data.objects[txt_char.name + "_ed_Trg"]
        bpy.ops.object.parent_set(type='OBJECT', keep_transform=True)
        bpy.context.view_layer.update()
        bpy.ops.object.origin_clear()
        txt_char.select_set(state=False)


        C.view_layer.objects.active = bpy.data.objects[txt_obj.name]
        bpy.ops.object.parent_set(type='OBJECT', keep_transform=True)
        end_trg.hide_select = True
        # txt_char.hide_select = True

        bpy.ops.object.empty_add(type='SINGLE_ARROW', radius=0.05, location=ob_ofst)
        start_trg = C.active_object
        start_trg.name = txt_char.name + "_st_Trg"

        ChilConstraint = start_trg.constraints.new(type='CHILD_OF')
        ChilConstraint.target = LOC #parent start_tg to handle_LOC

        CL = start_trg.constraints.new(type='COPY_LOCATION')
        CR = start_trg.constraints.new(type='COPY_ROTATION')
        CS = start_trg.constraints.new(type='COPY_SCALE')

        CL.target = CR.target = CS.target = end_trg
        CL.name, CR.name, CS.name = "COPY_LOCATION", "COPY_ROTATION", "COPY_SCALE"
        CL.mute = CR.mute = CS.mute = True


        start_trg.hide_select = True
        

        mooveToCollection(txt_char, chars_coll, True)
        mooveToCollection(start_trg, target_coll, True)
        mooveToCollection(end_trg, target_coll, True)

        CharsSettings.append([ txt_char.name, start_trg.name, end_trg.name, idx ])
        #[ txt_char, end_trg, start_trg, Settings, idx, txt_obj ]
        idx += 1

    bpy.ops.object.select_all(action='DESELECT')
    bpy.data.objects[txt_obj.name].select_set(state=True)
    C.view_layer.objects.active = bpy.data.objects[txt_obj.name]

    return str(CharsSettings), str(allSpaceKern)



def getName(s):
    return re.findall(r"['][\w\s]+[']",s)[0].replace("'","")


def text_prop_copier(context):
    """ used on the ui for copy animations settings """

    if getSettings(check=True) == False:
        return False

    op = getSettings(check=False)
    _, _, txtAppearance, _ = getCharSett(op, idx=0)

    active = txtAppearance.data
    chars = Collection_objs(op.id_data, groupe="chars", coll=False)


    # collect names of writeable properties
    properties = [p.identifier for p in active.bl_rna.properties if not p.is_readonly]

    for ob in  chars:
        if ob.type == 'FONT':
            text = ob.data

            # copy those properties
            for prop in properties:

                if (not prop.startswith('texspace')) and not prop in ["texspace","name","body",]:
                    setattr(text, prop, getattr(active, prop))

    return active.font


def curveStartPose(name, Settings):
    # START POSE
    paires = eval(Settings.paires)
    centre = Settings.center_font
    interM = Settings.space_character

    raw = list(eval(Settings.kerning).values())
    raw = [e[0] for e,p in zip(raw,eval(Settings.posKey)) if p==1]# pose filter space bare
    
    lengGths = [IIID_Vector(centre,i,3)[0] for i in raw] # distance from center
    DIV = np.divide(lengGths,interM)
    curvePose = np.add(normlize(raw), DIV) # rePose using normalize kerning list 
    
   
    for n,p in enumerate(list(reversed(paires))):#eval(Settings.paires)[ txt_char.name, start_trg.name, end_trg.name, idx ]
        bpy.data.objects[ p[0] ].constraints["tx_pose"].offset_factor = curvePose[n]
        bpy.data.objects[ p[2] ].constraints["tx_pose"].offset_factor = curvePose[n]




def readySetOnCurve(list_c, allSpaceKern, txt_obj, Settings, mainColl, proxyText=None):
    C = bpy.context

    # mainColl = make_collection(txt_obj.name,C.scene.collection)
    body_coll   = make_collection(txt_obj.name+"_body", mainColl)
    target_coll = make_collection(txt_obj.name+"_targets", body_coll)
    chars_coll  = make_collection(txt_obj.name+"_chars", body_coll)
    handle_coll  = make_collection(txt_obj.name+"_HANDLE", body_coll)


    def constraint(ob):
        ob.constraints[-1].name = "tx_pose"
        ob.constraints["tx_pose"].use_fixed_location = True
        ob.constraints["tx_pose"].offset_factor = 0
        ob.constraints["tx_pose"].use_fixed_location = False
        ob.constraints["tx_pose"].offset = 0
        ob.constraints["tx_pose"].use_fixed_location = True
        ob.constraints["tx_pose"].use_curve_follow = True
        ob.constraints["tx_pose"].forward_axis = 'FORWARD_X'

    
    #if proxyText is not None:
    bpy.ops.object.select_all(action='DESELECT')
    proxy_ob = bpy.data.objects[proxyText]

    #moove the text frame to the pat
    # proxy_ob.data.offset_x = - proxy_ob.dimensions.x/2
    proxy_ob.lock_location = True, True, True
    

    con = proxy_ob.constraints.new(type='FOLLOW_PATH')
    con.name = "tx_pose"
    con.target = txt_obj
    constraint(proxy_ob)
    con.offset_factor = .5


    proxy_ob.select_set(state=True)
    txt_obj.select_set(state=True) # parent 
    C.view_layer.objects.active = txt_obj

    mooveToCollection(proxy_ob, handle_coll, True)


    #build handller
    bpy.ops.object.empty_add(type='CONE', radius=0.2, location=(0, 0, 0))
    
    C.active_object.name = txt_obj.name + "_LOC"

    LOC = C.active_object
    
    con = LOC.constraints.new("COPY_LOCATION")
    con.name = "tx_pose"
    con.target = txt_obj

    txt_obj.select_set(state=True) # parent LOC
    C.view_layer.objects.active = txt_obj
    bpy.ops.object.parent_set(type='OBJECT')
    LOC.hide_select = True
    LOC.hide_viewport = True


    mooveToCollection(txt_obj, mainColl)
    mooveToCollection(LOC, handle_coll, True)


    list_end=[]
    CharsSettings = []
    
    for idx, o_name in enumerate(list_c):
        
        # ob_ofst = allSpaceKern[o_name[1]]
        txt_char = bpy.data.objects[o_name[0]]
        txt_char.location = 0,0,0


        #target move start/end
        bpy.ops.object.empty_add(type='SINGLE_ARROW', radius=0.05, location=(0, 0, 0))
        end_trg = C.active_object
        end_trg.name = txt_char.name + "_ed_Trg"


        bpy.ops.object.empty_add(type='SINGLE_ARROW', radius=0.001, location=(0, 0, 0))
        start_trg = C.active_object
        start_trg.name = txt_char.name + "_st_Trg"

        txt_char.select_set(state=True) # parent char path
        start_trg.select_set(state=True)
        end_trg.select_set(state=True)
        txt_obj.select_set(state=True)


        C.view_layer.objects.active = txt_obj
        bpy.ops.object.parent_set(type='PATH_CONST')

        constraint(txt_char)
        constraint(start_trg)
        constraint(end_trg)

        mooveToCollection(txt_char, chars_coll, True)
        mooveToCollection(start_trg, target_coll, True)
        mooveToCollection(end_trg, target_coll, True)

        # txt_char.hide_select = True
        start_trg.hide_select = True
        end_trg.hide_select = True

        list_end.append(end_trg)

        CharsSettings.append([ txt_char.name, start_trg.name, end_trg.name, idx ])
        idx += 1


    bpy.ops.object.select_all(action='DESELECT')
    bpy.data.objects[txt_obj.name].select_set(state=True)
    C.view_layer.objects.active = bpy.data.objects[txt_obj.name]

    return str(CharsSettings), str(allSpaceKern)




def SetUpChar(list_c, allSpaceKern, Settings, mainColl, txt_obj, proxyText=None):
    """Make constraint and links for characters"""
    C = bpy.context
    scene = C.scene

    Settings.charS_ob_nm = str([c[0] for c in list_c])
    
    l=list( range(0, len(eval(Settings.charS_ob_nm))) )
    random.shuffle(l)
    order =    str(l)

    Settings.rand_loc_val = order
    Settings.rand_rot_val = order
    Settings.rand_scl_val = order
    Settings.rand_vis_val = order

    Settings.wiggle_TimeL = str( [ [random.randrange(1,250),  random.randrange(1,250), random.randrange(1,250)] for d in range(len(list_c)) ])
    Settings.wiggle_TimeR = str( [ [random.randrange(1,250),  random.randrange(1,250), random.randrange(1,250)] for d in range(len(list_c)) ])
    Settings.wiggle_TimeS = str( [ [random.randrange(1,250),  random.randrange(1,250), random.randrange(1,250)] for d in range(len(list_c)) ])
    Settings.wiggle_TimeV = str( [ [random.randrange(1,250),  random.randrange(1,250), random.randrange(1,250)] for d in range(len(list_c)) ])


    if getattr(txt_obj,"type",False) == "CURVE":
        
        Settings.types = "CURVE"
        Settings.paires, _ = readySetOnCurve(list_c, allSpaceKern, txt_obj, Settings, mainColl, proxyText)


    else:
        Settings.paires, _ = readySet(list_c, allSpaceKern, txt_obj, Settings, mainColl, None)
   
  
 
def baker(Settings):
    """Custum baker for view hide keyframing"""

    start, end  = timeRange(Settings)
    bpy.context.scene.frame_current = start

    v, r, c = "hide_viewport", "hide_render", "color"
    for ob in Collection_objs(Settings.id_data,"chars",False):
        if getattr(ob,"type",False) != 'FONT':continue #echap les objets qui existe pas
        # fix vid baking fail
        action = bpy.data.actions.new(ob.name) if not ob.name in bpy.data.actions else bpy.data.actions[ob.name]
        fv = action.fcurves.new(data_path=v, action_group="Action Bake") if not v in action.fcurves else action.fcurves[v]
        # shader
        fcr = action.fcurves.new(data_path="color", index=0, action_group="Action Bake") if not c in action.fcurves else action.fcurves[c]
        fcg = action.fcurves.new(data_path="color", index=1, action_group="Action Bake") if not c in action.fcurves else action.fcurves[c]
        fcb = action.fcurves.new(data_path="color", index=2, action_group="Action Bake") if not c in action.fcurves else action.fcurves[c]
        fca = action.fcurves.new(data_path="color", index=3, action_group="Action Bake") if not c in action.fcurves else action.fcurves[c]
    
    bpy.ops.nla.bake(frame_start=start, frame_end=end, only_selected=True, visual_keying=True, clear_constraints=True, clear_parents=False, use_current_action=True, bake_types={'OBJECT'})
    
    # keyframe pass for non baked props 
    for ob in Collection_objs(Settings.id_data,"chars",False):
        fv = bpy.data.actions[ob.name].fcurves.find("hide_viewport")
        f1 = ob.animation_data.action.fcurves.new(data_path=v, action_group="Action Bake")
        f2 = ob.animation_data.action.fcurves.new(data_path=r, action_group="Action Bake")
        
        fcgSource = bpy.data.actions[ob.name].fcurves.find(data_path="color", index=1)
        fcg = ob.animation_data.action.fcurves.new(data_path="color", index=1, action_group="Action Bake")

        for kf in fv.keyframe_points:
            f1.keyframe_points.insert(kf.co[0],kf.co[1])
            f2.keyframe_points.insert(kf.co[0],kf.co[1])

        for kf in fcgSource.keyframe_points:
            fcg.keyframe_points.insert(kf.co[0],kf.co[1])



def bakeTxFrame(obj, Settings):
    """bake normal text"""

    print("baking %s"%obj.name)
    (lx,ly,lz) = obj.location
    (rx,ry,rz) = obj.rotation_euler[0:3]
    (sx,sy,sz) = obj.scale

    bpy.ops.object.select_all(action='DESELECT')
    obj.select_set(state=True)
    bpy.ops.object.location_clear()
    bpy.ops.object.rotation_clear()
    bpy.ops.object.scale_clear()

    #Set data animation
    bpy.ops.object.select_all(action='DESELECT')
    bpy.context.scene.frame_current = bpy.context.scene.frame_start
    for ob in Collection_objs(Settings.id_data,"chars",False):
        ob.hide_viewport = False
        ob.hide_select = False 
        ob.select_set(state=True)

    bpy.context.view_layer.objects.active = bpy.data.objects[ obj.name ]
    bpy.ops.object.parent_set(type='OBJECT', keep_transform=False)

    baker(Settings)

    obj.location       = (lx,ly,lz)  
    obj.rotation_euler = (rx,ry,rz)  
    obj.scale          = (sx,sy,sz)  

       


def bakeTxCurveNow(masterName, Settings):
    """bake text on curves"""
    S = scene  = bpy.context.scene
    C = context = bpy.context

    start = S.frame_start 
    end  = S.frame_end

    #Set data animation
    bpy.ops.object.select_all(action='DESELECT')
    S.frame_current = start
    for ob in Collection_objs(Settings.id_data,"chars",False):
        ob.hide_viewport = False
        ob.hide_select = False 
        ob.select_set(state=True)

    context.view_layer.objects.active = bpy.context.scene.objects[masterName]

    baker(Settings)
 
    bpy.ops.object.select_all(action='DESELECT')
    S.frame_current = start

    # print("MASTER CURVE:", masterName)
    for ob in Collection_objs(Settings.id_data, "chars",False):
        # print("\tCHAR:", ob.name)
        ob.hide_viewport = False
        ob.hide_select = False 
        ob.select_set(state=True)

    context.view_layer.objects.active = bpy.context.scene.objects[masterName]
    bpy.ops.object.parent_set(type='OBJECT', keep_transform=False)




def write_data(context, filepath):
    import json
    """Export a json file for debug"""
    Settings = getSettings(check=False)
    properties = [p.identifier for p in Settings.bl_rna.properties if not p.is_readonly]#  

    # copy those properties
    preset = [{ prop:getattr(Settings, prop) for prop in properties if not prop in ["wiggle_TVL","wiggle_TVR","wiggle_TVS"]}]

    preset[0]["wiggle_TVL"] = str(list(Settings.wiggle_TVL))
    preset[0]["wiggle_TVR"] = str(list(Settings.wiggle_TVR))
    preset[0]["wiggle_TVS"] = str(list(Settings.wiggle_TVS))

    with open(filepath, 'w', encoding='utf8') as outfile:
        json.dump(preset, outfile, indent=4)

    return {'FINISHED'}
