local TheBadlands = { require("lua.badlands.tasks.BadlandsTasks") }

local BadlandsData = require("lua.badlands.BadlandsData")
local BadlandsGenName = require("lua.badlands.MapGen").BADLANDS_WORLDGEN_FLAG
local GenerateStartingArea = require("lua.badlands.tasks.GenerateStartingArea").new
local TaskQueue = require("lua.badlands.tasks.BadlandsQueue")

local listening_events = {
    require("lua.events.on_chunk_generated"),
    require("lua.events.on_tick"),
    require("lua.events.on_sector_scanned")
}

local function init_badlands()
    -- game.surfaces["nauvis"].request_to_generate_chunks({0, 0}, 64)
    TaskQueue.new()
            :with_task(
                GenerateStartingArea(game.surfaces["nauvis"]),
                TaskQueue.priorities.HIGH
            )
end

local function listen_to_events()
    for _, listen_to_event in pairs(listening_events) do
        listen_to_event()
    end
end

function TheBadlands.init()
    if game.tick == 0 then
        BadlandsData().worldgen_enabled = game
            .default_map_gen_settings
            .property_expression_names[BadlandsGenName] and true or false
    end
    if BadlandsData().worldgen_enabled then
        listen_to_events()
        init_badlands()
    end
end

function TheBadlands.load()
    if BadlandsData().worldgen_enabled then
        listen_to_events()
        TaskQueue.new()
    end
end

return TheBadlands
