local Random = require("lua.util.Random")
local TaskQueue = require("lua.badlands.tasks.BadlandsQueue")
local ScanDepositsTask = require("lua.badlands.tasks.ScanDeposits").new

local SCAN_CHANCE = 33 / 1200 -- one deposit per 20 minutes
local scan_events = {}
local task = ScanDepositsTask(scan_events)

local function activate_task()
    if not task.active then
        task.active = true
        TaskQueue.queue():add_task(task, TaskQueue.priorities.LOW)
    end
end

return function (radar, tick)
    if radar.surface.name == "nauvis" then
        Random.seed(radar.unit_number, tick)
        if Random.next_number() <= SCAN_CHANCE then
            scan_events[#scan_events+1] = {
                x = radar.position.x,
                y = radar.position.y,
                surface = radar.surface,
                force = radar.force,
                tick = tick
            }
            activate_task()
        end
    end
end
