local TaskWithType = require("lua.util.tasks.TaskWithType")
local DecorateChunks = TaskWithType("decorate_chunks")
DecorateChunks.__index = DecorateChunks

local BadlandsDecorations = require("lua.badlands.worldgen.decorations.BadlandsDecorations")

local function decorated_chunk(chunk_position, surface_name, decoration)
    if decoration then
        return decoration.try_decorate(
            chunk_position,
            game.surfaces[surface_name]
        )
    end
    return nil
end

local function try_decorate_chunks(chunks_to_decorate)
    local succeed = false
    for surface_name, decorations in pairs(chunks_to_decorate) do
        for decoration_name, chunks in pairs(decorations) do
            local key, chunk_position = next(chunks)
            if chunk_position then
                succeed = true
                chunks[key] = not decorated_chunk(
                    chunk_position,
                    surface_name,
                    BadlandsDecorations[surface_name][decoration_name]
                ) and chunk_position or nil
                if chunks[key] then
                    break
                end
            end
        end
    end
    return succeed
end

function DecorateChunks:executed()
    self.active = try_decorate_chunks(self.chunks) and true
    return self.active and self or nil
end

function DecorateChunks.new(chunks_to_decorate)
    return DecorateChunks({ chunks = chunks_to_decorate })
end

return DecorateChunks
