local TaskWithType = require("lua.util.tasks.TaskWithType")
local GenerateSurface = TaskWithType("generate_surface_chunks")
GenerateSurface.__index = GenerateSurface

local function already_generated(self)
    if self.chunk_x >= self.radius - self.step then
        return true
    end
    return false
end

local function generate_next_chunk(self)
    self.chunk_y = self.chunk_y + self.step
    if self.chunk_y >= self.radius then
        self.chunk_x = self.chunk_x + self.step
        self.chunk_y = -self.radius
    end
    self.surface.request_to_generate_chunks({ self.chunk_x * 32, self.chunk_y * 32 }, self.step)
    return self
end

function GenerateSurface:executed()
    return not already_generated(self)
        and generate_next_chunk(self)
        or nil
end

function GenerateSurface.new(surface, radius, step)
    local task = {
        surface = surface.surface or surface,
        radius = radius or surface.radius or surface.map_gen_settings.width / 32 / 2,
        step = step or 1
    }
    task.chunk_x = -task.radius
    task.chunk_y = -task.radius
    return GenerateSurface(task)
end

return GenerateSurface
